(function (root, factory) {
    if (typeof define === 'function' && define.amd) {
        // AMD. Register as an anonymous module.
        define(['exports', 'echarts'], factory);
    } else if (typeof exports === 'object' && typeof exports.nodeName !== 'string') {
        // CommonJS
        factory(exports, require('echarts'));
    } else {
        // Browser globals
        factory({}, root.echarts);
    }
}(this, function (exports, echarts) {
    var log = function (msg) {
        if (typeof console !== 'undefined') {
            console && console.error && console.error(msg);
        }
    }
    if (!echarts) {
        log('ECharts is not Loaded');
        return;
    }
    if (!echarts.registerMap) {
        log('ECharts Map is not loaded')
        return;
    }
	echarts.registerMap('dl',{"type": "FeatureCollection", "features": [{"type":"Feature","properties":{"name":""},"geometry":{"type":"MultiPolygon","coordinates":[[[[121.617345,38.923843],[121.617345,38.933843],[121.637345,38.933843],[121.637345,38.923843],[121.617345,38.923843]]],[[[121.617345,38.933843],[121.604537382813,38.928843],[121.617345,38.923843],[121.63142703125,38.8979274726563],[121.644093046875,38.889184796875],[121.627345,38.8638430000001],[121.610704375,38.867202375],[121.597345,38.873843],[121.59326296875,38.9197585273437],[121.587345,38.9438430000001],[121.607345,38.9438430000001],[121.617345,38.9438430000001],[121.617345,38.933843]]],[[[121.637345,38.933843],[121.642345,38.9466506171875],[121.647345,38.933843],[121.637345,38.933843]]]]}},{"type":"Feature","properties":{"name":""},"geometry":{"type":"MultiPolygon","coordinates":[[[[121.717921171875,38.8961171699219],[121.693961210938,38.8683107734375],[121.6823059375,38.8692482734375],[121.627345,38.8638430000001],[121.644093046875,38.889184796875],[121.63142703125,38.8979274726563],[121.617345,38.923843],[121.637345,38.923843],[121.637345,38.933843],[121.647345,38.933843],[121.688521757813,38.9214455390625],[121.717921171875,38.8961171699219]]]]}},{"type":"Feature","properties":{"name":"庄河市"},"geometry":{"type":"MultiPolygon","coordinates":[[[[123.06072390625,39.457915265625],[123.077345,39.4338430000001],[123.04326296875,39.4425905585938],[123.06072390625,39.457915265625]]],[[[123.103922148438,39.5160353828125],[123.107345,39.503843],[123.095152617188,39.5072658515625],[123.103922148438,39.5160353828125]]],[[[123.00687625,39.5561940742187],[123.02341921875,39.5287746406251],[122.997345,39.493843],[122.969581328125,39.4985597968751],[122.947623320313,39.5349623847657],[122.972345,39.5498744941407],[122.992579375,39.5376699042969],[123.00687625,39.5561940742187]]],[[[123.287345,39.773843],[123.28334109375,39.7965688300781],[123.274346953125,39.7794045234375],[123.280709257813,39.7512245917969],[123.252345,39.7483339667969],[123.232808867188,39.7503249335938],[123.241881132813,39.7383803535157],[123.271314726563,39.713930890625],[123.272901640625,39.6983937812501],[123.211881132813,39.6893056464844],[123.202808867188,39.6783803535156],[123.151881132813,39.6693056464844],[123.140206328125,39.6552516914063],[123.09834109375,39.6709828925781],[123.072345,39.6683339667969],[123.061265898438,39.6694631171875],[122.98091921875,39.6591823554688],[122.995474882813,39.6470900703126],[122.962808867188,39.6283803535156],[122.8854309375,39.6168556953125],[122.8058215625,39.5870351386719],[122.741881132813,39.5593056464844],[122.722808867188,39.5483803535157],[122.701881132813,39.5393056464844],[122.672398710938,39.5180849433594],[122.647530546875,39.5323281074219],[122.629195585938,39.4900502753906],[122.612345,39.4883339667969],[122.601954375,39.4893923164063],[122.590206328125,39.4752516914063],[122.567345,39.483843],[122.551881132813,39.4883803535156],[122.532808867188,39.4993056464844],[122.496671171875,39.5149770332031],[122.512808867188,39.5283803535157],[122.543941679688,39.5658620429688],[122.5814465625,39.5821279121094],[122.561793242188,39.5984523750001],[122.563092070313,39.6111550117188],[122.603233671875,39.6285646796876],[122.591881132813,39.6483803535157],[122.578267851563,39.6947682929688],[122.561881132813,39.7083803535156],[122.545455351563,39.7281569648438],[122.484185820313,39.7547292304688],[122.504268828125,39.8449526191407],[122.501793242188,39.869233625],[122.524381132813,39.8879958320313],[122.511793242188,39.8984523750001],[122.513834257813,39.918452375],[122.507345,39.923843],[122.521173125,39.9404909492188],[122.556881132813,39.9368520332032],[122.534879179688,39.987583234375],[122.5132434375,40.0055580878906],[122.543233671875,40.0185646796876],[122.525836210938,40.0489394355469],[122.692301054688,40.0693569160156],[122.702691679688,40.0682973457032],[122.7576575,40.1078554511719],[122.772345,40.1093520332032],[122.799644804688,40.1065700507813],[122.822022734375,40.1193849921876],[122.838189726563,40.1177370429688],[122.862105742188,40.1728774238281],[122.887345,40.1938430000001],[122.89978640625,40.1777260566406],[122.930123320313,40.1822096992188],[122.94312625,40.1491347480469],[122.940982695313,40.1346108222656],[122.9831653125,40.1093825507813],[122.98045046875,40.0910182929688],[123.00170046875,40.0781996894532],[123.02298953125,40.0694863105469],[123.036549101563,40.0519155097657],[123.073883085938,40.0463991523438],[123.092857695313,40.0709841132813],[123.112345,40.0681044746094],[123.13369265625,40.0712587714844],[123.20298953125,40.0594863105469],[123.2310559375,40.0425551582031],[123.26298953125,40.0294863105469],[123.283922148438,40.0168593574219],[123.313219023438,40.0211891914063],[123.372686796875,39.9978115058594],[123.38170046875,40.0094863105469],[123.397345,40.0138430000001],[123.392652617188,39.9848146796875],[123.37080203125,39.9691518378906],[123.383170195313,39.9496681953125],[123.391636992188,39.9277150703126],[123.407447539063,39.9308388496094],[123.479879179688,39.9163185859375],[123.48341921875,39.8984096503907],[123.465201445313,39.8697145820313],[123.493453398438,39.8494631171875],[123.48968875,39.8304128242187],[123.513170195313,39.7996681953125],[123.517345,39.7838430000001],[123.481793242188,39.7793959785157],[123.472896757813,39.7682900214844],[123.461666289063,39.7592958808594],[123.46302859375,39.7483364082032],[123.409303007813,39.7293959785157],[123.412965117188,39.758843],[123.408912382813,39.7914296699219],[123.31291140625,39.7640163398438],[123.287345,39.773843]],[[123.095152617188,39.6972658515625],[123.107345,39.693843],[123.103922148438,39.7060353828125],[123.095152617188,39.6972658515625]]]]}},{"type":"Feature","properties":{"name":"长海县"},"geometry":{"type":"MultiPolygon","coordinates":[[[[122.717345,39.033843],[122.74517703125,39.0312636542969],[122.759888945313,39.0160305000001],[122.719888945313,39.0163869453125],[122.717345,39.033843]]],[[[122.717345,39.033843],[122.705152617188,39.0372658515626],[122.713922148438,39.0460353828125],[122.717345,39.033843]]],[[[122.831910429688,39.0565395332032],[122.837345,39.043843],[122.814346953125,39.047895734375],[122.831910429688,39.0565395332032]]],[[[122.863922148438,39.0660353828125],[122.867345,39.0538430000001],[122.855152617188,39.0572658515625],[122.863922148438,39.0660353828125]]],[[[122.803922148438,39.0860353828125],[122.807345,39.073843],[122.795152617188,39.0772658515626],[122.803922148438,39.0860353828125]]],[[[123.198643828125,39.0546181464844],[123.16406375,39.03712425],[123.157345,39.023843],[123.143985625,39.0306008125],[123.151026640625,39.0619277167969],[123.170704375,39.0523183417969],[123.163985625,39.0704836250001],[123.133985625,39.0791408515625],[123.172974882813,39.0869313789063],[123.198643828125,39.0546181464844]]],[[[122.423922148438,39.1760353828125],[122.427345,39.163843],[122.415152617188,39.1672658515625],[122.423922148438,39.1760353828125]]],[[[122.403922148438,39.1860353828126],[122.407345,39.1738430000001],[122.395152617188,39.1772658515625],[122.403922148438,39.1860353828126]]],[[[122.377345,39.2038430000001],[122.384918242188,39.1683913398438],[122.36259890625,39.1697219062501],[122.335260039063,39.1391237617188],[122.313375273438,39.1713613105469],[122.332628203125,39.1885622382813],[122.342061796875,39.1991237617188],[122.377345,39.2038430000001]]],[[[122.303922148438,39.2060353828125],[122.307345,39.193843],[122.295152617188,39.1972658515625],[122.303922148438,39.2060353828125]]],[[[122.697345,39.213843],[122.693922148438,39.2016506171875],[122.685152617188,39.2104201484375],[122.697345,39.213843]]],[[[122.377345,39.2038430000001],[122.380767851563,39.2160353828125],[122.389537382813,39.2072658515625],[122.377345,39.2038430000001]]],[[[122.603922148438,39.2260353828126],[122.607345,39.213843],[122.595152617188,39.2172658515625],[122.603922148438,39.2260353828126]]],[[[122.773922148438,39.2360353828125],[122.777345,39.223843],[122.765152617188,39.2272658515626],[122.773922148438,39.2360353828125]]],[[[122.431910429688,39.2365395332031],[122.437345,39.223843],[122.414346953125,39.2278957343751],[122.431910429688,39.2365395332031]]],[[[122.538365507813,39.2368520332031],[122.547345,39.223843],[122.48326296875,39.2285243964844],[122.538365507813,39.2368520332031]]],[[[122.697345,39.213843],[122.691358671875,39.23534690625],[122.632940703125,39.2267140937501],[122.62298953125,39.2386562324219],[122.723053007813,39.2481996894532],[122.75170046875,39.2230763984375],[122.697345,39.213843]]],[[[122.443922148438,39.2660353828126],[122.447345,39.253843],[122.435152617188,39.2572658515625],[122.443922148438,39.2660353828126]]],[[[123.003922148438,39.2660353828126],[123.007345,39.253843],[122.995152617188,39.2572658515625],[123.003922148438,39.2660353828126]]],[[[122.683922148438,39.2760353828125],[122.687345,39.263843],[122.675152617188,39.2672658515626],[122.683922148438,39.2760353828125]]],[[[122.663892851563,39.2703932929688],[122.667345,39.253843],[122.653892851563,39.2603932929688],[122.603892851563,39.2683974433594],[122.630513945313,39.2872927070313],[122.663892851563,39.2703932929688]]],[[[122.4849621875,39.2995034003907],[122.522345,39.2987404609375],[122.551344023438,39.2993325019531],[122.594698515625,39.2709084296876],[122.58224734375,39.2589430976563],[122.577345,39.253843],[122.57224734375,39.2587429023438],[122.56244265625,39.2689430976563],[122.4849621875,39.2995034003907]]]]}},{"type":"Feature","properties":{"name":"大连市区"},"geometry":{"type":"MultiPolygon","coordinates":[[[[121.497345,38.8238430000001],[121.509537382813,38.8204201484375],[121.500767851563,38.8116506171876],[121.497345,38.8238430000001]]],[[[121.497345,38.8238430000001],[121.467345,38.8238430000001],[121.461705351563,38.8486818671875],[121.463248320313,38.8611074042969],[121.413599882813,38.9008644843751],[121.390079375,38.8979396796876],[121.372896757813,38.9193959785156],[121.319815703125,38.9516384101563],[121.282174101563,38.9469557929688],[121.277345,38.963843],[121.283883085938,38.9723110175782],[121.31673953125,38.9674550605469],[121.347877226563,38.9801992011719],[121.33298953125,38.9994863105469],[121.3191028125,39.0102065253906],[121.34170046875,39.0394863105469],[121.36298953125,39.0481996894532],[121.375767851563,39.0647536445313],[121.412857695313,39.0167018867188],[121.432345,39.0195815253907],[121.442345,39.0181044746094],[121.452345,39.0195815253907],[121.46673953125,39.0174550605469],[121.5036340625,39.0325551582032],[121.53170046875,39.049486310547],[121.57298953125,39.0581996894532],[121.618365507813,39.0760390449219],[121.64170046875,39.0794863105469],[121.647345,39.083843],[121.652345,39.0710353828126],[121.657345,39.083843],[121.667345,39.083843],[121.693985625,39.080483625],[121.717345,39.033843],[121.72170046875,39.0281996894532],[121.75170046875,39.0159206367188],[121.738516875,39.0042360664063],[121.644029570313,39.0181996894532],[121.638507109375,38.9975368476563],[121.659854765625,39.0006911445313],[121.6631653125,38.9782973457031],[121.61170046875,38.9494863105469],[121.607345,38.9438430000001],[121.587345,38.9438430000001],[121.546417265625,38.9391884589844],[121.530972929688,38.8790138984376],[121.537345,38.8638430000001],[121.527266875,38.843921125],[121.500704375,38.830483625],[121.497345,38.8238430000001]]],[[[121.163922148438,39.0960353828125],[121.167345,39.083843],[121.155152617188,39.0872658515625],[121.163922148438,39.0960353828125]]]]}},{"type":"Feature","properties":{"name":"金州区"},"geometry":{"type":"MultiPolygon","coordinates":[[[[121.833619414063,38.889380109375],[121.827345,38.8638430000001],[121.81326296875,38.8735671210937],[121.825553007813,38.8979274726563],[121.833619414063,38.889380109375]]],[[[121.913922148438,39.0360353828126],[121.917345,39.023843],[121.905152617188,39.0272658515625],[121.913922148438,39.0360353828126]]],[[[121.657345,39.083843],[121.652345,39.0710353828126],[121.647345,39.083843],[121.652345,39.0966506171875],[121.657345,39.083843]]],[[[121.477345,39.193843],[121.473922148438,39.1816506171875],[121.465152617188,39.1904201484376],[121.477345,39.193843]]],[[[121.573922148438,39.1960353828125],[121.577345,39.183843],[121.565152617188,39.1872658515626],[121.573922148438,39.1960353828125]]],[[[121.477345,39.193843],[121.480767851563,39.2060353828125],[121.489537382813,39.1972658515625],[121.477345,39.193843]]],[[[121.597345,39.193843],[121.585152617188,39.1972658515625],[121.593922148438,39.2060353828125],[121.597345,39.193843]]],[[[121.493922148438,39.2260353828126],[121.497345,39.213843],[121.485152617188,39.2172658515625],[121.493922148438,39.2260353828126]]],[[[121.597345,39.253843],[121.607345,39.253843],[121.602345,39.2410353828125],[121.597345,39.253843]]],[[[122.293922148438,39.2760353828125],[122.297345,39.263843],[122.285152617188,39.2672658515626],[122.293922148438,39.2760353828125]]],[[[121.677345,39.303843],[121.665152617188,39.3072658515626],[121.673922148438,39.3160353828125],[121.677345,39.303843]]],[[[121.597345,39.193843],[121.610299101563,39.2038430000001],[121.584595976563,39.2236818671875],[121.622803984375,39.2180361152344],[121.64170046875,39.2346096015625],[121.607345,39.253843],[121.602345,39.2666506171876],[121.597345,39.253843],[121.5832434375,39.2655580878907],[121.616436796875,39.2799550605469],[121.652345,39.2762953925782],[121.686392851563,39.2797646308594],[121.677345,39.303843],[121.719996367188,39.2933669257813],[121.723468046875,39.308843],[121.721221953125,39.3188430000001],[121.723468046875,39.328843],[121.720714140625,39.3411208320313],[121.73298953125,39.3739321113281],[121.747345,39.383843],[121.75142703125,39.3779274726563],[121.809820585938,39.3629433417969],[121.817345,39.373843],[121.827345,39.373843],[121.857345,39.373843],[121.865465117188,39.3475392890626],[121.912076445313,39.3503176093751],[121.922076445313,39.3285292792969],[121.932345,39.3291408515626],[121.947345,39.328247296875],[121.962345,39.3291408515626],[121.972345,39.3285451484375],[121.982345,39.3291408515626],[122.002345,39.3279494453126],[122.0431653125,39.3303823066407],[122.132237578125,39.3185390449219],[122.142545195313,39.3191530585938],[122.172154570313,39.3085280585938],[122.247345,39.313843],[122.26197390625,39.3012404609375],[122.23271609375,39.2784706855469],[122.172867460938,39.2557595039063],[122.11170046875,39.2118398261719],[122.112877226563,39.1972243476563],[122.090582304688,39.1780165839844],[122.139952421875,39.1559853339844],[122.071363554688,39.1177162910157],[122.03271609375,39.1208217597656],[122.04197390625,39.0984706855469],[122.064527617188,39.0666591621094],[121.992022734375,39.0724843574219],[121.9585559375,39.0336403632812],[121.892535429688,39.0704750800781],[121.88271609375,39.0484706855469],[121.83271609375,39.0371120429688],[121.842003203125,39.0184133125],[121.858858671875,39.0197682929688],[121.891734648438,38.9914455390625],[121.894244414063,38.960200421875],[121.831646757813,38.9551711250001],[121.8327746875,38.9691896796875],[121.807628203125,38.9804091621094],[121.791920195313,39.0085646796875],[121.793331328125,39.0260927558594],[121.717345,39.033843],[121.693985625,39.080483625],[121.667345,39.083843],[121.68326296875,39.1079274726563],[121.69142703125,39.1329604316407],[121.65142703125,39.1479274726563],[121.637022734375,39.1687929511719],[121.60142703125,39.1779274726562],[121.597345,39.193843]]]]}},{"type":"Feature","properties":{"name":"旅顺口区"},"geometry":{"type":"MultiPolygon","coordinates":[[[[121.023922148438,38.8760353828125],[121.027345,38.8638430000001],[121.015152617188,38.8672658515625],[121.023922148438,38.8760353828125]]],[[[120.983922148438,38.9560353828126],[120.987345,38.9438430000001],[120.975152617188,38.9472658515625],[120.983922148438,38.9560353828126]]],[[[121.277345,38.963843],[121.282174101563,38.9469557929688],[121.319815703125,38.9516384101563],[121.372896757813,38.9193959785156],[121.390079375,38.8979396796876],[121.413599882813,38.9008644843751],[121.463248320313,38.8611074042969],[121.461705351563,38.8486818671875],[121.467345,38.8238430000001],[121.456490507813,38.8107753730469],[121.336959257813,38.8229592109375],[121.297730742188,38.7947267890625],[121.223209257813,38.8023220039062],[121.220640898438,38.7771401191407],[121.251881132813,38.7950331855469],[121.241119414063,38.7752870917969],[121.221881132813,38.7593056464844],[121.18865359375,38.7193056464844],[121.140347929688,38.7286782050781],[121.11142703125,38.7791725898438],[121.148741484375,38.7901222968751],[121.132808867188,38.8093056464844],[121.11318484375,38.8256056953125],[121.110816679688,38.848843],[121.114849882813,38.8884194160157],[121.082808867188,38.9023159003906],[121.097340117188,38.9295217109375],[121.147725859375,38.9583803535157],[121.182808867188,38.9493056464844],[121.207345,38.9352516914063],[121.244464140625,38.9565102363282],[121.271881132813,38.9593056464844],[121.277345,38.963843]]]]}},{"type":"Feature","properties":{"name":"普兰店市"},"geometry":{"type":"MultiPolygon","coordinates":[[[[122.343922148438,39.3460353828126],[122.347345,39.333843],[122.335152617188,39.3372658515626],[122.343922148438,39.3460353828126]]],[[[122.340767851563,39.9808266425782],[122.365889921875,39.9656728339844],[122.392345,39.9695815253907],[122.402345,39.9681044746094],[122.412735625,39.9696401191406],[122.43170046875,39.9581996894531],[122.45298953125,39.9494863105469],[122.47170046875,39.9381996894532],[122.507345,39.923843],[122.513834257813,39.918452375],[122.511793242188,39.8984523750001],[122.524381132813,39.8879958320313],[122.501793242188,39.869233625],[122.504268828125,39.8449526191407],[122.484185820313,39.7547292304688],[122.545455351563,39.7281569648438],[122.561881132813,39.7083803535156],[122.578267851563,39.6947682929688],[122.591881132813,39.6483803535157],[122.603233671875,39.6285646796876],[122.563092070313,39.6111550117188],[122.561793242188,39.5984523750001],[122.5814465625,39.5821279121094],[122.543941679688,39.5658620429688],[122.512808867188,39.5283803535157],[122.496671171875,39.5149770332031],[122.532808867188,39.4993056464844],[122.551881132813,39.4883803535156],[122.567345,39.483843],[122.56271609375,39.4584706855469],[122.55197390625,39.4492153144532],[122.526436796875,39.4195729804688],[122.512345,39.4184413886719],[122.49560671875,39.4197866035157],[122.377515898438,39.4077407050781],[122.304234648438,39.3618422675782],[122.29271609375,39.3484706855469],[122.25197390625,39.3192153144532],[122.247345,39.313843],[122.172154570313,39.3085280585938],[122.142545195313,39.3191530585938],[122.132237578125,39.3185390449219],[122.0431653125,39.3303823066407],[122.002345,39.3279494453126],[121.982345,39.3291408515626],[121.972345,39.3285451484375],[121.962345,39.3291408515626],[121.947345,39.328247296875],[121.932345,39.3291408515626],[121.922076445313,39.3285292792969],[121.912076445313,39.3503176093751],[121.865465117188,39.3475392890626],[121.857345,39.373843],[121.88142703125,39.3897585273438],[121.897345,39.3938430000001],[121.907345,39.3938430000001],[121.917345,39.3938430000001],[121.917345,39.4038430000001],[121.923648710938,39.4094753242188],[121.878761015625,39.4300783515625],[121.934718046875,39.5101918769531],[122.003272734375,39.5061061835938],[121.99033328125,39.5666506171876],[122.01420046875,39.6008180976563],[122.070396757813,39.5974684882813],[122.049386015625,39.6560207343751],[122.013121367188,39.6726662421875],[122.0326575,39.7086171699219],[122.030855742188,39.7388430000001],[122.075421171875,39.7492116523438],[122.11318484375,39.7697341132813],[122.1120325,39.7891091132813],[122.1326575,39.7985768867188],[122.131886015625,39.8115529609375],[122.182511015625,39.8085353828125],[122.192061796875,39.8106923652344],[122.1720325,39.8285903144532],[122.173521757813,39.8536244941407],[122.221798125,39.8967568183594],[122.235211210938,39.9259780097657],[122.270679960938,39.9422585273438],[122.277345,39.9638430000001],[122.312017851563,39.9796303535157],[122.322345,39.9781044746094],[122.340767851563,39.9808266425782]]]]}},{"type":"Feature","properties":{"name":""},"geometry":{"type":"MultiPolygon","coordinates":[[[[121.56142703125,38.8697585273438],[121.537345,38.8638430000001],[121.530972929688,38.8790138984376],[121.546417265625,38.9391884589844],[121.587345,38.9438430000001],[121.59326296875,38.9197585273437],[121.597345,38.873843],[121.56142703125,38.8697585273438]]]]}},{"type":"Feature","properties":{"name":"瓦房店市"},"geometry":{"type":"MultiPolygon","coordinates":[[[[121.447345,39.413843],[121.456553984375,39.4372634101562],[121.43298953125,39.4249245429688],[121.430894804688,39.3847475410157],[121.399268828125,39.3661550117188],[121.352564726563,39.3794924140625],[121.312896757813,39.3745583320313],[121.347515898438,39.4200661445313],[121.371793242188,39.417046125],[121.35935671875,39.4482900214844],[121.341656523438,39.4393288398438],[121.291793242188,39.3993959785157],[121.267769804688,39.3693959785156],[121.251671171875,39.3884316230469],[121.253590117188,39.4038430000001],[121.251666289063,39.4192958808594],[121.262896757813,39.4282900214844],[121.271793242188,39.4393959785157],[121.298912382813,39.4508242011719],[121.336261015625,39.4974648261719],[121.380079375,39.5029152656251],[121.39834109375,39.4801113105469],[121.417345,39.503843],[121.440069609375,39.5078481269532],[121.422906523438,39.5168398261719],[121.417345,39.503843],[121.371265898438,39.5207643867188],[121.329000273438,39.517368390625],[121.309229765625,39.4944228339844],[121.28271609375,39.5092153144531],[121.23197390625,39.5184706855469],[121.22271609375,39.5320546699219],[121.286866484375,39.5816823554688],[121.302022734375,39.5992702460937],[121.322345,39.5976381660156],[121.39423953125,39.6034145332031],[121.454273710938,39.6198439765625],[121.4519153125,39.6492018867188],[121.494742460938,39.6584706855469],[121.52388796875,39.6246413398438],[121.521944609375,39.648843],[121.523629179688,39.6698146796875],[121.5019153125,39.6885195136719],[121.5030871875,39.7030519843751],[121.460738554688,39.7395351386719],[121.48271609375,39.7584706855469],[121.49197390625,39.7812404609376],[121.470738554688,39.7995351386719],[121.540240507813,39.8594142890625],[121.567345,39.8572365546875],[121.607178984375,39.8604372382813],[121.639722929688,39.8982106757813],[121.690748320313,39.9209804511719],[121.776304960938,39.9141054511719],[121.795577421875,39.9572890449219],[121.83271609375,39.9684706855469],[121.858394804688,39.9827980781251],[121.87197390625,40.0006227851563],[121.831070585938,40.0188735175782],[121.890943632813,40.0415932441407],[121.948233671875,40.1080886054688],[121.967345,40.113843],[121.983033476563,40.0520632148438],[122.0532825,40.0659450507813],[122.081519804688,40.0480178046875],[122.161510039063,40.0319814277344],[122.183267851563,40.0016237617188],[122.210406523438,39.9962624335937],[122.241954375,40.0162917304688],[122.277345,39.9638430000001],[122.270679960938,39.9422585273438],[122.235211210938,39.9259780097657],[122.221798125,39.8967568183594],[122.173521757813,39.8536244941407],[122.1720325,39.8285903144532],[122.192061796875,39.8106923652344],[122.182511015625,39.8085353828125],[122.131886015625,39.8115529609375],[122.1326575,39.7985768867188],[122.1120325,39.7891091132813],[122.11318484375,39.7697341132813],[122.075421171875,39.7492116523438],[122.030855742188,39.7388430000001],[122.0326575,39.7086171699219],[122.013121367188,39.6726662421875],[122.049386015625,39.6560207343751],[122.070396757813,39.5974684882813],[122.01420046875,39.6008180976563],[121.99033328125,39.5666506171876],[122.003272734375,39.5061061835938],[121.934718046875,39.5101918769531],[121.878761015625,39.4300783515625],[121.923648710938,39.4094753242188],[121.917345,39.4038430000001],[121.907345,39.4038430000001],[121.907345,39.3938430000001],[121.897345,39.3938430000001],[121.888531523438,39.4076076484376],[121.840279570313,39.3940468574219],[121.827345,39.373843],[121.817345,39.373843],[121.79326296875,39.3797585273438],[121.747345,39.383843],[121.74298953125,39.3894863105469],[121.698839140625,39.4075551582032],[121.704615507813,39.3684755683594],[121.637564726563,39.3570851875001],[121.618082304688,39.3318447089844],[121.566910429688,39.3194863105469],[121.54298953125,39.3594863105469],[121.505889921875,39.3698171210938],[121.4786340625,39.4051308417969],[121.447345,39.413843]],[[121.477345,39.523843],[121.471910429688,39.5365395332031],[121.454346953125,39.5278957343751],[121.477345,39.523843]],[[121.537345,39.603843],[121.533922148438,39.6160353828125],[121.525152617188,39.6072658515626],[121.542779570313,39.5911464667969],[121.560343046875,39.599790265625],[121.537345,39.603843]],[[121.807345,39.9338430000001],[121.803922148438,39.9460353828126],[121.795152617188,39.9372658515625],[121.807345,39.9338430000001]],[[121.887345,39.993843],[121.883922148438,40.0060353828125],[121.875152617188,39.9972658515625],[121.887345,39.993843]]]]}}]})
}));