(function(e, fn) {
    "use strict";
    if (e.__proto__ === undefined) {
        e.SimSwiper = fn;
        return SimSwiper;
    } else {
        if (typeof module !== "undefined") {
            module.exports = fn;
        } else {
            e.__proto__.SimSwiper = fn;
        }
    }
})(this, function(el, conf) {
    "use strict";
    if (window.navigator) {
        var nav = window.navigator.userAgent;
        var isIE = nav.indexOf("Trident") === -1;
        let index = nav.indexOf("Chrome");
        if (index != -1) {
            let ch = nav.substr(index + 7, 9)
            if (typeof parseInt(ch)) {
                conf.isT = true;
            } else {
                conf.isT = false;
            }
        }
    }

    var con = document.querySelector(el),
        data = conf.data,
        g_conf = conf,
        slider = null,
        page = null,
        duration = conf.duration || 300,
        easing = conf.easing || "ease",
        isCube = conf.effect && conf.effect === 'cube';

    var th = null,
        now_position = 0,
        percentage = 0,
        setting = {
            prev: null,
            next: null,
            index: 0,
            width: 0,
            num: 1,
            duration: undefined,
            time: null,
            curIndex: 0,
            imgData: null,
            request: null,
            touchX: 0,
            autoplay: function() {
                var time = typeof g_conf.autoplay === "number" ? g_conf.autoplay : 3500;
                th.time = setInterval(
                    function() {
                        th._next();
                    },
                    time > th.duration ? time : 1200
                );
            },
            init: function() {
                th = this;
                th.duration = duration;
                this.num = data.length - 1;
                this.width = getStyle(con, "width");
                setStyle(slider, "width", isCube ? '100%' : this.width * data
                    .length + "px");
                var _this = this;
                try {
                    window.addEventListener("resize", function() {
                        slider.style.transition = "all 0s";
                    });
                    var next = document.querySelector(
                        "#" + con.id + ">" + g_conf.button["next"]
                    );
                    var prev = document.querySelector(
                        "#" + con.id + ">" + g_conf.button["prev"]
                    );
                    next.addEventListener(
                        "click",
                        function() {
                            _this._next();
                        },
                        false
                    );
                    prev.addEventListener("click", function() {
                        _this._prev();
                    });
                } catch (e) {
                    throw new Error("element collection error");
                }
                if (g_conf.autoplay) {
                    th.boot();
                    con.addEventListener("mousedown", th.stop, false);
                    con.addEventListener("mouseup", th.boot, false);
                    con.addEventListener("mouseleave", th.boot, false);
                    con.addEventListener("touchstart", th.stop, false);
                    con.addEventListener("touchend", th.boot, false);
                    window.addEventListener(
                        "visibilitychange",
                        function() {
                            var is = document.visibilityState;
                            is === "visible" ? th.boot() : th.stop();
                        },
                        false
                    );
                }
                _this.touchInit();
                if (g_conf.pagination["el"] !== undefined) {
                    page.childNodes[th.curIndex].classList.add("pagination-items-active");
                    if (g_conf.pagination["click"]) {
                        var poc = page.childNodes;
                        for (var i = 0; i < poc.length; i++) {
                            poc[i].index = i;
                            poc[i].onclick = function() {
                                th.index = th.curIndex = this.index;
                                th.change();
                            };
                        }
                    }
                }
                if (conf.lazy) {
                    _this.loadData(this.index);
                    _this.loadData(this.num);
                }
                if (conf.init !== undefined && typeof conf.init === "function") {
                    conf.init({
                        el: slider.childNodes[th.curIndex],
                        index: th.curIndex
                    });
                }
            },
            stop: function() {
                clearInterval(th.time);
            },
            boot: function() {
                if (th.time !== null) {
                    clearInterval(th.time);
                }
                th.autoplay();
            },
            _prev: function() {
                var _this = this;
                _this.index--;
                _this.change();
            },
            _next: function() {
                var _this = this;
                _this.index++;
                _this.change();
            },
            play: function() {
                th.curIndex = th.index === this.num ? 0 : th.index;
                var pc = page.childNodes;
                for (var i = 0; i < pc.length; i++) {
                    if (i === th.curIndex) {
                        pc[i].classList.add("pagination-items-active");
                    } else {
                        pc[i].classList.remove("pagination-items-active");
                    }
                }
                if (conf.change !== undefined && typeof conf.change === "function") {
                    conf.change({
                        index: th.curIndex,
                        el: slider.childNodes[th.curIndex],
                    });
                }
            },
            transform: function(t) {
                let tar = t ? t : this;
                now_position = tar.index * tar.width;
                let call = tar.animation(tar.index * tar.width, 300);
                slider.style['transform'] = call;
                let fs = 'all ' + (tar.duration / 1000) + "s "
                slider.style.transition = fs;
                th.play();
            },
            animation: function(num, time) {
                return !isCube ? "translate3d(-" + (this.index * this.width) + "px,0px,0px)" :
                    "rotateY(-" + (this.index * this.width) + "deg)";
                // : (-this.index * this.width) + "px";
            },
            back: function(index, duration) {
                th.index = index;
                th.duration = duration;
                th.transform();
            },
            sleep: function() {
                return new Promise(r => setTimeout(r, 8));
            },
            change: function() {
                var _this = this;
                if (_this.index === _this.num + 1) {
                    _this.index = 0;
                    if (conf.loop) {
                        _this.duration = 0;
                        if (conf.isT) {
                            _this.sleep().then(() => {
                                _this.back(1, 300)
                            });
                        } else {
                            window.requestAnimationFrame(() =>
                                window.requestAnimationFrame(() => {
                                    this.back(1, 300)
                                })
                            )
                        }
                    }
                }
                if (_this.index < 0) {
                    _this.index = _this.num;
                    if (conf.loop) {
                        _this.duration = 0;
                        if (conf.isT) {
                            _this.sleep().then(() => {
                                _this.back(_this.num - 1, 300)
                            });
                        } else {
                            window.requestAnimationFrame(() =>
                                window.requestAnimationFrame(() => {
                                    this.back(_this.num - 1, 300)
                                })
                            )
                        }

                    }
                }
                _this.transform();
                if (conf.lazy) {
                    _this.loadData(this.index);
                }
            },
            loadData: function(c) {
                var _thisImg = this.imgData[c].childNodes[0].firstElementChild;
                if (_thisImg && _thisImg.getAttribute(conf.lazy.attr) !== null) {
                    _thisImg.src = _thisImg.getAttribute(conf.lazy.attr);
                    _thisImg.removeAttribute(conf.lazy["attr"]);
                }
            },
            touchInit: function() {
                slider.addEventListener("mousedown", th.start, false);
                slider.addEventListener("touchstart", th.start, {
                    passive: false
                });
                slider.addEventListener("mouseleave", th.stop, false);
            },
            start: function(e) {
                e.preventDefault();
                th.touchX = e.clientX || e.touches[0].clientX;
                if (e.button === 0) {
                    document.addEventListener("mouseup", th.end, false);
                    document.addEventListener("mousemove", th.move);
                }
                document.addEventListener("touchmove", th.move, {
                    passive: false
                });
                document.addEventListener("touchend", th.end, {
                    passive: false
                });
                var thisSlider = slider.childNodes[th.curIndex];
                if (thisSlider.firstElementChild.tagName === "A") {
                    thisSlider.firstElementChild.onclick = function() {
                        return false;
                    };
                }
                con.style.cursor = "grabbing";
            },
            move: function(e) {
                try {
                    e.preventDefault();
                    var offX = (e.clientX || e.touches[0].clientX) - th.touchX;
                    percentage = offX / th.width;
                    var f = offX - now_position;
                    var thre;
                    if (th.checked(percentage)) {
                        thre = -th.width / 10;
                    } else {
                        thre = th.width + 100;
                    }
                    var tag = Math.abs(parseInt((offX - now_position - thre) / th.width));
                    th.index = tag;
                    if (Math.abs(f) > th.num * th.width) {
                        now_position = 0;
                        th.animate(f);
                        th.index = 0;
                    } else if (f > 0) {
                        now_position = th.num * th.width;
                        th.index = th.num;
                        th.animate(-now_position);
                    } else {
                        th.animate(f);
                    }
                } catch (e) {
                    void 0;
                }
            },
            checked: function(n) {
                return !(Math.floor(n) === -1);
            },
            animate: function(gv) {
                isIE
                    ?
                    (slider.style.transform = "translate3d(" + gv + "px,0px,0px)") :
                    (slider.style.left = gv + "px");
                slider.style.transition = "all 0s";
            },
            end: function(e) {
                e.preventDefault();
                th.change();
                document.removeEventListener("touchmove", th.move);
                document.removeEventListener("touchend", th.end);
                document.removeEventListener("mousemove", th.move, false);
                document.removeEventListener("mouseup", th.end, false);
                con.style.cursor = "default";
                var thisSlider = slider.childNodes[th.curIndex];
                if (thisSlider.firstElementChild.tagName === "A") {
                    thisSlider.firstElementChild.onclick = function() {
                        return;
                    };
                }
            },
        };
    (function() {
        if (arguments.length !== 2) {
            el = ".simple-swiper-container";
        } else {
            g_conf = conf;
        }
        var f = data[0];
        data.push(f);
        f = null;
        setLayout(con);
    })();

    function setLayout(el) {
        var frag = document.createDocumentFragment();
        var wrap = document.createElement("div");
        frag.appendChild(wrap);
        wrap.setAttribute("class", "swiper-wrapper" + (isCube ? " swiper-cube-wrapper" : ""));
        wrap.style.overflow = "hidden";
        slider = document.createElement("div");
        slider.setAttribute("class", "swiper-slider");
        frag = document.createDocumentFragment();
        var pa = document.querySelector(
            "#" + el.id + ">" + g_conf["pagination"].el
        );
        var p_frag = document.createDocumentFragment();

        function renderNode(item) {
            var slide = document.createElement("div");
            slide.setAttribute("class", isCube ?
                "swiper-items swiper-effect-cube" : "swiper-items");
            setStyle(slide, "float", "left");
            setStyle(slide, "height", "100%");
            setStyle(slide, "width", !isCube ? getStyle(con, "width") +
                "px" : "100%"); // 滚动条属性
            var a = document.createElement("a");
            a.setAttribute("href", item.href ? encodeURI(item.href) : 'javascript:void(0)');
            if (item.text) {
                a.innerText = item.text;
            } else if (item.src) {
                var img = document.createElement("img");
                var _src = conf.lazy ? conf.lazy["attr"] : "src";
                img.setAttribute(_src, item.src);
                a.appendChild(img);
            }
            slide.appendChild(a);
            frag.appendChild(slide);
            var p_el = document.createElement("span");
            p_el.setAttribute("class", "pagination-items");
            p_frag.appendChild(p_el);
        }
        if (isIE) {
            data.forEach(function(item) {
                renderNode(item);
            });
        } else {
            var i;
            for (i = 0; i < data.length; i++) {
                renderNode(data[i]);
            }
        }

        pa.appendChild(p_frag);
        pa.removeChild(pa.childNodes[0]);
        page = pa;
        slider.appendChild(frag);
        wrap.appendChild(slider);
        el.appendChild(wrap);
        slider = document.querySelector(
            "#" + el.id + ">.swiper-wrapper>.swiper-slider"
        );
        conf.lazy ? (setting.imgData = slider.children) : void 0;
        setting.init();
    }

    function setStyle(el, prop, value) {
        el.style[prop] = value;
    }

    function getStyle(el, prop) {
        return Math.ceil(parseFloat(window.getComputedStyle(el)[prop]));
    }
});