var vue = new Vue({
	el: "#power",
	data: {
		tableData: '',
		checked: {
			"read": {},
			"creat": {},
			"edit": {},
			"delet": {}
		},
		defaultProps: {
			children: 'child',
			label: 'name'
		},
		canCilck: true,
	},
	created: function() {
		this.getMenu()
	},
	mounted: function() {
		var that = this
	},
	methods: {
		getMenu: function() {
			var that = this
			return $.ajax({
				type: "get",
				url: "config.json",
				async: true,
				// data: {},
				dataType: "json",
				success: function(res) {
					for(var i = 0; i < res.length; i++) {
						res[i].asMoreItem = true
					}
					console.log("菜单数据", res)
					that.tableData = res
				}
			})
		},
		sortNumber: function(a, b) {
			return b.level - a.level
		},
		check_same: function(res) {
			var that = this
			for(let i = 0; i < res.length; i++) {
				if(!res[i].isLeaf) {
					var slefId = res[i].data.id
					var sameread = true,
						sameedit = true
					for(var j = 1; j < res[i].data.child.length; j++) {
						var id1 = res[i].data.child[0].id
						var id2 = res[i].data.child[j].id
						var read1 = this.checked.read[id1] ? this.checked.read[id1] : "-1"
						var read2 = this.checked.read[id2] ? this.checked.read[id2] : "-1"
						var compare_read = (read1 == read2 && read1 != "-1") ? true : false
						var edit1 = this.checked.edit[id1] ? this.checked.edit[id1] : "-1"
						var edit2 = this.checked.edit[id2] ? this.checked.edit[id2] : "-1"
						var compare_edit = (edit1 == edit2 && edit1 != "-1") ? true : false
						if(!compare_read) {
							sameread = false
						}
						if(!compare_edit) {
							sameedit = false
						}
					}
					if(compare_read) {
						this.$set(this.checked.read, slefId, true)
					} else {
						this.$set(this.checked.read, slefId, false)
					}
					if(compare_edit) {
						this.$set(this.checked.edit, slefId, true)
					} else {
						this.$set(this.checked.edit, slefId, false)
					}
				}
			}
			console.log("check_same", that.checked)
		},
		issameArr: function(a, b) {
			var arrA = a.sort().join(",")
			var arrB = b.sort().join(",")
			if(arrA == arrB) {
				return true
			} else {
				return false
			}
		},
		selectAll: function() {
			this.isAllSelect = !this.isAllSelect;
			let data = this.tableData;
			this.toggleSelect(data, this.isAllSelect, 'all');
		},
		//选择某行
		selectTr: function(index, row) {
			var that = this
			console.log(index, row)
			if(index == "1") {
				this.$set(this.checked.read, row.id, this.checked.read[row.id])
			} else if(index == "2") {
				this.$set(this.checked.creat, row.id, this.checked.creat[row.id])
			} else if(index == "3") {
				this.$set(this.checked.edit, row.id, this.checked.edit[row.id])
			} else if(index == "4") {
				this.$set(this.checked.delet, row.id, this.checked.delet[row.id])
			}
			this.$nextTick(() => {
				var checdata = that.$refs.tree.store._getAllNodes()
				checdata.sort(that.sortNumber)
				this.toggleSelect(row, index, 'tr');
				that.check_same(checdata)
			});
		},
		toggleSelection: function(row, flag) {
			this.$set(row, 'isChecked', flag);
			this.$nextTick(() => {
				if(flag) {
					console.log(row,flag)
					this.$refs.multipleTable.toggleRowSelection(row, flag);
				} else {
					this.$refs.multipleTable.clearSelection();
				}
			});
		},
		toggleSelect: function(data, index, type) {
			var that=this
			if(type === 'all') {
				if(data.length > 0) {
					data.forEach(item => {
						this.toggleSelection(item, flag);
						if(item.child && item.child.length > 0) {
							this.toggleSelect(item.child, flag, type)
						}
					})
				}
			} else {
				if(data.child && data.child.length > 0) {
					data.child.forEach(item => {
						if(index=="1"){
							this.$set(this.checked.read,item.id,this.checked.read[data.id])
						}else if(index=="2"){
							this.$set(this.checked.creat,item.id,this.checked.creat[data.id])
						}else if(index=="3"){
							this.$set(this.checked.edit,item.id,this.checked.edit[data.id])
						}else if(index=="4"){
							this.$set(this.checked.delet,item.id,this.checked.delet[data.id])
						}
						this.toggleSelect(item, index, type);
					})
				}
			}
		},
	}
})