/**
 * Created by LDM on 2017/4/10.
 * DEMO
 */
$(function(){

    var myJsPlumb = window.jsp = jsPlumb.getInstance();
    myJsPlumb.importDefaults({
        DragOptions : { cursor: 'pointer',zIndex:2}, //拖动时鼠标停留在该元素上显示指针，通过css控制
        PaintStyle : { strokeStyle:'#615f5e' },//元素的默认颜色
        EndpointStyle : { width:20, height:16, strokeStyle:'#615f5e' },//连接点的默认颜色
        Endpoint : "Rectangle",//连接点的默认形状
        Anchors : ["TopCenter"],//连接点的默认位置
        isSource:false,  //是否可以拖动（作为连线起点）
        isTarget:false//是否可以拖动（作为连线起点）
    });
    var color1 = "#615f5e";
    var exampleEndpoint1 = {
        endpoint:["Dot", { radius:8 }],//设置连接点的形状为圆形
        paintStyle:{ fillStyle:color1 },//设置连接点的颜色
        isSource:false,  //是否可以拖动（作为连线起点）
        scope:"dot",//连接点的标识符，只有标识符相同的连接点才能连接
        connectorStyle:{
            strokeWidth: 2,
            stroke: "#615f5e",
            joinstyle: "round",
            outlineStroke: "white",
            outlineWidth: 2
        },//连线颜色、粗细
        connector: [ "Flowchart", {stub: 30, gap: 0, cornerRadius: 0,midpoint :0.5} ],
        maxConnections:1,//设置连接点最多可以连接几条线
        isTarget:false,  //是否可以放置（作为连线终点）
        dragOptions: {},
        beforeDetach:function(conn){
            console.log(conn);
        },
        //绑定一个函数，当到达最大连接个数时弹出提示框
        onMaxConnections:function(info){
            alert("不能在连接了");
        }
    };
    var _addPoint = function(elementId,startDirection,pointStyle){
        var sourceUUID = elementId + startDirection;
        myJsPlumb.addEndpoint(elementId,{anchor:startDirection, uuid: sourceUUID},pointStyle);//将exampleEndpoint1类型的点绑定到id为elementId的元素上
    };
    var setConnect = function(sourceId,targetId,item,leftStub,isStart){
        //console.log(item);
        var leftStub =leftStub||15;
        var startDirection = item[0];
        if(isStart){
            _addPoint(sourceId,startDirection,exampleEndpoint1);
        }
        myJsPlumb.connect({

            //todo：false使线条不可拖动
            detachable:true,
            //开始点
            source:sourceId,
            //目的点
            target:targetId,
            //todo：连接器采用Flowchart折线，stub线的转折的大小,gap是距离的位置，cornerRadius折线的弯曲程度midpoint
            connector: [ "Flowchart", {stub: leftStub, gap: 0, cornerRadius:0,midpoint :0.5} ],
            //anchors锚（动态锚，静态锚）,[x,y,dx,dy];x,y的区间为[0,1]意思为锚的位置;dx,dy的区间为[-1,1]意思为曲线的方向
            anchors:item,
            //连接线的样式
            paintStyle:{
                //连接线的宽度，int值
                //连接器的颜色
                strokeStyle:"#615f5e",
                lineWidth:2,
                //连接器或端点的轮廓宽度
                outlineWidth:4,
                //连接器或端点的颜色
                outlineStroke: "white",
                opacity:0.5,
                shadowBlur:20,
                shadowColor:"white"
            },
            //fillStyle:定义Endpoint的颜色
            endpointStyle:{ fillStyle:"transparent" },
            //连接线悬浮样式
            hoverPaintStyle:{
            },
            //覆盖物类型，四个值Arrow可配置的箭头（可折回），Label点的连接器上可配置的标签，PlainArrow一个三角形的箭头，不可折回，Diamond钻石
            overlays : [
                //连线上面的箭头的样式
                ["PlainArrow", {
                    cssClass:"PlainArrow",
                    location:1,
                    width:20,
                    length:10,
                    id:"PlainArrow",
                    //点击事件
                    events:{
                        "click":function(arrow, evt) {
                            console.log("点击箭头"+arrow);
                        }
                    }
                }]
            ]
        });
    };
    var setConnectBg = function(sourceId,targetId,item,leftStub,isStart){
        var leftStub =leftStub||15;
        var startDirection = item[0];
        if(isStart){
            _addPoint(sourceId,startDirection,exampleEndpoint1);
        }
        myJsPlumb.connect({

            //todo：false使线条不可拖动
            detachable:true,
            //开始点
            source:sourceId,
            //目的点
            target:targetId,
            //todo：连接器采用Flowchart折线，stub线的转折的大小,gap是距离的位置，cornerRadius折线的弯曲程度midpoint
            connector: [ "Flowchart", {stub: leftStub, gap: 0, cornerRadius:0,midpoint :0.5} ],
            //anchors锚（动态锚，静态锚）,[x,y,dx,dy];x,y的区间为[0,1]意思为锚的位置;dx,dy的区间为[-1,1]意思为曲线的方向
            anchors:item,
            //连接线的样式
            paintStyle:{
                //连接器的颜色
                strokeStyle:"white",
                //连接器或端点的轮廓宽度
                lineWidth:8,
                //连接器或端点的颜色
                outlineStroke: "white"
            },
            //fillStyle:定义Endpoint的颜色
            endpointStyle:{ fillStyle:"transparent" },
            //连接线悬浮样式
            hoverPaintStyle:{
            },
            //覆盖物类型，四个值Arrow可配置的箭头（可折回），Label点的连接器上可配置的标签，PlainArrow一个三角形的箭头，不可折回，Diamond钻石
            overlays : [
                //连线上面的箭头的样式
                ["PlainArrow", {
                    cssClass:"PlainArrow",
                    location:1,
                    width:20,
                    length:10,
                    id:"PlainArrow",
                    //点击事件
                    events:{
                        "click":function(arrow, evt) {
                            console.log("点击箭头"+arrow);
                        }
                    }
                }]
            ]
        });
    };
   var addItemFunc = function(item,divClass,x,y){
       var itemHtml = "";
       itemHtml +='<div id="course'+item.id+'" class="item" dm-x="'+x+'"    dm-y="'+y+'"   dm-left="no" dm-right="no"  dm-top="no" dm-bottom="no">'+item.name+'</div>';
       $("."+divClass).append(itemHtml);
   };
    var setJsPlumbFunction = function(row){
        var row = row||6;
        var listDate1 =[{
            id:1,
            name:"state1"
        }, {
            id:2,
            name:"state2"
        }, {
            id:3,
            name:"state3"
        }, {
            id:4,
            name:"state4"
        }, {
            id:5,
            name:"state5"
        }];
        var listDate2 =[{
            id:11,
            name:"state11"
        }, {
            id:12,
            name:"state12"
        }, {
            id:13,
            name:"state13"
        }, {
            id:14,
            name:"state14"
        }, {
            id:15,
            name:"state15"
        }, {
            id:16,
            name:"state16"
        }, {
            id:17,
            name:"state17"
        }, {
            id:18,
            name:"state18"
        }, {
            id:19,
            name:"state19"
        }, {
            id:110,
            name:"110"
        }, {
            id:111,
            name:"111"
        }, {
            id:112,
            name:"112"
        }, {
            id:113,
            name:"113"
        }, {
            id:114,
            name:"114"
        }, {
            id:115,
            name:"115"
        }, {
            id:116,
            name:"116"
        }];
        for(var i=0;i<listDate1.length;i++){
            addItemFunc(listDate1[i],"js_item0",0,0);
        }
        for(var x=1;x<=parseInt(listDate2.length/row)+1;x++){
            var itemHtml = '';
            itemHtml += '<div class="js_plumb js_item'+x+'"> </div>';
            $("#jsDivID").append(itemHtml);
            console.log(listDate2.length);
            console.log(row);
            console.log(x);
        }
        for(var j=0;j<listDate2.length;j++){
            addItemFunc(listDate2[j],"js_item"+(parseInt(j/row)+1),parseInt(j/row+1),j%row);
        }
    };
    setJsPlumbFunction();

    //设置位置是否被占用 是就是yes，未被占用就是no
    var setDirectionIsTrue = function(id,direction){
        if(direction == "LeftMiddle"){
            $("#"+id).attr({"dm-left":"yes"});
        }else if(direction == "RightMiddle"){
            $("#"+id).attr({"dm-right":"yes"});
        }else if(direction == "TopCenter"){
            $("#"+id).attr({"dm-top":"yes"});
        }else if(direction == "BottomCenter"){
            $("#"+id).attr({"dm-bottom":"yes"});
        }
    };
    //判断位置是否被占用 占用就返回true，反之false
    var judgeDirectionIsTrue = function(id,direction){
        var dt = "";
        if(direction == "LeftMiddle"){
            dt = "dm-left";
        }else if(direction == "RightMiddle"){
            dt = "dm-right";
        }else if(direction == "TopCenter"){
            dt = "dm-top";
        }else if(direction == "BottomCenter"){
            dt = "dm-bottom";
        }
        var idDirection =  $("#"+id).attr(dt);
        if(idDirection == "yes"){
            return true;
        }
        return false;
    };
    var setItem = function(bool1,bool2,item){
        var returnItem = item;
        if(bool1&&bool1){
            returnItem[0]=item[1];
            returnItem[1]=item[0];
        }else if(bool1){
            returnItem[0]=item[1];
        }else if(bool1){
            returnItem[1]=item[0];
        }
        console.log("setItem");
        console.log(returnItem);
        return returnItem;
    };
    var setPathFunc =function(){
        var path="1,12,13,16,14,15,11,17,18,19,110,111,112,113,114,115,116";
        var path = path.split(",");
        console.log(path);
        var ll =["LeftMiddle","LeftMiddle"];
        var lr =["LeftMiddle","RightMiddle"];
        var lt =["LeftMiddle","TopCenter"];
        var lb =["LeftMiddle","BottomCenter"];
        var rl =["RightMiddle","LeftMiddle"];
        var rr =["RightMiddle","RightMiddle"];
        var rt =["RightMiddle","TopCenter"];
        var rb =["RightMiddle","BottomCenter"];
        var tl =["TopCenter","LeftMiddle"];
        var tr =["TopCenter","RightMiddle"];
        var tt =["TopCenter","TopCenter"];
        var tb =["TopCenter","BottomCenter"];
        var bl =["BottomCenter","LeftMiddle"];
        var br =["BottomCenter","RightMiddle"];
        var bt =["BottomCenter","TopCenter"];
        var bb =["BottomCenter","BottomCenter"];


        for(var i =  0;i+1<path.length;i++){
            var startX = $("#course"+path[i]).attr("dm-x");
            var startY = $("#course"+path[i]).attr("dm-y");
            var endX = $("#course"+path[i+1]).attr("dm-x");
            var endY = $("#course"+path[i+1]).attr("dm-y");
            var item=rl;
            /**
             * 判断是否同列
             */
            //判断是否为开始
            var distance =15;
             if(startX==0&&startY==0){
                 setConnectBg("course"+path[i],"course"+path[i+1],item,15,true);
                 setConnect("course"+path[i],"course"+path[i+1],item,15,true);
             }else{
                 //同列
                 if(startX==endX){
                     if(endY-startY==1){
                         //相邻行，上指向下
                         item = bt;
                     }else if(endY-startY==-1){
                         //相邻行，下指向上
                         item = tb;
                     }else{
                         /*不相邻行；左右指向
                         *考虑：1左右指向节点是否被占用
                         */
                         item = ll;
                        var ll1=judgeDirectionIsTrue("course"+path[i],ll[0]);
                         var ll2=judgeDirectionIsTrue("course"+path[i+1],ll[1]);
                         if(ll1&&ll2){
                             item =rr;
                         }else if(ll1){
                             item =rl;
                         }else if(ll2){
                             item =lr;
                         }
                         console.log(item);
                         distance =15+parseInt(endY)*3.5;
                     }
                 }else{
                     //不同列，同行
                     if(startY==endY){
                         item = tt;
                     }else if(startX<endX){
                         item = rl;
                         var rl1=judgeDirectionIsTrue("course"+path[i],item[0]);
                         var rl2=judgeDirectionIsTrue("course"+path[i+1],item[1]);
                          while(rl1||rl2){
                              item = setItem(rl1,rl2,item);
                              rl1=judgeDirectionIsTrue("course"+path[i],item[0]);
                              rl2=judgeDirectionIsTrue("course"+path[i+1],item[1]);
                          }
                         distance =15+parseInt(endY)*3.5;
                     }else{
                         item = lr;
                         var lr1=judgeDirectionIsTrue("course"+path[i],item[0]);
                         var lr2=judgeDirectionIsTrue("course"+path[i+1],item[1]);
                         console.log(item);
                          while(lr1||lr2){
                             item = setItem(lr1,lr2,item);
                             lr1=judgeDirectionIsTrue("course"+path[i],item[0]);
                             lr2=judgeDirectionIsTrue("course"+path[i+1],item[1]);
                             console.log(lr1);
                             console.log(lr1);
                         }
                     }
                 }
                 setConnectBg("course"+path[i],"course"+path[i+1],item,distance);
                 setConnect("course"+path[i],"course"+path[i+1],item,distance);
             }
            setDirectionIsTrue("course"+path[i],item[0]);
            setDirectionIsTrue("course"+path[i+1],item[1]);
        }
    };
    setPathFunc();

    jsPlumb.fire("jsPlumbDemoLoaded", myJsPlumb);

});
