//-----------------------------------------全局变量-------------------------------------------
var mouseX //鼠标的位置
var mouseY //鼠标的位置
var controlHtml //被选中的控件
var isCanBePlaced = false //是否可以放置
var isDownControl = false //是否按下了控件
var formLeft = 0 //form表单的坐标
var formTop = 0
var formRight = 0
var formBottom = 0
var object //中部控件
var objectControl //中部控件点击后记录控件信息
var objectIndex //中部控件正在操作的id
var numberRegExp = '^[0-9]+$' //纯数字表达式
var letterRegExp = '^[a-zA-Z]+$' //纯字母
var chineseRegExp = '^[\u4e00-\u9fa5]{0,}$' //中文
var emailRegExp = '^[a-z0-9A-Z]+[- | a-z0-9A-Z . _]+@([a-z0-9A-Z]+(-[a-z0-9A-Z]+)?\\.)+[a-z]{2,}$' //邮箱
var mobileRegExp = '^((13[0-9])|(14[5,7])|(15[0-3,5-9])|(17[0,3,5-8])|(18[0-9])|166|198|199|(147))\\d{8}$' //手机号码
var idRegExp = '^((d{18})|([0-9x]{18})|([0-9X]{18}))$' //身份证
var ldgDefaultBtns = {
	//默认按钮  移动和删除
	move: { class: 'icon-yidong controlMove' },
	delete: { class: 'icon-shanchu controlDelete' },
}
var contorlCache = []

//-----------------------------------------初始化方法及页面加载方法-------------------------------------------
function Initialization(Parameters) {
	//先清除对应div中的html代码
	let el = '.DiyForm'
	if (Parameters['el']) {
		el = Parameters['el']
	}
	$(el).empty()
	let height = '100%'
	if (Parameters['height']) {
		height = Parameters['height']
	}
	$(el).height(height)
	var main = '<div class="LdgDiyForm" style="background:#edededa1;">'
	main += leftToolbar()
	main += centerMain()
	main += rightAttribute()
	main += '</div><div class="dragControl"></div>'
	main += '<div class="previewMain"></div>'

	//添加基本的界面布局
	$(el).append(main)

	$('.interval').css('height', document.body.offsetHeight + 'px') //初始化高度，跟浏览器可视高度一致
}
function GetBtns(btns, id) {
	let str = '<!--表单控件的功能按钮-->'
	str += '<div class="LdgFormItemGroupButton">'
	str += '<span class="LdgFormItemID">' + id + '</span>'
	if (btns) {
		for (let key in btns) {
			str += '<i  class="iconfont ' + btns[key].class + '"></i>'
		}
	} else {
		for (let key in ldgDefaultBtns) {
			str += '<i  class="iconfont ' + ldgDefaultBtns[key].class + '"></i>'
		}
	}
	str += '</div>'
	return str
}
function GetRequired(required) {
	if (required) {
		return '<div class="required">*</div>'
	}
	return ''
}

function GetCheck(required, check = false) {
	if (required || check) {
		return '<div class="errorMain"></div>'
	}
	return ''
}

function getRadioByTextAreaValue(TextAreaValue, optionvalue, id) {
	let spilts = TextAreaValue.split('\n')
	let str = ''
	spilts.forEach(function (item) {
		if (item != '') {
			let checked = ''
			if (item == optionvalue) {
				checked = " checked=''"
			}
			str += `<div class="radio"><label><input type="radio" name="${id}" value="${item}"${checked}>${item}</label></div>`
		}
	})
	return str
}

function getCheckBoxByTextAreaValue(TextAreaValue, optionvalue, id) {
	let spilts = TextAreaValue.split('\n')
	let spiltso = optionvalue.split('\n')
	let str = ''
	spilts.forEach(function (item) {
		if (item != '') {
			let checked = ''
			spiltso.forEach(function (item2) {
				if (item == item2) {
					checked = " checked=''"
				}
			})
			str += `<div class="checkbox"><label><input  name="${id}" type="checkbox" value="${item}"${checked}>${item}</label></div>`
		}
	})
	return str
}

function getSelectByTextAreaValue(TextAreaValue, optionvalue, id) {
	let spilts = TextAreaValue.split('\n')
	if (!optionvalue || optionvalue.indexOf('请选择') == 0) {
		optionvalue = ''
	}
	let str = '<select name="${id}" class="form-control">'
	spilts.forEach(function (item) {
		let itemvalue = item
		if (itemvalue.indexOf('请选择') == 0) {
			itemvalue = ''
		}
		if (item != '') {
			let selected = ''
			if (itemvalue == optionvalue) {
				selected = " selected=''"
			}
			str += `<option value="${itemvalue}"${selected}>${item}</option>`
		}
	})
	str += '</select>'
	return str
}

function getTextSelectByTextAreaValue(TextAreaValue, id) {
	let spilts = TextAreaValue.split('\n')
	let str = '<input type="text" name="${id}" class="form-control selectInput formVal"><div class="selectInputDiv" title="下拉菜单">'
	spilts.forEach(function (item) {
		if (item != '') {
			str += '<p class="selectInputDivP">' + item + '</p>'
		}
	})
	str += '</div>'
	return str
}
let ldgFormConfig={
	width: { name: '组件标签宽度', value: '100', type: 'number' },
	align: { name: '标签对齐方式', value: 0, options: { 右侧对齐: 0, 顶部对齐: 1, 左侧对齐: 2 }, type: 'radio' },
}
let controlList = {
	//控件英文名
	text: {
		name: '文本框', //控件名称
		icon: 'icon-duohangshurukuang', //控件图标
		datas: {
			//控件属性
			//对象名:{name:"属性名称",value:"默认值",type:"text(文本类型)|number(数字类型)|date(日期型)|select(下拉选择)|radio(单选框)",options(仅支持下拉和单选框):{ 选项1: "值1", 选项2: "值1",选项3:"other(如果值为other,下拉选择支持自定义输入)" }}
			name: { name: '控件名称', value: '文本框', type: 'text' },
			placeholder: { name: '提示语句', value: '', type: 'text' },
			value: { name: '默认内容', value: '', type: 'text' },
			check: { name: '校验规则', value: '', options: { 无需校验: '', 数字: numberRegExp, 字母: letterRegExp, 中文: chineseRegExp, 邮箱: emailRegExp, 手机号: mobileRegExp, 身份证: idRegExp, 自定义: 'other' }, type: 'select' },
			required: { name: '是否必填', value: 0, options: { 必填: 0, 选填: 1 }, type: 'radio' },
		},
		btns: {
			move: { class: 'icon-yidong controlMove' },
			delete: { class: 'icon-shanchu controlDelete' },
		},
		getHtml: function () {
			return '<input name="'+this.datas.id.value+'" type="text" class="form-control formVal">'
		},
	}, //文本框
	multiple: {
		name: '多行文本框',
		icon: 'icon-danhangshurukuang',
		datas: {
			name: { name: '控件名称', value: '多行文本框', type: 'text' },
			placeholder: { name: '提示语句', value: '', type: 'text' },
			value: { name: '默认内容', value: '', type: 'textarea' },
			height: { name: '控件高度', value: 100, type: 'number' },
			required: { name: '是否必填', value: 0, options: { 必填: 0, 选填: 1 }, type: 'radio' },
		},
		getHtml: function () {
			return '<textarea name="'+this.datas.id.value+'" class="form-control formVal" cols="30" rows="5" style="resize: none;"></textarea>'
		},
	}, //多行文本框
	date: {
		name: '时间选择框',
		icon: 'icon-shijianxuanzeqi',
		datas: {
			name: { name: '控件名称', value: '时间框', type: 'text' },
			value: { name: '默认内容', value: '', type: 'date' },
			required: { name: '是否必填', value: 0, options: { 必填: 0, 选填: 1 }, type: 'radio' },
		},
		getHtml: function () {
			return '<input name="'+this.datas.id.value+'" type="date" class="form-control formVal">'
		},
	}, //时间选择框
	radio: {
		name: '单选框',
		icon: 'icon-danxuan',
		datas: {
			name: { name: '控件名称', value: '单选框', type: 'text' },
			value: { name: '默认勾选', value: '选项一', type: 'text' },
			options: { name: '单选框选项（一行一个选项）', value: '选项一\n选项二', type: 'textarea' },
			required: { name: '是否必填', value: 0, options: { 必填: 0, 选填: 1 }, type: 'radio' },
		},
		getHtml: function () {
			return getRadioByTextAreaValue(this.datas.options.value, this.datas.value.value, this.datas.id.value)
		},
	}, //单选框
	checkbox: {
		name: '多选框',
		icon: 'icon-duoxuan',
		datas: {
			name: { name: '控件名称', value: '多选框', type: 'text' },
			value: { name: '默认勾选', value: '多选一\n多选二', type: 'textarea' },
			options: { name: '多选框选项（一行一个选项）', value: '多选一\n多选二\n多选三', type: 'textarea' },
			required: { name: '是否必填', value: 0, options: { 必填: 0, 选填: 1 }, type: 'radio' },
		},
		getHtml: function () {
			return getCheckBoxByTextAreaValue(this.datas.options.value, this.datas.value.value, this.datas.id.value)
		},
	}, //多选框
	dropdown: {
		name: '下拉选择框',
		icon: 'icon-choose1',
		datas: {
			name: { name: '控件名称', value: '下拉选择框', type: 'text' },
			value: { name: '默认选择', value: '请选择省份', type: 'text' },
			options: { name: '下拉框选项（一行一个选项）', value: '请选择省份\n河南\n河北\n山东', type: 'textarea' },
			required: { name: '是否必填', value: 0, options: { 必填: 0, 选填: 1 }, type: 'radio' },
		},
		getHtml: function () {
			return getSelectByTextAreaValue(this.datas.options.value, this.datas.value.value, this.datas.id.value)
		},
	}, //下拉选择框
	textdropdown: {
		name: '文本下拉框',
		icon: 'icon-xialaxuanze',
		datas: {
			name: { name: '控件名称', value: '文本下拉框', type: 'text' },
			value: { name: '默认内容', value: '', type: 'text' },
			placeholder: { name: '提示语句', value: '', type: 'text' },
			options: { name: '下拉框选项（一行一个选项）', value: '操作证一级\n操作证二级\n电工操作证', type: 'textarea' },
			required: { name: '是否必填', value: 0, options: { 必填: 0, 选填: 1 }, type: 'radio' },
		},
		getHtml: function () {
			return getTextSelectByTextAreaValue(this.datas.options.value, this.datas.value.value, this.datas.id.value)
		},
	}, //文本下拉框
	//img: { name: '图片上传', icon: 'icon-ic_image_upload' }, //图片上传
	//file: { name: '文件上传', icon: 'icon-wenjianshangchuan' }, //文件上传
}
//左侧工具栏
function leftToolbar() {
	//<!--左侧工具栏-->
	var str = '<div class="ldgFormControl">'
	str += '<p class="LdgFormTitle">工具栏</p>'
	str += '<div class="LdgFormControls">'
	for (var key in controlList) {
		str += '<div class="controlName" data-type="' + key + '">'
		str += '<div class="controlRealName"><i  class="iconfont ' + controlList[key].icon + '"></i>' + controlList[key].name + '</div>'
		str += '</div>'
	}
	str += '</div></div>'
	return str
}

//中部控件主体
function centerMain() {
	//<!--中间内容区域-->
	var str = '<div class="ldgFormDesigner">'
	//<!--主体部分-->
	str += '<div class="LdgFormSubject ldgPrew ldgRight">'
	str += `<div class="LdgFormButton">
	<button class="btn btn-danger btn-xs ldgFormClearAll"><span class="glyphicon glyphicon-trash" aria-hidden="true"></span>清空</button>
	<span class="pull-right">
	<button class="btn btn-info btn-xs ldgFormImport"><span class="glyphicon glyphicon-import" aria-hidden="true"></span>导入JSON</button>
	<button class="btn btn-info btn-xs ldgFormExport"><span class="glyphicon glyphicon-export" aria-hidden="true"></span>导出JSON</button>
	<button class="btn btn-success btn-xs ldgFormPreview"><span class="glyphicon glyphicon-sunglasses" aria-hidden="true"></span>预览表单</button>
	<button class="btn btn-default btn-xs ldgFormConfigShow"><span class="glyphicon glyphicon-sunglasses" aria-hidden="true"></span>表单属性</button>
	</span>
	</div>`
	str += '<form class="LdgFormSubjectForm"></form>'
	str += '</div></div>'
	return str
}

//右侧属性栏
function rightAttribute() {
	//<!--右侧属性框-->
	var str = '<div class="ldgFormConfig">'
	str += '<p class="LdgFormTitle">表单属性  <button class="btn btn-danger btn-xs closeAttr"><span class="glyphicon glyphicon-remove" aria-hidden="true"></span>关闭</button></p>'
	str += '<div class="LdgFormConfigs"></div></div>'
	str += '<div class="ldgFormProperties">'
	str += '<p class="LdgFormTitle">组件设置  <button class="btn btn-danger btn-xs closeAttr"><span class="glyphicon glyphicon-remove" aria-hidden="true"></span>关闭</button></p>'
	str += '<div class="LdgFormAttribute" data-type=""></div>'
	/*
    //<!--图片框属性-->
    str +=
        '<div class="LdgFormAttribute" data-type="img">                     <div class="form-group">                         <label>控件名称</label>                         <input type="text" class="form-control controlAttributeName">                     </div>                     <div class="form-group">                         <label>上传数量</label>                         <input type="number" class="form-control uploadNum">                     </div>                     <div class="form-group">                         <label>此题</label>                         <div class="row">                             <div class="col-lg-6">                                 <div class="form-check">                                     <label class="form-check-label">                                         <input type="radio" class="form-check-input" name="ChoiceRadio"                                             value="0" >                                         必填                                     </label>                                 </div>                             </div>                             <div class="col-lg-6">                                 <div class="form-check">                                     <label class="form-check-label">                                         <input type="radio" class="form-check-input" name="ChoiceRadio"                                             value="1">                                         选填                                     </label>                                 </div>                             </div>                         </div>                     </div>                 </div> '
    //<!--文件框属性-->
    str +=
        '<div class="LdgFormAttribute" data-type="file">                     <div class="form-group">                         <label>控件名称</label>                         <input type="text" class="form-control controlAttributeName">                     </div>                     <div class="form-group">                         <label>上传数量</label>                         <input type="number" class="form-control uploadNum">                     </div>                     <div class="form-group">                         <label>此题</label>                         <div class="row">                             <div class="col-lg-6">                                 <div class="form-check">                                     <label class="form-check-label">                                         <input type="radio" class="form-check-input" name="ChoiceRadio"                                             value="0" >                                         必填                                     </label>                                 </div>                             </div>                             <div class="col-lg-6">                                 <div class="form-check">                                     <label class="form-check-label">                                         <input type="radio" class="form-check-input" name="ChoiceRadio"                                             value="1">                                         选填                                     </label>                                 </div>                             </div>                         </div>                     </div>                 </div>'
    */

	str += '</div>'
	return str
}

//-----------------------------------------中部控件的显示方法-------------------------------------------

//图片
function getImg() {
	//<!--具体的表单控件 图片-->
	var str = '<div class="row"><div class="LdgFormItem" data-type="img" data-choice="true" data-num="1" >'
	//<!--表单控件的头部-->
	str += '<div class="LdgFormItemHead">'
	//<!--表单控件的名称-->
	str += '<div class="required">*</div><div class="LdgFormItemName">上传图片</div>'
	//<!--表单控件的功能按钮-->
	str += '<div class="LdgFormItemGroupButton">'
	str += '<button type="button" class="btn btn-primary controlMove">移动</button>'
	str += '<button type="button" class="btn btn-primary controlDelete">删除</button>'
	str += '</div></div>'
	//<!--控件-->
	str += '<div class="LdgFormItemContent">'
	str += '<div class="form-group hidMargin">'
	str += '<div class="img-box full">'
	str += '<section class="img-section">'
	str += '<div class="z_photo upimg-div clear">'
	str += '<section class="z_file fl">'
	str += '<div class="z_fileImgDel">删除</div>'
	str += '<img src="../images/a11.png" class="add-img" />'
	str += '<input type="file" name="file" class="file imgFile" value="" accept="image/jpg,image/jpeg,image/png,image/bmp" leipiplugins="imgupload" title="图片上传" />'
	str += '</section></div></section>'
	str += '<div class="imgExplain">支持jpg、jpeg、png、bmp等图片格式</div>'
	str += '<div class="errerClass imgErrer"></div>'
	str += '</div>'
	str += '</div><div class="errorMain"></div></div></div></div>'
	return str
}

//文件
function getFile() {
	//<!--具体的表单控件 图片-->
	var str = '<div class="row"><div class="LdgFormItem" data-type="file" data-choice="true" data-num="1" >'
	//<!--表单控件的头部-->
	str += '<div class="LdgFormItemHead">'
	//<!--表单控件的名称-->
	str += '<div class="required">*</div><div class="LdgFormItemName">上传文件</div>'
	//<!--表单控件的功能按钮-->
	str += '<div class="LdgFormItemGroupButton">'
	str += '<button type="button" class="btn btn-primary controlMove">移动</button>'
	str += '<button type="button" class="btn btn-primary controlDelete">删除</button>'
	str += '</div></div>'
	//<!--控件-->
	str += '<div class="LdgFormItemContent">'
	str += '<div class="form-group hidMargin">'
	str += '<div class="message">'
	str += '<div class="messagedel">删除</div>'
	str += '<input type="text" name="txt" class="input fileUpload form-control" value="" disabled="disabled" />'
	str += '<input type="button" value="上传文件" size="30" class="liulan fileUploadBtn">'
	str += '<input type="file" name="f" style="height:26px;" class="files leipiplugins fileUploadReal" size="1" leipiplugins="uploadfile" title="文件上传" hidefocus></div>'
	str += '<div class="fileTips">'
	str += '<p>1.上传文档不超过100MB</p>'
	str += '<p>2.为了保证文档能正常使用，我们支持以下格式的文档上传：</p>'
	str += '<p>MS Office文档： doc,docx,ppt,pptx,xls,xlsx,vsd,pot,pps,rtf</p>'
	str += '<p>压缩文档： rar,zip,tar,gz,tgz</p>'
	str += '<p>图片： jpg,jpeg,gif,bmp,png</p>'
	str += '<p>WPS office系列： wps,et,dps</p>'
	str += '<p>PDF： pdf</p>'
	str += '<p>纯文本： txt</p>'
	str += '<p>EPUB： epub</p></div>'
	str += '<div class="errerClass FileErrer"></div>'
	str += '</div><div class="errorMain"></div></div></div></div>'
	return str
}

function switchType(typeinfo, type,isdiy) {
	if ('undefined' != typeof typeinfo.getDiyHtml) {
		return typeinfo.getDiyHtml(isdiy)
	}
	if ('undefined' != typeof typeinfo.getHtml) {
		let html='<div class="row"><div class="LdgFormItem" data-id="'+typeinfo.datas.id.value+'" data-type="' + type + '">' + '<div class="LdgFormItemHead"><div class="LdgFormItemName">' + GetRequired(typeinfo.datas.required) + '<span>' + typeinfo.datas.name.value + '</span>' + '</div></div>';
		if(isdiy)
		{
			html += GetBtns(typeinfo.btns, typeinfo.datas.id.value) 
		}
		html+='<div class="LdgFormItemContent"><div class="form-group hidMargin">' + typeinfo.getHtml(isdiy) + '</div>' + GetCheck(typeinfo.datas.required, typeinfo.datas.check) + '</div>'
		return html
	}
	var str
	switch (type) {
		case 'img':
			str = getImg()
			break
		case 'file':
			str = getFile()
			break
		default:
			str = ''
			break
	}
	return str
}

//-----------------------------------------左侧工具栏事件-------------------------------------------
//左侧工具栏鼠标按下控件事件
$('body').on('mousedown', '.controlName', function (e) {
	e.preventDefault()
	mouseX = e.clientX //获取鼠标所在的x坐标
	mouseY = e.clientY //获取鼠标所在的y坐标
	controlHtml = $(this).prop('outerHTML')
	var style = 'class="controlName controlNameMove" '
	style += 'style="width:' + $(this).width() + 'px;'
	style += 'position: absolute;'
	style += 'background: #fff;'
	style += 'z-index: 100;'
	style += 'top: ' + new Number(mouseY - $(this).height() / 2) + 'px;'
	style += 'left: ' + new Number(mouseX - $(this).width() / 2) + 'px;'
	style += '"'
	controlHtml = controlHtml.replace('class="controlName"', style)
	$('.dragControl').append(controlHtml)
	//获取form的坐标
	var LdgFormSubjectForm = $('.LdgFormSubject')
	formLeft = $(LdgFormSubjectForm).offset().left
	formTop = $(LdgFormSubjectForm).offset().top
	formRight = formLeft + LdgFormSubjectForm.width()
	formBottom = formTop + LdgFormSubjectForm.height()
	//按下了控件,触发滑动事件里的效果
	isDownControl = true
	$('.LdgDiyForm').removeClass('hasProperties')
})

//左侧工具栏鼠标松开控件事件
$('body').on('mouseup', '.controlName', function (e) {
	e.preventDefault()
	//松开了控件，不触发滑动事件里的效果
	isDownControl = false
	var type = $(this).data('type')
	//处于放置的位置才能在中部区域增加控件
	if (isCanBePlaced) {
		isCanBePlaced = false
		addControl(type)
		ApplyConfig()
	}
	$('.LdgFormSubjectForm').removeClass('placeLocationBottom')
	$('.LdgFormSubjectForm').removeClass('placeLocationTop')
	$('.dragControl').empty()
})

//-----------------------------------------中部区域事件-------------------------------------------
//中部控件删除事件
$('body').on('click', '.controlDelete', function (e) {
	e.stopPropagation() //阻止事件冒泡
	let type = $(this).parents('.LdgFormItem').data('type') //点击的元素类型
	var index = $(this).index('.controlDelete')
	$('.LdgFormSubjectForm').children().eq(index).remove()
	$('.LdgDiyForm').removeClass('hasProperties')
	contorlCache.splice(index,1)
})

//中部控件按下事件
$('body').on('mousedown', '.controlMove', function (e) {
	e.preventDefault()
	mouseX = e.clientX //获取鼠标所在的x坐标
	mouseY = e.clientY //获取鼠标所在的y坐标
	controlHtml = $(this).parents('.row').html()
	var style = 'class="LdgFormItem LdgFormItemMove" '
	style += 'style="width:' + $(this).parents('.row').width() + 'px;'
	style += 'position: absolute;'
	style += 'background: #fff;'
	style += 'z-index: 100;'
	style += 'top: ' + new Number(mouseY - $(this).parents('.row').height()) + 'px;' // / 2是中间
	style += 'left: ' + new Number(mouseX - $(this).parents('.row').width()) + 'px;'
	style += '"'
	controlHtml = controlHtml.replace('class="LdgFormItem"', style)
	controlHtml = '<div class="row">' + controlHtml + '</div>'
	$('.dragControl').append(controlHtml)
	//获取form的坐标
	var LdgFormSubjectForm = $('.LdgFormSubject')
	formLeft = getRealLocationLeft(LdgFormSubjectForm, 0)
	formTop = getRealLocationTop(LdgFormSubjectForm, 0)
	formRight = formLeft + LdgFormSubjectForm.width()
	formBottom = formTop + LdgFormSubjectForm.height()
	//按下了控件,触发滑动事件里的效果
	isDownControl = true

	var index = $(this).index('.controlMove')
	$('.LdgFormSubjectForm').children().eq(index).remove()
})

//中部控件松开事件
$('body').on('mouseup', '.LdgFormItemMove', function (e) {
	e.preventDefault()
	$(this).removeAttr('style')
	var str = $('.LdgFormItemMove').parents('.dragControl').html()
	str = str.replace(' LdgFormItemMove', '')

	//获取当前中部控件，删除放置效果
	var item = $('.LdgFormSubjectForm').find('.row')

	//处于放置的位置才能在中部区域增加控件
	if (isCanBePlaced && isDownControl) {
		if (item.length > 0) {
			//判断是否位置放好了，有时候没有放置在控件上，就放置到最底层
			var isSelectPosition = false
			for (var i = 0; i < item.length; i++) {
				if (item.eq(i).hasClass('placeLocationBottom')) {
					item.eq(i).after(str)
					item.eq(i).removeClass('placeLocationBottom')
					isSelectPosition = true
				} else if (item.eq(i).hasClass('placeLocationTop')) {
					item.eq(i).before(str)
					item.eq(i).removeClass('placeLocationTop')
					isSelectPosition = true
				}
			}
			if (!isSelectPosition) {
				$('.LdgFormSubjectForm').append(str)
			}
		} else {
			$('.LdgFormSubjectForm').append(str)
		}
	} else {
		//放置在其他地区时，直接删除样式，添加到最后一个位置
		if (item.length > 0) {
			//删除样式
			for (var i = 0; i < item.length; i++) {
				item.eq(i).removeClass('placeLocationBottom')
				item.eq(i).removeClass('placeLocationTop')
			}
		}
		$('.LdgFormSubjectForm').append(str)
	}

	$('.LdgFormSubjectForm').removeClass('placeLocationBottom')
	$('.LdgFormSubjectForm').removeClass('placeLocationTop')
	//松开了控件，不触发滑动事件里的效果
	isDownControl = false
	$('.dragControl').empty()
})

//中间控件点击事件（显示右侧属性栏）
$('body').on('click', '.ldgPrew .LdgFormItem', function () {
	$('.LdgDiyForm').addClass('hasProperties')
	$(".ldgFormProperties").addClass("showAttr")
	$(".ldgFormConfig").removeClass("showAttr")
	object = $(this)
	objectIndex = $('.ldgPrew .LdgFormItem').index($(this))
	let datas = contorlCache[objectIndex].datas
	AttributeShow('.LdgFormAttribute',datas)
})

//-----------------------------------------右侧属性栏事件-------------------------------------------
//显示属性框的方法
function AttributeShow(showel,datas) {
	var attribute = $(showel)
	//if (attribute.data('type') != object.data('type')) {
	//attribute.data('type', object.data('type'))
	//objectControl = controlList[object.data('type')]
	//let datas = objectControl.datas
	
	if (datas) {
		//$('.LdgFormAttribute').html(controlList[object.data('type')].attr)
		let html = ''
		for (let key in datas) {
			//let cvalue = object.data(key)
			let cvalue = datas[key].value
			// if (!cvalue) {
			// 	cvalue = datas[key].value
			// }
			if (datas[key].type == 'text' || datas[key].type == 'number' || datas[key].type == 'date') {
				//字符串输入框属性
				html += `<div class="form-group" attrname="${key}"><label>${datas[key].name}</label><input type="${datas[key].type}" value="${cvalue}" class="form-control"></div>`
			} else if (datas[key].type == 'textarea') {
				//多行字符串输入框属性
				html += `<div class="form-group" attrname="${key}"><label>${datas[key].name}</label> <textarea class="form-control" rows="5">${cvalue}</textarea></div>`
			} else if (datas[key].type == 'select') {
				//下拉框属性
				html += `<div class="form-group"  attrname="${key}"><label>${datas[key].name}</label><select class="form-control">`
				let othervalue = 'other'
				for (let key2 in datas[key].options) {
					if (datas[key].options[key2] == cvalue) {
						othervalue = ''
					}
				}
				for (let key2 in datas[key].options) {
					let tempselected = ''
					if (datas[key].options[key2] == cvalue || othervalue == datas[key].options[key2]) {
						tempselected = 'selected'
					}
					html += `<option ${tempselected} value="${datas[key].options[key2]}">${key2}</option>`
				}
				html += '</select>'
				html += '<input type="text" class="form-control other" placeholder="请输入自定义内容" style="display: ' + (othervalue != '' ? 'inline-block' : 'none') + ';" value="' + cvalue + '"></input>'
				html += '</div>'
			} else if (datas[key].type == 'radio') {
				//单选框属性
				html += `<div class="form-group"  attrname="${key}"><label>${datas[key].name}</label><div class="row">`
				let radioclass="col-lg-6";
				if(Object.keys(datas[key].options).length!=2)
				{
					radioclass="col-lg-12";
				}
				for (let key2 in datas[key].options) {
					let tempchecked = ''
					if (datas[key].options[key2] == cvalue) {
						tempchecked = 'checked'
					}
					html += `<div class="${radioclass}"><div class="form-check"><label class="form-check-label"><input type="radio" class="form-check-input" ${tempchecked} name="${key}" value="${datas[key].options[key2]}">${key2}</label></div></div>`
				}
				html += '</div></div>'
			}
		}
		$(showel).html(html)
	} else {
		$(showel).html('无属性选项')
		return
	}
	//}

	// //显示默认值
	// if (object.data('type') == 'text' || object.data('type') == 'multiple' || object.data('type') == 'date') {
	// 	attribute.find('.textDetailsName').val(object.find('.formVal').val())
	// }
	// //显示限制条件
	// if (object.data('type') == 'text') {
	// 	var limit = object.data('limit')
	// 	var optionss = attribute.find('.limitSelect option')
	// 	var auto = true //自定义正则表达式
	// 	for (var k = 0; k < optionss.length; k++) {
	// 		var op = optionss.eq(k).val()
	// 		if (op == limit) {
	// 			optionss.eq(k).prop('selected', 'selected')
	// 			auto = false
	// 		} else {
	// 			optionss.eq(k).prop('selected', false)
	// 		}
	// 	}
	// 	//是自定义表达式
	// 	if (auto) {
	// 		optionss.eq(optionss.length - 1).prop('selected', 'selected')
	// 		$('.textRegularCustom').show().text(limit)
	// 	} else {
	// 		$('.textRegularCustom').hide().text('')
	// 	}
	// }
	// //显示文件可上传数量
	// if (object.data('type') == 'img' || object.data('type') == 'file') {
	// 	attribute.find('.uploadNum').val(object.data('num'))
	// }
	// //显示下拉框值
	// if (object.data('type') == 'radio' || object.data('type') == 'checkbox') {
	// 	var inputs = object.find('input')
	// 	var inputval = ''
	// 	for (var j = 0; j < inputs.length; j++) {
	// 		inputval += inputs.eq(j).val() + '\n'
	// 	}
	// 	attribute.find('.selectAttr').val(inputval)
	// } else if (object.data('type') == 'dropdown') {
	// 	var inputs = object.find('option')
	// 	var inputval = ''
	// 	for (var j = 0; j < inputs.length; j++) {
	// 		inputval += inputs.eq(j).val() + '\n'
	// 	}
	// 	attribute.find('.selectAttr').val(inputval)
	// } else if (object.data('type') == 'textdropdown') {
	// 	var inputs = object.find('.form-group').find('p')
	// 	var inputval = ''
	// 	for (var j = 0; j < inputs.length; j++) {
	// 		inputval += inputs.eq(j).text() + '\n'
	// 	}
	// 	attribute.find('.selectAttr').val(inputval)
	// }
}
function getAttrValue(obj,type)
{
	let tempvalue = ''
	if (type == 'text' || type == 'number' || type == 'date') {
		tempvalue = $(obj).find('input').val()
	} else if (type == 'textarea') {
		tempvalue = $(obj).find('textarea').val()
	} else if (type == 'select') {
		tempvalue = $(obj).find('option:selected').val()
		if (tempvalue == 'other') {
			tempvalue = $(obj).find('.other').val()
			//如果有其它选项,则支持输入自定义内容
			$(obj).find('.other').show()
		} else {
			$(obj).find('.other').hide()
		}
	} else if (type == 'radio') {
		tempvalue = $(obj).find('input:radio:checked').val()
	}
	return tempvalue
}
//修改控件属性 改变属性 修改属性 属性修改 组件设置
$('body').on('change', '.LdgFormAttribute .form-group', function () {
	let temptypekey = object.data('type') //当前控件的类型
	let tempkey = $(this).attr('attrname') //修改的参数名称
	let temptype = contorlCache[objectIndex].datas[tempkey].type //要修改的参数类型
	let tempvalue =getAttrValue($(this),temptype)
	ChangeControl(tempkey, tempvalue, temptypekey,contorlCache[objectIndex].datas)
	//object.attr('data-' + tempkey, tempvalue)
	contorlCache[objectIndex].datas[tempkey].value = tempvalue
})

//表单属性 属性修改
$('body').on('change', '.LdgFormConfigs .form-group', function () {
	let tempkey = $(this).attr('attrname') //修改的参数名称
	let temptype = ldgFormConfig[tempkey].type //要修改的参数类型
	let tempvalue =getAttrValue($(this),temptype)
	ldgFormConfig[tempkey].value = tempvalue
	ChangeConfig(tempkey, tempvalue,".ldgPrew")
})
function ApplyConfig(showel=".ldgPrew")
{
	for(let key in ldgFormConfig)
	{
		ChangeConfig(key, ldgFormConfig[key].value,showel)
	}
	
}
function ChangeConfig(key,value,showel)
{
	if(key=="width")
	{
		$(showel+" .LdgFormItemHead").width(value)
	}else if(key=="align")
	{
		$(showel).removeClass("ldgRight").removeClass("ldgLeft")
		if(value==0)
		{
			$(showel).addClass("ldgRight")
		}else if(value==2)
		{
			$(showel).addClass("ldgLeft")
		}
	}
}

//修改单选框、复选框、下拉框、文本下拉框的选项值
$('body').on('change', '.selectAttr', function () {
	var val = $(this).val()
	if (val != '') {
		var spilts = val.split('\n')
		var inputName = 'selectName'
		if (object.data('type') == 'radio' || object.data('type') == 'checkbox') {
			var checkMargin = object.find('.checkMargin')
			if (checkMargin != null && checkMargin.length > 0) {
				inputName = checkMargin.eq(0).attr('name')
			}
		}
		object.find('.form-group').children().remove()
		var str = ''
		if (object.data('type') == 'dropdown') {
			str += '<select class="form-control">'
		} else if (object.data('type') == 'textdropdown') {
			str += '<input type="text" class="form-control"><div class="selectInputDiv" title="下拉菜单">'
		}
		for (var i = 0; i < spilts.length; i++) {
			if (spilts[i] != '') {
				str += getMoreHtml(object.data('type'), spilts[i], inputName)
			}
		}
		if (object.data('type') == 'dropdown') {
			str += '</select>'
		} else if (object.data('type') == 'textdropdown') {
			str += '</div>'
		}
		object.find('.form-group').append(str)
	}
})

//文本框的限制条件
// $('body').on('change', '.limitSelect', function () {
// 	var val = $(this).val()
// 	object.attr('data-limit', val)
// 	object.data('limit', val)
// 	var errorTips = RegExpErrorTips(val)
// 	object.attr('data-limiterror', errorTips)
// 	object.data('limiterror', errorTips)
// 	if (val == 'auto') {
// 		$('.textRegularCustom').show()
// 	} else {
// 		$('.textRegularCustom').hide()
// 	}
// })

//自定义正则表达式
// $('body').on('change', '.textRegularCustom', function () {
// 	object.attr('data-limit', $(this).val())
// 	object.data('limit', $(this).val())
// })

//上传图片和文件的数量
$('body').on('change', '.uploadNum', function () {
	object.attr('data-num', $(this).val())
	object.data('num', $(this).val())
})

//-----------------------------------------全局事件-------------------------------------------
//鼠标移动事件
document.onmousemove = function (e) {
	//e.preventDefault()
	if (isDownControl) {
		mouseX = e.clientX //获取鼠标所在的x坐标
		mouseY = e.clientY //获取鼠标所在的y坐标
		//让鼠标在控件的中心位置
		var width = $('.controlNameMove').width() / 2
		var height = $('.controlNameMove').height() / 2
		$('.controlNameMove')
			.css('top', mouseY - height + 'px')
			.css('left', mouseX - width + 'px')
		var widthItem = $('.LdgFormItemMove').width() - 30 // / 2是中间
		var heightItem = $('.LdgFormItemMove').height() - 30
		$('.LdgFormItemMove')
			.css('top', mouseY - heightItem + 'px')
			.css('left', mouseX - widthItem + 'px')
		if (formLeft < mouseX && mouseX < formRight && formTop < mouseY && mouseY < formBottom) {
			//是否可以放置
			isCanBePlaced = true

			//获取中部的控件
			var item = $('.LdgFormSubjectForm').find('.row')
			if (item.length > 0) {
				//先删除放置的位置样式
				for (var i = 0; i < item.length; i++) {
					item.eq(i).removeClass('placeLocationBottom')
					item.eq(i).removeClass('placeLocationTop')
				}
				$('.LdgFormSubjectForm').removeClass('placeLocationBottom')
				$('.LdgFormSubjectForm').removeClass('placeLocationTop')

				//判断是否位置放好了，有时候没有放置在控件上，就放置到最底层
				var isSelectPosition = false
				for (var i = 0; i < item.length; i++) {
					var itemTop = getRealLocationTop(item.eq(i), 0)
					var itemCenter = itemTop + item.eq(i).height() / 2
					var itemBottom = itemTop + item.eq(i).height()
					//根据鼠标和控件的位置，判断是在哪个控件上
					if (itemTop < mouseY && mouseY < itemCenter) {
						//处于该控件上半部分
						item.eq(i).addClass('placeLocationTop')
						isSelectPosition = true
					} else if (itemCenter < mouseY && mouseY < itemBottom) {
						//处于该控件下半部分
						item.eq(i).addClass('placeLocationBottom')
						isSelectPosition = true
					}
				}
				if (!isSelectPosition) {
					$('.LdgFormSubjectForm').addClass('placeLocationBottom')
				}
			} else {
				$('.LdgFormSubjectForm').addClass('placeLocationTop')
			}
		} else {
			isCanBePlaced = false
		}
	}
}

//获取控件在整个页面中的真实位置X
function getRealLocationLeft(val, left) {
	if (val[0].nodeName != '#document') {
		left += val.position().left
		left = getRealLocationLeft(val.parent(), left)
	}
	return left
}

//获取控件在整个页面中的真实位置Y
function getRealLocationTop(val, top) {
	if (val[0].nodeName != '#document') {
		top += val.position().top
		top = getRealLocationTop(val.parent(), top)
	}
	return top
}

//获取单选框、复选框、下拉框、文本下拉框的html
function getMoreHtml(type, inputval, inputName) {
	var str = ''
	if (type == 'radio') {
		str += '<div class="form-check"><label class="form-check-label"><input type="radio" class="form-check-input checkMargin" name="' + inputName + '" value="' + inputval + '">' + inputval + '</label></div>'
	} else if (type == 'checkbox') {
		str += '<div class="form-check"><label class="form-check-label"><input type="checkbox" class="form-check-input checkMargin" name="' + inputName + '" value="' + inputval + '">' + inputval + '</label></div>'
	} else if (type == 'dropdown') {
		str += '<option>' + inputval + '</option>'
	} else if (type == 'textdropdown') {
		str += '<p>' + inputval + '</p>'
	}
	return str
}

//正则表达式错误提示
function RegExpErrorTips(val) {
	var str = ''
	if (val == numberRegExp) {
		str = '只能输入纯数字'
	} else if (val == letterRegExp) {
		str = '只能输入纯字母'
	} else if (val == emailRegExp) {
		str = '只能输入邮箱'
	} else if (val == mobileRegExp) {
		str = '只能输入手机号码'
	} else if (val == idRegExp) {
		str = '只能输入身份证号码'
	} else if (val == chineseRegExp) {
		str = '只能输入中文'
	}
	return str
}
function addControl(type, typeinfo = null,previewel="") {
	
	let typec = controlList[type].deepClone()

	typec.datas['id'] = { name: '控件标识', value: type + '_' + Math.round(new Date().getTime()), type: 'text' }
	if (typeinfo != null) {
		for (let key in typeinfo) {
			typec.datas[key].value = typeinfo[key]
		}
	}
	let isdiyform=false
	if (previewel==""){previewel='.LdgFormSubjectForm';isdiyform=true}

	typec['type'] = type
	var str = switchType(typec, type,isdiyform)
    
	//获取当前中部控件，删除放置效果及处理单选框多选框name相同的问题
	var item = $(previewel).find('.row')

	if (item.length > 0) {
		//判断是否位置放好了，有时候没有放置在控件上，就放置到最底层
		var isSelectPosition = false
		for (var i = 0; i < item.length; i++) {
			if (item.eq(i).hasClass('placeLocationBottom')) {
				if(isdiyform){contorlCache.splice(i + 1, 0, typec)}
				item.eq(i).after(str)
				object = $(item.eq(i)).next()
				item.eq(i).removeClass('placeLocationBottom')
				isSelectPosition = true
			} else if (item.eq(i).hasClass('placeLocationTop')) {
				if(isdiyform){contorlCache.splice(i, 0, typec)}
				item.eq(i).before(str)
				object = $(item.eq(i)).prev()
				item.eq(i).removeClass('placeLocationTop')
				isSelectPosition = true
			}
		}
		if (!isSelectPosition) {
			object = $(str).appendTo(previewel)
			if(isdiyform){contorlCache.push(typec)}
		}
	} else {
		object = $(str).appendTo(previewel)
		if(isdiyform){contorlCache.push(typec)}
	}
	object=$(object).find(".LdgFormItem")
	if (typeinfo != null) {
		ChangeControl('id', typeinfo['id'], 'text')
		for (let key in typeinfo) {
			ChangeControl(key, typeinfo[key], type,typec.datas)
		}
	}
}
function ChangeControl(AttrKey, AttrValue, AttrType,datas) {
	if (AttrKey == 'name') {
		object.find('.LdgFormItemName span').text(AttrValue)
	} else if (AttrKey == 'options'||AttrKey == 'value') {
		let tempid = object.data('id')
		let tempoption = AttrValue
		// if (!tempoption) {
		// 	tempoption = objectControl.datas['value'].value
		// }
		let temphtml = '未知的类型'
		let upval=false
		if (AttrType.indexOf('radio') == 0) {
			temphtml = getRadioByTextAreaValue(datas.options.value, datas.value.value, tempid)
		} else if (AttrType.indexOf('checkbox') == 0) {
			temphtml = getCheckBoxByTextAreaValue(datas.options.value, datas.value.value, tempid)
		} else if (AttrType.indexOf('dropdown') == 0) {
			temphtml = getSelectByTextAreaValue(datas.options.value, datas.value.value, tempid)
		} else if (AttrType.indexOf('textdropdown') == 0) {
			temphtml = getTextSelectByTextAreaValue(datas.options.value, datas.value.value, tempid)
		}else{
			upval=true
		}
		if(upval)
		{
			object.find('.formVal').val(AttrValue)
		}else
		{
			object.find('.form-group').html(temphtml)
		}
		
	} else if (AttrKey == 'id') {
		object.find('.LdgFormItemID').text(AttrValue)
		object.data('id', AttrValue)
	} else if (AttrKey == 'placeholder') {
		object.find('.formVal').attr('placeholder', AttrValue)
	} else if (AttrKey == 'height') {
		object.find('.formVal').height(AttrValue)
	}  else if (AttrKey == 'required') {
		if (AttrValue == '0') {
			object.find('.required').removeClass('requiredHiddle')
		} else {
			object.find('.required').addClass('requiredHiddle')
		}
	}  else if (AttrKey == 'check') {
		object.data("check",AttrValue)
	}
	else {
		//未知的参数不要处理,否则都会录入到内容中
		//object.find('.formVal').val(AttrValue)
	}
}
function Clear() {
	$('.LdgFormItem').remove()
	contorlCache.splice(0, contorlCache.length)
}
function ImportJson(json,showel="") {
	try {
		let cd = JSON.parse(json)
		if(showel==""){Clear()}
		cd.list.forEach((c) => {
			addControl(c.type, c.options,showel)
		})
		for(let key in cd.config)
		{
			if(ldgFormConfig[key])
			{
				ldgFormConfig[key].value=cd.config[key];
			}
		}
		ApplyConfig(showel)
		
	} catch (err) {
		alert('导入错误,请检查导入数据是否正确')
		console.log(err)
	}
}
function ExportJson(preview = false) {
	let json = new Object()
	json.config=Object()
	for (let dname in ldgFormConfig) {
		json.config[dname] = ldgFormConfig[dname].value
	}
	json.list = []
	contorlCache.forEach((c, index) => {
		let newc = new Object()
		newc.type = c.type
		newc.options = new Object()
		for (let dname in c.datas) {
			newc.options[dname] = c.datas[dname].value
		}
		json.list.push(newc)
	})
	if (preview) {
		return JSON.stringify(json, null, '\t')
	}
	return JSON.stringify(json)
}

function GetForm(showel,preview = false)
{
	let formdata=$(showel).serializeArray();
	let json = new Object()
	formdata.forEach((c) => {
		json[c.name] = c.value
	})
	if (preview) {
		return JSON.stringify(json, null, '\t')
	}
	return JSON.stringify(json)
}

//清空
$('body').on('click', '.ldgFormClearAll', function () {
	Clear()
})

//导入
$('body').on('click', '.ldgFormImport', function () {
	$('#ldgFormImport').modal('show')
})

//导出
$('body').on('click', '.ldgFormExport', function () {
	let json = ExportJson(true)
	$('#ldgFormExport .modal-body textarea').val(json)
	$('#ldgFormExport').modal('show')
})

//预览
$('body').on('click', '.ldgFormPreview', function () {
	$("#ldgFormPreview").modal("show");
	let showel="#ldgFormPreview .modal-body form"
	$(showel).empty()
	if(!$(showel).hasClass("LdgFormSubjectForm")){
		$(showel).addClass("LdgFormSubjectForm");
	}
	let json = ExportJson()
	ImportJson(json,showel)
})

//表单属性
$('body').on('click', '.ldgFormConfigShow', function () {
	$('.LdgDiyForm').addClass('hasProperties')
	$(".ldgFormConfig").addClass("showAttr")
	$(".ldgFormProperties").removeClass("showAttr")
	AttributeShow('.LdgFormConfigs',ldgFormConfig)
})



//关闭属性
$('body').on('click', '.closeAttr', function () {
	$('.LdgDiyForm').removeClass('hasProperties')
})


//JS对象深度克隆
const deepClone = function (obj) {
	// 先检测是不是数组和Object
	// let isArr = Object.prototype.toString.call(obj) === '[object Array]';
	let isArr = Array.isArray(obj)
	let isJson = Object.prototype.toString.call(obj) === '[object Object]'
	if (isArr) {
		// 克隆数组
		let newObj = []
		for (let i = 0; i < obj.length; i++) {
			newObj[i] = deepClone(obj[i])
		}
		return newObj
	} else if (isJson) {
		// 克隆Object
		let newObj = {}
		for (let i in obj) {
			newObj[i] = deepClone(obj[i])
		}
		return newObj
	}
	// 不是引用类型直接返回
	return obj
}

Object.prototype.deepClone = function () {
	return deepClone(this)
}
Object.defineProperty(Object.prototype, 'deepClone', { enumerable: false })
$(function () {
	if ($('#ldgFormExport').length == 0) {
		$('body').append(
			'<div class="modal fade" id="ldgFormExport" tabindex="-1" role="dialog"><div class="modal-dialog" role="document"><div class="modal-content"><div class="modal-header"><button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button><h4 class="modal-title">导出JSON</h4></div><div class="modal-body"><textarea class="form-control" style="resize:none;height:600px"></textarea></div></div></div></div><div class="modal fade" id="ldgFormImport" tabindex="-1" role="dialog"><div class="modal-dialog" role="document"><div class="modal-content"><div class="modal-header"><button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button><h4 class="modal-title">导出JSON</h4></div><div class="modal-body"><textarea class="form-control" style="resize:none;height:600px"></textarea></div><div class="modal-footer"><button type="button" class="btn btn-default" data-dismiss="modal">取消</button> <button type="button" class="btn btn-primary" data-dismiss="modal">确认导入</button></div></div></div></div><div class="modal fade" id="ldgFormPreview" tabindex="-1" role="dialog"><div class="modal-dialog" role="document"><div class="modal-content"><div class="modal-header"><button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button><h4 class="modal-title">表单预览</h4></div><div class="modal-body"><form></form></div><div class="modal-footer"><button type="button" class="btn btn-default" data-dismiss="modal">取消</button> <button type="button" class="btn btn-primary">提取数据</button></div></div></div></div><div class="modal fade" id="ldgFormData" tabindex="-1" role="dialog"><div class="modal-dialog" role="document"><div class="modal-content"><div class="modal-header"><button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button><h4 class="modal-title">表单数据</h4></div><div class="modal-body"><textarea class="form-control" style="resize:none;height:600px"></textarea></div></div></div></div>'
		)
		$('#ldgFormImport .btn-primary').click(function () {
			//导入JSON数据到设计窗口
			ImportJson($('#ldgFormImport textarea').val())
		})
		$('#ldgFormPreview .btn-primary').click(function () {
			
			let showel=".modal-body .LdgFormSubjectForm"
			//提取表单数据
			if(CheckForm(showel))
			{
				$("#ldgFormPreview").modal("hide");
				let json=GetForm(showel,true);
				$("#ldgFormData").modal("show")
				$('#ldgFormData textarea').val(json)
			}
			

		})
	}
})
