const L_AJAX=$.extend({
    //ajax封装
    ajaxPack : function(obj,callback,errCallback){
        $.ajax({
            type: obj.type,
            url: `${obj.url}`,
            data: obj.param,
            dataType: "json",
            contentType: 'application/json;charset=utf-8',
            success : function (res) {
                L_AJAX.ajaxResultReduction(res,callback,errCallback);
            },
            error : function(response, ajaxOptions, thrownError){
                const res={
                    code:500,
                    message:"失败",
                    data:"请求发送错误，请检查网络或联系管理员！",
                };
                L_AJAX.ajaxResultReduction(res,callback,errCallback);
            },
        });
    },

    //ajax结果处理
    ajaxResultReduction : function(res,callback,errCallback){
        let resData=res;
        if (resData.code==undefined){
             resData={
                code:res==null ? 500 : 200,
                data:res==null ? "没有查到数据" :res,
                message: res==null ? "失败:" : "成功",
            };
        }
        L_AJAX.ifAjaxResErr(resData,callback,errCallback);
    },

    //请求结果成功错误返回
    ifAjaxResErr : function (res,callback,errCallback) {
        if (res.code==200){
            callback(res);
        }else {
           let errInfo=res.message+":"+res.data;
            errCallback(res,errInfo);
        }
    }
});