// 图片压缩方法
function JCompressor(_this,option){
	if(_this.value == ''){
		return false;
	}
	if(option == undefined){
		option = {}
	}
	var defaultopts = {
		// 最大文件大小
		MaxSize:20*1024*1024,
		// 是否是上传图片
		IsImg:true,
		// 是否预览
		IsPreview:true,
		// 预览图片元素
		PreviewContainer:(_this.name || _this.id)+"_img",
		// 是否压缩
		IsCompress:true,
		// 图片最大宽度
		MaxWidth:750,
		// 图片最大高度
		MaxHeight:1280,
		// 最大压缩大小/图片小于此项值时不压缩处理
		MaxCompressSize:0,
		// 压缩比例，越小越模糊（对jpg有效）
		Quality:0.8,
		// png图片压缩后大于最大压缩尺寸时换为jpg
		AllowPngToJpg:false,
		// 配置FileLoad方法输出类型 blob / base64
		FileType:'blob',
		// change方法开始时执行
		ChangeBefore:function(){},
		// change方法结束时执行
		ChangeAfter:function(){},
		// 方法执行完成
		FileLoad:function(data,obj){},
		// 错误清空file并退出时执行
		ErrorEmpty:function(){},
		// 预览图片
		ImgPreview:function(data){
			ImgPreview(data);
		},
		// 是否需要下载
		NeedDownload:false,
		// 下载图片（返回执行下载方法）
		DownloadLoad:function(nextfn){}
	}
	var opts = {};
	if(Object.assign == undefined){
		for(var key in defaultopts){
			if(option[key] == undefined){
				opts[key] = defaultopts[key];
			}else{
				opts[key] = option[key];
			}
		}
	}else{
		opts = Object.assign(defaultopts, option);
	}
	if(opts.PreviewContainer!=undefined && typeof(opts.PreviewContainer) == "string"){
		opts.PreviewContainer = document.getElementById(opts.PreviewContainer);
	}
	// 开放方法
	var openobj = {
		FileDom:_this,
		ChangeBefore:opts.ChangeBefore,
		ChangeAfter:opts.ChangeAfter,
		ImgPreview:opts.ImgPreview,
		FileLoad:opts.FileLoad,
		ErrorEmpty:opts.ErrorEmpty,
		BlobToBase64:BlobToBase64,
		Base64ToBlob:Base64ToBlob,
		DownloadLoad:opts.DownloadLoad
	}
	// - - - 开始
	openobj.ChangeBefore();
	var files = _this.files;
	var isMultiple = _this.hasAttribute('multiple');
	// 未选择文件
	if(files.length == 0){
		FileEmpty(function(){
			console.log("未选中文件");
		});
		return false;
	}
	// 判断是否多选
	if(isMultiple){
		var fileArr = [];
		var fileBase64Arr = [];
		for(var i=0;i<files.length;i++){
			ProcessingFn(files[i]);
		}
	}else{
		ProcessingFn(files[0]);
	}
	// 文件验证处理
	function ProcessingFn(file){
		// 上传文件最大限制
		if(file.size > opts.MaxSize) {
			FileEmpty(function(){
				alert('上传文件大小不能超过'+opts.MaxSize+'B，请重新上传！');
			});
			return false;
		}
		// 是否进行图片判断
		if(!opts.IsImg){
			return false;
		}
		// 判断图片格式
		if(!/(jp|jpe|pn)g$/.test(file.name)) {
			FileEmpty(function(){
				alert('图片格式错误，请重新上传！');
			});
			return false;
		}
		// 判断是否需要压缩
		if(opts.IsCompress){
			if(file.size < opts.MaxCompressSize){
				// 小于最大压缩尺寸不压缩处理
				FileReady(file);
				return false;
			}else{
				CompressorFn(file);
			}
		}else{
			FileReady(file);
		}
	}
	// 文件就绪
	function FileReady(filedata){
		if(isMultiple){
			fileArr.push(filedata);
			BlobToBase64(filedata,function(result){
				fileBase64Arr.push(result);
				if(fileBase64Arr.length == files.length){
					fileLoad(fileArr,fileBase64Arr);
				}
			});
		}else{
			BlobToBase64(filedata,function(result){
				fileLoad(filedata,result);
			});
		}
		function fileLoad(filedata,filebase64){
			// 判断是否需要预览
			if(opts.IsPreview){
				openobj.ImgPreview(filebase64);
			}
			if(opts.NeedDownload){
				DownloadLoad(filedata);
			}
			if(opts.FileType == "base64"){
				openobj.FileLoad(filebase64);
			}else{
				openobj.FileLoad(filedata);
			}
			openobj.ChangeAfter();
		}
	}
	// 预览图片
	function ImgPreview(filedata){
		if(!opts.PreviewContainer){
			alert("预览图片元素未找到！");
			return;
		}
		var isimgtag = opts.PreviewContainer.localName == "img";
		if(isMultiple){
			if(isimgtag){
				alert("多张图片预览时PreviewContainer属性值不能是img标签");
				return;
			}
			opts.PreviewContainer.innerHTML = "";
			filedata.forEach(function(item){
				var img = document.createElement("img");
				img.setAttribute("src", item);
				opts.PreviewContainer.appendChild(img);
			})
		}else{
			if(isimgtag){
				opts.PreviewContainer.src = filedata;
			}else{
				alert("单张图片预览时PreviewContainer属性值必须传入img标签");
			}
		}
	}
	// 压缩图片
	function CompressorFn(imgfile){
		// 转换base64
		BlobToBase64(imgfile,function(result){
			var img = new Image();
			img.src = result;
			img.onload = function(){
				var imgw = this.width;
				var imgh = this.height;
				var cvsw,cvsh;
					cvsw = imgw > opts.MaxWidth?opts.MaxWidth : imgw;
					cvsh = imgh > opts.MaxHeight?opts.MaxHeight : imgh;
				var wp = imgw / opts.MaxWidth;
				var hp = imgh / opts.MaxHeight;
				if(wp > hp){
					cvsh = imgh/imgw*cvsw;
				}else if(wp < hp){
					cvsw = imgw/imgh*cvsh;
				}
				var mimeType = imgfile.type;
				CanvasDraw(img,cvsw,cvsh,mimeType,function(imgblob){
					if(opts.AllowPngToJpg && mimeType == 'image/png' && imgblob.size > opts.MaxCompressSize){
						CanvasDraw(img,cvsw,cvsh,'image/jpeg',function(imgblob){
							nextfn(imgblob,imgfile.name.replace(/\.(png|jpg|gif)$/,".jpg"));
						});
					}else{
						nextfn(imgblob,imgfile.name);
					}
				});
				function nextfn(imgblob,imgname){
					imgblob.name = imgname;
					// FileReady(imgblob);
					// return;
					if(imgblob.size >= imgfile.size){
						FileReady(imgfile);
						openobj.compressed = false;
					}else{
						FileReady(imgblob);
						openobj.compressed = true;
					}
				}
			}
		})
		// 图片绘制
		function CanvasDraw(image,canvasw,canvash,mimeType,callback){
			//生成canvas
			var canvas = document.createElement('canvas');
			var ctx = canvas.getContext('2d');
			// 创建属性节点
			var anw = document.createAttribute("width");
			anw.nodeValue = canvasw;
			var anh = document.createAttribute("height");
			anh.nodeValue = canvash;
			canvas.setAttributeNode(anw);
			canvas.setAttributeNode(anh);
			ctx.drawImage(image, 0, 0, canvasw, canvash);
			if(canvas.toBlob == undefined){
				var imgbase64 = canvas.toDataURL(mimeType, opts.Quality);
				var imgblob = Base64ToBlob(imgbase64);
				callback(imgblob);
			}else{
				var imgblob = canvas.toBlob(function(imgblob){
					callback(imgblob);
				},mimeType, opts.Quality);
			}
		}
	}
	// blob/file转base64
	function BlobToBase64(fileblob,loadfn){
		var fr = new FileReader();
		fr.onload = function() {
			loadfn(this.result);
		};
		fr.readAsDataURL(fileblob);
	}
	// base64转文件流blob
	function Base64ToBlob(base64,mimeType) {
	  var bytes = window.atob(base64.split(",")[1]);
	  var ab = new ArrayBuffer(bytes.length);
	  var ia = new Uint8Array(ab);
	  for (var i = 0; i < bytes.length; i++) {
		ia[i] = bytes.charCodeAt(i);
	  }
	  var _blob = new Blob([ab],{type:mimeType});
	  return _blob;
	}
	// 清除file内容
	function FileEmpty(backfn){
		_this.value = '';
		if(opts.IsPreview && opts.PreviewContainer){
			if(isMultiple){
				opts.PreviewContainer.innerHTML = '';
			}else{
				opts.PreviewContainer.src = '';
			}
		}
		backfn();
		openobj.ErrorEmpty();
		openobj.ChangeAfter();
	}
	// 调用下载
	function DownloadLoad(filedata){
		var isArray = filedata instanceof Array;
		if (isArray && filedata.length == 1) {
			filedata = filedata[0];
			isArray = false;
		}
		if (isArray) {
			PackInZip(filedata, function(content) {
				openobj.DownloadLoad(function(){
					DownloadFile("images.zip",content);
				})
			});
		} else {
			openobj.DownloadLoad(function(){
				DownloadFile(filedata.name,filedata);
			})
		}
	}
	// 打压缩包
	function PackInZip(filearr,callback){
		// 创建一个JSZip的实例
		var zip = new JSZip();
		// 建一个文件夹
		var img = zip.folder("images");
		var fileNum = 0;
		for(var i = 0;i<filearr.length;i++){
			(function(){
				var filei = filearr[i];
				BlobToBase64(filei,function(base64data){
					base64data = base64data.replace(/(^\s*)data\:.+base64,/, "");
					img.file(filei.name, base64data, {base64: true});
					fileNum++;
					if(fileNum == filearr.length){
						toBase64Load();
					}
				})
			})()
		}
		function toBase64Load(){
			var zipdata = zip.generateAsync({type:"blob"});
			zipdata.then(function(content) {
				callback(content);
			});
		}
	}
	// 下载
	function DownloadFile(fileName, content) {
		saveAs(content, fileName);
		// let aLink = document.createElement('a');
		// let blob = content; //new Blob([content]); 
		// let evt = document.createEvent("HTMLEvents"); 
		// evt.initEvent("click", true, true);
		// aLink.download = fileName; 
		// aLink.href = URL.createObjectURL(blob);
		// aLink.dispatchEvent(new MouseEvent('click', {
		// 	bubbles: true, 
		// 	cancelable: true, 
		// 	view: window,
		// }));
	}
}