document.addEventListener('DOMContentLoaded', function () {
  // 内容
  var content = document.querySelector('.content');
  // 滚动条区域（包括上下箭头按钮）
  var scrollBar = document.querySelector('.scrollBar');
  // 滚动条中间区域（不包含上下箭头按钮）
  var barMiddle = document.querySelector('.barMiddle');
  // 滚动条上下按钮
  var barTopBtn = document.querySelector('.barTop');
  var barBottomBtn = document.querySelector('.barBottom');
  // 滚动条
  var bar = document.querySelector('.bar');
  var pos = { top: 0, y: 0 };
  // 定时器
  var timer = null;

  // 初始化滚动条
  function initScrollBar() {
    if (content.scrollHeight > content.clientHeight) {
      scrollBar.className = 'scrollBar';
      content.style.marginRight = '-'+ calculateScrollbarWidth() + 'px';
      content.style.paddingRight = '12px';
      bar.style.height = content.clientHeight / content.scrollHeight * 100 + '%';
    } else {
      scrollBar.className = 'scrollBar hide';
      content.style.marginRight = '0px';
    }
  }

  // 文章滚动事件
  function scrollContentHandle() {
    // window.requestAnimationFrame(function () {
      setTimeout(function () {
        bar.style.top = content.scrollTop / content.scrollHeight * 100 + '%';
      }, 1000 / 60);
    // })
  }
  content.addEventListener('scroll', scrollContentHandle);

  // 鼠标点击滚动条中间区域事件
  function barMiddleClick(e) {
    var bound = barMiddle.getBoundingClientRect();
    var ratio = (e.clientY - bound.top) / bound.height;

    content.scrollTop = ratio * (content.scrollHeight - content.clientHeight);
  }
  barMiddle.addEventListener('click', barMiddleClick);

  // 滚动条拖动事件
  function mouseDownBarHandler(e) {
    pos = {
      top: content.scrollTop,
      y: e.clientY
    };
    document.addEventListener('mousemove', mouseMoveBarHandler);
    document.addEventListener('mouseup', mouseUpBarHandler);

  }

  function mouseMoveBarHandler(e) {
    var dy = e.clientY - pos.y;
    content.scrollTop = pos.top + dy / (content.clientHeight / content.scrollHeight)
  }

  function mouseUpBarHandler() {
    document.removeEventListener('mousemove', mouseMoveBarHandler);
  }
  bar.addEventListener('mousedown', mouseDownBarHandler);
  bar.addEventListener('click', function (e) {
    e.stopPropagation();
  });

  // 滚动条上下按钮鼠标移入事件
  function mouseOverBarBtnHandler(e) {
    clearInterval(timer);
    var speed = 0;
    e.target === barTopBtn ? (speed = 5) : (speed = -5);
    timer = setInterval(function () {
      content.scrollTop = content.scrollTop - speed;
    }, 1000 / 60);
  }
  barTopBtn.addEventListener('mouseover', mouseOverBarBtnHandler);
  barTopBtn.addEventListener('mouseout', function () {
    clearInterval(timer);
  });
  barBottomBtn.addEventListener('mouseover', mouseOverBarBtnHandler);
  barBottomBtn.addEventListener('mouseout', function () {
    clearInterval(timer);
  });

  // 计算系统滚动条宽度
    function calculateScrollbarWidth() {
    var outer = document.createElement('div');
    var inner = document.createElement('div');

    outer.style.visibility = 'hidden';
    outer.style.overflow = 'scroll';
    outer.appendChild(inner);
    document.body.appendChild(outer);

    var scrollbarWidth = outer.offsetWidth - inner.offsetWidth;
    document.body.removeChild(outer);
    return scrollbarWidth;
  }

  // 初始化
  initScrollBar();
  
  // 监听窗口变化
  window.addEventListener('resize', function () {
    initScrollBar();
  })
});