/*-------------------------------------*/
/*
    canvas 图形绘表-----目前支持 折线和矩形---es5

    全手写，暂时只有折线和矩形两种,供学习用
    图表 尺寸由 ID 为 ctable 的css 大小控制
*/
/*-------------------------------------*/
function Ctable(el,showtext) {  
    if (!showtext) {
        this.showtext=false;
    } else{
        this.showtext=true;
    }        
    this.data=[];
    this.box=document.getElementById(el);
    this.c=document.createElement('canvas');
    this.box.appendChild(this.c);
    this.c.width=parseInt(this.box.offsetWidth);
    this.c.height=parseInt(this.box.offsetHeight);
    this.ct=this.c.getContext("2d");
    this.p=[];//用于记录当前 点 集合
    //绑定事件---用于鼠标预览详细信息
    var obj=this;
    this.box_msg=document.createElement('div');
    this.box_msg_title=document.createElement('h4');
    
    this.box.appendChild(this.box_msg);
    this.box_msg.appendChild(this.box_msg_title);
    
    this.c.addEventListener('mousemove',function(e){
        if (obj.p.length<1) {
            return;
        }
        for (var i = 0; i < obj.p.length; i++) {
            if ((obj.p[i][0]>e.offsetX-10&&obj.p[i][0]<e.offsetX+10)&&(obj.p[i][1]>e.offsetY-50&&obj.p[i][1]<e.offsetY+50)) {
                obj.box_msg_title.innerHTML=obj.p[i][2][1]+obj.p[i][2][4];
                obj.box_msg.style.left=(e.offsetX-obj.box_msg.offsetWidth/2)+'px';
                obj.box_msg.style.top=(e.offsetY-obj.box_msg.offsetHeight*1.5)+'px';
                if (obj.box_msg.style.visibility!='visible') {
                    obj.box_msg.style.visibility='visible';
                }
            }
        }
        
    });
    this.c.addEventListener('mouseleave',function(e){
        obj.box_msg.style.visibility='hidden';
    });
    //默认气泡样式
    this.box.style.position='relative';
    this.box_msg.style.visibility='hidden';
    this.box_msg.style.cursor='default';
    this.box_msg.style.position='absolute';
    this.box_msg.style.backgroundColor= 'rgba(0,0,0,0.55)';
    this.box_msg.style.color='#fff';
    this.box_msg.style.padding=' 0.5rem 0.5rem';
    this.box_msg.style.borderRadius='0.3rem';
    this.box_msg.style.transition='left 0.2s,top 0.2s';
    this.box_msg_title.style.margin='0';
}
Ctable.prototype.setData=function(data){
    if (data.length<1) {
        console.log('长度不能小于2');
        return;
    }
    this.data=data;

}
Ctable.prototype.clear=function(){
            this.p=[];
            this.ct.clearRect(0,0,this.c.width,this.c.height);//清理画布
        }
        //折线图
        Ctable.prototype.drawline = function(mark) {
            this.ct.clearRect(0,0,this.c.width,this.c.height);//清理画布
            if (!mark) {
                mark=false;//是否显示刻度线
            }
            //绘制刻度
            if (mark) {
                this.drawbox(data);
            }
            // 画线
            //获取Y总值
            var data=this.data;
            if (data.length<1) {
                console.log('长度不能小于2');
                return;
            }
            var tnum=0;
            for (var i = 0; i < data.length; i++) {
                tnum+=data[i][1];
            }
            //设置起点
            //this.ct.strokeStyle='red';
            var x=data[0][0]+10;
            var y=this.c.height-data[0][1]*this.c.height/tnum-20;
            this.ct.moveTo(x,y);
            //this.ct.strokeText(data[0][1],x,y-20);//绘制文字
            this.p.push([x,y,data[0]]);//收集点
            //开始绘制
            this.ct.fillStyle='#FF6A6A';
            this.ct.arc(x,y,5,0,Math.PI*2);
            //延时绘制
            var data_index=0;
            var obj=this;
            this.ct.beginPath();
            var timer=setInterval(function(){
                x=data_index*obj.c.width/data.length+10;
                y=obj.c.height-data[data_index][1]*obj.c.height/tnum-20;
                obj.ct.lineTo(x,y);
                obj.ct.strokeStyle='#36648B';
                obj.ct.stroke();
				var ex='';
				if(data[i][4]){
					ex=data[i][4];
				}
                if (obj.showtext) {
                   obj.ct.strokeText(data[data_index][1]+ex,x-6,y-20);//绘制文字 
                }
                
                obj.ct.strokeStyle='#FF6A6A';
                obj.ct.stroke();
                obj.ct.beginPath();
                obj.ct.arc(x,y,3,0,Math.PI*2);
                obj.ct.fill();
                obj.ct.moveTo(x,y);
                obj.p.push([x,y,data[data_index]]);//收集点
                if (data_index<data.length-1) {
                    data_index++;
                }else{
                    clearInterval(timer);
                }
            },120);
            //快速绘制
            for (var i = 1; i < data.length; i++) {
                break;
                x=i*this.c.width/data.length+10;
                y=this.c.height-data[i][1]*this.c.height/tnum-20;
                this.ct.lineTo(x,y);
                this.ct.strokeStyle='#36648B';
                this.ct.stroke();
                this.ct.strokeText(data[i][1],x,y-20);//绘制文字
                this.ct.strokeStyle='#FF6A6A';
                this.ct.stroke();
                this.ct.beginPath();
                this.ct.arc(x,y,3,0,Math.PI*2);
                this.ct.fill();
                this.ct.moveTo(x,y);
                //this.ct.stroke();

            }
        };
        //绘制刻度
        Ctable.prototype.drawbox=function() {
            var data=this.data;
            //获取Y总值
            var tnum=0;
            for (var i = 0; i < data.length; i++) {
                tnum+=data[i][1];
            }
            //X---line
            
            var x=0;
            var y=this.c.height-20;
            this.ct.beginPath();
            this.ct.moveTo(x,y);
            this.ct.lineTo(this.c.width,this.c.height-20);
            for (var i = 0; i < data.length; i++) {
                x=i*this.c.width/data.length+10;
                y=this.c.height-20;
                //刻度
                this.ct.moveTo(x,y);
                this.ct.lineTo(x,y+4);
                //单位
				var ex='';
				if(data[i][3]){
					ex=data[i][3];
				}
                this.ct.strokeText(data[i][0]+ex,x,y+14);//绘制文字
            }
			
            this.ct.strokeStyle='#607B8B';
            this.ct.stroke();
            //Y---line
            this.ct.beginPath();
            x=10;
            y=this.c.height
            this.ct.moveTo(x,0);
            this.ct.lineTo(x,y);
            var y_num=Math.ceil(tnum/10);
            if (y_num<1) {
                y_num=10;
            }
            //console.log(y_num)
            for (var i = 0; i <y_num; i+=10) {
                x=10;
                y=i*this.c.height/y_num;
                //刻度
                this.ct.moveTo(x,y);
                this.ct.lineTo(x+4,y);
                // console.log(y)
                //单位
                //this.ct.strokeText(tnum/i,14,y-10);//绘制文字
            }
            this.ct.strokeStyle='#607B8B';
            this.ct.stroke();

        }//矩形图
        Ctable.prototype.drawrect = function(mark) {
            this.ct.clearRect(0,0,this.c.width,this.c.height);//清理画布
            if (!mark) {
                mark=false;//是否显示刻度线
            }
            //绘制刻度
            if (mark) {
                this.drawbox(data);
            }
            // 画线
            //获取Y总值
            var data=this.data;
            if (data.length<1) {
                console.log('长度不能小于2');
                return;
            }
            var tnum=0;
            for (var i = 0; i < data.length; i++) {
                tnum+=data[i][1];
            }
            
            //开始绘制
            this.ct.fillStyle='#FF6A6A';
            //延时绘制
            var data_index=0;
            var obj=this;
            this.ct.beginPath();
            var x=0;
            var y=0;
            this.ct.strokeStyle='#607B8B';
            var timer=setInterval(function(){
                x=data_index*obj.c.width/data.length+10
                y=obj.c.height-data[data_index][1]*obj.c.height/tnum-20;
                var ex='';
				if(data[i][4]){
					ex=data[i][4];
				}
                if (obj.showtext) {
                    obj.ct.strokeText(data[data_index][1]+ex,x-5,y-20);//绘制文字
                }
               
                obj.ct.strokeStyle='#607B8B';
                obj.ct.stroke();
                obj.ct.beginPath();
                obj.p.push([x,y,data[data_index]]);//收集点
                var block_w=0.2*obj.c.width/data.length;
                obj.ct.fillRect(x-block_w/2,y,block_w,obj.c.height-y-20);
                //console.log(obj.c.height-y-20)
                if (data_index<data.length-1) {
                    data_index++;
                }else{
                    clearInterval(timer);
                }
            },120);
            //快速绘制
            for (var i = 1; i < data.length; i++) {
                break;
                x=i*this.c.width/data.length+10;
                y=this.c.height-data[i][1]*this.c.height/tnum-20;
                this.ct.lineTo(x,y);
                this.ct.strokeStyle='#36648B';
                this.ct.stroke();
                this.ct.strokeText(data[i][1],x,y-20);//绘制文字
                this.ct.strokeStyle='#FF6A6A';
                this.ct.stroke();
                this.ct.beginPath();
                this.ct.arc(x,y,3,0,Math.PI*2);
                this.ct.fill();
                this.ct.moveTo(x,y);
                //this.ct.stroke();

            }
        };