var writer;
var isCharVisible;
var isOutlineVisible;

function printStrokePoints(data) {
	var pointStrs = data.drawnPath.points.map(point => `{x: ${point.x}, y: ${point.y}}`);
	console.log(`[${pointStrs.join(', ')}]`);
}

function updateCharacter() {
	document.querySelector('#target').innerHTML = '';

	var character = document.querySelector('.js-char').value;
	window.location.hash = character;
	writer = HanziWriter.create('target', character, {
		width: 400,
		height: 400,
		radicalColor: '#166E16',
		onCorrectStroke: printStrokePoints,
		onMistake: printStrokePoints,
	});
	isCharVisible = true;
	isOutlineVisible = true;
	window.writer = writer;
}

window.onload = function() {
	var char = decodeURIComponent(window.location.hash.slice(1));
	if (char) {
		document.querySelector('.js-char').value = char;
	}

	updateCharacter();

	document.querySelector('.js-char-form').addEventListener('submit', function(evt) {
		evt.preventDefault();
		updateCharacter();
	});

	document.querySelector('.js-toggle').addEventListener('click', function() {
		isCharVisible ? writer.hideCharacter() : writer.showCharacter();
		isCharVisible = !isCharVisible;
	});
	document.querySelector('.js-toggle-hint').addEventListener('click', function() {
		isOutlineVisible ? writer.hideOutline() : writer.showOutline();
		isOutlineVisible = !isOutlineVisible;
	});
	document.querySelector('.js-animate').addEventListener('click', function() {
		writer.animateCharacter();
	});
	document.querySelector('.js-quiz').addEventListener('click', function() {
		writer.quiz({
			showOutline: true
		});
	});
}
