(function ($) {
    var options = {
        rotateNum: 5,
        dom: '#box',
        startCbs: function () {},//点击回调
        disabledCbs: function () {},//禁止回调
        endCbs: function () {} //结束回调
    };

    window.Lottery = Lottery;
    function Lottery(opts) {
        this.opts = $.extend(true, {}, options, opts);
        this.flag = false;//是否在抽奖中
        this.init();
    }

    Lottery.prototype.init = function () {
        var _this = this;
        this.angle = this.opts.rotateNum * 360;
        $(this.opts.dom).on('click', '.btn', function () {
            if(!_this.flag) {
                _this.goLottery( _this.opts.startCbs.call(_this) );
            }else {
                _this.opts.disabledCbs();
            }
        });
        $(this.opts.dom).find('.table').get(0).addEventListener('webkitTransitionEnd', function () {
            _this.flag = false;
            var ang = $(this).attr('data-deg');
            $(this).css({
                'transition': 'none',
                'transform': 'rotate('+ang+'deg)'
            });
            console.log(_this)
            _this.opts.endCbs(ang);

        });
    }
    // 转动转盘
    Lottery.prototype.goLottery = function (_deg) {
        if(this.flag) return;

        var deg = _deg + this.angle;
        this.flag = true;
        $(this.opts.dom).find('.table').css({
            'transition': 'transform 5s ease',
            'transform': 'rotate('+ deg +'deg)' 
        }).attr('data-deg', _deg);
    }
})($);