/* 
 * 联想词插件
 * 基于Jquery
 * 携带参数类型为标签上 data-*
 * ajax异步请求 回调json完成界面渲染
 * 
 * 需要在父级标签内拥有   <div class='usteel_associate'></div>
 * 
 * 使用方式 需要在界面重新声明并调用该方法
 * 
	_dom 和 _url 均为数组类型  dom对象(任意JQ选择器)和传参接口必须一一对应
	
	var usteel_associate = new usteel_associate({
		"_dom":["input[data-click=\"usteel_associate1\"]","input[data-click=\"usteel_associate2\"]"]
		,"_url":["test1.json","test2.json"]
	});
	usteel_associate.propertychange();
	 
 * 
 * 
 * 编写人  Andrew 
 * 联系方式  andrew.s@foxmail.com
 * 使用请勿删除以上内容 感谢为开源做出贡献
 * 
 * 使用方式 
	<div>
		<input type="" name="" id="" value="" data-click="usteel_associate" placeholder="请输入"/>
		<div class='usteel_associate'></div>
	</div>
 */

var usteel_associate = function(_array){
 	return{
 		propertychange : function(){
 			for (let i=0 ; i<_array._dom.length ; i++) {
 				operation(_array._dom[i],_array._url[i]);
 			}
 		}
 	}
}
$(function(){
	$(".usteel_associate").html("<p>请在上方输入</p>")
})
//_dom 和 _url 均为数组类型  dom对象和传参接口必须一一对应
function operation(_dom,_url){
	$(document).on("input propertychange", _dom , function(){
		let dataType = $(this).attr("data-type");
		let dataId = $(this).attr("data-id");
		let dataVal = $(this).val();
		//联想词列表
		let thisAuto = $(this).parent().find(".usteel_associate");
		/* 线上环境 需要接口支持*/
		// if($(this).val() != ""){
		// 	$.ajax({
		// 		type:"post",
		// 		url:_url,
		// 		async:true,
		// 		data:{
		// 			"dataType":dataType,
		// 			"dataId":dataId,
		// 			"dataVal":dataVal
		// 		},beforeSend:function(data){
		// 			thisAuto.show();
		// 			thisAuto.html("<p>加载中请稍后</p>");
		// 		},success:function(data){
		// 			let html = ""
		// 			if(data){
		// 				for (let i=0 ; i<data.length ; i++) {
		// 					html += "<p data-id='"+data[i].id+"'>"+data[i].val.replace(dataVal,"<em>"+dataVal+"</em>")+"</p>";
		// 				}
		// 			}else {
		// 				html = "<p>未找到，可增加</p>";
		// 			}
		// 			thisAuto.html(html);
		// 		},error:function(data){
				
		// 		}
		// 	});
		// }
		/* 线上环境结束 */
		// 测试内容
				data = [{"id":666666,"val":"测试数据没毛病"},{"id":99999,"val":"这个是接口1"},{"id":99999,"val":"这个是接口1"},{"id":99999,"val":"这个是接口1"},{"id":99999,"val":"这个是接口1"},{"id":99999,"val":"这个是接口1"},{"id":99999,"val":"abcdefg"},{"id":99999,"val":"hijklmn"},{"id":99999,"val":"opqrst"}]
				thisAuto.show();
				thisAuto.html("<p>加载中请稍后</p>");
				let html = ""
				for (let i=0 ; i<9 ; i++) {
					html += "<p data-id='"+data[i].id+"'>"+data[i].val.replace(dataVal,"<em>"+dataVal+"</em>")+"</p>";
				}
				thisAuto.html(html);
		// 测试内容结束

		//选择相应的联想进行回填
		$(document).on("click",".usteel_associate p[data-id]",function(){
			let thisVal = $(this).html();
			let thisId = $(this).attr("data-id");
			let thisAuto = $(this).parent();
			$(this).parent().parent().find("input").val(thisVal);
			$(this).parent().parent().find("input").attr("data-id",thisId);
			thisAuto.hide();
		});
	});
	//取得焦点时 展示相对应的联想列表
	$(document).on("focus", _dom ,function(){
		let thisAuto = $(this).parent().find(".usteel_associate");
		let thisVal = $(this).html();
		thisVal != null ? "" : $(this).html("");
		setTimeout(function () {
			thisAuto.show();
	    }, 100);
	});
	//失去焦点时 展示相对应的联想列表
	$(document).on("blur", _dom ,function(){
		let thisAuto = $(this).parent().find(".usteel_associate");
		setTimeout(function () {
			thisAuto.hide();
	    }, 100);
	});
}





