// 数组去重
Array.prototype.unique = function(){
	this.sort();
	var res = [];
	var json = {};
	for (var i = 0; i < this.length; i++) {
		if(!json[this[i]]){
			res.push(this[i]);
			json[this[i]] = 1;
		}
	}
	return res;
}

// 对样式操作
var setClass = {
	hasClass: function(elements,cName){	// 判断是否含有某个class
		if(elements.className.match(new RegExp( "(\\s|^)" + cName + "(\\s|$)") ))
			return true;
		else
			return false;
	},
	addClass: function(elements,cName){	// 添加class
		if( !this.hasClass( elements,cName ) ){
			elements.className += " " + cName;
		};
	},
	removeClass: function(elements,cName){	// 移除某个class
		if( this.hasClass( elements,cName ) ){
			elements.className = elements.className.replace( new RegExp( "(\\s|^)" + cName + "(\\s|$)" )," " );
		}
	}
}

var Bind = function(This){
	return function(){
		This.init();
	}
}

function AutoComplete(input,auto,arr) {
	this.obj = document.getElementById(input);
	this.autoObj = document.getElementById(auto);
	this.search_value = "";	//当前的搜索输入值
	this.index = -1;		//当前选中的DIV的索引
	this.value_arr = arr;	//数据库中供检索的值 不包含重复值
}
AutoComplete.prototype = {
	// 初始化
	init: function(){
		var This = this;
		setClass.removeClass(This.autoObj,"hidden");
		this.autoObj.style.left = this.obj.offsetLeft + "px";
		this.autoObj.style.top = this.obj.offsetTop + this.obj.offsetHeight + "px";
	},
	//删除自动完成需要的所有DIV
	deleteDIV: function(){
		while(this.autoObj.hasChildNodes()){
			this.autoObj.removeChild(this.autoObj.firstChild);
		}
		setClass.addClass(this.autoObj,"hidden");
	},
	autoOnmouseover: function(index){
		if(index != this.index){
			setClass.addClass(this.autoObj.children[index],"on");
			setClass.removeClass(this.autoObj.children[this.index],"on");
			this.index = index;
		}
	},
	setValue: function(This){
		return function(){
			This.obj.value = this.seq;
			setClass.addClass(This.autoObj,"hidden");
		}
	},
	// 响应键盘
	pressKey: function(event){
		var code = event.keyCode;
		var length = this.autoObj.children.length;
		if(code == 38){		//↑
			setClass.removeClass(this.autoObj.children[this.index],"on");
			this.index--;
			if(this.index < 0){
				this.index = length - 1;
			}
			setClass.addClass(this.autoObj.children[this.index],"on");
			this.obj.value = this.autoObj.children[this.index].seq;
		}else if(code == 40){	//↓
			setClass.removeClass(this.autoObj.children[this.index],"on");
			this.index++;
			if(this.index > length-1){
				this.index = 0;
			}
			setClass.addClass(this.autoObj.children[this.index],"on");
			this.obj.value = this.autoObj.children[this.index].seq;
		}else{			//回车
			this.obj.value = this.autoObj.children[this.index].seq;
			setClass.addClass(this.autoObj,"hidden");
			this.index = -1;
		}
	},
	// 程序入口
	start: function(event){
		event = event || window.event;
		var code = event.keyCode;
		var This = this;
		if(code != 13 && code != 38 && code != 40){
			this.init();
			this.deleteDIV();
			this.search_value = this.obj.value;
			var valueArr = this.value_arr.unique();
			//去掉前后空格不能为空
			if(this.obj.value.replace(/(^\s*)|(\s*$)/g,"") == ""){ return;}
			//判断数组中是否含有输入的关键字
			try{
				var reg = new RegExp("("+ this.obj.value +")","i");	//输入"aaa" 则 reg = /(aaa)/i
			}catch(e){
				alert(e.message);
			}
			var div_index = 0;	//记录匹配索引个数
			for (var i = 0; i < valueArr.length; i++) {
				if(reg.test(valueArr[i])){
					var div = document.createElement("div");
					div.className = "auto_out";
					div.seq = valueArr[i];
					div.index = div_index;
					div.innerHTML = valueArr[i].replace(reg,"<strong>$1</strong>");
					this.autoObj.appendChild(div);
					setClass.removeClass(this.autoObj,"hidden");
					div_index++;
					if(div_index == 1) {
						setClass.addClass(this.autoObj.firstChild,"on");
						this.index = 0;
					}
					div.onmouseover = function(){
						This.autoOnmouseover(this.index);
					}
					div.onclick = this.setValue(This);
				}
			}
		}else{
			this.pressKey(event);
		}
		window.onresize = Bind(This);
	}
}
$(function () {
       //鼠标经过移除按钮显示，点击移除自身， 当剩余四个的时候下面的图片居中
       $(".grouping ul li").mouseenter(function(){
            $(this).find('em').show();
            //点击移除自身， 当剩余四个的时候改变盒子宽高，两个也一样，
            $(this).find('em').click(function(){
            $(this).parent().remove();
            if($(".grouping ul li").length===4){
               $(".grouping ul li").css("padding","1% 6%")
               $(".auto").css("width","49%")
            }
            if($(".grouping ul li").length===2){
               $(".grouping ul li").css("padding","5% 6%")
               $(".auto").css("width","49%")
            }
       })
       }) .mouseleave(function(){
           $(this).find('em').hide() })//鼠标移出;
  });

  //调用函数增加迷糊查询功能
 $(function () {
    var array = ['七里香','b0','b12','b22','b3','b4','b5','b6','如果爱','b7','b8','b2','abd','ab','acd','accd','abd','qq音乐','b1','cd','ccd','cbcv','小王爱','cxf','b0'];
    var autoComplete = new AutoComplete("input","auto",array);
    document.getElementById("input").onkeyup = function(event){
      autoComplete.start(event);
    }
    var autoComplete2 = new AutoComplete("input2","auto2",array);
    document.getElementById("input2").onkeyup = function(event){
      autoComplete2.start(event);
    }
    var autoComplete3 = new AutoComplete("input3","auto3",array);
    document.getElementById("input3").onkeyup = function(event){
      autoComplete3.start(event);
    }
    var autoComplete4 = new AutoComplete("input4","auto4",array);
    document.getElementById("input4").onkeyup = function(event){
      autoComplete4.start(event);
    }
    var autoComplete5 = new AutoComplete("input5","auto5",array);
    document.getElementById("input5").onkeyup = function(event){
      autoComplete5.start(event);
    }
    var autoComplete6 = new AutoComplete("input6","auto6",array);
    document.getElementById("input6").onkeyup = function(event){
      autoComplete6.start(event);
    }
    var autoComplete7 = new AutoComplete("input7","auto7",array);
    document.getElementById("input7").onkeyup = function(event){
      autoComplete7.start(event);
    }
    var autoComplete8 = new AutoComplete("input8","auto8",array);
    document.getElementById("input8").onkeyup = function(event){
      autoComplete8.start(event);
    }
    var autoComplete9 = new AutoComplete("input9","auto9",array);
    document.getElementById("input9").onkeyup = function(event){
      autoComplete9.start(event);
    }
    var autoComplete10 = new AutoComplete("input10","auto10",array);
    document.getElementById("input10").onkeyup = function(event){
      autoComplete10.start(event);
    }
    var autoComplete11 = new AutoComplete("input11","auto11",array);
    document.getElementById("input11").onkeyup = function(event){
      autoComplete11.start(event);
    }
    var autoComplete12 = new AutoComplete("input12","auto12",array);
    document.getElementById("input12").onkeyup = function(event){
      autoComplete12.start(event);
    }
    var autoComplete13 = new AutoComplete("input13","auto13",array);
    document.getElementById("input13").onkeyup = function(event){
      autoComplete13.start(event);
    }
    var autoComplete14 = new AutoComplete("input14","auto14",array);
    document.getElementById("input14").onkeyup = function(event){
      autoComplete14.start(event);
    }
    var autoComplete15 = new AutoComplete("input15","auto15",array);
    document.getElementById("input15").onkeyup = function(event){
      autoComplete15.start(event);
    }
    var autoComplete16 = new AutoComplete("input16","auto16",array);
    document.getElementById("input16").onkeyup = function(event){
      autoComplete16.start(event);
    }
 });