/**
 * 表格渲染插件
 * @author 李帅武
 */
;(function($, window, document, undefined){
    var TableRender = function (elem,options) {
        this.elem = elem;
        this.$elem = $(elem);
        this.options = options;
        this.$win = $(window);
        this.$doc = $(document);
        this.docHeight = this.$doc.height();
    };
    TableRender.prototype = {
        defaults: {
            captions:[{
                title:"表头标题：",
                content:"内容",
                style:{
                    fontSize:12,
                    fontFamily:"微软雅黑"
                }
            }],
            data:{},
            set:{//设置
                type:"transverse",//表格样式  vertical | transverse
                editRow:[],//可编辑的行 字段内容为数据字段名
                addRow:[],
                mergeTd:[]
            },
            mapObj:{},
            firstRowText:"",
            editCallback:function (data) {

            }
        },
        init:function () {
            this.config = $.extend({}, this.defaults, this.options);
            this.render();
        },
        render:function () {
            //渲染表格
            var _viewer_ = this;
            var captions = _viewer_.config.captions;
            var dataArray = _viewer_.config.data.dataArray;
            var mapObj = _viewer_.config.mapObj;
            var editRow = _viewer_.config.set.editRow;
            var addRow = _viewer_.config.set.addRow;
            var mergeTd = _viewer_.config.set.mergeTd;
            var html = '<table class="tableRender-table">';
                html += '<caption style="text-align:left;">';
                if(_viewer_.config.set.type === "transverse"){
                    captions.forEach(function (item,index) {
                        html += '<span class="tableRender-captions"><span class="tableRender-captions-style">'+item["title"]+item["content"]+'</span></span>';
                    });
                    html +=  '</caption>';
                    html += '<tr class="tableRender-headStyle">';
                    html += '<td>'+_viewer_.config.firstRowText+'</td>';
                    dataArray.forEach(function (item,index) {
                        html += '<td>'+(index+1)+'</td>';
                    });
                    html += '<tr>';
                    for(var key in mapObj){
                        html += '<tr className="'+key+'">';
                            if(editRow.indexOf(key)!== -1){
                                if(addRow.indexOf(key)!== -1) {
                                    html += '<td class="isEndit isAdd" style="background-color: #FFC000!important;">' + mapObj[key] + '</td>';
                                }else{
                                    html += '<td class="isEndit" style="background-color: #FFFF00;">'+mapObj[key]+'</td>';
                                }
                            }else if(addRow.indexOf(key)!== -1){
                                html += '<td class="isAdd isEndit" style="background-color: #FFC000!important;" contenteditable="true">'+mapObj[key]+'</td>';
                            }else{
                                html += '<td>'+mapObj[key]+'</td>';
                            }
                            dataArray.forEach(function (item,index) {
                                if(mergeTd.indexOf(key) === -1){
                                    if(editRow.indexOf(key)!== -1){
                                        if(addRow.indexOf(key)!== -1) {
                                            html += '<td class="isEndit isAdd" style="background-color: #FFC000!important;" contenteditable="true"><span contenteditable="true">' + item[key] + '</span></td>';
                                        }else{
                                            html += '<td class="isEndit" style="background-color: #FFFF00;" contenteditable="true"><span contenteditable="true">'+item[key]+'</span></td>';
                                        }
                                    }else if(addRow.indexOf(key)!== -1){
                                        html += '<td class="isEndit isAdd" style="background-color: #FFC000!important;"><span contenteditable="true">'+item[key]+'</span></td>';
                                    }else{
                                        html += '<td>'+item[key]+'</td>';
                                    }
                                }else{
                                    if(index === 0){
                                        if(editRow.indexOf(key)!== -1){
                                            if(addRow.indexOf(key)!== -1) {
                                                html += '<td colspan="'+_viewer_.config.data.dataArray.length+'" class="isEndit isAdd" style="background-color: #FFC000!important;" contenteditable="true"><span contenteditable="true">' + item[key] + '</span></td>';
                                            }else{
                                                html += '<td colspan="'+_viewer_.config.data.dataArray.length+'" class="isEndit" style="background-color: #FFFF00;" contenteditable="true"><span contenteditable="true">'+item[key]+'</span></td>';
                                            }
                                        }else if(addRow.indexOf(key)!== -1){
                                            html += '<td colspan="'+_viewer_.config.data.dataArray.length+'" class="isEndit isAdd" style="background-color: #FFC000!important;" contenteditable="true"><span contenteditable="true">'+item[key]+'</span></td>';
                                        }else{
                                            html += '<td colspan="'+_viewer_.config.data.dataArray.length+'">'+item[key]+'</td>';
                                        }
                                    }
                                }
                            });
                        html += '</tr>';
                    }
                    //还可以在结尾添加占满全行的tr
                    if(_viewer_.config.data.hasOwnProperty("addTr")){
                        _viewer_.config.data.addTr.forEach(function (item,index) {
                            html += '<tr>';
                            html += '<td style="text-align: left;" colspan="'+(_viewer_.config.data.dataArray.length + 1)+'">'+item+'</td>';
                            html +=  '</tr>';
                        });
                    }
                    html += '</table>';
                }else{
                    captions.forEach(function (item,index) {
                        html += '<span class="tableRender-captions"><span class="tableRender-captions-style">'+item["title"]+item["content"]+'</span></span>';
                    });
                    html +=  '</caption>';
                    html += '<tr class="tableRender-headStyle">';
                    html += '<td>'+_viewer_.config.firstRowText+'</td>';
                    for(var key in mapObj){
                        html += '<td>'+mapObj[key]+'</td>';
                    }
                    html += '<tr>';
                    dataArray.forEach(function (item,index) {
                        html += '<tr>';
                            html += '<td>'+(index+1)+'</td>';
                            for(var key in item){
                                if(editRow.indexOf(key)!== -1){
                                    html += '<td className = "'+key+'" class="isEndit" style="background-color: #FFFF00;" contenteditable="true"><span contenteditable="true">'+item[key]+'</span></td>';
                                }else{
                                    html += '<td className = "'+key+'">'+item[key]+'</td>';
                                }
                            }
                        html += '<tr>';
                    });
                }
            _viewer_.$elem.html(html);
            captions.forEach(function (item,index) {
                $(".tableRender-captions-style:eq("+index+")").css(_viewer_.config.captions[index].style);
            });
            $(".tableRender-headStyle").css(_viewer_.config.set.head);

            //监听编辑数据
            $(".isEndit").unbind('keyup').on('keyup',excute);
            function excute() {
                var editText = $(this).text();
                _viewer_.config.editCallback(_viewer_.updata(this,true));
            }
            //鼠标右击增加行
            $(document).bind('contextmenu',function(){
                return false;
            });
            $('.isAdd').unbind("mousedown").mousedown(function(e){
                if(3 === e.which){
                    _viewer_.addPop(e,this);
                    e.preventDefault()
                }
            })
        },

        excute:function () {

        },
        //右击选择弹框
        addPop:function (e,clickThis) {
            var _viewer_ = this;
            var clientX = e.clientX;
            var clientY = e.clientY;
            var nTr = $(clickThis).parent();
            var html = '';
                html +=
                    '<div class="tableRender-addPop">' +
                        '<ul>' +
                            '<li id="addTr">往下增加一行</li>' +
                            '<li id="removeTr">删除此行</li>' +
                        '</ul>' +
                    '</div>';
            if($(".tableRender-addPop").length > 0){
                $(".tableRender-addPop").remove();
            }
            $("body").append(html);
            $(".tableRender-addPop").css({
                position:"absolute",
                top:clientY,
                left:clientX
            });
            if($(".isAdd").parent().length === 1){
                $("#removeTr").css({
                    backgroundColor:"#dddddd",
                    cursor:"auto"
                })
            }
            var _con = $(".tableRender-addPop"); // 设置目标区域
            $(document).mouseup(function(e){
                if(!_con.is(e.target) && _con.has(e.target).length === 0){ // Mark 1
                    _con.remove();
                }
            });
            //增加行
            $("#addTr").click(function (event) {
                var trId = _viewer_.createRandomId();
                nTr.after('<tr>'+nTr.get(0).innerHTML+'</tr>');
                nTr.next().attr("className",nTr.attr("className") + "_" + trId);
                var nTds = nTr.next().children();
                for(var i = 0;i < nTds.length;i ++){
                    if(i !== 0){
                        $(nTds[i]).find("span").html("&nbsp;");
                    }
                }
                $('.isAdd').unbind("mousedown").mousedown(function(e){
                    if(3 === e.which){
                        _viewer_.addPop(e,this);
                        e.preventDefault()
                    }
                });
                //监听编辑数据
                $(".isEndit").unbind('keyup').on('keyup',excute);
                function excute() {
                    var editText = $(this).text();
                    _viewer_.config.editCallback(_viewer_.updata(this,true));
                }
                //增加行后更新数据
                _viewer_.config.data.dataArray.forEach(function (item,index) {
                    item[nTr.next().attr("className")] = "";
                });
                _viewer_.config.editCallback(_viewer_.updata(null,false));
                _con.remove();
            });
            //删除行
            $("#removeTr").click(function (event) {
                if($(".isAdd").parent().length > 1){
                    //删除行前更新数据
                    _viewer_.config.data.dataArray.forEach(function (item,index) {
                        delete item[nTr.attr("className")];
                    });
                    _viewer_.config.editCallback(_viewer_.updata(null,false));
                    nTr.remove();
                    _con.remove();
                }else{
                    return;
                }
            });
        },
        //生成随机uuid
        createRandomId:function () {
            return 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function(c) {
                var r = Math.random()*16|0, v = c === 'x' ? r : (r&0x3|0x8);
                return v.toString(16);
            });
        },
        //更新数据集  bol 是否为仅编辑
        updata:function (getThis,bol) {
            var _viewer_ = this;
            if(bol){
                var chidNodes = $(getThis).parent().children();
                for(var i = 0;i < chidNodes.length;i ++){
                    if($(chidNodes[i]).text() === $(getThis).text()){
                        var index = null;
                        var name = null;
                        if(_viewer_.config.set.type === "transverse"){
                            index = i - 1;
                            name = $($(getThis).parent()).attr("className");
                            _viewer_.config.data.dataArray[index][name] = $(getThis).text();
                        }else{
                            index = Number($(chidNodes[0]).text()) - 1;
                            name = $(getThis).attr("className");
                            _viewer_.config.data.dataArray[index][name] = $(getThis).text();
                        }
                    }
                }
            }
            return {"dataArray":_viewer_.config.data.dataArray}
        }
    };
    $.fn.tableRender = function(options) {
        new TableRender(this, options).init();
        return this;
    };

})( jQuery, window , document );