function getCursortPosition(e) {
    var eleP = e.target.parentNode; //获取父级元素
    var pos = 0;
    if (e.target.nodeName == "DIV") {
        pos = getDivPosition(e.target);
    } else {
        pos = getPosition(e.target);
    }

    var spanEle = (eleP.childNodes)[7];
    spanEle.innerText = pos;
    return pos;
}

//可编辑div获取坐标
const getDivPosition = function (element) {
    var caretOffset = 0;
    var doc = element.ownerDocument || element.document;
    var win = doc.defaultView || doc.parentWindow;
    var sel;
    if (typeof win.getSelection != "undefined") {//谷歌、火狐
        sel = win.getSelection();
        if (sel.rangeCount > 0) {//选中的区域
            var range = win.getSelection().getRangeAt(0);
            var preCaretRange = range.cloneRange();//克隆一个选中区域
            preCaretRange.selectNodeContents(element);//设置选中区域的节点内容为当前节点
            preCaretRange.setEnd(range.endContainer, range.endOffset);  //重置选中区域的结束位置
            caretOffset = preCaretRange.toString().length;
        }
    } else if ((sel = doc.selection) && sel.type != "Control") {//IE
        var textRange = sel.createRange();
        var preCaretTextRange = doc.body.createTextRange();
        preCaretTextRange.moveToElementText(element);
        preCaretTextRange.setEndPoint("EndToEnd", textRange);
        caretOffset = preCaretTextRange.text.length;
    }
    return caretOffset;
}

//输入框获取光标
const getPosition = function (element) {
    let cursorPos = 0;
    if (document.selection) {//IE
        var selectRange = document.selection.createRange();
        selectRange.moveStart('character', -element.value.length);
        cursorPos = selectRange.text.length;
    } else if (element.selectionStart || element.selectionStart == '0') {
        cursorPos = element.selectionStart;
    }
    return cursorPos;
}

var current_length = '';
function Mobile2(obj)
{
    var value = obj.value;
    value = value.replace(/[^\d]/g,'');
    var result = [];

    if (keycode != 8 && index == 4) {
        index++;
    }

    if (keycode != 8 && index == 9) {
        index++;
    }

    for(var i = 0; i < value.length; i++)
    {
        if (i==3||i==7)
        {

            result.push(" " + value.charAt(i) );
        }
        else
        {
            result.push(value.charAt(i));
        }
    }
    obj.value = result.join("");

    current_length = result.join("");
}




function setCaretPosition(ctrl, pos){//设置光标位置函数
    if(ctrl.setSelectionRange)
    {
        ctrl.focus();
        ctrl.setSelectionRange(pos,pos);
    }
    else if (ctrl.createTextRange) {
        var range = ctrl.createTextRange();
        range.collapse(true);
        range.moveEnd('character', pos);
        range.moveStart('character', pos);
        range.select();
    }
}
var index = 0;
var keycode = 0;
$(function(){
    $("#mobile").on("input",function(event){
        if ($(this).val() == current_length) {
            return false;
        }
        keycode = event.keyCode;
        index = getCursortPosition(event);
        Mobile2(document.getElementById("mobile"));
        setCaretPosition(document.getElementById("mobile"),index);
    })
})
