var NodeData = [{
        fixed: true,
        id: "20210817172945",
        nodeType: 0,
        name: "RTU",
        x: 400,
        y: 400,
        value: [400, 400],
        symbol: 'image://../images/工业1icon/RTU.png',
        symbolSize: [68, 73],
        label: {
            show: true,
            color: "#f58025",
            fontWeight: "bolder",
            fontSize: 14,
            position: 'bottom',
            offset: [0, 10],
            distance: 0,
        },
        itemStyle: {
            color: "#f58025"
        }
    },
    {
        fixed: true,
        id: "20210817172948",
        nodeType: 0,
        name: "PC",
        x: 100,
        y: 200,
        value: [100, 200],
        symbol: 'image://../images/工业1icon/PC.png',
        symbolSize: [68, 43],
        label: {
            show: true,
            color: "#ffb402",
            fontWeight: "normal",
            fontSize: 12,
            position: 'top',
            distance: 0,
            offset: [0, 0],
        },
        itemStyle: {
            color: "#ffb402"
        }
    },
    {
        fixed: true,
        id: "20210817172950",
        nodeType: 0,
        name: "PLC",
        x: -200,
        y: -200,
        value: [-200, -200],
        symbol: 'image://../images/工业1icon/PLC.png',
        symbolSize: [68, 38],
        label: {
            show: true,
            color: "#35c2ff",
            fontWeight: "bolder",
            fontSize: 14,
            position: 'bottom',
            offset: [80, 0],
            distance: -50,
        },
        itemStyle: {
            color: "#35c2ff"
        }
    },
];

var DataLink = [{
    id: "1",
    nodeType: 1,
    sourceID: "20210817172948",
    targetID: "20210817172945",
    coords: [
        [100, 200],
        [400, 400]
    ],
    effect: {
        period: 2,
        trailLength: 0,
        symbol: "pin",
        symbolSize: [12, 12],
        color: "#f20"
    },
    lineStyle: {
        color: "#f20",
        type: "dotted",
        width: 1,
        curveness: 0.2,
        opacity: 1
    },
}, {
    id: "2",
    nodeType: 1,
    sourceID: "20210817172948",
    targetID: "20210817172950",
    coords: [
        [100, 200],
        [-200, -200]
    ],
    effect: {
        period: 2,
        trailLength: 0.01,
        symbol: "arrow",
        symbolSize: [12, 12],
        color: "#00f4ed"
    },
    lineStyle: {
        color: "#00f4ed",
        type: "solid",
        width: 1,
        curveness: 0.2,
        opacity: 1
    },
}]

var xAxis = {
    min: -600,
    max: 600,
    minorTick: {
        show: false
    },
    minorSplitLine: {
        show: true
    },
    // splitNumber: 50,
    axisLine: {
        show: false
    },
    axisTick: {
        show: false
    },
    splitLine: {
        lineStyle: {
            type: 'dashed'
        }
    },

}

var yAxis = {
    min: -600,
    max: 600,
    minorTick: {
        show: false
    },
    minorSplitLine: {
        show: true
    },
    // splitNumber: 50,
    axisLine: {
        show: false
    },
    axisTick: {
        show: false
    },
    splitLine: {
        lineStyle: {
            type: 'dashed'
        }
    }
}
var grid = {
    left: '5%',
    right: '3%',
    bottom: '5%',
    top: '5%',
    containLabel: true
}

var myChart = echarts.init(document.getElementById('echarts'));
var option;
option = ({
    grid: grid,
    tooltip: {
        show: true,
        formatter: function(params) {
            var htmlStr = '<div>';
            if (params.data.nodeType == "0") {
                htmlStr += params.marker + 'ID：' + params.data.id + '<br/>';
                htmlStr += params.marker + '名称：' + params.data.name + '<br/>';
                // htmlStr += params.marker + '节点IP：' + params.data.ip + '<br/>';
                htmlStr += params.marker + '节点X坐标：' + params.data.x + '<br/>';
                htmlStr += params.marker + '节点Y坐标：' + params.data.y + '<br/>';
                htmlStr += '</div>';
            } else {
                var sourceName, targetName;
                for (var i = 0; i < NodeData.length; i++) {
                    if (params.data.sourceID == NodeData[i].id) {
                        sourceName = NodeData[i].name
                    }
                    if (params.data.targetID == NodeData[i].id) {
                        targetName = NodeData[i].name
                    }
                }
                htmlStr += params.marker + '来源设备：' + sourceName + '<br/>';
                htmlStr += params.marker + '目的设备：' + targetName + '<br/>';
            }
            return htmlStr;
        }
    },
    xAxis: xAxis,
    yAxis: yAxis,
    series: [{
            type: "graph",
            zlevel: 5,
            draggable: false,
            coordinateSystem: "cartesian2d",
            symbol: "rect",
            symbolOffset: ["15%", 0],
            label: {
                show: true,
                color: "#35c2ff",
                fontWeight: "bolder",
                fontSize: 14,
                position: 'top',
                offset: [0, 10],
                distance: 5,
                // formatter: function() {
                //     return '边缘物联代理装置系统'
                // },
            },
            itemStyle: {
                color: "#35c2ff"
            },
            data: NodeData,
            links: [],
            lineStyle: {}
        },
        {
            type: "lines",
            coordinateSystem: "cartesian2d",
            z: 1,
            zlevel: 2,
            animation: false,
            effect: {
                show: true,
                period: 5,
                trailLength: 0,
                symbolSize: 12,
                symbol: "pin",
                color: "#00F4ED",
                loop: true,
            },
            lineStyle: {
                color: "#00F4ED",
                type: 'solid',
                width: 1,
                curveness: 0.2,
                opacity: 1
            },
            data: DataLink
        },
    ]
});

myChart.setOption(option);
// 自适应宽度
window.addEventListener("resize", function() {
    myChart.resize();
});

/*******************/

// layui预加载
layui.use(['element', 'layer', 'form', 'colorpicker'], function() {
    var element = layui.element,
        layer = layui.layer,
        form = layui.form,
        colorpicker = layui.colorpicker,
        $ = layui.$;

    // 节点颜色选择
    var node_color = '#00F4ED'; //默认颜色

    function NodeColor(node_color) {
        colorpicker.render({
            elem: '#NodeColor',
            color: node_color,
            done: function(color) {
                $('#NodeColor-input').val(color);
            }
        });
    };
    NodeColor();

    // 连接线颜色选择
    function LinkColor(node_color) {
        colorpicker.render({
            elem: '#LinkColor',
            color: node_color,
            done: function(color) {
                $('#LinkColor-input').val(color);
            }
        });
    };
    LinkColor();

    // 特效颜色选择
    function effectSymbolColor(node_color) {
        colorpicker.render({
            elem: '#effectSymbolColor',
            color: node_color,
            done: function(color) {
                $('#effectSymbolColor-input').val(color);
            }
        });
    };
    effectSymbolColor();

    // 左侧图形事件
    $(".icon-body").on({
        mouseover: function() {
            var $this = $(this);
            var imgSrc = $(this).find("img").attr("src");
            var imgTitle = $(this).find("p").text();
            var content = '<div class="imgBig"><p>' + imgTitle + '</p><img src="' + imgSrc + '"></div>'
            layer.open({
                type: 4,
                skin: 'icon-tips',
                area: '180px',
                shade: 0,
                tips: 1,
                closeBtn: 0,
                content: [content, $this]
            });
        },
        mouseout: function() {
            layer.closeAll('tips');
        },
        click: function() { //添加节点-表单赋值
            var imgSrc = $(this).find("img").attr("src");
            var imgTitle = $(this).find("p").text();
            layer.open({
                type: 1,
                title: '样式',
                content: $('#modelAlert'),
                area: ['320px', '100%'],
                offset: 'rt',
                anim: 5,
                shadeClose: true,
                success: function() {
                    NodeColor(node_color);
                    $(".modelAlert-node_edit").show().text("添加节点").addClass("layui-this").siblings().removeClass("layui-this");
                    $(".layui-tab-item_nodeAdd").addClass("layui-show").siblings().removeClass("layui-show");
                    $(".modelAlert-node_add").hide();
                    $(".modelAlert-node_delete").hide();
                    $("#btnType").val("add");
                    form.val('NodeAddForm', {
                        "show": "true",
                        "LabelName": imgTitle,
                        "symbol": imgSrc,
                        "symbolSizeX": $(".imgBig img").width(),
                        "symbolSizeY": $(".imgBig img").height(),
                        "position": "top",
                        "distance": "0",
                        "offsetX": "0",
                        "offsetY": "0",
                        "color": "#00F4ED",
                        "fontSize": "12",
                        "fontWeight": "normal",
                        "coordinateX": "0",
                        "coordinateY": "0",
                        // "symbol": params.data.symbol,
                        // "symbolSizeX": params.data.symbolSize[0],
                        // "symbolSizeY": params.data.symbolSize[1],
                    });
                    form.render();
                }
            });
        }
    }, '.icon-body_img');

    //编辑节点
    var DefaultCoordsArr = []; //存放初始坐标

    function NodeModify(params) {
        var node_color = params.data.label.color;
        NodeColor(node_color);
        DefaultCoordsArr[0] = params.data.x;
        DefaultCoordsArr[1] = params.data.y;
        $(".modelAlert-node_edit").show().text("编辑节点").addClass("layui-this").siblings().removeClass("layui-this");
        $(".layui-tab-item_nodeAdd").addClass("layui-show").siblings().removeClass("layui-show");
        $(".modelAlert-node_add").show().text("增加节点关系");
        $(".modelAlert-node_delete").show().text("删除节点");
        $(".nodeDelete").show();
        $(".nodeLinkDelete").hide();
        $("#btnType").val("edit"); //点击类型
        $("#NodeId").val(params.data.id); //节点Id
        // 表单赋值
        form.val('NodeAddForm', {
            "show": params.data.label.show + "",
            "LabelName": params.data.name,
            "position": params.data.label.position,
            "distance": params.data.label.distance,
            "offsetX": params.data.label.offset[0],
            "offsetY": params.data.label.offset[1],
            "color": params.data.label.color,
            "fontSize": params.data.label.fontSize,
            "fontWeight": params.data.label.fontWeight,
            "coordinateX": params.data.x,
            "coordinateY": params.data.y,
            "symbol": params.data.symbol,
            "symbolSizeX": params.data.symbolSize[0],
            "symbolSizeY": params.data.symbolSize[1],
        });
        form.render();
    };

    // 添加编辑节点提交
    form.on('submit(NodeAddSubmit)', function(data) {
        // 判断节点标签是否显示
        if (data.field.show == "true") {
            data.field.show = true;
        } else {
            data.field.show = false;
        };
        // 添加
        if ($("#btnType").val() == "add") {
            var Symbol = 'image://' + data.field.symbol;
            var addID = new Date().Format("yyyyMMddHHmmss");
            var addData = {
                fixed: true,
                id: addID,
                nodeType: 0, //判断节点或者连接线(0:节点,1:连接线)
                name: data.field.LabelName,
                x: parseInt(data.field.coordinateX),
                y: parseInt(data.field.coordinateY),
                value: [parseInt(data.field.coordinateX), parseInt(data.field.coordinateY)],
                symbol: Symbol,
                symbolSize: [parseInt(data.field.symbolSizeX), parseInt(data.field.symbolSizeY)],
                label: {
                    show: data.field.show,
                    color: data.field.color,
                    fontWeight: data.field.fontWeight,
                    fontSize: parseInt(data.field.fontSize),
                    position: data.field.position,
                    distance: parseInt(data.field.distance),
                    offset: [parseInt(data.field.offsetX), parseInt(data.field.offsetY)],
                },
                itemStyle: {
                    color: data.field.color
                }

            };
            NodeData.push(addData);
            myChart.setOption(option);
            layer.closeAll();
            return false;

        } else { // 编辑
            var Symbol = data.field.symbol;
            var id = $("#NodeId").val();
            $.each(NodeData, function(i) {
                if (id == NodeData[i].id) {
                    NodeData[i].fixed = true;
                    NodeData[i].id = id;
                    NodeData[i].nodeType = 0; //判断节点或者连接线(0:节点,1:连接线)
                    NodeData[i].name = data.field.LabelName;
                    NodeData[i].x = parseInt(data.field.coordinateX);
                    NodeData[i].y = parseInt(data.field.coordinateY);
                    NodeData[i].value = [parseInt(data.field.coordinateX), parseInt(data.field.coordinateY)];
                    NodeData[i].symbol = Symbol;
                    NodeData[i].symbolSize = [parseInt(data.field.symbolSizeX), parseInt(data.field.symbolSizeY)];
                    NodeData[i].label = {
                        show: data.field.show,
                        color: data.field.color,
                        fontWeight: data.field.fontWeight,
                        fontSize: parseInt(data.field.fontSize),
                        position: data.field.position,
                        distance: parseInt(data.field.distance),
                        offset: [parseInt(data.field.offsetX), parseInt(data.field.offsetY)],
                    };
                    NodeData[i].itemStyle = {
                        color: data.field.color
                    }
                }
            });

            // console.log(DefaultCoordsArr);
            // 存放修改后坐标
            var ModifyCoordsArr = [];
            ModifyCoordsArr[0] = parseInt(data.field.coordinateX);
            ModifyCoordsArr[1] = parseInt(data.field.coordinateY);
            // console.log(ModifyCoordsArr);

            $.each(DataLink, function(i) {
                if (DataLink[i].sourceID == id || DataLink[i].targetID == id) {

                    var coordsArr = DataLink[i].coords;
                    $.each(coordsArr, function(j) {
                        // console.log(coordsArr[j])
                        if (coordsArr[j].toString() == DefaultCoordsArr.toString()) {
                            coordsArr[j] = ModifyCoordsArr;
                        }
                    })
                }
            });
            myChart.setOption(option);
            layer.closeAll();
            return false;
        }
    });

    // 删除节点
    function NodeDelete(params) {
        $(".nodeDelete").click(function() {
            layer.confirm('是否删除设备节点？', { icon: 3, title: '提示' }, function(index) {
                NodeData.splice(params.dataIndex, 1); //删除节点
                var arr = []; //存放节点对应的关系
                $.each(DataLink, function(i) {
                    if (DataLink[i].sourceID == params.data.id || DataLink[i].targetID == params.data.id) {
                        arr.push(DataLink[i]);
                    }
                })
                console.log(params.data.id)
                console.log(arr);

                for (var i = 0; i < DataLink.length; i++) {
                    for (var j = 0; j < arr.length; j++) {
                        if (DataLink[i].id == arr[j].id) {
                            DataLink.splice($.inArray(DataLink[i], DataLink), 1);
                        }
                    }
                }
                myChart.setOption(option);
                layer.closeAll();
            });
        })

    };

    // 增加节点关系-表单赋值
    function NodeLinksAdd(params) {
        $("#btnLinkType").val("linkAdd");
        $("input[name=targetID]").removeClass("layui-disabled").prop("disabled", "");
        // var link_color = params.data.lineStyle.color;
        LinkColor(node_color);
        // var effect_color = params.data.effect.color;
        effectSymbolColor(node_color);
        form.val('NodeLinkAddForm', {
            "nodeType": 1,
            "sourceID": params.data.id,
            "targetID": "",
            "sourceX": parseInt(params.data.x),
            "sourceY": parseInt(params.data.y),
            "targetX": "",
            "targetY": "",
            "target": params.data.target,
            "linkType": "solid",
            "linkWidth": 1,
            "linkOpacity": 1,
            "linkCurveness": 0.2,
            "linkColor": "#00F4ED",
            "effectPeriod": 4,
            "effectSymbol": "arrow",
            "effectSymbolSizeX": 12,
            "effectSymbolSizeY": 12,
            "effectSymbolColor": "#00F4ED",
            "trailLength": 0.2,
        });
        form.render();
    }

    // 编辑节点关系- 表单赋值
    function NodeLinksEdit(params) {
        var link_color = params.data.lineStyle.color;
        LinkColor(link_color);
        var effect_color = params.data.effect.color;
        effectSymbolColor(effect_color);
        $(".modelAlert-node_add").show().text("编辑节点关系").addClass("layui-this").siblings().removeClass("layui-this");
        $(".layui-tab-item_nodeAddLink").addClass("layui-show").siblings().removeClass("layui-show");
        $(".modelAlert-node_edit").hide();
        $(".modelAlert-node_delete").show().text("删除节点关系连接线");
        $(".nodeDelete").hide();
        $(".nodeLinkDelete").show();
        $("#btnLinkType").val("linkEdit");
        $("#NodeLinkId").val(params.data.id); //节点连接线Id
        $("input[name=targetID]").addClass("layui-disabled").prop("disabled", "disabled");
        form.val('NodeLinkAddForm', {
            "nodeType": 1,
            "sourceID": params.data.sourceID,
            "targetID": params.data.targetID,
            "sourceX": params.data.coords[0][0],
            "sourceY": params.data.coords[0][1],
            "targetX": params.data.coords[1][0],
            "targetY": params.data.coords[1][1],
            "target": params.data.target,
            "linkType": params.data.lineStyle.type,
            "linkWidth": params.data.lineStyle.width,
            "linkOpacity": params.data.lineStyle.opacity,
            "linkCurveness": params.data.lineStyle.curveness,
            "linkColor": params.data.lineStyle.color,
            "effectPeriod": params.data.effect.period,
            "effectSymbol": params.data.effect.symbol,
            "effectSymbolSizeX": params.data.effect.symbolSize[0],
            "effectSymbolSizeY": params.data.effect.symbolSize[1],
            "effectSymbolColor": params.data.effect.color,
            "trailLength": params.data.effect.trailLength,
        });
        form.render();
    }

    // 节点关系提交
    form.on('submit(NodeLinkAddSubmit)', function(data) {
        if ($("#btnLinkType").val() == "linkAdd") {
            var addLinkID = new Date().Format("yyyyMMddHHmmss");
            var addLinkData = {
                id: addLinkID,
                nodeType: 1, //判断节点或者连接线(0:节点,1:连接线)
                sourceID: data.field.sourceID,
                targetID: data.field.targetID,
                coords: [
                    [parseInt(data.field.sourceX), parseInt(data.field.sourceY)],
                    [parseInt(data.field.targetX), parseInt(data.field.targetY)]
                ],
                effect: {
                    period: parseInt(data.field.effectPeriod),
                    trailLength: parseInt(data.field.trailLength),
                    symbol: data.field.effectSymbol,
                    symbolSize: [parseInt(data.field.effectSymbolSizeX), parseInt(data.field.effectSymbolSizeY)],
                    color: data.field.effectSymbolColor
                },
                lineStyle: {
                    type: data.field.linkType,
                    color: data.field.linkColor,
                    width: parseInt(data.field.linkWidth),
                    curveness: data.field.linkCurveness,
                    opacity: data.field.linkOpacity
                },

            };
            DataLink.push(addLinkData);
            myChart.setOption(option);
            layer.closeAll();
            return false;
        } else {
            var id = $("#NodeLinkId").val();
            $.each(DataLink, function(i) {
                if (id == DataLink[i].id) {
                    DataLink[i].id = id;
                    DataLink[i].nodeType = 1; //判断节点或者连接线(0:节点,1:连接线)
                    DataLink[i].sourceID = data.field.sourceID;
                    DataLink[i].targetID = data.field.targetID;
                    DataLink[i].coords = [
                        [parseInt(data.field.sourceX), parseInt(data.field.sourceY)],
                        [parseInt(data.field.targetX), parseInt(data.field.targetY)]
                    ];
                    DataLink[i].effect = {
                        period: parseInt(data.field.effectPeriod),
                        trailLength: parseInt(data.field.trailLength),
                        symbol: data.field.effectSymbol,
                        symbolSize: [parseInt(data.field.effectSymbolSizeX), parseInt(data.field.effectSymbolSizeY)],
                        color: data.field.effectSymbolColor
                    };
                    DataLink[i].lineStyle = {
                        type: data.field.linkType,
                        color: data.field.linkColor,
                        width: parseInt(data.field.linkWidth),
                        curveness: data.field.linkCurveness,
                        opacity: data.field.linkOpacity
                    };
                }
            });
            console.log(DataLink)
            myChart.setOption(option);
            layer.closeAll();
            return false;
        }
    })

    // 删除节点关系
    function NodeLinksDelete(params) {
        $(".nodeLinkDelete").click(function() {
            layer.confirm('是否删除节点关系？', { icon: 3, title: '提示' }, function(index) {
                DataLink.splice(params.dataIndex, 1); //删除节点关系
                myChart.setOption(option);
                layer.closeAll();
            })
        })
    }

    // 画布点击
    myChart.on('click', function(params) {
        if (params.data.nodeType == "0") { //点击节点
            layer.open({
                type: 1,
                title: '样式',
                content: $('#modelAlert'),
                area: ['320px', '100%'],
                offset: 'rt',
                anim: 5,
                // shade: 0,
                shadeClose: true,
                success: function(index, layero) {
                    //编辑节点表单赋值
                    NodeModify(params);

                    //增加节点关系表单赋值
                    NodeLinksAdd(params);

                    // 删除节点
                    NodeDelete(params);

                },
                cancel: function(index, layero) {

                }
            });

        } else { //点击连接线
            layer.open({
                type: 1,
                title: '样式',
                content: $('#modelAlert'),
                area: ['320px', '100%'],
                offset: 'rt',
                anim: 5,
                shadeClose: true,
                success: function() {
                    //编辑关系表单赋值
                    NodeLinksEdit(params);

                    // 删除节点关系
                    NodeLinksDelete(params);
                }
            });
            // NodeLinksDelete(params);
        }
    });
});


// 场景提交
$("#EchartsBtnSubmit").click(function() {
    // var graphImg = myChart.getDataURL(); //拓扑图转换成base64图片地址
    var topoNode = {
        NodeData: NodeData,
        DataLink: DataLink
    }
    var params = {
        // "thumbnail": graphImg,
        "topoNode": topoNode,
    }
    alert(JSON.stringify(params))
})