/*
 * Sequence.js
 *
 * The responsive CSS animation framework for creating unique sliders,
 * presentations, banners, and other step-based applications.
 *
 * @link https://github.com/IanLunn/Sequence
 * @author IanLunn
 * @version 2.1.0
 * @license http://sequencejs.com/licenses/
 * @copyright Ian Lunn Design Limited 2015
 */
function defineSequence(a,b){"use strict";var c=[],d=0,e=function(e,f){function g(a){return"[object Array]"===Object.prototype.toString.call(a)?!0:!1}function h(a,b){for(var c in b)a[c]=b[c];return a}function i(a,b){var c;return a.currentStyle?c=a.currentStyle[b]:document.defaultView&&document.defaultView.getComputedStyle&&(c=document.defaultView.getComputedStyle(a,"")[b]),c}function j(a,b,c){if(a.addEventListener)return a.addEventListener(b,c,!1),c;if(a.attachEvent){var d=function(){c.call(a)};return a.attachEvent("on"+b,d),d}}function k(a,b,c){a.addEventListener?a.removeEventListener(b,c,!1):a.detachEvent&&a.detachEvent("on"+b,c)}function l(a){var b,c;return c=a.indexOf("ms")>-1?1:1e3,b="0s"==a?0:parseFloat(a.replace("s",""))*c}function m(a,b){return void 0!==a?new RegExp("(\\s|^)"+b+"(\\s|$)").test(a.className):void 0}function n(a,b){var c,d,e;for(g(a)===!1&&(d=1,a=[a]),d=a.length,e=0;d>e;e++)c=a[e],m(c,b)===!1&&(c.className+=(c.className?" ":"")+b)}function o(a,b){var c,d,e;for(g(a)===!1?(d=1,a=[a]):d=a.length,e=0;d>e;e++)c=a[e],m(c,b)===!0&&(c.className=c.className.replace(new RegExp("(\\s|^)"+b+"(\\s|$)")," ").replace(/^\s+|\s+$/g,""))}function p(a,b){var c=a.getBoundingClientRect(),d=!1;return b.clientX>=c.left&&b.clientX<=c.right&&b.clientY>=c.top&&b.clientY<=c.bottom&&(d=!0),d}function q(a,b,c){if("BODY"===b.nodeName)return!1;if(a!==b)return c=b,q(a,b.parentNode,c);if(void 0!==c)for(var d=c,e=a.getElementsByTagName(d.nodeName),f=e.length;f--;)if(d===e[f])return f+1}function r(a){var c=0,d=b.DIRECTION_NONE;return(void 0!==a.left||void 0!==a.right)&&(c+=1),(void 0!==a.up||void 0!==a.down)&&(c+=2),1===c?d=b.DIRECTION_HORIZONTAL:2===c?d=b.DIRECTION_VERTICAL:3===c&&(d=b.DIRECTION_ALL),d}function s(a,b){var c="seq-",d="no-touch";b.touch===!0&&(d="touch"),n(a,c+d)}var t=e.getAttribute("data-seq-enabled");if(null!==t)return c[t];e.setAttribute("data-seq-enabled",d),d++;var u={startingStepId:1,startingStepAnimatesIn:!1,cycle:!0,phaseThreshold:!0,reverseWhenNavigatingBackwards:!1,reverseTimingFunctionWhenNavigatingBackwards:!1,moveActiveStepToTop:!0,animateCanvas:!0,animateCanvasDuration:250,autoPlay:!1,autoPlayInterval:5e3,autoPlayDelay:null,autoPlayDirection:1,autoPlayButton:!0,autoPlayPauseOnHover:!0,navigationSkip:!0,navigationSkipThreshold:250,fadeStepWhenSkipped:!0,fadeStepTime:500,ignorePhaseThresholdWhenSkipped:!1,preventReverseSkipping:!1,nextButton:!0,prevButton:!0,pagination:!0,preloader:!1,preloadTheseSteps:[1],preloadTheseImages:[],hideStepsUntilPreloaded:!1,pausePreloader:!1,keyNavigation:!1,numericKeysGoToSteps:!1,keyEvents:{left:function(a){a.prev()},right:function(a){a.next()}},swipeNavigation:!0,swipeEvents:{left:function(a){a.next()},right:function(a){a.prev()},up:void 0,down:void 0},swipeHammerOptions:{},hashTags:!1,hashDataAttribute:!1,hashChangesOnFirstStep:!1,fallback:{speed:500}},v=50,w=100,x={animation:{WebkitAnimation:"-webkit-",animation:""}},y=function(a,b,c){function d(a){r.cssText=a}function e(a,b){return typeof a===b}function f(a,b){return!!~(""+a).indexOf(b)}function g(a,b){for(var d in a){var e=a[d];if(!f(e,"-")&&r[e]!==c)return"pfx"==b?e:!0}return!1}function h(a,b,d){for(var f in a){var g=b[a[f]];if(g!==c)return d===!1?a[f]:e(g,"function")?g.bind(d||b):g}return!1}function i(a,b,c){var d=a.charAt(0).toUpperCase()+a.slice(1),f=(a+" "+u.join(d+" ")+d).split(" ");return e(b,"string")||e(b,"undefined")?g(f,b):(f=(a+" "+v.join(d+" ")+d).split(" "),h(f,b,c))}var j,k,l,m="2.8.3",n={},o=b.documentElement,p="modernizr",q=b.createElement(p),r=q.style,s=({}.toString," -webkit- -moz- -o- -ms- ".split(" ")),t="Webkit Moz O ms",u=t.split(" "),v=t.toLowerCase().split(" "),w={svg:"http://www.w3.org/2000/svg"},x={},y=[],z=y.slice,A=function(a,c,d,e){var f,g,h,i,j=b.createElement("div"),k=b.body,l=k||b.createElement("body");if(parseInt(d,10))for(;d--;)h=b.createElement("div"),h.id=e?e[d]:p+(d+1),j.appendChild(h);return f=["&#173;",'<style id="s',p,'">',a,"</style>"].join(""),j.id=p,(k?j:l).innerHTML+=f,l.appendChild(j),k||(l.style.background="",l.style.overflow="hidden",i=o.style.overflow,o.style.overflow="hidden",o.appendChild(l)),g=c(j,a),k?j.parentNode.removeChild(j):(l.parentNode.removeChild(l),o.style.overflow=i),!!g},B={}.hasOwnProperty;l=e(B,"undefined")||e(B.call,"undefined")?function(a,b){return b in a&&e(a.constructor.prototype[b],"undefined")}:function(a,b){return B.call(a,b)},Function.prototype.bind||(Function.prototype.bind=function(a){var b=this;if("function"!=typeof b)throw new TypeError;var c=z.call(arguments,1),d=function(){if(this instanceof d){var e=function(){};e.prototype=b.prototype;var f=new e,g=b.apply(f,c.concat(z.call(arguments)));return Object(g)===g?g:f}return b.apply(a,c.concat(z.call(arguments)))};return d}),x.touch=function(){var c;return"ontouchstart"in a||a.DocumentTouch&&b instanceof DocumentTouch?c=!0:A(["@media (",s.join("touch-enabled),("),p,")","{#modernizr{top:9px;position:absolute}}"].join(""),function(a){c=9===a.offsetTop}),c},x.cssanimations=function(){return i("animationName")},x.csstransforms=function(){return!!i("transform")},x.csstransitions=function(){return i("transition")},x.svg=function(){return!!b.createElementNS&&!!b.createElementNS(w.svg,"svg").createSVGRect};for(var C in x)l(x,C)&&(k=C.toLowerCase(),n[k]=x[C](),y.push((n[k]?"":"no-")+k));return n.addTest=function(a,b){if("object"==typeof a)for(var d in a)l(a,d)&&n.addTest(d,a[d]);else{if(a=a.toLowerCase(),n[a]!==c)return n;b="function"==typeof b?b():b,"undefined"!=typeof enableClasses&&enableClasses&&(o.className+=" "+(b?"":"no-")+a),n[a]=b}return n},d(""),q=j=null,n._version=m,n._prefixes=s,n._domPrefixes=v,n._cssomPrefixes=u,n.testProp=function(a){return g([a])},n.testAllProps=i,n.testStyles=A,n.prefixed=function(a,b,c){return b?i(a,b,c):i(a,"pfx")},n}(window,window.document);Array.prototype.indexOf||(Array.prototype.indexOf=function(a,b){if(void 0===this||null===this)throw new TypeError('"this" is null or not defined');var c=this.length>>>0;for(b=+b||0,1/0===Math.abs(b)&&(b=0),0>b&&(b+=c,0>b&&(b=0));c>b;b++)if(this[b]===a)return b;return-1});var z,A;"undefined"!=typeof document.hidden?(z="hidden",A="visibilitychange"):"undefined"!=typeof document.mozHidden?(z="mozHidden",A="mozvisibilitychange"):"undefined"!=typeof document.msHidden?(z="msHidden",A="msvisibilitychange"):"undefined"!=typeof document.webkitHidden&&(z="webkitHidden",A="webkitvisibilitychange");var B={modernizr:y};return B.ui={defaultElements:{nextButton:"seq-next",prevButton:"seq-prev",autoPlayButton:"seq-autoplay",pagination:"seq-pagination",preloader:"seq-preloader"},getElements:function(a,b){var c,d,e,f,g,h=[];for(d=document.querySelectorAll(b===!0?"."+this.defaultElements[a]:b),e=d.length,g=0;e>g;g++)c=d[g],f=c.getAttribute("rel"),(null===f||f===B.$container.getAttribute("id"))&&h.push(c);return h},show:function(a,b){B.propertySupport.transitions===!0?(a.style[y.prefixed("transitionDuration")]=b+"ms",a.style[y.prefixed("transitionProperty")]="opacity, "+y.prefixed("transform"),a.style.opacity=1):B.animationFallback.animate(a,"opacity","",0,1,b)},hide:function(a,b,c){B.propertySupport.transitions===!0?(a.style[y.prefixed("transitionDuration")]=b+"ms",a.style[y.prefixed("transitionProperty")]="opacity, "+y.prefixed("transform"),a.style.opacity=0):B.animationFallback.animate(a,"opacity","",1,0,b),void 0!==c&&(B.hideTimer=setTimeout(function(){c()},b))}},B.autoPlay={init:function(){B.isAutoPlayPaused=!1,B.isAutoPlaying=!1},getDelay:function(a,b,c){switch(a){case!0:a=null===b?c:b;break;case!1:case void 0:a=0}return a},start:function(a,b){if(B.isAutoPlaying===!0||B.isReady===!1)return!1;var c=B.options;return a=this.getDelay(a,c.autoPlayDelay,c.autoPlayInterval),void 0===b&&B.started(B),n(B.$container,"seq-autoplaying"),n(B.$autoPlay,"seq-autoplaying"),c.autoPlay=!0,B.isAutoPlaying=!0,B.isAnimating===!1&&(B.autoPlayTimer=setTimeout(function(){1===c.autoPlayDirection?B.next():B.prev()},a)),!0},stop:function(){return B.options.autoPlay!==!0||B.isAutoPlaying!==!0?!1:(B.options.autoPlay=!1,B.isAutoPlaying=!1,clearTimeout(B.autoPlayTimer),o(B.$container,"seq-autoplaying"),o(B.$autoPlay,"seq-autoplaying"),B.stopped(B),!0)},unpause:function(){return B.isAutoPlayPaused!==!0?!1:(B.isAutoPlayPaused=!1,this.start(!0),!0)},pause:function(){return B.options.autoPlay!==!0?!1:(B.isAutoPlayPaused=!0,this.stop(),!0)}},B.canvas={init:function(){void 0!==B.$screen&&(B.$screen.style.height="100%",B.$screen.style.width="100%"),B.canvas.getTransformProperties()},getSteps:function(a){var b,c,d,e=[],f=a.children,g=f.length;for(B.stepProperties={},d=0;g>d;d++)c=f[d],b=d+1,e.push(c),B.stepProperties[b]={},B.stepProperties[b].isActive=!1;return e},getTransformProperties:function(){var a,b,c,d;for(a=0;a<B.noOfSteps;a++)b=B.$steps[a],c=a+1,d={seqX:0,seqY:0,seqZ:0},d.seqX+=-1*b.offsetLeft,d.seqY+=-1*b.offsetTop,B.stepProperties[c].canvasTransform=d},move:function(a,b){if(B.options.animateCanvas===!0){var c,d=0;return b===!0&&B.firstRun===!1&&(d=B.options.animateCanvasDuration),B.isFallbackMode===!1&&(c=B.stepProperties[a].canvasTransform,B.$canvas.style[y.prefixed("transitionDuration")]=d+"ms",B.$canvas.style[y.prefixed("transform")]="translateX("+c.seqX+"px) translateY("+c.seqY+"px) translateZ("+c.seqZ+"px) "),!0}return!1},removeNoJsClass:function(){if(B.isFallbackMode!==!0)for(var a=0;a<B.$steps.length;a++){var b=B.$steps[a];if(m(b,"seq-in")===!0){var c=a+1;B.animation.resetInheritedSpeed(c),o(b,"seq-in")}}}},B.animation={getPhaseProperties:function(a){var b,c,d,e,f=B.$steps[a-1],g=f.querySelectorAll("*[data-seq]"),h=f.querySelectorAll("*"),j=h.length,k=[],m=[],n=[],o=[],p=[],q=[];for(c=0;j>c;c++)b=h[c],d=l(i(b,y.prefixed("transitionDuration"))),e=l(i(b,y.prefixed("transitionDelay"))),o.push(d),p.push(e),q.push(d+e),null!==b.getAttribute("data-seq")&&(k.push(d),m.push(e),n.push(d+e));var r=Math.max.apply(Math,o),s=Math.max.apply(Math,p),t=Math.max.apply(Math,q),u=Math.max.apply(Math,k),v=Math.max.apply(Math,m),w=Math.max.apply(Math,n);return{stepId:a,stepElement:f,children:h,animatedChildren:g,watchedTimings:{maxDuration:u,maxDelay:v,maxTotal:w},timings:{maxDuration:r,maxDelay:s,maxTotal:t}}},getPhaseThreshold:function(a,b,c,d){var e=0;return c===!0&&B.options.ignorePhaseThresholdWhenSkipped===!0&&(a=!0),void 0===a&&(b===!0?e=d:b!==!1&&(e=b)),e},getReversePhaseDelay:function(a,b,c,d,e){var f=0,g=0,h=0;return c===!0||d!==!1&&e!==!1||(f=a-b,f>0?h=f:0>f&&(g=Math.abs(f))),{next:h,current:g}},moveActiveStepToTop:function(a,b){if(B.options.moveActiveStepToTop===!0){var c=B.$steps[B.prevStepId-1],d=B.noOfSteps-1;c.style.zIndex=1,a.style.zIndex=d,b.style.zIndex=B.noOfSteps}return null},manageNavigationSkip:function(a,b){if(B.isFallbackMode!==!0){var c,d,e,f,g;if(B.ui.show(b,0),B.options.navigationSkip===!0){if(B.navigationSkipThresholdActive=!0,0!==B.phasesAnimating&&(clearTimeout(B.phaseThresholdTimer),clearTimeout(B.nextPhaseStartedTimer),B.options.fadeStepWhenSkipped===!0))for(c=1;c<=B.noOfSteps;c++)d=B.stepProperties[c],d.isActive===!0&&c!==a&&(e=B.$steps[c-1],f=c,g={},g.id=f,g.element=e,B.phasesSkipped.push(g),B.animation.stepSkipped(e));B.navigationSkipThresholdTimer=setTimeout(function(){B.navigationSkipThresholdActive=!1},B.options.navigationSkipThreshold)}}},stepSkipped:function(a){B.ui.hide(a,B.options.fadeStepTime,function(){})},changeStep:function(a){var b="seq-step"+a;if(void 0!==B.currentStepId){var c="seq-step"+B.currentStepId;n(B.$container,b),o(B.$container,c)}else n(B.$container,b)},reverseProperties:function(a,b,c,d,e){var f,g,h,j,k,m,n,o=this,p=a.children,q=p.length,r=a.timings,s="",t="",u=[],v=[];for(g=0;q>g;g++)f=p[g],h=l(i(f,y.prefixed("transitionDuration"))),j=l(i(f,y.prefixed("transitionDelay"))),k=h+j,j=r.maxTotal-k,d!==!0&&(j+=b),k=h+j,u.push(k),null!==f.getAttribute("data-seq")&&v.push(k),e.reverseTimingFunctionWhenNavigatingBackwards===!0&&(s=i(f,y.prefixed("transitionTimingFunction")),t=o.reverseTimingFunction(s)),f.style[y.prefixed("transition")]=h+"ms "+j+"ms "+t;return m=Math.max.apply(Math,u),n=Math.max.apply(Math,v),setTimeout(function(){o.domDelay(function(){for(g=0;q>g;g++)f=p[g],f.style[y.prefixed("transition")]=""})},m+c),n},forward:function(a,b,c,d,e){var f,g,h,i=this;B.firstRun===!1&&i.currentPhaseStarted(B.currentStepId),o(c,"seq-out"),i.domDelay(function(){f=i.startAnimateOut(B.currentStepId,b,1),g=f.watchedTimings.maxTotal,h=i.getPhaseThreshold(d,B.options.phaseThreshold,B.isAnimating,g),B.isAnimating=!0,i.startAnimateIn(a,g,c,h,e)})},reverse:function(a,b,c,d,e){var f,g,h,i,j,k=this,l=0;n(c,"seq-out"),k.domDelay(function(){g=k.getPhaseProperties(B.currentStepId,"current"),h=k.getPhaseProperties(a,"next"),l=k.getPhaseThreshold(d,B.options.phaseThreshold,B.isAnimating,g.timings.maxTotal),f=k.getReversePhaseDelay(g.timings.maxTotal,h.timings.maxTotal,B.options.phaseThreshold,B.options.ignorePhaseThresholdWhenSkipped,B.isAnimating),i=k.reverseProperties(g,f.current,0,d,B.options),j=k.reverseProperties(h,f.next,l,d,B.options),k.startAnimateOut(B.currentStepId,b,-1,i),B.isAnimating=!0,B.firstRun===!1&&k.currentPhaseStarted(B.currentStepId),k.startAnimateIn(a,i,c,l,e,j)})},startAnimateIn:function(a,b,c,d,e,f){var g,h,i=this;B.prevStepId=B.currentStepId,B.currentStepId=a,B.firstRun===!0&&B.pagination.update(),B.firstRun===!1||B.options.startingStepAnimatesIn===!0?(B.stepProperties[a].isActive=!0,B.nextPhaseStartedTimer=setTimeout(function(){i.nextPhaseStarted(a,e)},d),B.phaseThresholdTimer=setTimeout(function(){n(c,"seq-in"),o(c,"seq-out"),void 0===f&&(g=B.animation.getPhaseProperties(a,"next"),f=g.watchedTimings.maxTotal),i.phaseEnded(a,"next",f,i.nextPhaseEnded),h=i.getStepDuration(b,f,B.options.phaseThreshold),B.stepEndedTimer=setTimeout(function(){B.animation.stepEnded(a)},h)},d)):(i.resetInheritedSpeed(a),B.phasesAnimating=0,B.isAnimating=!1,B.options.autoPlay===!0&&B.autoPlay.start(!0),n(c,"seq-in"),o(c,"seq-out")),B.firstRun=!1},startAnimateOut:function(a,b,c,d){var e,f=this;return 1===c?(o(b,"seq-in"),n(b,"seq-out"),e=f.getPhaseProperties(a,"current"),d=e.watchedTimings.maxTotal):o(b,"seq-in"),B.firstRun===!1&&(B.stepProperties[a].isActive=!0,f.phaseEnded(a,"current",d,f.currentPhaseEnded)),e},getStepDuration:function(a,b,c){var d;switch(c){case!0:d=b;break;case!1:d=a>=b?a:b;break;default:d=a>=b+c?a-c:b}return d},currentPhaseStarted:function(a){B.phasesAnimating++,B.currentPhaseStarted(a,B)},currentPhaseEnded:function(a){B.currentPhaseEnded(a,B)},nextPhaseStarted:function(a,b){B.phasesAnimating++,void 0===b&&B.hashTags.update(),B.pagination.update(),B.nextPhaseStarted(a,B)},nextPhaseEnded:function(a){B.nextPhaseEnded(a,B)},phaseEnded:function(a,b,c,d){var e;e=function(a){B.stepProperties[a].isActive=!1,B.phasesAnimating--,d(a)},"current"===b?B.currentPhaseEndedTimer=setTimeout(function(){e(a)},c):B.nextPhaseEndedTimer=setTimeout(function(){e(a)},c)},stepEnded:function(a){B.isAnimating=!1,B.isAutoPlaying=!1,B.options.autoPlay===!0&&B.autoPlay.start(!0,!0),B.animationEnded(a,B)},reversePhase:function(a){var b={"seq-out":"seq-in","seq-in":"seq-out"};return b[a]},domDelay:function(a){setTimeout(function(){a()},v)},reverseTimingFunction:function(a){if(""===a||void 0===a)return a;var b,c,d,e,f={linear:"cubic-bezier(0.0,0.0,1.0,1.0)",ease:"cubic-bezier(0.25, 0.1, 0.25, 1.0)","ease-in":"cubic-bezier(0.42, 0.0, 1.0, 1.0)","ease-in-out":"cubic-bezier(0.42, 0.0, 0.58, 1.0)","ease-out":"cubic-bezier(0.0, 0.0, 0.58, 1.0)"};for(a.indexOf("cubic-bezier")<0&&(a=a.split(",")[0],a=f[a]),b=a.replace("cubic-bezier(","").replace(")","").split(","),c=b.length,e=0;c>e;e++)b[e]=parseFloat(b[e]);return d=[1-b[2],1-b[3],1-b[0],1-b[1]],a="cubic-bezier("+d+")"},resetInheritedSpeed:function(a){if(B.isFallbackMode!==!0){var b,c,d=B.$steps[a-1].querySelectorAll("*"),e=d.length;for(c=0;e>c;c++)b=d[c],b.style[y.prefixed("transition")]="0ms 0ms";B.animation.domDelay(function(){for(c=0;e>c;c++)b=d[c],b.style[y.prefixed("transition")]=""})}},getDirection:function(a,b,c,d,e,f,g){var h=1;return h=void 0!==b?b:f===!0||e===!0?g===!0&&1===a&&c===d?1:c>a?-1:1:1},requiresFallbackMode:function(a){var b=a.transitions,c=!1;return b===!1&&(c=!0),c},getPropertySupport:function(){var a=!1,b=!1;return y.csstransitions===!0&&(a=!0),y.cssanimations===!0&&(b=!0),{transitions:a,animations:b}}},B.animationFallback={animate:function(a,b,c,d,e,f,g){if(a!==!1){var h=(new Date).getTime(),i=setInterval(function(){var j=Math.min(1,((new Date).getTime()-h)/f);a.style[b]=d+j*(e-d)+c,1===j&&(void 0!==g&&g(),clearInterval(i))},25);a.style[b]=d+c}},setupCanvas:function(){var a,b,c;if(B.isFallbackMode===!0)for(n(B.$container,"seq-fallback"),void 0!==B.$screen&&(B.$screen.style.overflow="hidden",B.$screen.style.width="100%",B.$screen.style.height="100%"),B.$canvas.style.width="100%",B.$canvas.style.height="100%",this.canvasWidth=B.$canvas.offsetWidth,a=0;a<B.noOfSteps;a++)b=B.$steps[a],c=a+1,n(b,"seq-in"),b.style.width="100%",b.style.height="100%",b.style.position="absolute",b.style.whiteSpace="normal",b.style.left="100%"},moveCanvas:function(a,b,c,d){if(d===!0){var e=0,f=-100,g=100,h=0;-1===c&&(f=100,g=-100),this.animate(b,"left","%",e,f,B.options.fallback.speed),this.animate(a,"left","%",g,h,B.options.fallback.speed)}else b.style.left="-100%",a.style.left="0"},goTo:function(a,b,c,d,e,f,g){B.prevStepId=B.currentStepId,B.currentStepId=a,void 0===g&&B.hashTags.update(),B.pagination.update(),B.firstRun===!1?(this.moveCanvas(e,c,f,!0),B.isAnimating=!0,B.animationStarted(B.currentStepId,B),B.stepEndedTimer=setTimeout(function(){B.animation.stepEnded(B.currentStepId)},B.options.fallback.speed)):(this.moveCanvas(e,c,f,!1),B.firstRun=!1,B.options.autoPlay===!0&&B.autoPlay.start(!0))}},B.pagination={getLinks:function(a){var b,c,d=a.childNodes,e=d.length,f=[];for(c=0;e>c;c++)b=d[c],1===b.nodeType&&f.push(b);return f},update:function(){if(void 0!==B.$pagination.elements){var a,b,c,d,e=B.currentStepId-1,f=B.$pagination.elements.length;if(void 0!==B.$pagination.currentLinks)for(d=B.$pagination.currentLinks.length,a=0;d>a;a++)c=B.$pagination.currentLinks[a],o(c,"seq-current");for(B.$pagination.currentLinks=[],b=0;f>b;b++)c=B.$pagination.links[b][e],B.$pagination.currentLinks.push(c),n(c,"seq-current")}return B.$pagination.currentLinks}},B.hashTags={init:function(a){if(B.options.hashTags===!0){var b,c;B.hasPushstate=!(!window.history||!history.pushState),c=location.hash.replace("#!",""),B.stepHashTags=this.getStepHashTags(),""!==c&&(B.currentHashTag=c,b=this.hasCorrespondingStep(B.currentHashTag),b>-1&&(a=b+1))}return a},hasCorrespondingStep:function(a){var b=-1,c=B.stepHashTags.indexOf(a);return c>-1&&(b=c),b},getStepHashTags:function(){var a,b,c=[];for(a=0;a<B.noOfSteps;a++)b=B.options.hashDataAttribute===!1?B.$steps[a].id:B.$steps[a].getAttribute("data-seq-hashtag"),c.push(b);return c},update:function(){if(B.options.hashTags===!0&&B.firstRun===!1||B.options.hashTags===!0&&B.firstRun===!0&&B.options.hashChangesOnFirstStep===!0){var a=B.currentStepId-1;B.currentHashTag=B.stepHashTags[a],""!==B.currentHashtag&&(B.hasPushstate===!0?history.pushState(null,null,"#!"+B.currentHashTag):location.hash="#!"+B.currentHashTag)}},setupEvent:function(){if("onhashchange"in window){if(window.addEventListener)return window.addHashChange=function(a,b){window.addEventListener("hashchange",a,b)},void(window.removeHashChange=function(a){window.removeEventListener("hashchange",a)});if(window.attachEvent)return window.addHashChange=function(a){window.attachEvent("onhashchange",a)},void(window.removeHashChange=function(a){window.detachEvent("onhashchange",a)})}var a=[],b=location.href;window.addHashChange=function(b,c){"function"==typeof b&&a[c?"unshift":"push"](b)},window.removeHashChange=function(b){for(var c=a.length-1;c>=0;c--)a[c]===b&&a.splice(c,1)},setInterval(function(){var c=location.href;if(b!==c){var d=b;b=c;for(var e=0;e<a.length;e++)a[e].call(window,{type:"hashchange",newURL:c,oldURL:d})}},100)}},B.preload={defaultHtml:'<svg width="39" height="16" viewBox="0 0 39 16" xmlns="http://www.w3.org/2000/svg" class="seq-preload-indicator"><title>Sequence.js Preloading Indicator</title><desc>Three orange dots increasing in size from left to right</desc><g fill="#F96D38"><path class="seq-preload-circle seq-preload-circle-1" d="M3.999 12.012c2.209 0 3.999-1.791 3.999-3.999s-1.79-3.999-3.999-3.999-3.999 1.791-3.999 3.999 1.79 3.999 3.999 3.999z"/><path class="seq-preload-circle seq-preload-circle-2" d="M15.996 13.468c3.018 0 5.465-2.447 5.465-5.466 0-3.018-2.447-5.465-5.465-5.465-3.019 0-5.466 2.447-5.466 5.465 0 3.019 2.447 5.466 5.466 5.466z"/><path class="seq-preload-circle seq-preload-circle-3" d="M31.322 15.334c4.049 0 7.332-3.282 7.332-7.332 0-4.049-3.282-7.332-7.332-7.332s-7.332 3.283-7.332 7.332c0 4.05 3.283 7.332 7.332 7.332z"/></g></svg>',fallbackHtml:'<div class="seq-preload-indicator seq-preload-indicator-fallback"><div class="seq-preload-circle seq-preload-circle-1"></div><div class="seq-preload-circle seq-preload-circle-2"></div><div class="seq-preload-circle seq-preload-circle-3"></div></div>',defaultStyles:"@"+x.animation[y.prefixed("animation")]+"keyframes seq-preloader {50% {opacity: 1;}100% {opacity: 0;}}.seq-preloader {background: white;visibility: visible;opacity: 1;position: absolute;z-index: 9999;height: 100%;width: 100%;top: 0;left: 0;right: 0;bottom: 0;} .seq-preloader.seq-preloaded {opacity: 0;visibility: hidden;"+y.prefixed("transition")+": visibility 0s .5s, opacity .5s;}.seq-preload-indicator {overflow: visible;position: relative;top: 50%;left: 50%;-webkit-transform: translate(-50%, -50%);transform: translate(-50%, -50%);}.seq-preload-circle {display: inline-block;height: 12px;width: 12px;fill: #F96D38;opacity: 0;"+x.animation[y.prefixed("animation")]+"animation: seq-preloader 1.25s infinite;}.seq-preload-circle-2 {"+x.animation[y.prefixed("animation")]+"animation-delay: .15s;}.seq-preload-circle-3 {"+x.animation[y.prefixed("animation")]+"animation-delay: .3s;}.seq-preload-indicator-fallback{width: 42px;margin-left: -21px;overflow: visible;}.seq-preload-indicator-fallback .seq-preload-circle {width: 8px; height:8px;background-color: #F96D38;border-radius: 100%; opacity: 1;display: inline-block; vertical-align: middle;}.seq-preload-indicator-fallback .seq-preload-circle-2{margin-left: 3px; margin-right: 3px; width: 12px; height: 12px;}.seq-preload-indicator-fallback .seq-preload-circle-3{width: 16px; height: 16px;}",init:function(b){if(B.options.preloader!==!1){var c,d,e,f,g,h,i=this;return n(B.$container,"seq-preloading"),B.$preloader=B.ui.getElements("preloader",B.options.preloader),i.append(),i.addStyles(),i.toggleStepsVisibility("hide"),c=i.getImagesToPreload(B.options.preloadTheseSteps),d=i.getImagesToPreload(B.options.preloadTheseImages,!0),e=c.concat(d),f=a(e),f.on("always",function(){i.complete(b)}),g=1,f.on("progress",function(a,b){h=b.isLoaded?"loaded":"broken",B.preloadProgress(h,b.img.src,g++,e.length,B)}),!0}return!1},complete:function(a){B.preloaded(B),B.options.pausePreloader!==!0&&(this.toggleStepsVisibility("show"),o(B.$container,"seq-preloading"),n(B.$container,"seq-preloaded"),n(B.$preloader[0],"seq-preloaded"),void 0!==this.preloadIndicatorTimer&&clearInterval(this.preloadIndicatorTimer),(y.prefixed("animation")===!1||y.svg===!1)&&(B.$preloader[0].style.display="none"),void 0!==a&&a())},addStyles:function(){if(B.options.preloader===!0){var a=document.head||document.getElementsByTagName("head")[0];if(this.styleElement=document.createElement("style"),this.styleElement.type="text/css",this.styleElement.styleSheet?this.styleElement.styleSheet.cssText=this.defaultStyles:this.styleElement.appendChild(document.createTextNode(this.defaultStyles)),a.appendChild(this.styleElement),y.prefixed("animation")===!1||y.svg===!1){var b=B.$preloader[0].firstChild,c=function(){b.style.visibility="hidden",preloadFlashTime=1e3,setTimeout(function(){b.style.visibility="visible"},500)};c(),this.preloadIndicatorTimer=setInterval(function(){c()},1e3)}return!0}return!1},removeStyles:function(){this.styleElement.parentNode.removeChild(this.styleElement)},getImagesToPreload:function(a,b){var c=[];if(g(a)===!0){var d,e,f,h,i,j,k,l,m=a.length;if(b!==!0)for(d=0;m>d;d++)for(f=B.$steps[d],h=f.getElementsByTagName("img"),i=h.length,e=0;i>e;e++)j=h[e],c.push(j);else for(k=[],d=0;m>d;d++)l=a[d],k[d]=new Image,k[d].src=l,c.push(k[d])}return c},append:function(){return B.options.preloader===!0?(B.$preloader=document.createElement("div"),B.$preloader.className="seq-preloader",B.$preloader=[B.$preloader],B.$preloader[0].innerHTML=y.prefixed("animation")!==!1&&y.svg===!0?B.preload.defaultHtml:B.preload.fallbackHtml,B.$container.insertBefore(B.$preloader[0],null),!0):!1},toggleStepsVisibility:function(a){if(B.options.hideStepsUntilPreloaded===!0){var b,c;for(b=0;b<B.noOfSteps;b++)c=B.$steps[b],"hide"===a?B.ui.hide(c,0):B.ui.show(c,0);return!0}return!1}},B.manageEvents={list:{load:[],click:[],touchstart:[],mousemove:[],mouseleave:[],hammer:[],keyup:[],hashchange:[],resize:[]},init:function(){return B.manageEvents.list[A]=[],B.options.hashTags===!0&&this.add.hashChange(),B.options.swipeNavigation===!0?this.add.swipeNavigation():B.hammerTime=!1,B.options.keyNavigation===!0&&this.add.keyNavigation(),this.add.resizeThrottle(),this.add.pageVisibility(),B.options.nextButton!==!1&&(B.$next=B.ui.getElements("nextButton",B.options.nextButton),this.add.button(B.$next,"nav",B.next)),B.options.prevButton!==!1&&(B.$prev=B.ui.getElements("prevButton",B.options.prevButton),this.add.button(B.$prev,"nav",B.prev)),B.options.autoPlayButton!==!1&&(B.$autoPlay=B.ui.getElements("autoPlayButton",B.options.autoPlayButton),this.add.button(B.$autoPlay,"nav",B.toggleAutoPlay)),this.add.stopOnHover(),B.options.pagination!==!1&&(B.$pagination={},B.$pagination.relatedElementId=d,B.$pagination.links=[],B.$pagination.elements=B.ui.getElements("pagination",B.options.pagination),this.add.button(B.$pagination.elements,"pagination")),null},removeAll:function(a){var b,c;for(b in a)a.hasOwnProperty(b)===!0&&(c=a[b],this.remove(b));return null},remove:function(a){var b=B.manageEvents.list[a],c=b.length;switch(a){case"hashchange":B.options.hashTags===!0&&removeHashChange(b[0].handler);break;case"hammer":if(B.manageEvents.list.hammer.length>0&&void 0!==document.querySelectorAll){var d=B.manageEvents.list.hammer[0].handler;B.hammerTime.off("swipe",[d])}break;default:for(var e=0;c>e;e++){var f=b[e];k(f.element,a,f.handler)}}},add:{hashChange:function(){B.hashTags.setupEvent();var a=function(a){var b,c;b=a.newURL||location.href,b=b.split("#!")[1],B.currentHashTag!==b&&(c=B.stepHashTags.indexOf(b)+1,B.currentHashTag=b,B.goTo(c,void 0,void 0,!0))};return addHashChange(a),B.manageEvents.list.hashchange.push({element:window,handler:a}),B.manageEvents.list.hashchange},button:function(a,b,c){var d,e,f,g,h,i,k,l=a.length;switch(b){case"nav":f=function(a){d=j(a,"click",function(a){a||(a=window.event),a.preventDefault?a.preventDefault():a.returnValue=!1,c()})};break;case"pagination":f=function(a,b){d=j(a,"click",function(a){a||(a=window.event),a.preventDefault?a.preventDefault():a.returnValue=!1;var b=a.target||a.srcElement;g=this,i=q(g,b),B.goTo(i)}),B.$pagination.links.push(B.pagination.getLinks(a,b))}}for(k=0;l>k;k++)e=a[k],h=e.getAttribute("rel"),h===B.$container.id&&null===e.getAttribute("data-seq-button")?(e.setAttribute("data-seq-button",!0),f(e,h)):null===h&&null===e.getAttribute("data-seq-button")&&f(e,h),B.manageEvents.list.click.push({element:e,handler:d});return B.manageEvents.list.click},stopOnHover:function(){var a,b;return B.isMouseOver=!1,a=j(B.$container,"touchstart",function(){B.isTouched=!0}),B.manageEvents.list.touchstart.push({element:B.$container,handler:a}),b=j(B.$container,"mousemove",function(a){return a=a||window.event,B.isTouched===!0?void(B.isTouched=!1):void(p(B.$container,a)===!0?(B.options.autoPlayPauseOnHover===!0&&B.isMouseOver===!1&&B.autoPlay.pause(),B.isMouseOver=!0):(B.options.autoPlayPauseOnHover===!0&&B.isMouseOver===!0&&B.autoPlay.unpause(),B.isMouseOver=!1))}),B.manageEvents.list.mousemove.push({element:B.$container,handler:b}),b=j(B.$container,"mouseleave",function(){B.options.autoPlayPauseOnHover===!0&&B.autoPlay.unpause(),B.isMouseOver=!1}),B.manageEvents.list.mouseleave.push({element:B.$container,handler:b}),null},swipeNavigation:function(){if(void 0===window.addEventListener)return void(B.hammerTime=!1);var a,c;"function"==typeof b&&(c=function(a){switch(a.direction){case 2:B.options.swipeEvents.left(B);break;case 4:B.options.swipeEvents.right(B);break;case 8:B.options.swipeEvents.up(B);break;case 16:B.options.swipeEvents.down(B)}},B.hammerTime=new b(B.$container).on("swipe",c),B.hammerTime.get("swipe").set(B.options.swipeHammerOptions),a=r(B.options.swipeEvents),B.hammerTime.get("swipe").set({direction:a}),B.manageEvents.list.hammer.push({element:B.$container,handler:c}))},keyNavigation:function(){var a=j(document,"keyup",function(a){a||(a=window.event);var b=parseInt(String.fromCharCode(a.keyCode));switch(b>0&&b<=B.noOfSteps&&B.options.numericKeysGoToSteps&&B.goTo(b),a.keyCode){case 37:B.options.keyEvents.left(B);break;case 39:B.options.keyEvents.right(B)}});B.manageEvents.list.keyup.push({element:document,handler:a})},resizeThrottle:function(){function a(){setTimeout(function(){B.canvas.getTransformProperties(),B.propertySupport.transitions===!0&&B.canvas.move(B.currentStepId,!1)},500),B.throttledResize(B)}var b,c;c=j(window,"resize",function(){clearTimeout(b),b=setTimeout(a,w)}),B.manageEvents.list.resize.push({element:window,handler:c})},pageVisibility:function(){var a=j(document,A,function(){document[z]?B.autoPlay.pause():B.autoPlay.unpause()},!1);B.manageEvents.list[A].push({element:document,handler:a})}}},B.init=function(b){var c,d,e,g;B.options=h(u,f),B.isAnimating=!1,B.isReady=!1,B.$container=b,B.$screen=B.$container.querySelectorAll(".seq-screen")[0],B.$canvas=B.$container.querySelectorAll(".seq-canvas")[0],B.$steps=B.canvas.getSteps(B.$canvas),B.noOfSteps=B.$steps.length,B.phasesAnimating=0,B.phasesSkipped=[],s(B.$container,y),c=B.options.startingStepId,n(B.$container,"seq-active"),B.propertySupport=B.animation.getPropertySupport(),B.isFallbackMode=B.animation.requiresFallbackMode(B.propertySupport),B.canvas.init(c),B.canvas.removeNoJsClass(B),B.manageEvents.init(),B.autoPlay.init(),B.firstRun=!0,c=B.hashTags.init(c),1===B.options.autoPlayDirection?(e=c-1,B.prevStepId=1>e?B.noOfSteps:e):(e=c+1,B.prevStepId=e>B.noOfSteps?1:e),B.currentStepId=B.prevStepId,d=B.prevStepId,B.animationFallback.setupCanvas(c),g=function(){B.animation.domDelay(function(){B.animation.domDelay(function(){B.animation.resetInheritedSpeed(d)}),B.isReady=!0,B.ready(B),B.goTo(c,B.options.autoPlayDirection,!0)})},B.options.preloader!==!1&&void 0!==document.querySelectorAll&&"function"==typeof a?B.preload.init(function(){g()}):g()},B.destroy=function(){var a,b,c;for(B.autoPlay.stop(),clearTimeout(B.autoPlayTimer),clearTimeout(B.phaseThresholdTimer),clearTimeout(B.stepEndedTimer),clearTimeout(B.currentPhaseEndedTimer),clearTimeout(B.nextPhaseStartedTimer),clearTimeout(B.nextPhaseEndedTimer),clearTimeout(B.fadeStepTimer),clearTimeout(B.hideTimer),clearTimeout(B.navigationSkipThresholdTimer),B.manageEvents.removeAll(B.manageEvents.list),o(B.$pagination.currentLinks,"seq-current"),o(B.$container,"seq-step"+B.currentStepId),o(B.$container,"seq-active"),B.$container.removeAttribute("style"),void 0!==B.$screen&&B.$screen.removeAttribute("style"),B.$canvas.removeAttribute("style"),a=0;a<B.noOfSteps;a++)b=B.$steps[a],b.removeAttribute("style"),B.animation.resetInheritedSpeed(a+1),o(b,"seq-in"),o(b,"seq-out");return c=B.$steps[B.options.startingStepId-1],B.animation.resetInheritedSpeed(B.options.startingStepId),n(c,"seq-in"),e.removeAttribute("data-seq-enabled"),B.destroyed(B),B=null},B.next=function(){var a=B.currentStepId+1;return a>B.noOfSteps&&B.options.cycle===!1?!1:(a>B.noOfSteps&&(a=1),B.goTo(a),a)},B.prev=function(){var a,b=B.currentStepId-1;return 1>b&&B.options.cycle===!1?!1:(1>b&&(b=B.noOfSteps),B.options.reverseWhenNavigatingBackwards===!0&&(a=-1),B.goTo(b,a),b)
},B.toggleAutoPlay=function(a){return B.isAutoPlaying===!1?B.start(a):B.stop(),B.isAutoPlaying},B.stop=function(){B.autoPlay.stop()},B.start=function(a){B.autoPlay.start(a)},B.goTo=function(a,b,c,d){if(b=B.animation.getDirection(a,b,B.currentStepId,B.noOfSteps,B.isFallbackMode,B.options.reverseWhenNavigatingBackwards,B.options.cycle),void 0===a||1>a||a>B.noOfSteps||a===B.currentStepId||B.options.navigationSkip===!1&&B.isAnimating===!0||B.options.navigationSkip===!0&&B.navigationSkipThresholdActive===!0&&void 0===d||B.isFallbackMode===!0&&B.isAnimating===!0&&void 0===d||B.options.preventReverseSkipping===!0&&B.direction!==b&&B.isAnimating===!0)return!1;var e,f;return clearTimeout(B.autoPlayTimer),B.direction=b,1===b?o(B.$container,"seq-reversed"):n(B.$container,"seq-reversed"),e=B.$steps[B.currentStepId-1],f=B.$steps[a-1],B.animation.moveActiveStepToTop(e,f),B.animation.changeStep(a),B.isFallbackMode===!1?(B.animation.resetInheritedSpeed(a),(B.firstRun===!1||B.firstRun===!0&&B.options.startingStepAnimatesIn===!0)&&B.animationStarted(a,B),B.canvas.move(a,!0),B.animation.manageNavigationSkip(a,f),1===b?B.animation.forward(a,e,f,c,d):B.animation.reverse(a,e,f,c,d)):B.animationFallback.goTo(a,B.currentStepId,e,a,f,b,d),!0},B.started=function(){},B.stopped=function(){},B.animationStarted=function(){},B.animationEnded=function(){},B.currentPhaseStarted=function(){},B.currentPhaseEnded=function(){},B.nextPhaseStarted=function(){},B.nextPhaseEnded=function(){},B.throttledResize=function(){},B.preloaded=function(){},B.preloadProgress=function(){},B.ready=function(){},B.destroyed=function(){},B.utils={addClass:n,removeClass:o,addEvent:j,removeEvent:k},B.init(e),c.push(B),B};return e}if("function"==typeof define&&define.amd)define(["imagesLoaded","Hammer"],defineSequence);else{Hammer="function"!=typeof Hammer?null:Hammer,imagesLoaded="function"!=typeof imagesLoaded?null:imagesLoaded;var sequence=defineSequence(imagesLoaded,Hammer)}