
var cityList = [
    { key: 'A', data: ['安丘市', '安乡县', '安仁县', '安化县', '安吉县', '安国市', '安图县', '安多县', '安宁市', '安平县', '安庆市', '安康市', '安新县', '安泽县', '安溪县', '安福县', '安远县', '安阳市', '安陆市', '安顺市', '安龙县', '澳门', '阿克苏地区', '阿克陶县', '阿勒泰地区', '阿合奇县', '阿坝藏族羌族自治州', '阿尔山市', '阿拉善盟', '阿拉尔市', '阿瓦提县', '阿里地区', '鞍山市'] },
    { key: 'B', data: ['亳州市', '保亭黎族苗族自治县', '保定市', '保山市', '保康县', '保德县', '保靖县', '八宿县', '包头市', '北京市', '北屯市', '北川羌族自治县', '北戴河区', '北流市', '北海市', '博乐市', '博兴县', '博尔塔拉蒙古自治州', '博湖县', '博爱县', '博野县', '博鳌', '宝丰县', '宝兴县', '宝应县', '宝鸡市', '宾川县', '巴东县', '巴中市', '巴彦淖尔市', '巴楚县', '巴里坤哈萨克自治县', '巴音郭楞蒙古自治州', '巴马瑶族自治县', '布尔津县', '拜城县', '本溪市', '柏乡县', '毕节市', '泊头市', '泌阳县', '波密县', '滨州市', '滨海县', '璧山县', '白城市', '白山市', '白沙黎族自治县', '白沟镇', '白洋淀', '白银市', '百色市', '蚌埠市', '霸州市'] },
    { key: 'C', data: ['呈贡区', '城口县', '城步苗族自治县', '崇义县', '崇左市', '崇礼县', '巢湖市', '常宁市', '常山县', '常州市', '常德市', '常熟市', '慈利县', '慈溪市', '成安县', '成武县', '成都市', '承德县', '承德市', '昌乐县', '昌吉回族自治州', '昌江黎族自治县', '昌邑市', '昌都地区', '昌黎县', '曹县', '曹妃甸区', '查济', '楚雄彝族自治州', '池州市', '沧州市', '滁州市', '潮州市', '澄江县', '澄海区', '澄迈县', '磁县', '苍南县', '苍山县', '茌平县', '茶陵县', '赤城县', '赤壁市', '赤峰市', '赤水市', '辰溪县', '郴州市', '重庆市', '长乐市', '长兴县', '长兴岛', '长垣县', '长寿区', '长岛县', '长春市', '长汀县', '长沙县', '长沙市', '长治县', '长治市', '长泰县', '长白山', '长白山池北', '长白山池南', '长白山池西', '长葛市', '长阳土家族自治县', '长顺县'] },
    { key: 'D', data: ['东光县', '东兴市', '东台市', '东宁县', '东安县', '东山县', '东川区', '东平县', '东方市', '东明县', '东海县', '东港区', '东莞市', '东营市', '东阳市', '东阿县', '丹东市', '丹凤县', '丹巴县', '丹江口市', '丹阳市', '代县', '儋州市', '单县', '垫江县', '大丰市', '大余县', '大兴安岭地区', '大冶市', '大厂回族自治县', '大同市', '大名县', '大城县', '大姚县', '大宁县', '大庆市', '大悟县', '大新县', '大理白族自治州', '大田县', '大石桥市', '大英县', '大足区', '大连市', '大邑县', '定兴县', '定南县', '定安县', '定州市', '定襄县', '定西市', '定边县', '定远县', '定陶县', '岱山县', '当涂县', '当阳市', '德令哈市', '德保县', '德兴市', '德化县', '德宏傣族景颇族自治州', '德州市', '德惠市', '德昌县', '德清县', '德钦县', '德阳市', '敦化市', '敦煌市', '洞口县', '洞头县', '独山县', '登封市', '砀山县', '稻城县', '达州市', '迪士尼', '迪庆藏族自治州', '迭部县', '道县', '邓州市', '郸城县', '都匀市', '都江堰市'] },
    { key: 'E', data: ['二浪河', '二连浩特市', '二龙山风景区', '峨眉山市', '恩平市', '恩施土家族苗族自治州', '鄂尔多斯市', '鄂州市', '额尔古纳市', '额济纳旗'] },
    { key: 'F', data: ['丰县', '丰城市', '丰宁坝上', '丰宁满族自治县', '丰都县', '佛山市', '凤凰县', '凤城市', '凤山县', '凤阳县', '奉化市', '奉节县', '富宁县', '富平县', '富民县', '富源县', '富蕴县', '富阳市', '封丘县', '府谷县', '扶余县', '扶沟县', '抚州市', '抚松县', '抚顺市', '方城县', '方山县', '汾西县', '汾阳市', '法库县', '浮山县', '涪陵区', '福安市', '福州市', '福泉市', '福海县', '福清市', '福鼎市', '繁峙县', '繁昌县', '肥乡县', '肥城市', '范县', '费县', '阜南县', '阜城县', '阜宁县', '阜平县', '阜康市', '阜新市', '阜阳市', '防城港市'] },
    { key: 'G', data: ['个旧市', '光山县', '光泽县', '公主岭市', '公安县', '共和县', '冠县', '古丈县', '古交市', '古县', '古田县', '固原市', '固始县', '固安县', '固镇县', '巩义市', '广元市', '广南县', '广安市', '广宗县', '广州市', '广平县', '广德县', '广水市', '广汉市', '广饶县', '恭城瑶族自治县', '故城县', '果洛藏族自治州', '根河市', '格尔木市', '桂东县', '桂平市', '桂林市', '桂阳县', '沽源县', '灌云县', '灌南县', '瓜州县', '甘南藏族自治州', '甘孜藏族自治州', '盖州市', '藁城市', '谷城县', '贵德县', '贵港市', '贵溪市', '贵阳市', '赣县', '赣州市', '赣榆县', '馆陶县', '高唐县', '高安市', '高密市', '高州市', '高平市', '高淳县', '高碑店市', '高邑县', '高邮市', '高阳县', '高雄', '高青县', '鼓浪屿'] },
    { key: 'H', data: ['互助土族自治县', '会东县', '会同县', '会昌县', '会泽县', '会理县', '侯马市', '化州市', '华容县', '华山', '华阳镇', '合作市', '合川区', '合肥市', '合阳县', '含山县', '呼伦贝尔市', '呼和浩特市', '呼图壁县', '和县', '和林格尔县', '和田地区', '和硕县', '和静县', '和顺县', '和龙市', '哈密地区', '哈尔滨市', '哈巴河县', '壶关县', '宏村景区', '怀仁县', '怀化市', '怀安县', '怀来县', '怀远县', '惠安县', '惠州市', '惠民县', '惠水县', '杭州市', '杭锦后旗', '桓台县', '横山县', '横店影视城', '汉中市', '汉寿县', '汉川市', '河口瑶族自治县', '河曲县', '河池市', '河津市', '河源市', '河间市', '洪江市', '洪泽县', '洪洞县', '洪湖市', '浑源县', '海东市', '海伦市', '海兴县', '海北藏族自治州', '海南藏族自治州', '海口市', '海城市', '海宁市', '海安县', '海晏县', '海林市', '海盐县', '海螺沟', '海西蒙古族藏族自治州', '海门市', '海阳市', '淮北市', '淮南市', '淮安市', '淮阳县', '湖州市', '湟中县', '滑县', '潢川县', '珲春市', '睢县', '睢宁县', '禾木', '红原县', '红安县', '红河县', '红河哈尼族彝族自治州', '花垣县', '花莲', '获嘉县', '菏泽市', '葫芦岛市', '衡东县', '衡南县', '衡山县', '衡水市', '衡阳县', '衡阳市', '贺兰县', '贺州市', '辉南县', '辉县市', '邯郸市', '霍城县', '霍尔果斯', '霍山县', '霍州市', '韩城市', '鹤壁市', '鹤山市', '鹤岗市', '鹤峰县', '黄冈市', '黄南藏族自治州', '黄山市', '黄岩区', '黄果树风景区', '黄梅县', '黄石市', '黄骅市', '黄龙溪古镇', '黑水县', '黑河市'] },
    { key: 'J', data: ['九华山', '九台市', '九寨沟县', '九江市', '井冈山市', '井陉县', '交口县', '交城县', '京山县', '介休市', '佳县', '佳木斯市', '冀州市', '加格达奇', '即墨市', '句容市', '吉县', '吉安市', '吉木乃县', '吉木萨尔县', '吉林市', '吉首市', '嘉义', '嘉兴市', '嘉善县', '嘉峪关市', '嘉祥县', '嘉禾县', '嘉鱼县', '基隆', '姜堰市', '将乐县', '巨野县', '巨鹿县', '建始县', '建宁县', '建德市', '建水县', '建湖县', '建瓯市', '建阳市', '揭阳市', '旌德县', '晋中市', '晋城市', '晋宁县', '晋州市', '晋江市', '景县', '景宁畲族自治县', '景德镇市', '江华瑶族自治县', '江山市', '江川县', '江永县', '江油市', '江津区', '江都区', '江门市', '江阴市', '江陵县', '泾县', '津市市', '济南市', '济宁市', '济源市', '济阳县', '浚县', '焦作市', '界首市', '监利县', '稷山县', '简阳市', '绛县', '绩溪县', '缙云县', '胶南市', '胶州市', '荆州市', '荆门市', '莒南', '莒县', '蛟河市', '郏县', '鄄城县', '酒泉市', '金乡县', '金华市', '金坛市', '金堂县', '金川县', '金平区', '金平苗族瑶族傣族自治县', '金昌市', '金湖县', '金门', '锦州市', '镜泊湖', '集安市', '靖州苗族侗族自治县', '靖江市', '靖边县', '静乐县', '鸡泽县', '鸡西市'] },
    { key: 'K', data: ['克孜勒苏柯尔克孜自治州', '克拉玛依市', '凯里市', '喀什地区', '喀纳斯', '垦利县', '奎屯市', '宽城满族自治县', '岢岚县', '库尔勒市', '库车县', '康乐县', '康保县', '康定县', '康定新都桥', '开化县', '开原市', '开县', '开封市', '开平市', '开远市', '昆山市', '昆明市', '柯坪县'] },
    { key: 'L', data: ['临县', '临城县', '临夏回族自治州', '临安市', '临朐县', '临武县', '临江市', '临汾市', '临沂市', '临沧市', '临沭县', '临泉县', '临海市', '临清市', '临湘市', '临漳县', '临澧县', '临猗县', '临西县', '临邑县', '临颍县', '临高县', '丽水市', '丽江市', '乐东黎族自治县', '乐亭县', '乐山市', '乐平市', '乐清市', '乐陵市', '六安市', '六盘水市', '兰州市', '兰溪市', '冷水江市', '凉山彝族自治州', '利川市', '利津县', '卢氏县', '吕梁市', '娄底市', '岚县', '庐山风景区', '廉江市', '廊坊市', '拉萨市', '旅顺口区', '来安县', '来宾市', '林口县', '林州市', '林芝地区', '柳州市', '柳林县', '柳河县', '栾城县', '栾川县', '梁山县', '梁平县', '梁河县', '泸定县', '泸州市', '泸沽湖', '泸溪县', '泸西县', '洛南县', '洛宁县', '洛川县', '洛阳市', '浏阳市', '涞水县', '涞源县', '涟水县', '涟源市', '溧水县', '溧阳市', '滦南县', '滦县', '滦平县', '潞城市', '澧县', '灵宝市', '灵寿县', '灵武市', '灵石县', '理县', '禄丰县', '禄劝彝族苗族自治县', '离石区', '绿春县', '罗山县', '罗平县', '罗江县', '罗源县', '罗田县', '老河口市', '耒阳市', '聊城市', '荔波县', '莱州市', '莱芜市', '莱西市', '莱阳市', '蓝山县', '蠡县', '轮台县', '辽源市', '辽阳市', '连云港市', '连城县', '连江县', '郎溪县', '醴陵市', '阆中市', '陆良县', '陇南市', '陵县', '陵川县', '陵水黎族自治县', '隆化县', '隆回县', '隆尧县', '鲁山县', '鹿泉市', '鹿邑县', '黎城县', '黎平县', '龙井市', '龙南县', '龙口市', '龙山县', '龙岩市', '龙泉市', '龙泉驿区', '龙海市', '龙游县', '龙胜各族自治县', '龙虎山'] },
    { key: 'M', data: ['孟州市', '孟村回族自治县', '孟津县', '密山市', '弥勒县', '明光市', '明溪县', '木垒哈萨克自治县', '木渎风景区', '梅州市', '梅河口市', '民权县', '汨罗市', '渑池县', '满城县', '满洲里市', '漠河县', '牡丹江市', '玛纳斯县', '眉山市', '米东区', '米脂县', '绵山风景区', '绵竹市', '绵阳市', '芒市', '芒康县', '苗栗', '茂县', '茂名市', '蒙城县', '蒙自市', '蒙阴县', '闽侯县', '闽清县', '马尔康县', '马祖', '马鞍山市', '马龙县', '麦盖提县', '麻城市', '麻江县', '麻阳苗族自治县'] },
    { key: 'N', data: ['内丘县', '内乡县', '内江市', '内黄县', '农安县', '南乐县', '南京市', '南充市', '南华县', '南县', '南召县', '南和县', '南城县', '南宁市', '南安市', '南宫市', '南岳区', '南川区', '南平市', '南康市', '南戴河', '南投', '南昌市', '南浔区', '南漳县', '南皮县', '南通市', '南阳市', '南陵县', '南靖县', '宁乡县', '宁化县', '宁国市', '宁城县', '宁安市', '宁德市', '宁晋县', '宁武县', '宁波市', '宁津县', '宁海县', '宁蒗彝族自治县', '宁远县', '宁都县', '宁阳县', '宁陵县', '尼勒克县', '怒江傈僳族自治州', '楠溪江', '那曲地区'] },
    { key: 'P', data: ['偏关县', '凭祥市', '屏东', '屏南县', '屏边苗族自治县', '平乡县', '平凉市', '平利县', '平原县', '平和县', '平安县', '平山县', '平度市', '平江县', '平泉县', '平湖市', '平潭县', '平舆县', '平遥县', '平邑县', '平阳县', '平阴县', '平陆县', '平顶山市', '平顺县', '彭州市', '彭水苗族土家族自治县', '攀枝花市', '普宁市', '普格县', '普洱市', '普者黑景区', '普陀山', '沛县', '浦城县', '浦江县', '澎湖', '濮阳市', '盘县', '盘锦市', '磐安县', '磐石市', '莆田市', '萍乡市', '蒲县', '蒲城县', '蒲江县', '蓬莱市', '邳州市', '郫县', '鄱阳县'] },
    { key: 'Q', data: ['七仙岭', '七台河市', '且末县', '丘北县', '乾安县', '伽师县', '全南县', '全椒县', '千岛湖风景区', '启东市', '奇台县', '屈家岭管理区', '巧家县', '庆云县', '庆元县', '庆阳市', '曲周县', '曲沃县', '曲阜市', '曲阳县', '曲靖市', '栖霞市', '沁县', '沁源县', '沁阳市', '泉州市', '淇县', '清丰县', '清徐县', '清河县', '清流县', '清苑县', '清远市', '潜山县', '潜江市', '琼中黎族苗族自治县', '琼海市', '确山县', '祁东县', '祁县', '祁连县', '祁门县', '祁阳县', '秦皇岛市', '綦江区', '蕲春县', '衢州市', '迁安市', '迁西县', '邱县', '钦州市', '青县', '青岛市', '青州市', '青河县', '青海湖', '青田县', '青龙满族自治县', '黔东南苗族侗族自治州', '黔南布依族苗族自治州', '黔江区', '黔西南布依族苗族自治州', '齐河县', '齐齐哈尔市'] },
    { key: 'R', data: ['乳山市', '仁寿县', '仁怀市', '任丘市', '任县', '如东县', '如皋市', '容城县', '日喀则地区', '日照市', '汝南县', '汝城县', '汝州市', '汝阳县', '瑞丽市', '瑞安市', '瑞金市', '芮城县', '若尔盖县', '若羌县', '荣成市', '荣昌县', '饶阳县'] },
    { key: 'S', data: ['三亚市', '三明市', '三星堆', '三栋屋博物馆', '三沙市', '三河市', '三清山', '三门县', '三门峡市', '上杭县', '上海市', '上犹县', '上蔡县', '上虞市', '上里古镇', '上饶市', '什邡市', '十堰市', '厦门市', '双峰县', '双廊古镇', '双流县', '双牌县', '双辽市', '双鸭山市', '商丘市', '商南县', '商城县', '商水县', '商河县', '商洛市', '四平市', '室韦', '宿州市', '宿迁市', '寿光市', '寿宁县', '寿阳县', '射洪县', '射阳县', '尚义县', '尚志市', '山南地区', '山阳县', '山阴县', '嵊山枸杞景区', '嵊州市', '嵊泗县', '嵩县', '嵩明县', '师宗县', '朔州市', '松原市', '松溪县', '松滋市', '松潘县', '松阳县', '桑植县', '水富县', '汕头市', '汕尾市', '沈丘县', '沈阳市', '沙县', '沙市区', '沙河市', '沙洋县', '沙湾县', '沙雅县', '沭阳县', '泗县', '泗水县', '泗洪县', '泗阳县', '涉县', '深圳市', '深州市', '深泽县', '疏勒县', '疏附县', '石台县', '石嘴山市', '石城县', '石家庄市', '石屏县', '石林彝族自治县', '石柱土家族自治县', '石楼县', '石河子市', '石狮市', '石门县', '石首市', '社旗县', '神农架', '神木县', '神池县', '绍兴市', '绥中县', '绥化市', '绥宁县', '绥德县', '绥滨县', '绥芬河市', '肃宁县', '舒城县', '苏州市', '莎车县', '莘县', '蜀南竹海', '遂宁市', '遂平县', '遂昌县', '邵东县', '邵武市', '邵阳县', '邵阳市', '鄯善县', '陕县', '随州市', '韶关市', '韶山市', '顺平县', '顺德区', '顺昌县'] },
    { key: 'T', data: ['台东', '台中', '台前县', '台北', '台南', '台山市', '台州市', '同里', '吐鲁番地区', '唐县', '唐山市', '唐河县', '团风县', '图们市', '图木舒克市', '塔什库尔干塔吉克自治县', '塔城地区', '天全县', '天台县', '天堂寨镇', '天柱山景区', '天水市', '天津市', '天长市', '天门市', '太仓市', '太原市', '太和县', '太康县', '太谷县', '屯昌县', '屯留县', '托克逊县', '桃园', '桃江县', '桃源县', '桃花岛', '桐乡市', '桐城市', '桐庐县', '桐柏县', '汤阴县', '泰兴市', '泰宁县', '泰安市', '泰州市', '泰顺县', '滕州市', '漯河市', '潼南县', '特克斯县', '腾冲县', '通化市', '通山县', '通州区', '通海县', '通辽市', '通道侗族自治县', '郯城县', '铁岭市', '铜仁市', '铜山区', '铜川市', '铜梁县', '铜陵市'] },
    { key: 'W', data: ['万全县', '万宁市', '万州区', '万盛区', '万荣县', '乌什县', '乌兰察布市', '乌兰浩特市', '乌恰县', '乌拉特中旗', '乌海市', '乌苏市', '乌镇', '乌鲁木齐市', '五台山', '五大连池市', '五家渠市', '五寨县', '五峰土家族自治县', '五常市', '五指山市', '五河县', '五莲县', '卧龙景区', '卫辉市', '吴忠市', '吴桥县', '吴江区', '吴起县', '围场满族蒙古族自治县', '威县', '威海市', '婺源县', '尉犁县', '巫山县', '巫溪县', '微山县', '文安县', '文山壮族苗族自治州', '文成县', '文昌市', '文水县', '文登市', '无为县', '无极县', '无棣县', '无锡市', '望都县', '梧州市', '武义县', '武乡县', '武冈市', '武功山风景区', '武城县', '武夷山市', '武威市', '武安市', '武定县', '武平县', '武强县', '武当山', '武汉市', '武穴市', '武邑县', '武都区', '武陟县', '武隆县', '汪清县', '汶上县', '汶川县', '涠洲岛', '涡阳县', '温县', '温宿县', '温岭市', '温州市', '温江区', '渭南市', '潍坊市', '瓦房店市', '维多利亚公园', '维西傈僳族自治县', '舞钢市', '舞阳县', '芜湖县', '芜湖市', '蔚县', '闻喜县', '魏县'] },
    { key: 'X', data: ['下花园区', '习水县', '乡城县', '乡宁县', '仙居县', '仙桃市', '仙游县', '信丰县', '信宜市', '信阳市', '兴义市', '兴化市', '兴县', '兴国县', '兴城市', '兴安县', '兴安盟', '兴山县', '兴平市', '兴隆县', '咸宁市', '咸阳市', '响水县', '喜德县', '夏县', '夏河县', '夏津县', '夏邑县', '孝义市', '孝感市', '孝昌县', '宣化县', '宣城市', '宣威市', '宣恩县', '寻乌县', '寻甸回族彝族自治县', '小金县', '徐州市', '徐水县', '忻州市', '息县', '新乐市', '新乡市', '新会区', '新余市', '新化县', '新县', '新和县', '新宁县', '新安县', '新密市', '新平彝族傣族自治县', '新昌县', '新晃侗族自治县', '新沂市', '新河县', '新泰市', '新浦区', '新源县', '新田县', '新竹', '新绛县', '新蔡县', '新邵县', '新郑市', '新野县', '昔阳县', '歙县', '浠水县', '淅川县', '湘乡市', '湘潭县', '湘潭市', '湘西土家族苗族自治州', '湘阴县', '溆浦县', '献县', '盱眙县', '秀山土家族苗族自治县', '荥阳市', '行唐县', '襄垣县', '襄城县', '襄汾县', '襄阳市', '西华县', '西双版纳傣族自治州', '西塘古镇', '西宁市', '西安市', '西峡县', '西平县', '西昌市', '西江苗寨', '西递', '许昌市', '象山县', '辛集市', '邢台市', '锡林浩特市', '锡林郭勒盟', '隰县', '雄县', '雪乡', '霞浦县', '项城市', '香格里拉县', '香河县', '香港'] },
    { key: 'Y', data: ['义乌市', '义马市', '于都县', '云台山', '云和县', '云林', '云梦县', '云浮市', '云阳县', '云霄县', '亚布力', '仪征市', '伊吾县', '伊宁市', '伊川县', '伊春市', '伊犁哈萨克自治州', '余姚市', '余干县', '余杭区', '偃师市', '元氏县', '元江哈尼族彝族傣族自治县', '元谋县', '元阳县', '兖州市', '原平市', '原阳县', '右玉县', '叶县', '叶城县', '垣曲县', '姚安县', '宜兰', '宜兴市', '宜城市', '宜宾市', '宜川县', '宜州市', '宜昌市', '宜春市', '宜章县', '宜良县', '宜都市', '宜阳县', '尤溪县', '岳普湖县', '岳阳县', '岳阳市', '应县', '应城市', '延吉市', '延安市', '延津县', '延边朝鲜族自治州', '扬中市', '扬州市', '攸县', '易县', '杨凌区', '榆林市', '榆树市', '榆社县', '永仁县', '永修县', '永兴县', '永和县', '永善县', '永嘉县', '永城市', '永安市', '永定县', '永川区', '永州市', '永年县', '永康市', '永春县', '永泰县', '永济市', '永清县', '永顺县', '沂南县', '沂水县', '沂源县', '沅江市', '沅陵县', '炎陵县', '烟台市', '焉耆回族自治县', '牙克石市', '玉山县', '玉林市', '玉树藏族自治州', '玉泉山', '玉溪市', '玉环县', '玉田县', '玉门市', '盈江县', '益阳市', '盐城市', '盐山县', '禹城市', '禹州市', '翼城县', '艺龙测试', '英吉沙县', '英山县', '营口市', '虞城县', '运城市', '远安县', '郓城县', '鄢陵县', '酉阳土家族苗族自治县', '野三坡', '银川市', '阳信县', '阳原县', '阳城县', '阳新县', '阳朔县', '阳江市', '阳泉市', '阳谷县', '雁荡山', '雅安市', '颍上县', '鱼台县', '鹰潭市', '黟县'] },
    { key: 'Z', data: ['中卫市', '中宁县', '中山市', '中方县', '中江县', '中牟县', '中阳县', '周口市', '周宁县', '周庄', '子洲县', '左权县', '庄河市', '张北县', '张家口市', '张家港市', '张家界市', '张掖市', '彰化', '忠县', '扎兰屯市', '扎鲁特旗', '扎龙自然保护区', '招远市', '政和县', '昭苏县', '昭通市', '朝阳市', '朱家尖', '枝江市', '枣庄市', '枣强县', '枣阳市', '柘城县', '柘荣县', '柞水县', '株洲县', '株洲市', '樟树市', '正安县', '正定县', '正阳县', '沾化县', '沾益县', '泽普县', '涿州市', '涿鹿县', '淄博市', '湛江市', '漳州市', '漳平市', '漳浦县', '珠海市', '秭归县', '章丘市', '织金县', '肇东市', '肇庆市', '自贡市', '舟山市', '芷江侗族自治县', '诏安县', '诸城市', '诸暨市', '资兴市', '资源县', '资阳市', '赞皇县', '赵县', '遵义市', '遵化市', '邹城市', '邹平县', '郑州市', '钟祥市', '镇安县', '镇平县', '镇江市', '镇远县', '长子县', '驻马店市'] }
  ] 
  
  var hotCity = ['北京', '南京', '上海市', '杭州', '苏州', '天津', '深圳', '无锡', '成都', '重庆', '武汉', '沈阳', '广州', '宁波', '西安']
  
  $(function () {
  
      init();
  
      // 选择城市
      $('body').on('click', '.city-list p', function () {
          var data = $(this).text();
          saveHistory(data);
      });
  
      $('.hot.hotCity').on('click', 'div', function () {
          var data = $(this).text();
          saveHistory(data);
      });
  
  })
  
  function bindHistoryClick() {
    $('.history .hot').on('click', 'div', function () {
        var data = $(this).text();
        saveHistory(data);
    });
    
  }
  
  function clearHistory() {
    localStorage.setItem('hotelHistory', '');
    initHistory();
  }
  
  function saveHistory(data) {
    var hotelHistory = localStorage.getItem('hotelHistory');
    if(!hotelHistory){
      hotelHistory = '';
    }
    if(hotelHistory.indexOf(data) > -1) {
      var arr = hotelHistory.split(',');
      var newArr = [];
      $.each(arr, function (i, item) {
        if(item !== data) {
          newArr.push(item);
        }
      })
      hotelHistory = newArr.join(',');
    }
    localStorage.setItem('hotelHistory', data + ',' + hotelHistory);
    initHistory();
  }
  
  function init() {
      $('.city').html('');
      var hotHtml = '';
      hotHtml += '<div class="tips" id="热门1">热门城市</div>';
      hotHtml += '<div class="hot hotCity">';
      $.each(hotCity, function (i, item) {
          hotHtml += '<div>' + item + '</div>'
      })
      hotHtml += '</div>';
      hotHtml += '<div class="history"></div>';
      $('.city').append(hotHtml);
  
      initHistory();
      
      var html = '';
      $.each(cityList, function (i, item) {
          html += '<div class="city-list"><span class="city-letter" id="' + item.key + '1">' + item.key + '</span>';
          $.each(item.data, function (j, data) {
              html += '<p>' + data + '</p>';
          })
          html += '</div>';
      })
      $('.city').append(html);
  }
  
  function initHistory() {  // 历史记录渲染
    var hotelHistory = localStorage.getItem('hotelHistory');
      var history = '';
      history += '<div class="tips" id="历史1">历史记录<div class="clear-history" onClick="clearHistory();">清空历史</div></div>';
      history += '<div class="hot">';
      if(hotelHistory) {
        $.each(hotelHistory.split(','), function (i, item) {
          if(item) {
            history += '<div>' + item + '</div>'
          }
        })
      }
      history += '</div>';
      $('.history').html(history);
      bindHistoryClick();
  }
  
  ; (function ($) {
  
      $('.letter').bind("touchstart touchmove", function (e) {
          var top = $(window).scrollTop();
          e.preventDefault();//阻止默认滚动
          var touch = e.touches[0];
          var ele = document.elementFromPoint(touch.pageX, touch.pageY - top);
  
          if (ele.tagName === 'A') {
              var s = $(ele).text();
              $(window).scrollTop($('#' + s + '1').offset().top)
              $("#showLetter span").html(s.substring(0, 1));
              $("#showLetter").show().delay(500).hide(0);
          }
      });
  
      $('.letter').bind("touchend", function (e) {
          $("#showLetter").hide(0);
      });
  
  })(Zepto); 
  