/*!
* Mui Player Mobile Plugin Javascript Library v1.3.0
* Date：2021-04-05
* Released under MIT license
* https://muiplayer.js.org/
*/
"use strict";function _typeof(e){return(_typeof="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}!function(e,t){"object"==("undefined"==typeof exports?"undefined":_typeof(exports))&&"object"==("undefined"==typeof module?"undefined":_typeof(module))?module.exports=t():"function"==typeof define&&_typeof(define.amd)?define(t):e.MuiPlayerMobilePlugin=t()}(window,function(){return function(u){function l(){return{mPlayer:t,mplayerTime:t.querySelector("#mplayer-time"),timeStart:t.querySelector("#time-start"),timeEnd:t.querySelector("#time-end"),timeProgress:t.querySelector("#time-progress"),timeTotal:t.querySelector("#time-total"),volumeControl:t.querySelector("#volume-control"),volumeProgress:t.querySelector("#volume-progress"),volumeTotal:t.querySelector("#volume-total"),luminanceControl:t.querySelector("#luminance-control"),luminanceProgress:t.querySelector("#luminance-progress"),luminanceTotal:t.querySelector("#luminance-total"),mplayerLeft:t.querySelector("#mplayer-left"),lockScreen:t.querySelector("#lock-screen"),menuButton:t.querySelector("#menu-button"),batteryInfo:t.querySelector("#battery-info"),mplayerSidebar:t.querySelector("#mplayer-sidebar"),toggleFit:t.querySelector("#toggle-fit"),toggleLoop:t.querySelector("#toggle-loop")}}var u=u||{},m={},t=null,i=new function(){return{isLockScreen:!1,startX:null,startY:null,moveX:null,moveY:null,_defaultVolumePro:null,_defaultLuminanicePro:null,isTouchMove:!1,useTouchType:null}},o='\x3c!-- 播放器中央进度控件 --\x3e<div class="mplayer-time"id="mplayer-time"><div class="time"><span class="time-start"id="time-start"></span><span class="time-symbol">/</span><span class="time-end"id="time-end"></span></div>\x3c!--Progress Time--\x3e<div class="time-progress"id="time-progress"><div style="width: 0%;"class="time-total"id="time-total"></div></div></div>',n='\x3c!-- Mplayer屏幕亮度显示控件 --\x3e<div class="small-control"id="luminance-control"><svg t="1574053406895"viewBox="0 0 1024 1024"version="1.1"xmlns="http://www.w3.org/2000/svg"p-id="1562"width="19"height="19"><path d="M496.011864 847.708901l0 96.02603c0 8.697079 7.158027 15.941064 15.988136 15.941064 8.891508 0 15.988136-7.137561 15.988136-15.941064l0-96.02603c0-8.697079-7.158027-15.941064-15.988136-15.941064C503.107469 831.767837 496.011864 838.905398 496.011864 847.708901zM738.110761 738.110761c-6.287193 6.287193-6.259564 16.35141-0.033769 22.577205l67.900459 67.900459c6.15007 6.15007 16.33299 6.210445 22.577205-0.032746 6.287193-6.287193 6.258541-16.352433 0.032746-22.577205l-67.900459-67.900459C754.537895 731.925898 744.353952 731.865523 738.110761 738.110761zM527.988136 176.291099 527.988136 80.265068c0-8.697079-7.158027-15.941064-15.988136-15.941064-8.891508 0-15.988136 7.137561-15.988136 15.941064l0 96.02603c0 8.697079 7.158027 15.941064 15.988136 15.941064C520.891508 192.231139 527.988136 185.094602 527.988136 176.291099zM512 512m-255.81427 0a249.988 249.988 0 1 0 511.62854 0 249.988 249.988 0 1 0-511.62854 0ZM828.554656 195.445344c-6.287193-6.287193-16.352433-6.258541-22.577205-0.032746l-67.900459 67.900459c-6.15007 6.15007-6.210445 16.334014 0.033769 22.577205 6.287193 6.287193 16.352433 6.259564 22.577205 0.033769l67.900459-67.901483C834.737472 211.872478 834.797847 201.689558 828.554656 195.445344zM943.734932 496.011864l-96.02603 0c-8.697079 0-15.941064 7.158027-15.941064 15.988136 0 8.891508 7.137561 15.988136 15.941064 15.988136l96.02603 0c8.697079 0 15.941064-7.158027 15.941064-15.988136C959.674972 503.107469 952.538435 496.011864 943.734932 496.011864zM176.291099 496.011864 80.265068 496.011864c-8.697079 0-15.941064 7.158027-15.941064 15.988136 0 8.891508 7.137561 15.988136 15.941064 15.988136l96.02603 0c8.697079 0 15.941064-7.158027 15.941064-15.988136C192.231139 503.107469 185.094602 496.011864 176.291099 496.011864zM263.312034 738.075968l-67.900459 67.900459c-6.15007 6.15007-6.210445 16.33299 0.032746 22.577205 6.287193 6.287193 16.352433 6.258541 22.577205 0.032746l67.901483-67.900459c6.15007-6.151094 6.210445-16.334014-0.033769-22.577205C279.602046 731.822544 269.537829 731.851197 263.312034 738.075968zM218.022549 195.411575c-6.15007-6.15007-16.33299-6.210445-22.577205 0.032746-6.287193 6.287193-6.258541 16.352433-0.032746 22.577205l67.900459 67.901483c6.15007 6.15007 16.334014 6.210445 22.577205-0.033769 6.287193-6.287193 6.259564-16.35141 0.033769-22.577205L218.022549 195.411575z"p-id="1563"fill="#ffffff"></path></svg><div class="progress"id="luminance-progress"><div class="total"id="luminance-total"style="width: 0%;"></div></div></div>',r='\x3c!-- Mplayer音量显示控件 --\x3e<div class="small-control"id="volume-control"><img class="icon-two"style="display: inline;"width="19"height="19"src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADAAAAAwCAMAAABg3Am1AAAANlBMVEUAAAD////////////////////////////////////////////////////////////////////xY8b8AAAAEXRSTlMAQBDA8KAg0IBg4HCQUDCwn9QHtzAAAAEQSURBVEjH7ZTBcoQgEEQVQRFEff//s4FC1gSXkDnktn0Ri37FTEPN8NE37bPMb9ESQp3AKPAviIDd8ROYbfjNP2oqYIK17V+hBg7AtvwnT0AZILxv9+AJREVCz414bqDaMK+/MBVpKkBNLuQkgNcRvNd4JbCVorYeUGq01xG6D0SZUouDsQeUWzvSdwPbBUq7Krdz9ICsJS4zOPWBqxaf+gf9N8CCvWz/BJi4FJXkYJY0HY1uEMSaHocXXJyawKn7OrpAtLGnxd57fHc0a8nKFMDr9glhm/OkyY+21q5roGgB0555T+CkNWuVqYDib48y/wQ8qaCmgq4BG/2iYay8F477vowUGNYUo0izGj4q+gKKsi0nAoxfOwAAAABJRU5ErkJggg=="/><img class="icon-one"style="display: none;"width="19"height="19"src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADAAAAAwCAMAAABg3Am1AAAAOVBMVEUAAAD///////////////////////////////////////////////////////////////////////8KOjVvAAAAEnRSTlMAQBC/8NAggDCgcGBQ4N+QsJ/fLHffAAAAsklEQVRIx+3Uuw6DMAxGYWOSkBu38/4PWxakVqhV/4GNM+cbYlm2p7dyMqmJoAjfgUF4H5FAXpDAEJBAAwnsSMA3JOCRf0AfzwJ8Ah+XfgVcO0EDVgV4BCYBmBUgKcBG2CQwAK4AizBIYIUqgQmme0FR/7BAEsc6mwA8QhWAjzC7ACKQlW2F0C7rXcNXYH1NPy9SAPEIRBGYFw0cVRVYDyKwPMO95/6oqMAaIZlUcns6ewG5zilmwncwVgAAAABJRU5ErkJggg=="/><img class="icon-zero"style="display: none;"width="19"height="19"src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADAAAAAwCAMAAABg3Am1AAAAM1BMVEUAAAD///////////////////////////////////////////////////////////////+3leKCAAAAEHRSTlMAQL8Q8NAwIOCgn3BgUK9/0BJchgAAAGtJREFUSMft1DkWgCAQBNHRGcDdvv9pNeFhSMVScf+0bfQpF0PdCiJ8kzSBfRICeRECUwiBQ0JgEwJ+CQFP6gHnXAt1AbUGGOD3YA8IWjkgME8QmK8MvO0U2BkNsDPmdw9aKbBDUQxV3Ea1ByaZIX0l0zmlAAAAAElFTkSuQmCC"/><div class="progress"id="volume-progress"><div class="total"id="volume-total"style="width: 0%;"></div></div></div>',a='\x3c!-- Mplayer 左侧操作按钮 --\x3e<div class="mplayer-left"id="mplayer-left">\x3c!--锁屏--\x3e<div class="control-icon"id="lock-screen"control>\x3c!--Lock--\x3e<div class="_lock"id="_lock"><svg t="1573132768516"viewBox="0 0 1024 1024"version="1.1"xmlns="http://www.w3.org/2000/svg"p-id="1405"width="22"height="22"><path d="M758.5 931h-497c-50.453 0-91.5-41.047-91.5-91.5v-335c0-50.453 41.047-91.5 91.5-91.5h497c50.453 0 91.5 41.047 91.5 91.5v335c0 50.453-41.047 91.5-91.5 91.5z m-497-454c-15.164 0-27.5 12.336-27.5 27.5v335c0 15.163 12.336 27.5 27.5 27.5h497c15.163 0 27.5-12.337 27.5-27.5v-335c0-15.164-12.337-27.5-27.5-27.5h-497z"fill="#ffffff"p-id="1406"></path><path d="M512.1 791c-17.673 0-32-14.327-32-32V588.999c0-17.673 14.327-32 32-32 17.673 0 32 14.327 32 32V759c0 17.673-14.328 32-32 32zM297.472 446.595c-17.673 0-32-14.327-32-32 0-109.504 25.127-192.098 74.684-245.486 22.309-24.034 49.483-42.036 80.767-53.505 27.139-9.95 57.454-14.995 90.101-14.995 76.909 0 134.36 20.286 175.638 62.018 51.002 51.562 75.166 134.096 73.874 252.317-0.191 17.552-14.481 31.649-31.99 31.65-0.12 0-0.237 0-0.357-0.002-17.672-0.193-31.842-14.676-31.648-32.348 1.08-98.854-17.552-168.368-55.379-206.611-28.637-28.952-71.205-43.025-130.137-43.025-52.665 0-94.371 16.163-123.96 48.04-38.214 41.169-57.59 109.113-57.59 201.946-0.003 17.674-14.329 32.001-32.003 32.001z"fill="#ffffff"p-id="1407"></path></svg></div>\x3c!--Open--\x3e<div class="_unlock"id="_unlock"style="display: none;"><svg t="1573132914638"viewBox="0 0 1024 1024"version="1.1"xmlns="http://www.w3.org/2000/svg"p-id="1990"width="22"height="22"><path d="M813.72147413 436.3513088h-56.8729696V300.99145813c0-135.14152853-109.706976-245.06682667-244.84850453-245.06682666C376.85847147 55.92463147 267.15149547 165.9590912 267.15149547 301.20978027c0 19.430688 15.82837013 35.25905813 35.25905813 35.25905813 19.430688 0 35.25905813-15.82837013 35.25905813-35.25905813 0-96.38931307 78.15939733-174.7670336 174.33038827-174.76703254S686.33038827 204.71130667 686.33038827 300.99145813v135.35985067H210.93349333c-19.430688 0-35.58654187 15.5008864-35.58654186 34.9315744v408.91774293c0 48.57672107 39.8438272 88.09306453 88.42054826 88.09306454h497.119968c48.57672107 0 87.87474133-39.51634347 87.87474134-88.09306454V471.2828832c-0.1091616-19.430688-15.5008864-34.9315744-35.04073494-34.9315744z m-35.47738026 443.84931733c0 9.715344-7.64128213 17.68410987-17.35662614 17.68410987H263.76749973c-9.715344 0-18.01159253-7.96876587-18.0115936-17.68410987v-373.33120106h532.48818774v373.33120106z"fill="#ffffff"p-id="1991"></path><path d="M512 807.93593173c19.430688 0 35.25905813-15.82837013 35.25905813-35.25905813V645.83159467c0-19.430688-15.71920853-35.25905813-35.25905813-35.25905814-19.430688 0-35.25905813 15.82837013-35.25905813 35.25905814v126.95444053c0.1091616 19.430688 15.82837013 35.14989653 35.25905813 35.14989653z"fill="#ffffff"p-id="1992"></path></svg></div></div></div>',s='\x3c!-- Mplayer弹出右侧栏菜单 --\x3e<div class="mplayer-sidebar"id="mplayer-sidebar"slot="mplayer-sidebar"><div class="title">设置</div><div class="setting-box"><svg t="1572955773659"viewBox="0 0 1024 1024"version="1.1"xmlns="http://www.w3.org/2000/svg"p-id="4387"width="21"height="21"><path d="M810.666667 96H213.333333A117.461333 117.461333 0 0 0 96 213.333333v597.333334c0 64.682667 52.629333 117.333333 117.333333 117.333333h597.333334c64.682667 0 117.333333-52.650667 117.333333-117.333333V213.333333c0-64.682667-52.650667-117.333333-117.333333-117.333333zM864 810.666667c0 29.418667-23.914667 53.333333-53.333333 53.333333H213.333333A53.397333 53.397333 0 0 1 160 810.666667V213.333333c0-29.418667 23.936-53.333333 53.333333-53.333333h597.333334c29.418667 0 53.333333 23.914667 53.333333 53.333333v597.333334z"p-id="4388"fill="#ffffff"></path><path d="M448 245.333333h-170.666667c-4.138667 0-8.042667 0.853333-11.669333 2.282667l-0.490667 0.149333c-7.893333 3.242667-14.165333 9.536-17.429333 17.429334l-0.149333 0.490666A31.893333 31.893333 0 0 0 245.333333 277.333333v170.666667a32 32 0 1 0 64 0v-93.418667l105.365334 105.365334c6.250667 6.272 14.442667 9.386667 22.634666 9.386666s16.384-3.114667 22.634667-9.365333a32 32 0 0 0 0-45.248l-105.386667-105.386667H448a32 32 0 1 0 0-64zM746.666667 544a32 32 0 0 0-32 32v93.418667l-105.365334-105.365334a32 32 0 1 0-45.248 45.248l105.365334 105.365334H576a32 32 0 0 0 0 64h170.666667c4.117333 0 8.042667-0.853333 11.669333-2.261334l0.490667-0.149333c7.872-3.242667 14.165333-9.536 17.408-17.408l0.149333-0.490667c1.429333-3.648 2.282667-7.573333 2.282667-11.690666v-170.666667a32 32 0 0 0-32-32z"p-id="4389"fill="#ffffff"></path></svg><div class="box-name">铺满全屏</div><div class="toogle-switch close"id="toggle-fit"><div class="ball"></div></div></div><div class="setting-box"><svg t="1574076029235"viewBox="0 0 1024 1024"version="1.1"xmlns="http://www.w3.org/2000/svg"p-id="1557"width="21"height="21"><path d="M683 833H215l45 42c9 6 15 15 15 27-3 18-18 30-36 30-9 0-21-6-27-12l-102-90c-12-12-15-33 0-45L212 692c6-6 18-9 27-9 18 0 33 15 33 33 0 9-6 18-12 24l-39 36h465c105 0 186-84 186-186v-81c0-18 12-30 30-30s30 12 30 30v81c0 132-111 243-249 243zM341 191h465l-45-42c-9-6-15-15-15-27 3-18 18-30 36-30 9 0 21 6 27 12l102 90c12 12 15 33 0 45L812 332c-6 6-18 9-27 9-18 0-33-15-33-33 0-9 6-18 12-24l39-36H338C236 251 152 335 152 440v84c0 18-12 30-30 30s-30-12-30-30v-81C92 302 203 191 341 191z"p-id="1558"fill="#ffffff"></path></svg><div class="box-name">循环播放</div><div class="toogle-switch close"id="toggle-loop"><div class="ball"></div></div></div><div class="title">播放速度</div><div class="setting-box"><div class="play-speed"data="0.8">0.8</div><div class="play-speed"data="1.0">1.0</div><div class="play-speed"data="1.25">1.25</div><div class="play-speed"data="1.5">1.5</div><div class="play-speed"data="2.0">2.0</div></div><div class="title">分享视频</div><div class="setting-box">\x3c!--微信--\x3e<div class="share-box"data="1"style="background: #00c80d;"><svg t="1572959869357"viewBox="0 0 1024 1024"version="1.1"xmlns="http://www.w3.org/2000/svg"p-id="2984"width="28"height="28"><path d="M693.12 347.264c11.776 0 23.36 0.896 35.008 2.176-31.36-146.048-187.456-254.528-365.696-254.528C163.2 94.912 0 230.656 0 403.136c0 99.52 54.272 181.248 145.024 244.736L108.8 756.864l126.72-63.488c45.312 8.896 81.664 18.112 126.912 18.112 11.392 0 22.656-0.512 33.792-1.344-7.04-24.256-11.2-49.6-11.2-76.032C385.088 475.776 521.024 347.264 693.12 347.264zM498.304 249.024c27.392 0 45.376 17.984 45.376 45.248 0 27.136-17.984 45.312-45.376 45.312-27.072 0-54.336-18.176-54.336-45.312C443.968 266.944 471.168 249.024 498.304 249.024zM244.672 339.584c-27.2 0-54.592-18.176-54.592-45.312 0-27.264 27.392-45.248 54.592-45.248S289.92 266.944 289.92 294.272C289.92 321.408 271.872 339.584 244.672 339.584zM1024 629.76c0-144.896-145.024-262.976-307.904-262.976-172.48 0-308.224 118.144-308.224 262.976 0 145.28 135.808 262.976 308.224 262.976 36.096 0 72.512-9.024 108.736-18.112l99.392 54.528-27.264-90.624C969.728 783.872 1024 711.488 1024 629.76zM616.128 584.384c-17.984 0-36.224-17.92-36.224-36.224 0-18.048 18.24-36.224 36.224-36.224 27.52 0 45.376 18.176 45.376 36.224C661.504 566.464 643.648 584.384 616.128 584.384zM815.488 584.384c-17.856 0-36.032-17.92-36.032-36.224 0-18.048 18.112-36.224 36.032-36.224 27.264 0 45.376 18.176 45.376 36.224C860.864 566.464 842.752 584.384 815.488 584.384z"p-id="2985"fill="#ffffff"></path></svg></div>\x3c!--朋友圈--\x3e<div class="share-box"data="2"style="background: #47d300;"><svg t="1572960303277"viewBox="0 0 1024 1024"version="1.1"xmlns="http://www.w3.org/2000/svg"p-id="3166"width="30"height="30"><path d="M679.170882 398.98197 679.170882 126.497019c0 0-133.338844-71.481008-288.989857-16.365736L679.170882 398.98197zM704.414823 559.284933 704.414823 137.748271c0 0 157.630087 71.433936 202.051809 244.963131L704.414823 559.284933zM619.614461 681.811524l290.99042-273.64845c0 0 51.487651 83.708494-25.293059 273.64845L619.614461 681.811524zM471.029378 716.50672l393.014048 0c0 0-47.444569 128.594797-217.255069 181.688016L471.029378 716.50672zM342.736457 629.695562l0 256.17959c0 0 102.071723 65.36573 276.878005 21.478174L342.736457 629.695562zM115.370099 642.946354 314.44511 464.326211l0 406.206512C314.44511 870.5317 194.172863 828.782853 115.370099 642.946354zM110.3252 614.376669c0 0-45.538149-146.935514 18.154475-274.554076l273.811156 0L110.3252 614.376669zM145.682475 311.183322c0 0 57.602929-130.594337 214.20971-191.869912l186.893574 191.869912L145.682475 311.183322z"p-id="3167"fill="#ffffff"></path></svg></div>\x3c!--QQ--\x3e<div class="share-box"data="3"style="background: #19b8ef;"><svg t="1572960366859"viewBox="0 0 1024 1024"version="1.1"xmlns="http://www.w3.org/2000/svg"p-id="2494"width="28"height="28"><path d="M116.435 593.714c-33.54 78.964-38.985 154.297-12.059 168.37 18.572 9.696 47.686-12.382 74.936-52.909 10.791 44.157 37.493 84.137 75.633 116.21-40.004 14.768-66.135 38.886-66.135 66.232 0 44.954 70.709 81.302 157.978 81.302 78.716 0 143.907-29.538 155.94-68.371 3.232-0.049 15.663-0.049 18.796 0 12.083 38.784 77.324 68.371 155.989 68.371 87.267 0 157.978-36.398 157.978-81.302 0-27.297-26.105-51.464-66.135-66.232 38.089-32.123 64.889-72.053 75.631-116.21 27.251 40.527 56.29 62.605 74.887 52.909 26.95-14.073 21.631-89.456-12.032-168.37-26.355-62.058-62.11-107.754-89.457-117.848 0.398-3.929 0.596-7.958 0.596-11.935 0-23.968-6.661-46.146-18.049-64.196 0.199-1.393 0.199-2.834 0.199-4.227 0-11.038-2.636-21.381-7.114-30.332-6.909-161.309-111.93-289.402-281.866-289.402-170.036 0-275.106 128.093-281.943 289.402-4.525 9.001-7.135 19.343-7.135 30.332 0 1.393 0.099 2.835 0.15 4.227-11.288 18.05-17.951 40.178-17.951 64.196 0 3.978 0.15 7.955 0.498 11.935-27.151 10.094-63.028 55.841-89.333 117.848z"p-id="2495"fill="#ffffff"></path></svg></div>\x3c!--复制链接--\x3e<div class="share-box"data="4"style="background: #f1f1f2;"><svg t="1572960510060"viewBox="0 0 1024 1024"version="1.1"xmlns="http://www.w3.org/2000/svg"p-id="2890"width="28"height="28"><path d="M829.19277102 195.1443091l-2.9663086-2.9663086a175.14703937 175.14703937 0 0 0-246.94519043 0L421.86466874 349.52718832a175.21445555 175.21445555 0 0 0 0 247.0126066l2.89889242 2.89889243c5.66295251 5.59553633 11.73040204 10.71916093 17.86526774 15.50570393l57.57335289-57.64076905c-6.74161051-3.91013426-13.07872399-8.76409343-18.8090934-14.49446285l-2.89889241-2.83147625a94.71962648 94.71962648 0 0 1 0-133.82096684l157.48402015-157.41660399a94.58479415 94.58479415 0 0 1 133.68613523 1e-8l2.89889242 2.89889242a94.65221032 94.65221032 0 0 1 0 133.75355141L701.4392537 456.71879472c12.33714684 30.60691161 18.20234786 63.10147379 17.59560307 95.52861981l110.15791425-110.09049883a175.0796232 175.0796232 0 0 0 0-246.94519043z m-232.58555993 226.78777509a172.85489176 172.85489176 0 0 0-17.9326839-15.50570395l-57.57335289 57.57335363c6.74161051 4.04496659 13.14614016 8.76409343 18.87650882 14.56187828l2.9663086 2.89889242a94.65221032 94.65221032 0 0 1 0 133.75355141L385.52738847 772.63065995a94.78704266 94.78704266 0 0 1-133.82096757 0l-2.89889242-2.96630859a94.65221032 94.65221032 0 0 1 0-133.7535514l71.19140625-71.12399008a244.04629801 244.04629801 0 0 1-17.66301922-95.52861981L192.1780005 579.21385583a175.21445555 175.21445555 0 0 0 0 247.08002277l2.89889244 2.96630858a175.28187172 175.28187172 0 0 0 247.01260659 0L599.50610352 671.77616776a175.28187172 175.28187172 0 0 0 0-247.0126066l-2.89889243-2.89889242z"p-id="2891"fill="#000000"></path></svg></div></div></div>',c='<button class="player-btn menu-button header-control"id="menu-button"style="display: none;"control><svg t="1607603786690" class="icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="2354"><path d="M512 318.59375c-53.71875 0-97.3125-43.59375-97.3125-97.3125S458.28125 124.0625 512 124.0625 609.3125 167.65625 609.3125 221.375 565.71875 318.59375 512 318.59375z m0 291.84375c-53.71875 0-97.3125-43.59375-97.3125-97.3125S458.28125 415.90625 512 415.90625 609.3125 459.5 609.3125 513.21875 565.71875 610.4375 512 610.4375z m0 291.84375c-53.71875 0-97.3125-43.59375-97.3125-97.3125S458.28125 707.75 512 707.75s97.3125 43.59375 97.3125 97.3125S565.71875 902.28125 512 902.28125z" p-id="2355" fill="#ffffff"></path></svg></button>',d='<button class="player-btn battery-info header-control"id="battery-info"><div class="capacity"id="capacity"><div class="level"id="level"><div class="count"id="count"></div></div></div><div class="time"id="time"></div></button>',g=null,p={overloadingEl:function(){g=new l;for(var e=0,t=Object.keys(g);e<t.length;e++){var o=t[e];"mPlayer"!=o&&(g[o]||(g[o]={style:{},classList:{add:function(){},contains:function(){},remove:function(){}},addEventListener:function(){},removeEventListener:function(){}}),g[o].querySelector=function(e){e=this.querySelectorAll?this.querySelectorAll(e):[];return e[0]||{exist:!1,style:{},height:"",width:""}})}},plusRuntimeAction:function(){function e(){(new p.plusRuntimeHandle)._volume_luminance("init")}window.plus?e():setTimeout(function(){window.plus?e():p.unPlusRuntimeHandle()},3e3)},initLanguage:function(e){var t=m.$method.getLangObject(),o=e.querySelector("#mplayer-sidebar").children;return o[0].innerText=t.settings,o[1].querySelector(".box-name").innerText=t.coveredPlay,o[2].querySelector(".box-name").innerText=t.loopPlay,o[3].innerText=t.playbackSpeed,o[5].innerText=t.share,e},initConifgAttribute:function(e){var t=m.option.volume;return 0<=t&&t<=1?(e.querySelector("#volume-total").style.width=100*t+"%",e.querySelector("video").volume=t):e.querySelector("#volume-total").style.width="100%",0<=u.defaultLuminance&&u.defaultLuminance<=1?e.querySelector("#luminance-total").style.width=100*u.defaultLuminance+"%":e.querySelector("#luminance-total").style.width="100%",e},initConfigControls:function(s){!1===u.showLock&&m.$method.removeNode(s,"#lock-screen"),!1!==u.showBattery&&navigator.getBattery||m.$method.removeNode(s,"#battery-info");var e=u.hotKeyConfig||{};!1===e.volumeHandle&&m.$method.removeNode(s,"#volume-control"),1!=e.luminanceHandle&&m.$method.removeNode(s,"#luminance-control"),!0===m.option.loop&&(s.querySelector("#toggle-loop").classList.add("open"),s.querySelector("#toggle-loop").classList.remove("close")),"cover"==m.option.objectFit&&(s.querySelector("#toggle-fit").classList.add("open"),s.querySelector("#toggle-fit").classList.remove("close"));return 0!=u.showMenuButton?function(){var e=u.defaultMenuConfig||{};!0===m.option.live&&(e.showSpeedSwitch=!1,e.showLoopSwitch=!1,m.$method.removeNode(s,"#mplayer-time")),!1===e.showFillSwitch&&s.querySelector("#toggle-fit").parentNode.parentNode.removeChild(s.querySelector("#toggle-fit").parentNode),!1===e.showLoopSwitch&&s.querySelector("#toggle-loop").parentNode.parentNode.removeChild(s.querySelector("#toggle-loop").parentNode),!1===e.showSpeedSwitch&&s.querySelector(".play-speed").parentNode.parentNode.removeChild(s.querySelector(".play-speed").parentNode);for(var t=e.showShare||[],o=s.querySelectorAll(".share-box"),l=0;l<o.length;l++){for(var n=o[l].getAttribute("data"),i=!1,r=0;r<t.length;r++)if(n==t[r]){i=!0;break}i||o[l]&&o[l].parentNode.removeChild(o[l])}for(var a=s.querySelectorAll("#mplayer-sidebar .title"),l=0;l<a.length;l++)0==a[l].nextElementSibling.children.length&&a[l]&&a[l].parentNode.removeChild(a[l])}():(m.$method.removeNode(s,"#menu-button"),m.$method.removeNode(s,"#mplayer-sidebar")),s},initConfigTheme:function(e){return m.$habit.forwardRate=0<u.forwardRate&&u.forwardRate<=1?u.forwardRate:.1,e.querySelector("#time-start")&&(e.querySelector("#time-start").style.color=m.$habit.themeColor),e.querySelector("#time-total")&&(e.querySelector("#time-total").style.background=m.$habit.themeColor),e.querySelector("#toggle-fit")&&(e.querySelector("#toggle-fit").style.background=m.$habit.themeColor),e.querySelector("#toggle-loop")&&(e.querySelector("#toggle-loop").style.background=m.$habit.themeColor),0<e.querySelectorAll("#mplayer-sidebar .play-speed").length&&(e.querySelectorAll("#mplayer-sidebar .play-speed")[1].style.background=m.$habit.themeColor),e},parseCamel:function(e){return e.replace(/\B([A-Z])/g,"-$1").toLowerCase()},unPlusRuntimeHandle:function(){},plusRuntimeHandle:function(){var o=this,l=0;this._volume_luminance=function(e){var t=plus.device.getVolume();if(0==t&&l<3&&"init"==e)return l++,void setTimeout(function(){o._volume_luminance(e)},200);1<t?t=100<=10*t?100:10*t:t<=1&&(t=100<=100*t?100:100*t),g.volumeTotal.style.width=t+"%",m.$el.videoObject.volume=1;t=plus.screen.getBrightness();1<t?t=100<10*t?100:10*t:t<=1&&(t=100<100*t?100:100*t),g.luminanceTotal.style.width=t+"%"}},toggleControlsDisplay:function(){var e,t=g.mplayerLeft.getBoundingClientRect().width;m.$method.hasNotchInScreen()&&(e=plus.navigator.getStatusbarHeight(),t+=Math.round(e)/2),this.ON_SideLeft=function(){g.mplayerLeft.style.left=t+"px"},this.OFF_SideLeft=function(){g.mplayerLeft.style.left=-t+"px"}},readBattery:function(e){var t,o,n;"showControls"!=(e=e||{}).type&&!1!==m.option.showBattery&&(t=new Date,o=1==(o=t.getHours()).toString().length?"0"+o:o,t=t.getMinutes(),t=o+":"+(t=1==t.toString().length?"0"+t:t),g.batteryInfo.querySelector("#time").innerHTML=t,n=!1,e=function l(){navigator.getBattery().then(function(e){var t=e.level,o=e.charging;0<t&&(n=!0),o=o,g.batteryInfo.querySelector("#count").style.background=o?"#55c612":"#FFFFFF",o=null,1<(t=t)?o=100<10*t?100:10*t:t<=1&&(o=100<10*t?100:100*t),100==o?g.batteryInfo.querySelector("#count").style.borderRadius="1px":o<10&&(g.batteryInfo.querySelector("#count").style.background="red"),g.batteryInfo.querySelector("#count").style.width=o+"%",e.onlevelchange=function(e){l()},e.onchargingchange=function(e){l()}})},navigator.getBattery&&e(),setTimeout(function(){n||g.batteryInfo instanceof Element&&m.$method.removeNode(g.mPlayer,"#battery-info")},1e3))},onLockScreenTap:function(e){e.stopPropagation(),i.isLockScreen?(g.lockScreen.querySelector("#_lock").style.display="flex",g.lockScreen.querySelector("#_unlock").style.display="none",i.isLockScreen=!1,m.$method.toggleControlsDisplay({type:"showControls"}),p.toggleEventListenerGlobal("add")):(g.lockScreen.querySelector("#_lock").style.display="none",g.lockScreen.querySelector("#_unlock").style.display="flex",i.isLockScreen=!0,m.$method.toggleControlsDisplay({type:"hideControls"}),p.toggleEventListenerGlobal("remove","lockAction"))},onShareBox:function(e){e.stopPropagation();e=Number.parseFloat(e.currentTarget.getAttribute("data"));m._this.emit("share",{type:e})},onPlaySpeed:function(o){o.stopPropagation();var e,t=Number.parseFloat(o.currentTarget.getAttribute("data"));m.$el.videoObject.playbackRate!=t&&(m.$method.toggleControlsDisplay(o),function(){for(var e=g.mplayerSidebar.querySelectorAll(".play-speed"),t=0;t<e.length;t++)e[t].style.background="transparent";o.currentTarget.style.background=m.$habit.themeColor}(),m.$el.videoObject.playbackRate=t,e=m.$method.getLangObject(),1!=t?m.$method.showToast(e.tsps.replace("?",t)):m.$method.showToast(e.dsps))},onToggleLoop:function(e){e.stopPropagation(),-1<e.currentTarget.getAttribute("class").indexOf("open")?(m.$el.videoObject.loop=!1,e.currentTarget.classList.add("close"),e.currentTarget.classList.remove("open")):(m.$el.videoObject.loop=!0,e.currentTarget.classList.add("open"),e.currentTarget.classList.remove("close"))},onToggleFit:function(e){(e=e||{}).stopPropagation&&e.stopPropagation();this.fill=function(){-1<(g.toggleFit instanceof Element?g.toggleFit.getAttribute("class"):"").indexOf("close")&&(g.toggleFit.classList.add("open"),g.toggleFit.classList.remove("close"),m.$el.videoObject.classList.add("covered"))},this.unfill=function(){-1<(g.toggleFit instanceof Element?g.toggleFit.getAttribute("class"):"").indexOf("open")&&(g.toggleFit.classList.add("close"),g.toggleFit.classList.remove("open"),m.$el.videoObject.classList.remove("covered"))},e.type&&(-1<g.toggleFit.getAttribute("class").indexOf("close")?this.fill():this.unfill())},videoScreenTouch:function(e){if((e=e||{}).stopPropagation&&e.stopPropagation(),m.$data.mediaStatus&&!(m.$data.duration<=1)&&(!1!==u.pageGetsture||m.$data.isFullScreen)){if("touchstart"==e.type){if(i.isTouchMove)return;i.startX=e.touches[0].clientX,i.startY=e.touches[0].clientY,g.mPlayer.addEventListener("touchmove",p.videoScreenTouch),g.mPlayer.addEventListener("touchend",p.videoScreenTouch),g.mPlayer.addEventListener("touchcancel",p.videoScreenTouch)}var t,o;if("touchmove"==e.type)switch(e.preventDefault(),i.moveX=e.touches[0].clientX,i.moveY=e.touches[0].clientY,i.isTouchMove||(i.isTouchMove=!0,m.$method.createTimerCloseControl("cancel")),m.$data.showScreenControls&&i.useTouchType&&m.$method.toggleControlsDisplay(e),i.useTouchType||(t=u.hotKeyConfig||{},10<Math.abs(i.moveX-i.startX)&&!m.option.live&&m.$data.duration!=1/0&&0!=t.processHandle?i.useTouchType="forward":10<Math.abs(i.moveY-i.startY)&&(!1===t.volumeHandle||1!=t.luminanceHandle?(0!=t.volumeHandle&&(i.useTouchType="volume"),!0===t.luminanceHandle&&(i.useTouchType="luminance")):(o=g.mPlayer.getBoundingClientRect().width,i.useTouchType=o/2>o-i.startX?0!=t.volumeHandle?"volume":"":0!=t.luminanceHandle?"luminance":"")),function(){switch(i.useTouchType){case"forward":m.$data._defaultPlayProgressPro=m.$el.progressPlay.style.width.substr(0,m.$el.progressPlay.style.width.length-1)||0,g.timeTotal.style.width=m.$data._defaultPlayProgressPro+"%",m.$data._defaultPlayProgressPro;break;case"volume":window.plus&&(new p.plusRuntimeHandle)._volume_luminance(),i._defaultVolumePro=g.volumeTotal.style.width.substr(0,g.volumeTotal.style.width.length-1),p.toggleVolumeIcon(Number.parseFloat(i._defaultVolumePro)),g.volumeControl.style.transition="none",g.volumeControl.style.opacity=1;break;case"luminance":window.plus&&(new p.plusRuntimeHandle)._volume_luminance(),i._defaultLuminanicePro=g.luminanceTotal.style.width.substr(0,g.luminanceTotal.style.width.length-1),g.luminanceControl.style.transition="none",g.luminanceControl.style.opacity=1}}()),i.useTouchType){case"forward":var l=i.moveX-i.startX;m.$method.progressControlHandle(l,g.timeProgress,m.$habit.forwardRate),p.toggleMiddleProgress("show");break;case"volume":l=i.startY-i.moveY;p.screenVolumeHandle(l);break;case"luminance":l=i.startY-i.moveY;p.screenLuminanceHandle(l)}"touchend"==e.type&&(g.mPlayer.removeEventListener("touchmove",p.videoScreenTouch),g.mPlayer.removeEventListener("touchend",p.videoScreenTouch),g.mPlayer.removeEventListener("touchcancel",p.videoScreenTouch),"forward"==i.useTouchType?(m.$el.videoObject.currentTime=m.$data.currentTime,p.toggleMiddleProgress("hide")):"volume"==i.useTouchType?(g.volumeControl.style.transition="opacity 0.5s",g.volumeControl.style.opacity=0):"luminance"==i.useTouchType&&(g.luminanceControl.style.transition="opacity 0.5s",g.luminanceControl.style.opacity=0),p.resetTouchVariable()),"touchcancel"==e.type&&(g.mPlayer.removeEventListener("touchmove",p.videoScreenTouch),g.mPlayer.removeEventListener("touchend",p.videoScreenTouch),g.mPlayer.removeEventListener("touchcancel",p.videoScreenTouch),g.volumeControl.style.transition="opacity 0.5s",g.volumeControl.style.opacity=0,g.luminanceControl.style.transition="opacity 0.5s",g.luminanceControl.style.opacity=0,p.resetTouchVariable())}},screenLuminanceHandle:function(e){m.$method.computeProgress(e,g.luminanceProgress,function(e){e=Number.parseFloat(i._defaultLuminanicePro)+.35*e;100<=e?e=100:e<=0&&(e=0),g.luminanceTotal.style.width=e+"%",m._this.emit("luminance-change",{size:(.01*e).toFixed(2)})})},screenVolumeHandle:function(e){m.$method.computeProgress(e,g.volumeProgress,function(e){e=Number.parseFloat(i._defaultVolumePro)+.35*e;100<=e?e=100:e<=0&&(e=0),p.toggleVolumeIcon(e),g.volumeTotal.style.width=e+"%",m._this.emit("volume-change",{size:(.01*e).toFixed(2)})})},toggleVolumeIcon:function(e){0==e?(g.volumeControl.querySelector(".icon-zero").style.display="inline",g.volumeControl.querySelector(".icon-two").style.display="none",g.volumeControl.querySelector(".icon-one").style.display="none"):50<=e?(g.volumeControl.querySelector(".icon-two").style.display="inline",g.volumeControl.querySelector(".icon-zero").style.display="none",g.volumeControl.querySelector(".icon-one").style.display="none"):(g.volumeControl.querySelector(".icon-one").style.display="inline",g.volumeControl.querySelector(".icon-zero").style.display="none",g.volumeControl.querySelector(".icon-two").style.display="none")},resetTouchVariable:function(){setTimeout(function(){i.startX=null,i.startY=null,i.moveX=null,i.moveY=null,i.isTouchMove=!1,i.useTouchType=null,m.$data._defaultPlayProgressPro=null,i._defaultVolumePro=null,i._defaultLuminanicePro=null},200)},toggleMiddleProgress:function(e){"show"==e?(g.mplayerTime.style.transition="none",g.mplayerTime.style.opacity=1,m.$method.showCover()):"hide"==e&&(g.mplayerTime.style.transition="opacity 1s",g.mplayerTime.style.opacity=0,m.$method.hideCover())},onAgentEventAction:function(e){switch(e){case"touchmove-footerbar":p.toggleMiddleProgress("show");break;case"touchend-footerbar":p.toggleMiddleProgress("hide");break;case"remove-event":p.toggleEventListenerGlobal("remove")}},onMenuTap:function(e){e.stopPropagation(),m._this.showRightSidebar("mplayer-sidebar")},showThumbnails:function(e){var n=0,i=0,t=u.thumbnails||{},r=t.preview||[],o=t.tile||[10,10],t=t.scale||[160,90],a=o[0]||10,s=o[1]||10,c=t[0]||160,d=t[1]||90;0!=r.length&&(t=parseInt(e/100*m.$data.duration),e=(n=t)%a==0?0:parseInt(n%a)*c,t=n/a<1?0:parseInt(n/a)*d,function(){var e;i=parseInt(n/(a*s)),!1===g.mplayerTime.querySelector('[data-playimage-index="'+i+'"]').exist&&((t=document.createElement("div")).setAttribute("class","preview-image"),t.setAttribute("data-playimage-index",i),t.style.width="100%",t.style.height="100%",t.style.borderRadius="4px",t.style.backgroundImage="url("+r[i]+")",!1===(e=g.mplayerTime.querySelector(".mp-thumbnails")).exist?((e=document.createElement("div")).setAttribute("class","mp-thumbnails"),e.style.width=c+"px",e.style.height=d+"px",e.style.margin="12px auto auto auto",e.appendChild(t),g.mplayerTime.appendChild(e)):e.appendChild(t));for(var t=g.mplayerTime.querySelectorAll(".preview-image"),o=0;o<t.length;o++){var l=t[o].getAttribute("data-playimage-index");t[o].style.display=l!=i?"none":"block"}}(),g.mplayerTime.querySelector('[data-playimage-index="'+i+'"]').style.backgroundPosition=-e+"px "+-t+"px")},onSeekProgress:function(e){g.timeTotal.style.width=e.percentage+"%",m.$method.computePlayTime(m.$data.percentage,m.$data.duration,function(e){g.timeStart.innerHTML=e}),"landscape"==m._this._global_.mobilePlugin.direction&&p.showThumbnails(e.percentage)},onDurationChange:function(t){setTimeout(function(){var e;t.duration!=1/0&&(e=m.$method.formatCurrentTime(t.duration),g.timeEnd.innerHTML=e)},100)},onControlsToggle:function(t){var e;i.isLockScreen||(t.show&&g&&p.readBattery(),e=function(){var e=new p.toggleControlsDisplay;t.show?e.ON_SideLeft():e.OFF_SideLeft()},m._this._global_.isReady?e():setTimeout(function(){e()},150))},onFullscreenChange:function(e){function t(){m._this._global_.mobilePlugin.direction=e.direction,"portrait"==e.direction&&(g.menuButton.style.display="none",g.batteryInfo.style.display="none",g.mplayerLeft.style.opacity=0,g.mplayerTime.style.top="50%",g.mplayerTime.querySelector(".mp-thumbnails").style.display="none"),"landscape"==e.direction&&(g.menuButton.style.display="block",g.batteryInfo.style.display="flex",g.mplayerLeft.style.opacity=1,g.mplayerTime.style.top="35%",g.mplayerTime.querySelector(".mp-thumbnails").style.display="block")}m._this._global_.isReady?t():setTimeout(function(){t()},150)},onReady:function(){var e;"function"==typeof m.$el&&(e=new m.$el,m.$el=e),t=m.$el.mPlayer,p.overloadingEl(),p.plusRuntimeAction(),p.toggleEventListenerGlobal("add","playerReady"),p.readBattery()},onDestory:function(){p.toggleEventListenerGlobal("remove","playerDestory")},onError:function(){p.toggleEventListenerGlobal("remove","playerError")},onAction:function(e){e="add"==e?"on":"off";m._this[e]("seek-progress",p.onSeekProgress),m._this[e]("duration-change",p.onDurationChange),m._this[e]("controls-toggle",p.onControlsToggle),m._this[e]("fullscreen-change",p.onFullscreenChange),m._this[e]("ready",p.onReady),m._this[e]("destory",p.onDestory),m._this[e]("error",p.onError)},toggleEventListenerGlobal:function(e,t){var l="add"==e?"addEventListener":"removeEventListener";m._this._global_.mobilePlugin.eventStatus=l;!function(){g.mPlayer[l]("touchstart",p.videoScreenTouch),g.menuButton[l]("click",p.onMenuTap),g.toggleFit&&g.toggleFit[l]("click",p.onToggleFit),g.toggleLoop&&g.toggleLoop[l]("click",p.onToggleLoop);for(var e=g.mplayerSidebar instanceof Element?g.mplayerSidebar.querySelectorAll(".play-speed"):[],t=0;t<e.length;t++)e[t][l]("click",p.onPlaySpeed);for(var o=g.mplayerSidebar instanceof Element?g.mplayerSidebar.querySelectorAll(".share-box"):[],t=0;t<o.length;t++)o[t][l]("click",p.onShareBox)}(),"playerReady"==t&&g.lockScreen.addEventListener("click",p.onLockScreenTap),"removeEventListener"==l&&"lockAction"!=t&&p.onAction("remove")}};this.interface=function(n){this._onAgentMpTap=function(e){var t,o,l;i.isLockScreen?(t=new p.toggleControlsDisplay,o=g.mplayerLeft.getBoundingClientRect(),l=g.mPlayer.getBoundingClientRect(),0<o.left-l.left?t.OFF_SideLeft():t.ON_SideLeft()):("click"==e&&m.$method.toggleControlsDisplay(n),"dbclick"==e&&m.$method.onPlayTap({type:"dblscreen"}))},this._onAgentEventAction=function(e){p.onAgentEventAction(e)}},this.appendTemplate=function(e,t){m={},m=t,console.info("loading mui player mobile plugin..."),p.onAction("add");t=(t=o+n+r+a+s).toString().replace(/<!--.*?-->/g,""),t=m.$method.createRangeIsDocFragment(t);return p.initLanguage(t),e.appendChild(t),e.querySelector("#buttom-group").appendChild(m.$method.createRangeIsDocFragment(c)),e.querySelector("#buttom-group").appendChild(m.$method.createRangeIsDocFragment(d)),e=p.initConifgAttribute(e),e=p.initConfigControls(e),e=p.initConfigTheme(e)},this.name="MuiPlayerMobilePlugin"}});