var __loadingIndex = 0;
$(function () {
    //初始化对象
    $("#DeviceMap").baidumap({
        authLocalCity : false,
        style : {
            height : $(window).height() - 20
        },
        defaultCenter: '西安',
        zoom : 6
    }).on('polygonComplete', function (res) {
        //自动搜索完成回调
        layer.close(__loadingIndex);
    });
    
    //搜索指定地方
    // $("#DeviceMap").baidumap('searchLocal','大浪时尚小镇');
    
    //输入框自动完成
    $("#DeviceMap").baidumap('autoComplete','address');
    
    //设置多个数据
    $("#DeviceMap").baidumap('setData', [{
        "lat": 24.4854510,
        "lng": 118.0959950,
        "icon": 'online',
        //"iconUrl": '/img/user5-128x128.jpg',
        content: '<div><i class="fa fa-bank"></i><p>名称:test01</p><p>网络状态:在线</p><p>区域:福建</p><p>线路:厦门南中</p><p>所在点位:厦门南中1' +
        '</p>状态:正常</p></div>'
    },{
        "lat": 30.2789730,
        "lng": 120.1621610,
        "icon": 'online',
        //"iconUrl": '/img/user5-128x128.jpg',
        content: '<div><i class="fa fa-bank"></i><p>名称:test02</p><p>网络状态:在线</p><p>区域:杭州</p><p>线路:杭州xxx</p><p>所在点位:杭州xxxxx' +
        '</p>状态:正常</p></div>'
    }]);    
    
    //设置单个数据
    $("#DeviceMap").baidumap('setData', {
        "lat": 26.0804430,
        "lng": 119.3034040,
        "icon": 'online',
        //"iconUrl": '/img/user5-128x128.jpg',
        content: '<div><i class="fa fa-bank"></i><p>名称:test01</p><p>网络状态:在线</p><p>区域:福建</p><p>线路:厦门南中</p><p>所在点位:厦门南中1' +
        '</p>状态:正常</p></div>'
    });
    
    //创建区域树
    getRegionTree();
});

function getRegionTree() {
    var tree = $.fn.zTree.init($("#regionTree"), {
        data: {
            simpleData: {
                enable: true,
                idKey: "regionId",
                pIdKey: "regionId"
            },
            key: {
                name: "regionName",
                url: "nourl",
            }
        },
        callback : {
            onClick : function (event,treeId,data) {
                __loadingIndex = layer.load();
                $("#DeviceMap").baidumap('getBoundary',data.regionName,8);
            }
        }
    },[{
        regionId : 0,regionName:"行政区域",isParent:true,open:true,children:[
            {
                regionId : 1,parentId:0,regionName:"北京市",isParent:true,children:[
                    {regionId : 2,parentId : 0,regionName:"海淀区",isParent:false},
                    {regionId : 3,parentId : 0,regionName:"朝阳区",isParent:false},
                    {regionId : 4,parentId : 0,regionName:"昌平区",isParent:false}
                ]
            }
        ]
    }]);

}