//---这是一个不涉及任何操作性质的验证输入的控件，它依赖jquery，除此之外不依赖任何js，它仅提供验证，任何具体的提示操作都需要进行配置
//---可以使用默认的配置，也可以随时进行修改
// v:1.02
;
(
	function() {
		//---内部变量
		var msg = {}; //提示文本
		var callBack; //错误时的回调
		var ck = {}; //暴露外界的操作对象
		var errorAlert; //发生异常时的提示函数
		var extendType; //扩展类型
		var Regs = {}; //正则表达式的扩展
		var type = { //用作判断类型的对象，存储所有类型的判断函数
			n: function(p, v) {
				if(v.length != 0) {
					var reg = /^-{0,1}([0-9]+|[0-9]+\.[0-9]+)$/;
					if(!reg.test(v)) {
						return {
							msgType: 'notN',
							type: 'base-n'
						};
					}
				}
				var fun = function(str) {
					var obj = {
						msgType: '',
						type: str[0]
					};
					switch(str[0]) {
						case "int":
							var reg = /^-{0,1}[0-9]*$/;
							if(!reg.test(v)) {
								obj.msgType = "isInt";
								return obj;
							}
							break;
						case "plus":
							var reg = /-/;
							if(reg.test(v)) {
								obj.msgType = "isPositive";
								return obj;
							}
							break;
						case "rg":
							var _str = str[1].split("~");
							var floatNum = parseFloat(v);
							if(_str[0] == "") {
								if(floatNum > parseFloat(_str[1])) {
									obj.n2 = _str[1];
									obj.msgType = "NumRangeMax";
									return obj;
								}
							} else if(_str[1] == "") {
								if(floatNum < parseFloat(_str[0])) {
									obj.n1 = _str[0];
									obj.msgType = "NumRangeMin";
									return obj;
								}
							} else {
								if(floatNum < parseFloat(_str[0]) || floatNum > parseFloat(_str[1])) {
									obj.n1 = _str[0];
									obj.n2 = _str[1];
									obj.msgType = "NumRange";
									return obj;
								}
							}
							break;
						case "il":
							var _str = str[1].split('~');
							var intnum = v.split(".")[0];
							if(_str[0] == "") {
								if(intnum.length > ~~_str[1]) {
									obj.n2 = _str[1];
									obj.msgType = 'IntLengthMax';
									return obj;
								}
							} else if(_str[1] == "") {
								if(intnum.length < ~~_str[0]) {
									obj.n1 = _str[0];
									obj.msgType = 'IntLengthMin';
									return obj;
								}
							} else {
								if(intnum.length > ~~_str[1] || intnum.length < ~~_str[0]) {
									obj.n1 = _str[0];
									obj.n2 = _str[1];
									obj.msgType = 'IntLength';
									return obj;
								}
							}
							break;
						case "fl":
							var _str = str[1].split('~');
							var floatnum = v.split(".")[1] || "";
							if(_str[0] == "") {
								if(floatnum.length > ~~_str[1]) {
									obj.n2 = _str[1];
									obj.msgType = 'FloatLengthMax';
									return obj;
								}
							} else if(_str[1] == "") {
								if(floatnum.length < ~~_str[0]) {
									obj.n1 = _str[0];
									obj.msgType = "FloatLengthMin";
									return obj;
								}
							} else {
								if(floatnum.length > ~~_str[1] || floatnum.length < ~~_str[0]) {
									obj.n1 = _str[0];
									obj.n2 = _str[1];
									obj.msgType = "FloatLength";
									return obj;
								}
							}
							break;
					}
				}
				var df = DefaultCheck(p, v, fun);
				if(df != null) {
					return df;
				}
				return {
					check: true
				}
			},
			e: function(p, v) {
				var reg = /[^a-zA-Z]/;
				if(reg.test(v)) {
					return {
						msgType: 'notE',
						type: 'base-e'
					};
				}
				var fun = function(str) {
					var obj = {
						msgType: '',
						type: str[0]
					};
					switch(str[0]) {
						case "A":
							var reg = /[a-z]/;
							if(reg.test(v)) {
								obj.msgType = "notLowercase";
								return obj;
							}
							break;
						case "a":
							var reg = /[A-Z]/;
							if(reg.test(v)) {
								obj.msgType = 'notCapital';
								return obj;
							}
							break;
					}
					return null;
				}
				var df = DefaultCheck(p, v, fun);
				if(df != null) {
					return df;
				}
				return {
					check: true
				}
			},
			t: function(p, v) {
				var df = DefaultCheck(p, v);
				if(df != null) {
					return df;
				}
				return {
					check: true
				}
			}
		};

		//---内部方法

		function DefaultCheck(p, v, fun) { //内部验证方法，在默认的验证类型中使用
			var obj = {
				msgType: '',
				type: ""
			};
			var ckParam = p[1].trim().substr(1, p[1].length - 2);
			ckParam = ckParam.split(",");
			if(ckParam.indexOf("t") == -1){
				v = v.trim();
			}
			if(ckParam.indexOf("n") == -1 && v.length == 0) {
				obj.type = "n";
				obj.msgType = "notNull";
				return obj;
			}
			for(var i = 0; i < ckParam.length; i++) {
				var str = ckParam[i].split(":");
				obj.type = str[0];
				switch(str[0]) {
					case "n":
						//进行处理，避免浪费性能在遍历上
						break;
					case "reg":
						if(!Regs[str[1]]) {
							errorAlert("没有该正则表达式");
							return null;
						}
						if(!Regs[str[1]].test(v)) {
							obj.msgType = "Reg";
							return obj;
						}
						break;
					case "l":
						var _str = str[1].split("~");
						if(_str[0] == "") {
							if(v.length > ~~_str[1]) {
								obj.n2 = _str[1];
								obj.msgType = "lengthMax";
								return obj;
							}
						} else if(_str[1] == "") {
							if(v.length < ~~_str[0]) {
								obj.n1 = _str[0];
								obj.msgType = "lengthMin";
								return obj;
							}
						} else {
							if(v.length < ~~_str[0] || v.length > ~~_str[1]) {
								obj.n1 = _str[0];
								obj.n2 = _str[1];
								obj.msgType = "lengthMsg";
								return obj;
							}
						}
						break;
					default:
						if(fun) {
							var funResult = fun(str);
							if(funResult) {
								return funResult;
							}
						}
						break;
				}
			}
			return null;
		}

		function getReplace(r, text) { //对提示文本的占位符进行替换处理
			for(var b in r) {
				if(b != "msgType" && b != "type") {
					text = text.replace("{" + b + "}", r[b] || "");
				}
			}
			return text;
		}
		//---唯一暴露的操作函数
		window.$ck = ck;
		ck.data = {}; //验证结果数据
		ck.isAllBack = false; //是否调用全部的验证回调（默认为一个控件没有通过时，其余验证全部暂停）

		ck.check = function(group, obj) {
			ck.data.result = true;
			//---变量列表
			var selector = ""; //额外的选择器
			obj = obj || {};

			var cb = obj.fun || callBack;

			extendType && $.extend(type, extendType); //如果有扩展类型，则在其基础之上进行类型的扩展
			obj.regs && $.extend(Regs, obj.regs); //如果有扩展的正则表达式
			if(group != null && group != "") { //如果有进行分组
				selector += "[data-checkGroup=" + group + "]";
			}

			$(selector + "[data-checkParam]").each(
				function() {
					if(ck.isAllBack || ck.data.result) {
						var str = $(this).attr("data-checkParam");
						var params = str.split("-");

						var result = false;
						if(type[params[0]]) {
							result = type[params[0]](params, $(this).val());
							if(!result.check) {
								var _msg = {};
								var dataKey = $(this).attr("data-checkKey");
								if(obj.msg) {
									if(dataKey) {
										result.key = dataKey;
										_msg.value = obj.msg[result.msgType+"$key"] || msg[result.msgType+"$key"] || obj.msg[result.msgType] || msg[result.msgType];
									}else{
										_msg.value = obj.msg[result.msgType] || msg[result.msgType];
									}
								} else {
									if(dataKey) {
										result.key = dataKey;
										_msg.value = msg[result.msgType+"$key"] || msg[result.msgType];
									}else{
										_msg.value = msg[result.msgType];
									}
								}
								_msg.type = result.type;
								
								_msg.value = getReplace(result, _msg.value);

								if(params.length > 2) {
									cb($(this), params[2], _msg);
								} else {
									cb($(this), "", _msg);
								}
								ck.data.result = false;
							} else {
								if(!ck.isAllBack) { //如果设置了触发所有回调，则结果不会重新设置为真
									ck.data.result = true;
								}
							}
						} else {
							errorAlert("没有对应的扩展");
						}
					}

				}
			);
		};
		ck.setMsg = function(obj) { //设置使用的提示消息，完全替代的操作方式
			msg = obj;
		};
		ck.setFun = function(fun) { //设置使用的回调函数，完全替代的操作方式
			callBack = fun;
		};
		ck.setError = function(fun) { //设置使用的异常提示
			errorAlert = fun;
		}
		ck.extend = function(jsonObj,msgEx) { //扩展类型使用
			extendType = jsonObj;
			msg && $.extend(msg,msgEx);
		}
		ck.setReg = function(regs) {
			Regs = regs;
		}
	}
)();