/**
 * Created by Administrator on 2016/12/9.
 */
(function () {
    window.Bird=Class.extend({
        init:function () {
            this.image=game.imagesObj.bird;
            this.swing=0;
            this.width=this.image.width/3;
            this.height=this.image.height;
            this.x=(game.canvas.width-this.width)/2;
            this.y=100;
            this.ro=25;
            this.state="down";
            this.maxHeight=null;
            this.fly();
            this.dropStartFrame=game.frameUtil.currentFrame;
            this.dieYpoint=0
        },
        update:function () {
            if(game.frameUtil.currentFrame%5==0){
                this.swing++;
                this.swing%=3;
            }
            if(this.state=="down"){
                this.ro++;
                this.y+=0.006*Math.pow(game.frameUtil.currentFrame-this.dropStartFrame,2);
            }
            if(this.state=="fly"){
                this.ro=-25;
                this.y=Math.floor(this.y-(this.y-this.maxHeight)/10);
                if(this.y<=this.maxHeight){
                    this.state="down";
                }
                if(this.y<=0){
                    this.y=0;
                    this.state="down";
                }
                this.dropStartFrame=game.frameUtil.currentFrame;
            }
            if(this.y>game.canvas.height-108){
                this.state="die" ;
            }
            if(this.state=='die'){
                game.house.speed=0;
                game.tree.speed=0;
                game.floor.speed=0;
                for(var i=0;i<game.pipeManager.pipeArr.length;i++){
                    game.pipeManager.pipeArr[i].speed=0;
                }
                game.pipeManager.space=10000;
                if(this.dieYpoint==0){
                    this.dieYpoint =this.y;
                    this.y=-100;
                }
                game.canvas.removeEventListener('click',birdFly)
                game.blood.update();
                game.blood.render();
            }
        },
        render:function () {
            game.ctx.save();
            game.ctx.translate(this.x,this.y);
            game.ctx.rotate((Math.PI/180)*this.ro)
            game.ctx.translate(-this.x,-this.y)
            game.ctx.drawImage(this.image,this.swing*this.width,0,this.width,this.height,this.x,this.y,this.width,this.height)
            game.ctx.restore()
        },
        fly:function () {
            var self=this;
            game.canvas.addEventListener('click',birdFly)
        }
    })
        function birdFly() {
            game.bird.maxHeight=game.bird.y-60;
            game.bird.state="fly";
        }
})()