/**
 * Created by Administrator on 2016/12/8.
 */
(function () {
   window.Game=Class.extend({
       init:function (paramsJson) {
           var self=this;
           this.timer=null;
           this.fps=paramsJson.fps;
           //画布
           this.canvas=document.getElementById(paramsJson.canvasId);
           this.ctx=this.canvas.getContext("2d")
           //Util类
           this.frameUtil=new FrameUtil()
           //静态资源
           //图片资源
           this.imagesObj=null;
           this.static=new StaticResource();
           this.static.imageLoad("staticResource.json",function (alreadyLoad,allLoad,imageObj) {
               if(alreadyLoad==allLoad){
                   self.imagesObj=imageObj;
                   self.run();
               }else{
                   self.ctx.clearRect(0,0,self.canvas.width,self.canvas.height);
                   self.ctx.fillText("正在加载："+alreadyLoad+"of"+allLoad,200,200)
               }
           })
           
       },
       mainloop:function () {
           var self=this;
           this.timer=setInterval(function () {
               self.ctx.clearRect(0,0,self.canvas.width,self.canvas.height);
               self.frameUtil.update();
               self.frameUtil.render();
               self.house.update();
               self.house.render();
               self.tree.update();
               self.tree.render();
               self.floor.update();
               self.floor.render();
               self.pipeManager.update();
               self.pipeManager.render();
               self.bird.update();
               self.bird.render();
               self.score.update();
               self.score.render();
           },1000/this.fps)
       },
       run:function () {
           this.mainloop();
           //背景
           this.house=new Background({
               "image":this.imagesObj.house,
               "x":0,
               "y":140,
           });
           this.tree=new Background({
               "image":this.imagesObj.tree,
               "x":0,
               "y":game.canvas.height-264,
           });
           this.floor=new Background({
               "image":this.imagesObj.floor,
               "x":0,
               "y":game.canvas.height-48,
           })
           this.pipeManager=new PipeManager()
           this.bird=new Bird()
           this.blood=new Blood()
           this.score=new Score()
           // this.setting=new Setting()
       },
       stop:function () {
           clearInterval(this.timer)
       }
   }) 
})()