/* 
 *	时间:2021年1月29日
 * 	作者:dxx(笑笑)
 * 	CSDN:dx_DiabloProgrammer
 * 	名称:dx_placeholder
 * 	描述:自定义文本消息提示，代替文本框中的placeholder，同时不局限与文本框（input）,可与其他插件配合使用。
 * 		本插件可以为单独的一个dom元素添加文本提示，也可以同时为form表单下的多个dom元素添加，局限性小
 * 	兼容:使用过三个存在已久的placeholder插件。如jquery.placeholder.js，在ie8下虽然可以展示要展示的内容，但在ie8下，
 * 		文本框不输入任何值，点击按钮，发送一次请求，该placeholder内容将会被作为参数发送。本插件解决了这一问题。
 */
;(function (jquery) {
    var obj = {
        options: {
            message:'请输入内容',//展示的文字内容
            color:'#ccc',//字体颜色
            zIndex: 3,//字体展示的层级
            left: '10px',//placeholder绝对定位下距离左边的值
            top:0,//placeholder绝对定位下距离上边的值  默认情况下是文本框的高度的一半，在文本位置错乱的情况下需要手动设置
            fontSize: '14px',//字体大小
            height:'',//盒子高度，在盒子位置错乱的情况，可以手动设置该参数(主要针对ie8)   已移除
        },
        init:function (ele,options) {
            /*定义dom元素*/
            var that = ele
            var ele_temp = ele
            /*创建元素*/
            var span = '<span></span>'
            if(options.form) { //是否为表单文本框设置提示信息
                var option_temp = JSON.stringify(obj.options) //深拷贝
                for (var item in options.formOptions) {
                    if(that.find('.'+item).length>0) {
                        ele_temp = that.find('.'+item)
                    } else if (that.find('#'+item).length>0) {
                        ele_temp = that.find('#'+item)
                    } else {
                        // alert('请确保'+item+"元素存在")
                        toastr.error('请确保'+item+"元素存在") //使用自身项目的消息提示
                        return;
                    }
                    options.formOptions[item] = $.extend(JSON.parse(option_temp),options.formOptions[item])
                    obj.show_placeholder(ele_temp,span,options.formOptions[item])
                }
            } else {  //为单个文本框设置提示信息
                obj.show_placeholder(ele_temp,span,options)
            }
        },
        show_placeholder:function(ele,d_ele,options) { //ele:dom元素  d_ele:文本元素
			/*取消元素默认的placeholder属性*/
			ele.attr('placeholder','')
            ele.after(d_ele)
			if(!ele.val()) {
				ele.next().text(options.message)
			}
            var ele_height = ele.outerHeight() //设置dom元素高度
            obj.dom_position(ele,ele.next(),ele_height,options)
            obj.dom_event(ele,ele.next())
        },
        dom_position:function (ele,d_ele,ele_height,options) { //ele:dom元素  d_ele:文本元素
            /*设置父元素为相对定位*/
            if(!ele.parent().is($('body')) && ele.parent().css('position') != 'absolute') {
                ele.parent().css('position','relative')
            }
            var css = {
                position:'absolute',
                left: options.left,
                top: options.top == 0 ? (ele_height/2) + 'px' : options.top,
                color: options.color,
                zIndex: options.zIndex,
                fontSize:options.fontSize,
            }
            d_ele.css(css)
        },
        dom_event:function(ele,d_ele) {  //ele:dom元素  d_ele:文本元素
            ele.on('focus',function () {
                d_ele.hide()
            })
            ele.blur(function () {
                if (!$(this).val()) {
                    d_ele.show()
                }
            })
            d_ele.click(function () {
                $(this).hide()
                ele.focus().click()
            })
        },
    }
	$.fn.dxPlaceholder = function (options) {
	    var newOptions = $.extend(true,{
	        form:false,//是否为表单输入框设置placeholder 默认false,只为单个文本框设置
	        formOptions: {},//存放多个文本框的配置  默认配置项在初始化时配置
	    },obj.options,options)
	    obj.init(this,newOptions)
	}
})(window.jquery)