/*
 * 2017-10-26
 * DDD
 * CFCMVideo 类 
 * 封装video 各个api接口方法
 * */
class CFCMVideo {
	constructor(id) {
		this.id = document.getElementById(id);
		this.listening = function(events, val, fn) {
			var thisid = this.id;
			thisid['on' + events] = function() {
				fn(thisid[val]);
			}
		};
		this.eventsarr = ['progress', 'loadedmetadata', 'timeupdate', 'volumechange'];
	}
	//播放
	play() {
		this.id.play();
	}
	readyState(i) {
		return {
			ind: i,
			state: this.id.readyState
		};
	}
	controls(boolenval) {
		this.id.controls = boolenval;
	}
	mute(flag) {
		this.id.muted = flag;
	}
	progress(fn) {
		this.listening("progress", 'progress', fn);
	}
	pause() {
		this.id.pause();
	}
	playbackRate (num) {
	  this.id.playbackRate = num
	}
	duration(fn) {
		this.listening("loadedmetadata", 'duration', fn);
	}
	timeupdate(fn) {
		this.listening("timeupdate", 'currentTime', fn);
	}
	playtoseconds(num, step) {
		var thisid = this.id;
		if(!num) {
			num = 0;
		}
		if(arguments.length == 2) {
			thisid.currentTime = num + step;
		} else {
//			console.log('currentTime' + num)
			thisid.currentTime = num;
		}
	}
	volumchange(fn) {
		this.listening("volumechange", 'volume', fn);
	}
	volumset(num) {
		this.id.volume = num;
	}
	removelistening() {
		var thisid = this.id;
		for(let i = 0; i < this.eventsarr.length; i++) {
			thisid['on' + this.eventsarr[i]] = null;
		}
	}
}
/*
 * 2017-4-26
 * DDD
 * LocalVideo 类 调用本地视频播放
 * Param:
 * Param @channelnum 频道数量
 * Param @channel 高清频道地址
 * Param @channelB 标清频道地址
 * Param @channelS 超清频道地址
 * Param @channeltitle 频道标题
 * Param @coursename 频道名称
 * Param @coursetitle 课程名称
 * Param @id dom id
 * Param @mainfile 主流
 * Param @durationcount 加载loading计数
 * Param @knowledge 知识点
 * Param @model 高标清
 * Param @playtype infinite/false // 无限循环
 * Param @widhei 初始化宽高
 * Param @voicenum: 2 '默认为50,100位基础值，宽度为两百的时候，倍率为0.5'
 * Param @setchannel: true/false 默认为false，为true是指定通道播放
 * Param @autoplay true/false // 是否自动播放
 * Param @autojump // 初始跳转多少秒开始播放
 * Param @volmchannelopen 音频通道是否允许关闭，开启同时启用
 * Param @slidebackfn //点击进度条回调
 * Param @playbackRate [1] 播放速率
 * Param @playbackRateflag 是否显示播放速率
 * Param @logo {img: '', style: 'width:0;height:30px;left:'} // logo及位置绝对定位
 * Param @font [{time: 10, timeend:12, content: '123'}] 字幕 time 秒
 * Param @fontstyle: ''字幕样式表
 * Param @bigplay: true/false 是否显示中间的播放按钮
 * Param @html5m3u8: true/false // 是否支持M3u8直播
 * Param @hlssrc: '' // hls路径
 * */
class LocalVideo {
	constructor(opt) {
		this.initVal(opt);
	}
	initVal(opt) {
		this.cfg = {};
		let defaultConfig = {
			id: "playerArea",
			Fullscreenid: 'V_fullScreen',
			logo: {img: '', style: ''},
			durationcount: 0,
			fullscreen: false,
			playnowseconds: 0,
			font: [],
			fontstyle: '',
			channel: [],
			channelB: [],
			channelS: [],
			channeltitle: [],
			playtype: false,
			model: [],
			knowledge: [],
			autoplay: false,
			listtopval: 20,
			titleshow: 'block',
			voicenum: 2,
			setchannel: false,
			volmchannelopen: true,
			slidebackfn: false,
			playbackRate: [0.5, 1, 1.25, 1.5, 2, 2.5, 3, 3.5, 4, 4.5, 5],
			playbackRateflag: false,
			bigplay: true,
			html5m3u8: false,
			hlssrc: ''
		}
		Object.assign(this.cfg, defaultConfig, opt);
		
		this.initcommonVal();
	}
	initcommonVal() {
		let cfg = this.cfg;
		//初始化大小计算16/9
		cfg.WH = this.idstyle(cfg.widhei ? cfg.widhei.wid : window.innerWidth, cfg.widhei ? cfg.widhei.hei : window.innerHeight);
		if(this.platformcheck().mobile || (cfg.channelB.length <= 0 && cfg.channel.length <= 0 && cfg.channelS.length <= 0)) {
			// dom操作
			this.domDeal();
			return;
		}
		//单个文件，默认读取第一个
		if(cfg.channelnum == 1) {
			cfg.mainfile[0] = 0;
		}
		for(let item = 0; item < cfg.model.length; item++) {
			if(cfg.model[item] == "高清") {
				cfg.model[item] = {
					type: 'high',
					name: '高清'
				}
			} else if(cfg.model[item] == "标清") {
				cfg.model[item] = {
					type: 'normal',
					name: '标清'
				}
			} else {
				cfg.model[item] = {
					type: 'surper',
					name: '超清'
				}
			}
		}
		if(cfg.setchannel) {
			//初始化静音id
			cfg.mutedid = 'mute_' + cfg.mainfile[0];
		}
		//设置总时长
		cfg.totaltime = cfg.mainfile[1];

		//禁用鼠标右键
		document.oncontextmenu = function() {
			return false
		};
		// dom操作
		this.domDeal();
		//键盘事件
		this.keycode();
		//初始化model高标清按钮显示
		if(cfg.model.length <= 1) {
			this.setStyle(cfg.V_modelcontrol, 'display', 'none');
		}
		//初始化音频通道显示
		if(cfg.channelnum.length <= 1) {
			this.setStyle(cfg.V_volumcontrol, 'display', 'none');
		}
		// resize事件
		this.resize();
	}
	setStyle(obj, type, val) {
		obj.style[type] = val;
	}
	setAttr(obj, type, val) {
		obj.setAttribute(type, val);
	}
	platformcheck() {
		var h5video = !!document.createElement('video').canPlayType;
		var navigatorinfo = navigator.userAgent;
		var mobile = (navigatorinfo.match(/(iPhone|Android|iPad|Mobile|uc)/i));
		var isie11 = navigatorinfo.match(/.(clr)*[rv:]([11.]+)/) != null;
		var isie = navigatorinfo.match(/.(msie)/gi) != null;
		var ischrome = navigatorinfo.match(/.(chrome)/gi) != null;
		var isfirefox = navigatorinfo.match(/.(firefox)/gi) != null;
		let checkres;
		if(mobile) {
			checkres = 'mobile';
		} else if(h5video && !mobile) {
			checkres = 'pch5'
		}
		return {
			ie11: isie11,
			ie: isie,
			checkres: checkres,
			h5video: h5video,
			mobile: mobile,
			firefox: isfirefox,
			chrome: ischrome
		}
	}
	/*
	 * @F11 执行全屏事件 
	 * 
	 * */
	keycode() {
		let _this = this;
		let cfg = this.cfg;
		document.onkeydown = function(e) {
			var ev = e || window.event;
			if(ev.keyCode == "122") { //f11 /esc|| ev.keyCode == "27"
				if(cfg.lock) { //锁定时间标识，如果时间锁定，一秒后才可以生效
					if(!cfg.f11count) {
						cfg.f11count = setTimeout(function() {
							delete cfg.f11secondtime;
							delete cfg.f11time;
							delete cfg.lock;
							clearTimeout(cfg.f11count);
							delete cfg.f11count;
						}, 1000)
					}
					if(ev.preventDefault) {
						ev.preventDefault();
						ev.stopPropagation()
					} else {
						ev.cancelBubble = true;
						ev.returnValue = true;
					}
					return false;
				} else {
					if(cfg.f11time) {
						cfg.f11secondtime = new Date().getTime();
						if((cfg.f11secondtime - cfg.f11time) <= 1000) {
							console.log('您的操作太频繁，请稍后再试!');
							cfg.lock = true;
						}
					} else {
						cfg.f11time = new Date().getTime();
					}
					if(cfg.fullscreen) {
						cfg.fullscreen = false;
					} else {
						cfg.fullscreen = true;
					}
					if(_this.platformcheck().ie11 || _this.platformcheck().ie) {
						//ie下除了ie11,没有全屏事件，为了统一处理，ie下全屏处理为f11全屏
					} else {
						if(ev.preventDefault) {
							ev.preventDefault();
						} else {
							ev.cancelBubble = true;
						}
						cfg.fullscreenObj.click();
					}
				}

			} else if(ev.keyCode == '32') {
				if(_this.getStyle(cfg.V_pause, "display") == "block") {
					cfg.V_pause.click();
				} else {
					cfg.V_play.click();
				}
			} else if(ev.keyCode == '38') {
				//volum+	
				_this.opts('updownvolum', 'add');
			} else if(ev.keyCode == '40') {
				//volum-
				_this.opts('updownvolum', 'subtract');

			}
			//			else if(ev.keyCode == '39') {
			//				//volum+	
			//				_this.opts('jump', cfg.playnowseconds, 'add');
			//			} else if(ev.keyCode == '37') {
			//				//volum-
			//				_this.opts('jump', cfg.playnowseconds, 'subtract');
			//
			//			} 
			else if(ev.keyCode == '123') {
				if(ev.preventDefault) {
					ev.preventDefault();
				} else {
					ev.cancelBubble = true;
				}
				return false;
			}
			//console.log(ev.keyCode)

		}
	}
	/*
	 * @resize 执行一次resize
	 * 
	 */
	resize() {
		var resizePlayer = null;
		var _this = this;
		let cfg = this.cfg;
		if(window.addEventListener) {
			window.onresize = function() {
				if(!(_this.platformcheck().ie11 || _this.platformcheck().ie)) {
					if(!cfg.fullscreen && _this.platformcheck().chrome) {
						return;
					}
				}
				if(resizePlayer) {
					clearTimeout(resizePlayer);
				}
				resizePlayer = setTimeout(function() {
					_this.resizeplayer(_this)

				}, 100);
			}
		}
	}
	/*
	 * @FN resizeplayer resize具体执行操作
	 * @WH 重新计算比例，并修改大小
	 * @FN countcreatevideo :重新计算各个元素大小并赋值
	 * @FN slideRefrash : 重新初始化播放进度条的位置以及控制数据
	 * @FN addknowledge : 重新初始化知识点数据
	 * @FN voiceRefrash : 重新初始化音量条数据及操作
	 */
	resizeplayer(_this) {
		let cfg = _this.cfg;
		if(cfg.WH.wid == screen.width || (cfg.WH.hei + 0) == screen.height) {
			cfg.fullscreen = false;
		}
		if(cfg.fullscreen) {
			//需要全屏
			cfg.WH = _this.idstyle(screen.width, screen.height);
			cfg.fullscreen = true;
		} else {
			delete cfg.fullscreen;
			cfg.WH = _this.idstyle(cfg.widhei ? cfg.widhei.wid : window.innerWidth, cfg.widhei ? cfg.widhei.hei : window.innerHeight);
		}
		var showobjborder = "";
		if(this.platformcheck().mobile) {
			showobjborder = "border-bottom:1px solid #666;"
		}
		_this.setAttr(cfg.showObj, 'style', 'width:' + cfg.WH.wid + 'px;height:' + (cfg.WH.hei - 1) + 'px;' + showobjborder);

		_this.countcreatevideo(cfg.channelnum);

		_this.slideRefrash();

		_this.addknowledge();
		_this.voiceRefrash();
		if(cfg.channelnum == 3 || cfg.channelnum == 2) {
			//三分屏有top值
			// _this.setAttr(cfg.V_control, 'style', "bottom:" + cfg.V_control.previousElementSibling.style.top);
		}
	}
	/*
	 * @FN domDeal 初始化dom操作，插入视频节点，控制条，并计算元素大小
	 * @Param num : 分屏模式
	 * @FN createvideo ： 创建视频节点，并插入
	 * @FN slidedom : 插入控制条，并初始化数据，绑定方法
	 * @FN countcreatevideo : 重新计算各个元素大小并赋值
	 * 
	 */
	domDeal() {
		let cfg = this.cfg;
		let _this = this
		cfg.showObj = this.getid(cfg.id);
		var showobjborder = "";
		if(this.platformcheck().mobile) {
			showobjborder = "border-bottom:1px solid #666;"
		}
		this.setAttr(cfg.showObj, 'style', 'width:' + cfg.WH.wid + 'px;height:' + cfg.WH.hei + 'px;' + showobjborder);
		//		console.log('开始填充dom' + cfg.id + '---'+cfg.channelnum)
		cfg.showObj.innerHTML = this.createvideo(cfg.channelnum);
		if(!this.platformcheck().mobile) {
			this.slidedom();
		}
		this.countcreatevideo(cfg.channelnum);
		if (cfg.html5m3u8) {
			let hlsjs = document.createElement('script')
			hlsjs.setAttribute('id', 'hls')
			hlsjs.setAttribute('src', cfg.hlssrc)
			if (!document.getElementById('hls')){
				document.body.appendChild(hlsjs)
				hlsjs.onload = function() {
					_this.opts('hlsplay')
				}
			}
		}
		if(cfg.channelnum == 3 || cfg.channelnum == 2) {
			//三分屏有top值
			// this.setAttr(cfg.V_control, 'style', "bottom:" + (cfg.V_control.previousElementSibling.style.top ?cfg.V_control.previousElementSibling.style.top  : '0'));
		}
	}
	/*
	 * @FN slidedom 初始化控制条dom操作，并绑定数据
	 * @FN opts('init') : 初始化分屏模式下video对象
	 * @FN opts('duration') : 调用video时长监听，获取总时长信息及加载信息
	 */
	slidedom() {
		let cfg = this.cfg;
		let _this = this
		var appenddom = document.createElement('div');
		this.setAttr(appenddom, 'class', "control");
		this.setAttr(appenddom, 'id', "V_control");
		var html = `
			<div class="play iconfont icon-bofang" id="V_play" style="display: block;"></div>
			<div class="pause iconfont icon-zanting1"  id="V_pause" style="display: none;"></div>
			<div class="nowtime" id="V_nowtime">00:00:00</div>
			<div class="totaltime" id="V_totaltime">00:00:00</div>
			<div class="timeline" id="V_timeline">
			 	<div id="V_playin" class="playin" style="width: 0px;"></div>
			 	<div class="playinbg" id="V_playinbg"></div>
			 </div>
			 <div class="fullScreen iconfont icon-a" id="${cfg.Fullscreenid}" title="F11进入ie全屏或退出全屏"></div>
			 <div class="scroll" id="V_scroll" volumval="50">
				 <div class="scrollson" id="V_scrollson" style="left: 25px;"></div>
				 <div class="scrollsonbg" id="V_scrollsonbg" style="width: 25px;"></div>
			 </div>
			
			 <div class="volum iconfont icon-yinliangkai" id="V_volum"></div>
			
			<div class="modelcontrol" id="V_modelcontrol">
				<div class="title">清晰度</div>
				<div class="modelcontrollist" id="V_modelcontrollist"></div>
			</div>
			<div class="volumcontrol" id="V_volumcontrol">
				<div class="title">声音通道</div>
				<div class="volumcontrollist" id="V_volumcontrollist"></div>
			</div>
			<div class="playcontrol" id="V_playcontrol" style="display: ${cfg.playbackRateflag ? 'block' : 'none'}">
				<div class="title">播放倍率</div>
				<div class="playcontrollist" id="V_playcontrollist"></div>
			</div>
		`
		appenddom.innerHTML = html;
		this.getid(cfg.id).appendChild(appenddom);
		if (cfg.bigplay) {
		    var bigplaydom = document.createElement('div');
			this.setAttr(bigplaydom, 'class', "bigplay iconfont icon-video");
			this.setAttr(bigplaydom, 'id', "bigplay");
			this.getid(cfg.id).appendChild(bigplaydom);
			cfg.bigplayobj = this.getid('bigplay')
		}
		if (cfg.logo.img) {
			let logo = document.createElement('img')
			logo.setAttribute('class', 'playlogo')
			logo.setAttribute('src', cfg.logo.img)
			logo.setAttribute('style', cfg.logo.style)
			this.getid(cfg.id).appendChild(logo);
		}
		if (cfg.font.length > 0) {
		  let font = document.createElement('div')
		  font.setAttribute('id', 'font')
		  font.setAttribute('class', 'font')
		  font.setAttribute('style', cfg.fontstyle)
		  this.getid(cfg.id).appendChild(font);
		  cfg.fontobj = this.getid('font')
		}
		//		this.getid(cfg.id).appendChild(bigplaydom);

		cfg.fullscreenObj = this.getid(cfg.Fullscreenid);
		cfg.V_control = this.getid('V_control');
		cfg.V_modelcontrol = this.getid('V_modelcontrol');
		cfg.V_modelcontrollist = this.getid('V_modelcontrollist');
		if (cfg.playbackRateflag) {
		  cfg.V_playcontrol = this.getid('V_playcontrol');
		  cfg.V_playcontrollist = this.getid('V_playcontrollist');
		}
		cfg.V_volum = this.getid('V_volum');
		cfg.V_volumcontrol = this.getid('V_volumcontrol');
		cfg.V_play = this.getid('V_play');
		cfg.V_pause = this.getid('V_pause');
		cfg.V_nowtime = this.getid('V_nowtime');
		cfg.V_totaltime = this.getid('V_totaltime');
		cfg.V_timeline = this.getid('V_timeline');
		cfg.V_playin = this.getid('V_playin');
		cfg.V_playinbg = this.getid('V_playinbg');
		cfg.V_scroll = this.getid('V_scroll');
		cfg.V_scrollson = this.getid('V_scrollson');
		cfg.V_scrollsonbg = this.getid('V_scrollsonbg');
		cfg.V_volumcontrollist = this.getid('V_volumcontrollist');
		this.getid(cfg.id).onmouseenter = function() {
			cfg.V_control.style.height = "40px"
			cfg.V_control.style.overflow = "visible"
			_this.showhide('block')
		}
		this.getid(cfg.id).onmouseleave = function() {
			cfg.V_control.style.height = "0px"
			cfg.V_control.style.overflow = "hidden"
			_this.showhide('none')
			let flag = _this.getStyle(cfg.V_volumcontrollist, "display");
			if(flag == "block") {
				_this.setStyle(cfg.V_volumcontrollist, 'display', 'none');
			}
			let flagmodel = _this.getStyle(cfg.V_modelcontrollist, "display");
			if(flagmodel == "block") {
				_this.setStyle(cfg.V_modelcontrollist, 'display', 'none');
			}
		}
		this.opts('init');
		this.opts('duration');

	}
	/*
	 * @FN showhide 列表标题
	 */
	showhide(display) {
		let cfg = this.cfg
		let listobj = this.getid(cfg.id).querySelectorAll('.outtitle')
		Array.prototype.slice.call(listobj).forEach(function(item) {
			item.style.display = display
		})
	}
	/*
	 * @FN addknowledge 初始化知识点
	 */
	addknowledge() {
		let cfg = this.cfg;
		var oneseconds = cfg.WH.wid / parseInt(cfg.mainfile[1]); //每秒代表的实际距离
		var html = '';
		var knowledge = cfg.knowledge;
		for(let i = 0; i < knowledge.length; i++) {
			let leftwid = oneseconds * (this.timetoseconds(knowledge[i].time));
			//			html += '<div class="knowledge" style="left:' + leftwid + 'px;"><span class="time">时间：' + knowledge[i].time + '</span><span class="content">内容：' + knowledge[i].content + '</span></div>'
			html += '<div class="knowledge"  style="left:' + leftwid + 'px;"><div class="knowledgehover"><span class="content">' + knowledge[i].content + '</span></div></div>'
		}
		cfg.V_playinbg.innerHTML = html;
		let knowledgeobj = cfg.V_playinbg.querySelectorAll('.knowledge')
		Array.prototype.slice.call(knowledgeobj).forEach(function(item) {
			item.onmouseenter = function(e) {
				var ev = e || window.event;
				this.style.overflow = 'visible'
			};
			item.onmouseleave = function(e) {
				var ev = e || window.event;
				this.style.overflow = 'hidden'
			};
		})
	}
	/*
	 * @FN videoopt 绑定控制条事件函数
	 * @FN slideRefrash ： 绑定或者更新播放进度条数据及事件
	 * @Param cfg.V_play : 播放(如果切换高标清，需要跳转到当前播放位置，并充值切换开关)
	 * @Param cfg.V_pause : 暂停
	 * @Param cfg.V_model : 高标清切换(添加loading图标，去除error图标，替换url,重新实例化video对象，加载调用，跳转到当前播放位置)
	 * @Param cfg.V_volumcontrol : 音频控制台
	 * @Param cfg.V_volum : 静音按钮
	 * @Param cfg.fullscreenObj : 全屏按钮
	 * @FN voiceRefrash : 音量条事件 
	 */
	videoopt() {
		var _this = this;
		let cfg = this.cfg;

		cfg.V_play.onclick = function() {
			_this.opts('play');
			if(cfg.modeltypechange) {
				_this.opts('jump', cfg.playnowseconds);
				cfg.modeltypechange = false;
			}
			_this.setStyle(this, 'display', 'none');
			_this.setStyle(cfg.V_pause, 'display', 'block');
		}
		cfg.V_pause.onclick = function() {
			_this.opts('pause');
			_this.setStyle(this, 'display', 'none');
			_this.setStyle(cfg.V_play, 'display', 'block');

		}
		if (cfg.bigplay) {
			cfg.bigplayobj.onclick = function(){
//				console.log('点击')
				cfg.V_play.click()
			}
		}
		if(cfg.model.length > 1) {
			cfg.V_modelcontrol.onclick = function(e) {
				let ev = e || window.event;
				if(ev.preventDefault) {
					ev.preventDefault();
					ev.stopPropagation();
				} else {
					ev.cancelBubble = true;
					ev.returnValue = false;
				}
				let flag = _this.getStyle(cfg.V_modelcontrollist, "display");
				if(flag == "none") {
					_this.setStyle(cfg.V_modelcontrollist, 'display', 'block');
				} else {
					_this.setStyle(cfg.V_modelcontrollist, 'display', 'none');
				}
			}

		}
		if (cfg.playbackRateflag) {
			cfg.V_playcontrol.onclick = function(e) {
				let ev = e || window.event;
				if(ev.preventDefault) {
					ev.preventDefault();
					ev.stopPropagation();
				} else {
					ev.cancelBubble = true;
					ev.returnValue = false;
				}
				let flag = _this.getStyle(cfg.V_playcontrollist, "display");
				if(flag == "none") {
					_this.setStyle(cfg.V_playcontrollist, 'display', 'block');
				} else {
					_this.setStyle(cfg.V_playcontrollist, 'display', 'none');
				}
			}
		}
		
		cfg.V_volumcontrol.onclick = function(e) {
			let ev = e || window.event;
			if(ev.preventDefault) {
				ev.preventDefault();
				ev.stopPropagation();
			} else {
				ev.cancelBubble = true;
				ev.returnValue = false;
			}
			let flag = _this.getStyle(cfg.V_volumcontrollist, "display");
			if(flag == "none") {
				_this.setStyle(cfg.V_volumcontrollist, 'display', 'block');
			} else {
				_this.setStyle(cfg.V_volumcontrollist, 'display', 'none');
			}
		}
		cfg.V_volum.onclick = function() {
			var flag = this.className.indexOf('icon-yinliangkai');
			var volumval = parseInt(cfg.V_scroll.getAttribute('volumval'));
			if(flag < 0) { //取消静音
				//			console.log(flag, '取消静音')
				_this.setAttr(cfg.V_scrollsonbg, 'style', "width:" + volumval / cfg.voicenum + 'px');
				_this.setAttr(cfg.V_scrollson, 'style', "left:" + volumval / cfg.voicenum + 'px');
				_this.opts('volum', volumval / 100, cfg.mutedid.split('_')[1]);
				_this.setAttr(_this.getid(cfg.mutedid), 'class', "mute selected iconon iconfont icon-yinliangkai");
				this.className = this.className.replace(/(icon-yinliangguan)/gi, 'icon-yinliangkai')
			} else { //静音了
				//				console.log(flag, '静音了')
				if(cfg.V_volumcontrollist.querySelector('.iconon')) {
					cfg.mutedid = cfg.V_volumcontrollist.querySelector('.iconon').getAttribute("id");
					_this.setAttr(cfg.V_volumcontrollist.querySelector('.iconon'), 'class', "mute iconoff iconfont icon-yinliangguan");
				}
				this.className = this.className.replace(/(icon-yinliangkai)/gi, 'icon-yinliangguan')
				_this.setAttr(cfg.V_scrollsonbg, 'style', 'width:0px');
				_this.setAttr(cfg.V_scrollson, 'style', 'left:0px');
				_this.opts('volum', 0);
			}
		}
		cfg.fullscreenObj.onclick = function() {
			if(_this.platformcheck().ie11 || _this.platformcheck().ie) {
				return false;
			}
			let flag = this.className.indexOf('icon-a');
			if(flag >= 0) {
				cfg.fullscreen = true;
				_this.FullScreen(cfg.showObj);
				_this.setAttr(this, 'class', 'outfullScreen iconfont icon-quanpingtuichu');
			} else {
				cfg.fullscreen = false;
				_this.CancelFullScreen();
				_this.setAttr(this, 'class', 'fullScreen iconfont icon-a');
				_this.resizeplayer(_this);
			}
		}
		//音量控制
		this.voiceRefrash();
		document.addEventListener && (document.addEventListener('webkitfullscreenchange', function() {
				_this.escFullScreen();
			}, false) ||
			document.addEventListener('mozfullscreenchange', function() {
				_this.escFullScreen();
			}, false) ||
			document.addEventListener('fullscreenchange', function() {
				_this.escFullScreen();
			}, false) ||
			document.addEventListener('webkitfullscreenchange', function() {
				_this.escFullScreen();
			}, false));
		document.attachEvent && document.attachEvent('msfullscreenchange', function() {
			_this.escFullScreen();
		});
	}
	/*
	 * @FN voiceRefrash 音量控制
	 */
	voiceRefrash() {
		//音量控制
		var _this = this;
		let cfg = this.cfg;
		var volumflag = false;
		
		cfg.V_scroll.onmousedown = function(e) {
			var volumx = _this.getoffset(cfg.V_scroll).left+ document.documentElement.scrollLeft;
			//不考虑出现滚动条的情况
			//			var ev = e || window.event;
			var movex = 0;
			var mouseupx = 0;
			volumflag = true;
			if(volumflag) {
				document.onmousemove = function(e) {
					var ev = e || window.event;
					movex = (ev.pageX || ev.clientX) + (document.documentElement.scrollLeft || document.body.scrollLeft);
					var volumlen = (movex - volumx) > 100 / cfg.voicenum ? 100 / cfg.voicenum : (movex - volumx);
					volumlen = volumlen <= 0 ? 0 : volumlen;
					_this.setAttr(cfg.V_scrollsonbg, 'style', "width:" + volumlen + "px");
					_this.setAttr(cfg.V_scrollson, 'style', "left:" + volumlen + "px");
					_this.setAttr(cfg.V_scroll, 'volumlen', volumlen * cfg.voicenum);
					_this.opts('volum', volumlen / (100 / cfg.voicenum), cfg.mutedid.split('_')[1]);
					if(volumlen == 0) {
						_this.setAttr(cfg.V_volum, 'class', "volum iconfont icon-yinliangguan");
					} else {
						_this.setAttr(cfg.V_volum, 'class', "volum iconfont icon-yinliangkai");
					}
				}
				document.onmouseup = function(e) {
					var ev = e || window.event;
					if(volumflag) {
						document.onmousemove = null;
						mouseupx = (ev.pageX || ev.clientX)+ (document.documentElement.scrollLeft || document.body.scrollLeft);
						var volumlen = (mouseupx - volumx) > 100 / cfg.voicenum ? 100 / cfg.voicenum : (mouseupx - volumx);
						volumlen = volumlen <= 0 ? 0 : volumlen;
						_this.opts('volum', volumlen / (100 / cfg.voicenum), cfg.mutedid.split('_')[1]);
						_this.setAttr(cfg.V_scrollsonbg, 'style', "width:" + volumlen + "px");
						_this.setAttr(cfg.V_scrollson, 'style', "left:" + volumlen + "px");
						_this.setAttr(cfg.V_scroll, 'volumval', volumlen * cfg.voicenum);
						if(volumlen == 0) {
							_this.setAttr(cfg.V_volum, 'class', "volum iconfont icon-yinliangguan");
						} else {
							_this.setAttr(cfg.V_volum, 'class', "volum iconfont icon-yinliangkai");
						}
					}
					volumflag = false;
				}
			}
		}
	}
	/*
	 * @FN voiceRefrash 播放进度条控制
	 */
	slideRefrash() {
		var _this = this;
		let cfg = this.cfg;
		var duration = parseInt(cfg.mainfile[1]);
		var oneseconds = duration / cfg.WH.wid;
		_this.setAttr(cfg.V_playin, "style", "width:" + (cfg.playnowseconds / oneseconds).toFixed(2) + "px");
		this['videobj_' + cfg.nowchannelnum].timeupdate(function(now) {
			//		    console.log(now, '-----------')
			cfg.V_nowtime.innerHTML = _this.timeformcat(parseInt(now));
			if (cfg.font.length > 0) {
			  // 字幕匹配
			  for (let item = 0; item < cfg.font.length; item++) {
			    if (parseInt(now) >= cfg.font[item].time && parseInt(now) <= cfg.font[item].timeend) {
			      cfg.fontobj.innerHTML = cfg.font[item].content
			      break
			    } else {
			      cfg.fontobj.innerHTML = ''
			    }
			  }
			}
			var widlen = now / oneseconds;
			_this.setAttr(cfg.V_playin, "style", "width:" + widlen.toFixed(2) + "px");
			if(cfg.playnowseconds > parseInt(now)) {
				_this.opts('jump', cfg.playnowseconds);
				cfg.playnowseconds = parseInt(now);
			} else if(parseInt(now) == duration) {
				cfg.playnowseconds = 0;
				_this.opts('jump', 0);
//				console.log(cfg.playtype, 'cfg.playtype')
				if(cfg.playtype !== 'infinite') { // 无限循环
					cfg.V_pause.click();
				}
			} else {
				cfg.playnowseconds = parseInt(now);
			}

		})
		this.slideoptRefrash();
	}
	/*
	 * @FN voiceRefrash 播放进度条点击拖拽控制
	 */
	slideoptRefrash() {
		let _this = this;
		let cfg = this.cfg;
		//播放进度控制
		var downflag = false;
		var wid = cfg.WH.wid;
		var duration = cfg.mainfile[1] * 1;
		var oneseconds = duration / wid;
		
		cfg.V_timeline.onmousedown = function(e) {
			//不考虑出现滚动条的情况
			//			var ev = e || window.event;
			//			var downx = ev.pageX || ev.clientX;
			var timelinex = _this.getoffset(cfg.showObj).left + (document.documentElement.scrollLeft || document.body.scrollLeft)
			var movex = 0;
			var mouseupx = 0;
			downflag = true;
			if(downflag) {
				document.onmousemove = function(e) {
					var ev = e || window.event;
					movex = (ev.pageX || ev.clientX)+ (document.documentElement.scrollLeft || document.body.scrollLeft);
					var timewid = parseInt((movex  - timelinex) * oneseconds);
					_this.setAttr(cfg.V_playin, "style", "width:" + (movex - timelinex) + "px");
					cfg.playnowseconds = timewid;
					_this.opts('jump', timewid);
				}
				document.onmouseup = function(e) {
					var ev = e || window.event;
					if(downflag) {
						document.onmousemove = null;
						mouseupx = (ev.pageX || ev.clientX)+ (document.documentElement.scrollLeft || document.body.scrollLeft);
						var timewid = parseInt((mouseupx - timelinex) * oneseconds);
						_this.setAttr(cfg.V_playin, "style", "width:" + (mouseupx - timelinex) + "px");
						cfg.playnowseconds = timewid;
						_this.opts('jump', timewid);
						if (typeof cfg.slidebackfn === 'function') {
						  cfg.slidebackfn(cfg.playnowseconds)
						}
					}
					downflag = false;
				}
			}
		}
	}
	/*
	 * @FN timeformcat 格式化时分秒
	 */
	timeformcat(total) { //格式化时分秒
		var hour = parseInt(total / 3600);
		var minutes = parseInt((total - hour * 3600) / 60);
		var seconds = parseInt(total - hour * 3600 - minutes * 60);
		return(hour < 10 ? ("0" + hour) : hour) + ":" + (minutes < 10 ? ("0" + minutes) : minutes) + ":" + (seconds < 10 ? ("0" + seconds) : seconds);
	}
	/*
	 * @FN timetoseconds 格式化时分秒
	 */
	timetoseconds(time) {
		var obj = time.split(':');
		var hour = obj[0] * 3600;
		var minutes = obj[1] * 60;
		var seconds = obj[2] * 1;
		return hour + minutes + seconds
	}
	/*
	 * @FN getid 
	 */
	getid(id) {
		return document.getElementById(id);
	}
	/*
	 * @FN appendvideo  填充dom
	 */
	appendvideo(html, num) {
		let cfg = this.cfg;
		for(var i = 0; i < num; i++) {
			html += '<div class="list"  id=list_' + i + '  >';
			html += '<div class="error"></div>';
			html += '<div class="loading" style="display:' + (this.platformcheck().mobile ? "none" : "block") + '"></div>';
			html += '<div class="title outtitle" style="display:' + cfg.titleshow + '">' + cfg.channeltitle[i] + '</div>';
			if(typeof cfg.model[0] == 'object') {
				if(cfg.model[0].type === 'normal') {
					cfg.defaultmodel = 'normal'
					html += '<video width="100%"  height="100%" ' + (this.platformcheck().mobile ? "controls=controls" : "") + '  id="video_' + i + '"   type="video/mp4" src=' + cfg.channelB[i] + '>对不起，您的浏览器不支持video播放!</video>';
				} else if(cfg.model[0].type === 'high') {
					cfg.defaultmodel = 'high'
					html += '<video width="100%"  height="100%" ' + (this.platformcheck().mobile ? "controls=controls" : "") + '  id="video_' + i + '"   type="video/mp4" src=' + cfg.channel[i] + '>对不起，您的浏览器不支持video播放!</video>';
				} else if(cfg.model[0].type === 'super') {
					cfg.defaultmodel = 'super'
					html += '<video width="100%"  height="100%" ' + (this.platformcheck().mobile ? "controls=controls" : "") + '  id="video_' + i + '"   type="video/mp4" src=' + cfg.channelS[i] + '>对不起，您的浏览器不支持video播放!</video>';
				}
			} else {
				// 默认标清
				html += '<video width="100%"  height="100%" ' + (this.platformcheck().mobile ? "controls=controls" : "") + '  id="video_' + i + '"   type="video/mp4" src=' + cfg.channelB[i] + '>对不起，您的浏览器不支持video播放!</video>';
			}
			html += '</div>';
		}
		//		console.log(html, 'html from appendvideo')
		return html
	}
	/*
	 * @FN createvideo  填充dom
	 */
	createvideo(num) {
		//		console.log('num--------------------------'+num)
		var html = '';
		switch(num) {
			case 1:
			case 2:
			case 3:
			case 4:
				html = this.appendvideo(html, num);
				break;
			case 5:
			case 6:
				//增加一个补位元素
				var addLostDom = document.createElement("div");
				this.setAttr(addLostDom, "class", "videopartLostDom");
				html = this.appendvideo(html, num);
				if(num == 5) {
					html += '<div class="nosingal"  id=list_' + 5 + '   >NOSINGAL</div>';
				}
				break;
			case 7:
			case 8:
			case 9:
				html = this.appendvideo(html, num);
				if(num == 7) {
					html += '<div class="nosingal" id=list_' + 7 + '   >NOSINGAL</div>';
					html += '<div class="nosingal"  id=list_' + 8 + '  >NOSINGAL</div>';
				}
				if(num == 8) {
					html += '<div id=list_' + 8 + ' class="nosingal" >NOSINGAL</div>';
				}
				break;
		}
		//		console.log(html, '-------------')
		return html;
	}
	/*
	 * @FN countcreatevideo  计算大小
	 */
	countcreatevideo(num) {
		let cfg = this.cfg;
		if(!this.platformcheck().mobile) {
			cfg.WH.hei = cfg.WH.hei //  - this.getid('V_control').clientHeight;
		} else {
			cfg.WH.hei = cfg.WH.hei;
		}
		switch(num) {
			case 1:
				this.setAttr(this.getid('list_0'), 'style', 'width:' + (cfg.WH.wid - 2) + 'px;height:' + (cfg.WH.hei - 2) + 'px');
				break;
			case 2:
				var thiswid = parseInt(cfg.WH.wid / 2) - 2;
				var thishei = parseInt(cfg.WH.hei / 2) - 2;
				var border, wid;
				for(var i = 0; i < num; i++) {
					if(i == 0) {
						border = "border-right:none;border-bottom:1px solid #666;";
						wid = thiswid + 1;
					} else {
						border = 'border-bottom:1px solid #666;';
						wid = thiswid;
					}
					this.setAttr(this.getid('list_' + i), 'style', border + 'width:' + wid + 'px;height:' + thishei + 'px;top:' + parseInt((cfg.WH.hei - thishei) / 2 - cfg.listtopval) + 'px');
				}
				break;
			case 3:
				var thiswid = parseInt(cfg.WH.wid / 3);
				var thishei = parseInt(cfg.WH.hei / 2);
				let hei = parseInt((cfg.WH.hei - thishei * 2) / 2);
				for(var i = 0; i < num; i++) {
					if(i == 0) {
						this.setAttr(this.getid('list_' + i), 'style', 'border-right:none;width:' + (thiswid * 2 - 1) + 'px;height:' + thishei * 2 + 'px;top:' + hei + 'px');
					} else if(i == 1) {
						this.setAttr(this.getid('list_' + i), 'style', 'border-bottom:none;width:' + (thiswid - 2) + 'px;height:' + thishei + 'px;top:' + hei + 'px');
					} else {
						this.setAttr(this.getid('list_' + i), 'style', 'width:' + (thiswid - 2) + 'px;height:' + (thishei - 1) + 'px;top:' + hei + 'px');
					}
				}
				break;
			case 4:
				var thiswid = parseInt(cfg.WH.wid / 2) - 2;
				var thishei = parseInt(cfg.WH.hei / 2) - 2;
				var thiswid1 = thiswid + 1;

				for(var i = 0; i < num; i++) {
					var border = '';
					if(i == 0) {
						border = "border-right:none;border-bottom:none;";
						this.setAttr(this.getid('list_' + i), 'style', border + 'width:' + thiswid1 + 'px;height:' + thishei + 'px;');

					} else if(i == 1) {
						border = "border-bottom:none;";
						this.setAttr(this.getid('list_' + i), 'style', border + 'width:' + thiswid + 'px;height:' + thishei + 'px;');
					} else if(i == 2) {
						border = "border-right:none;";
						this.setAttr(this.getid('list_' + i), 'style', border + 'width:' + thiswid1 + 'px;height:' + thishei + 'px;');
					} else {
						this.setAttr(this.getid('list_' + i), 'style', border + 'width:' + thiswid + 'px;height:' + thishei + 'px;');
					}
				}
				break;
			case 5:
			case 6:
				var thiswid = parseInt(cfg.WH.wid / 3);
				var thishei = parseInt(cfg.WH.hei / 3);
				//增加一个补位元素
				var addLostDom = document.createElement("div");
				this.setAttr(addLostDom, "class", "videopartLostDom");
				for(var i = 0; i < num; i++) {
					if(i == 0) {
						this.setAttr(this.getid('list_' + i), 'style', 'width:' + (thiswid * 2 - 1) + 'px;height:' + (thishei * 2 - 1) + 'px;border-right:none;border-bottom:none;');
					} else if(i == 1) {
						this.setAttr(this.getid('list_' + i), 'style', 'width:' + (thiswid - 2) + 'px;height:' + (thishei - 1) + 'px;border-bottom:none;');

					} else if(i == 2) {
						this.setAttr(this.getid('list_' + i), 'style', 'width:' + (thiswid - 2) + 'px;height:' + (thishei - 1) + 'px;border-bottom:none;');

					} else if(i == 3) {
						this.setAttr(this.getid('list_' + i), 'style', 'width:' + (thiswid - 2) + 'px;margin-right:' + (cfg.WH.wid - thiswid * 3) + 'px;height:' + (thishei - 1) + 'px;float:right;border-left:none;');

					} else if(i == 4) {
						this.setAttr(this.getid('list_' + i), 'style', 'width:' + (thiswid - 2) + 'px;height:' + (thishei - 1) + 'px;float:right;');

					} else if(i == 5) {
						this.setAttr(this.getid('list_' + i), 'style', 'width:' + (thiswid - 1) + 'px;height:' + (thishei - 1) + 'px;border-right:none;');
					}
				}
				if(num == 5) {
					this.setAttr(this.getid('list_' + 5), 'style', 'border-right:none;width:' + (thiswid - 1) + 'px;height:' + (thishei - 1) + 'px;line-height:' + thishei + 'px;text-align:center;color:#fff');
				}
				break;
			case 7:
			case 8:
			case 9:
				var thiswid = parseInt(cfg.WH.wid / 3) - 2;
				var thishei = parseInt(cfg.WH.hei / 3) - 1;
				var thiswid1 = thiswid + 1;
				for(var i = 0; i < num; i++) {
					var border;
					if(i == 0 || i == 1 || i == 3 || i == 4 || i == 6 || i == 7) {
						border = "border-right:none;";
						this.setAttr(this.getid('list_' + i), 'style', border + 'width:' + thiswid1 + 'px;height:' + thishei + 'px;');
					} else {
						border = '';
						this.setAttr(this.getid('list_' + i), 'style', border + 'width:' + thiswid + 'px;height:' + thishei + 'px;');
					}
				}
				if(num == 7) {
					this.setAttr(this.getid('list_' + 7), 'style', 'border-right:none;width:' + thiswid1 + 'px;float:left;height:' + thishei + 'px;line-height:' + thishei + 'px;text-align:center;color:#fff');
					this.setAttr(this.getid('list_' + 8), 'style', 'width:' + thiswid + 'px;float:left;height:' + thishei + 'px;line-height:' + thishei + 'px;text-align:center;color:#fff');
				}
				if(num == 8) {
					this.setAttr(this.getid('list_' + 8), 'style', 'width:' + thiswid + 'px;float:left;height:' + thishei + 'px;line-height:' + thishei + 'px;text-align:center;color:#fff');
				}
				break;
		}
	}
	/*
	 * @FN getStyle  获取样式表属性
	 */
	getStyle(el, name) {　　
		if(window.getComputedStyle) {　　　
			return window.getComputedStyle(el, null)[name];　　
		} else {　　　
			return el.currentStyle[name];　　
		}
	}
	/*
	 * @FN getoffset  获取样式表相对位置
	 */
	getoffset(Node, offset) {
		if(Node == null) { //当该节点为body节点时，结束递归
			return offset;
		}
		if(!offset) {
			offset = {};
			offset.top = 0;
			offset.left = 0;
		}
		var nodeposition = this.getStyle(Node, 'position');
		if(nodeposition == "absolute" || nodeposition == "relative") {
			if(Node.getBoundingClientRect && navigator.userAgent.toLowerCase().match(/.(msie)/) != null) {
				offset.top += Node.getBoundingClientRect.top;
				offset.left += Node.getBoundingClientRect.left;
				return offset;
			} else {
				offset.top += Node.offsetTop;
				offset.left += Node.offsetLeft;
			}
		} else {
			offset.top += 0;
			offset.left += 0;
		}
		return this.getoffset(Node.parentElement, offset); //向上累加offset里的值
	}
	/*
	 * @FN idstyle  计算16/9大小
	 */
	idstyle(wid, hei) {
		var obj = {},
			temp = hei;
		//以宽度为依据,计算比例
		if(wid * 0.5625 > hei) { //以高度逆算宽度
			if(hei / 0.5625 <= wid) {
				obj.hei = hei;
				obj.wid = parseInt(hei / 0.5625);
			} else {
				temp = temp - 10;
				//不作处理throw new error("浏览器当前宽高不适合预览,请重置!")
				this.idstyle(wid, temp);
			}
		} else {
			obj.hei = parseInt(wid * 0.5625);
			obj.wid = wid;
		}
		return obj;
	}
	/*V_playcontrollist
	 * @FN channelplayEvent  播放速率列表点击事件
	 */
	channelplayEvent(param) {
		let _this = this;
		let cfg = this.cfg;
		let listlen = param.querySelectorAll('.modelspan');
		Array.prototype.slice.call(listlen).forEach(function(item, ind) {
			item.addEventListener("click", function(e) {
				let ev = e || window.event;
				if(ev.preventDefault) {
					ev.preventDefault();
					ev.stopPropagation();
				} else {
					ev.cancelBubble = true;
					ev.returnValue = false;
				}
				param.querySelector('.selected').setAttribute('class', 'modelspan')
				let flag = this.textContent * 1;
				this.setAttribute('class', 'modelspan selected')
				_this.opts("playbackRate", flag);
			}, false)
		})
	}
	/*V_modelcontrollist
	 * @FN channelmodelEvent  通道列表点击事件
	 */
	channelmodelEvent(param) {
		let _this = this;
		let cfg = this.cfg;
		let listlen = param.querySelectorAll('.modelspan');
		Array.prototype.slice.call(listlen).forEach(function(item, ind) {
			item.addEventListener("click", function(e) {
				let ev = e || window.event;
				if(ev.preventDefault) {
					ev.preventDefault();
					ev.stopPropagation();
				} else {
					ev.cancelBubble = true;
					ev.returnValue = false;
				}
				_this.opts("removelistening");
				param.querySelector('.selected').setAttribute('class', 'modelspan')
				cfg.V_pause.click();
				_this.opts('loading', 'block');
				_this.opts('error', 'none');
				let flag = this.getAttribute("type");
				if (cfg.html5m3u8) {
				  _this.opts('hlsplay');
				} else {
					if(flag == "normal") {
						cfg.defaultmodel = 'normal'
						_this.opts("urlreplace", cfg.channelB);
					} else if(flag == "super") {
						cfg.defaultmodel = 'super'
						_this.opts("urlreplace", cfg.channelS);
					} else {
						cfg.defaultmodel = 'high'
						_this.opts("urlreplace", cfg.channel);
					}
				}
				
				cfg.durationcount = 0;
				_this.opts('init');
				_this.opts('duration', 'jump');
				//切换流地址，跳转时间，播放
			}, false)
		})
	}
	/*
	 * @FN channelmuteEvent  音频列表点击事件
	 */
	channelmuteEvent(param) {
		let _this = this;
		let cfg = this.cfg;
		let listlen = param.querySelectorAll('.mute');
		let volumval = cfg.V_scroll.getAttribute("volumval")
		Array.prototype.slice.call(listlen).forEach(function(item, ind) {
			item.addEventListener("click", function(e) {
				let ev = e || window.event;
				if(ev.preventDefault) {
					ev.preventDefault();
					ev.stopPropagation();
				} else {
					ev.cancelBubble = true;
					ev.returnValue = false;
				}
//				console.log('mute 点击事件')
				let flag = this.getAttribute("class");
				cfg.mutedid = this.getAttribute('id');
				if (cfg.volmchannelopen) { // 点击及开启,并关闭其他
				  	_this.setAttr(this, "class", "mute selected iconon iconfont icon-yinliangkai");
					_this.opts('volum', volumval / 100, ind);
				} else {
				  if(flag.match(/(iconon)/gi) != null) {
					//					console.log('mute_静音')
						_this.setAttr(this, "class", "mute iconoff iconfont icon-yinliangguan");
						cfg.V_volum.click();
					} else {
						//					console.log('mute_取消静音')
						if(param.querySelector('.iconon')) {
							_this.setAttr(param.querySelector('.iconon'), "class", "mute iconoff iconfont icon-yinliangguan");
						}
						_this.setAttr(this, "class", "mute selected iconon iconfont icon-yinliangkai");
						if(cfg.V_volum.className.indexOf('icon-yinliangguan') != null) {
							cfg.V_volum.click();
						} else {
							_this.opts('volum', volumval / 100, ind);
						}
					}
				}
			}, false)
		})
	}
	/*
	 * @FN FullScreen  全屏方法调用
	 */
	FullScreen(element) {
		if(element.requestFullScreen) {
			element.requestFullScreen();
		} else if(element.mozRequestFullScreen) {
			element.mozRequestFullScreen();
		} else if(element.webkitRequestFullScreen) {
			element.webkitRequestFullScreen();
		} else if(element.msRequestFullScreen) {
			element.msRequestFullScreen();
		} else if(element.msRequestFullscreen) {
			element.msRequestFullscreen();
		} else {
			return true;
		}
	}
	/*
	 * @FN FullScreen  取消全屏方法调用
	 */
	CancelFullScreen() {
		if(document.exitFullscreen) {
			document.exitFullscreen();
		} else if(document.mozCancelFullScreen) {
			document.mozCancelFullScreen();
		} else if(document.webkitCancelFullScreen) {
			document.webkitCancelFullScreen();
		} else if(document.msExitFullscreen) {
			document.msExitFullscreen();
		} else if(document.msExitFullScreen) {
			document.msExitFullScreen();
		} else {
			return true;
		}
	}
	/*
	 * @FN escFullScreen  esc取消全屏方法调用
	 */
	escFullScreen() {
		let cfg = this.cfg;
		if(!document.fullscreenElement && !document.mozFullScreenElement && !document.webkitFullscreenElement && !document.msFullscreenElement) {
			this.CancelFullScreen();
			cfg.fullscreenObj.setAttribute('class', 'fullScreen iconfont icon-a');
		}
	}
	/*
	 * @FN opts  操作
	 * @FN removelistening : 清除video方法
	 * @FN init : 初始化video对象,并绑定双击事件,调用音频控制台列表点击操作
	 * @FN duration : 绑定文件加载
	 * @FN play : 播放
	 * @FN pause : 暂停
	 * @FN jump : 跳转
	 * @FN volum : 音量控制
	 * @FN urlreplace : 高标清切换地址
	 * @FN loading : 加载图标
	 * @FN error : 404图标设置
	 */
	opts(etype, num, ind) {
		let cfg = this.cfg;
		var listlen = this.getid(cfg.id).querySelectorAll('.list');
		let _this = this;
		let dom = '';
		let redaystate;
		//cfg.errnum=[];
		if(etype == 'updownvolum') {
			let numval = parseInt(cfg.V_scroll.getAttribute("volumval"));
			if(num == "add") {
				numval += 2;
				numval > 100 ? numval = 100 : numval;
			} else {
				numval -= 2;
				numval <= 0 ? numval = 0 : numval;
			}
			let objind = cfg.mutedid.split("_")[1];
			this['videobj_' + objind].volumset(numval / 100)
			this.setAttr(cfg.V_scroll, "volumval", numval);
			if(numval <= 0) {
				this.setAttr(cfg.V_volum, "class", 'volum iconfont icon-yinliangguan');
				this['videobj_' + objind].mute(true);
			} else {
				this.setAttr(cfg.V_volum, "class", 'volum iconfont icon-yinliangkai');
				this['videobj_' + objind].mute(false);
			}
			this.setAttr(cfg.V_scrollsonbg, "style", "width:" + numval / 2 + 'px');
			this.setAttr(cfg.V_scrollson, "style", "left:" + numval / 2 + 'px');
			return;
		}
		for(var i = 0; i < listlen.length; i++) {
			if(this['videobj_' + i]) {
				redaystate = this['videobj_' + i].readyState(i);
			}
			switch(etype) {
				case 'removelistening':
					if(this['videobj_' + i]) {
						this['videobj_' + i].removelistening();
					}
					break;
				case 'init':
//					console.log('opts init fn exe')
					this['videobj_' + i] = new CFCMVideo('video_' + i);
					document.onselectstart = function() {
						return false;
					};
					if(this.getStyle(this.getid('video_' + i), 'display') == "none") {
						this.setStyle(this.getid('video_' + i), 'display', "block");
					}
					this['videobj_' + i].id.ondblclick = function(e) {
						if(_this.platformcheck().ie) {
							alert('对不起,您的浏览器不支持双击全屏!')
						} else {
							cfg.fullscreen = true;
							_this.FullScreen(this);
							this.setAttr(cfg.fullscreenObj, "class", "outfullScreen iconfont icon-quanpingtuichu");
						}
					}
					//					console.log('cfg.setchannel', cfg.setchannel)
					if(!cfg.setchannel) {
//											    console.log('cfg.setchannel=false', cfg.setchannel, 'cfg.mutedid='+cfg.mutedid)
						if(!cfg.mutedid) {
							this['videobj_' + i].mute('false') //禁用指定流之外的音频
							dom += '<div id="mute_' + i + '" class="mute iconoff iconfont icon-yinliangguan" title="' + cfg.channeltitle[i] + '">' + cfg.channeltitle[i] + '</div>';
						} else {
							if(cfg.mutedid.split('_')[1] == i) {
								dom += '<div id="mute_' + i + '" class="mute selected iconon iconfont icon-yinliangkai" title="' + cfg.channeltitle[i] + '">' + cfg.channeltitle[i] + '</div>';
							} else {
								this['videobj_' + i].mute('false') //禁用指定流之外的音频
								dom += '<div id="mute_' + i + '" class="mute iconoff iconfont icon-yinliangguan" title="' + cfg.channeltitle[i] + '">' + cfg.channeltitle[i] + '</div>';
							}
						}
					} else {
//												console.log('cfg.setchannel=true', cfg.setchannel)
						if(i != cfg.mainfile[0]) {
							this['videobj_' + i].mute('false') //禁用指定流之外的音频
							dom += '<div id="mute_' + i + '" class="mute iconoff iconfont icon-yinliangguan" title="' + cfg.channeltitle[i] + '">' + cfg.channeltitle[i] + '</div>';

						} else {
							dom += '<div id="mute_' + i + '" class="mute selected iconon iconfont icon-yinliangkai" title="' + cfg.channeltitle[i] + '">' + cfg.channeltitle[i] + '</div>';
							cfg.mutedid = 'mute_' + i;
						}
					}
					break;
				case 'duration':
					this.durationcallback(i, num);
					break;
				case 'play':
					if(redaystate.state != 0) {
						if(this.getStyle(cfg.bigplayobj, 'display') == "block") {
						  cfg.bigplayobj.style.display = 'none'
						}
						this['videobj_' + i].play();
					} else {
						//cfg.errnum.push(i)
						this.errordeal(i);
					}
					break;
				case 'hlsplay':
					this['m3u8_' + i] = document.getElementById('video_' + i);
					this.setStyle(this.getid('list_' + i).querySelector('.loading'), 'display', 'none')
					if(Hls.isSupported()) {
						let temp = this['m3u8_' + i]
					    this['hls_'+ i] = new Hls();
					    if (cfg.defaultmodel == 'high') {
					      this['hls_'+ i].loadSource(cfg.channel[i]);
					    } else if(cfg.defaultmodel == 'normal') {
					    	this['hls_'+ i].loadSource(cfg.channelB[i]);
					    } else{
					    	this['hls_'+ i].loadSource(cfg.channelS[i]);
					    }
					    
					    this['hls_'+ i].attachMedia(_this['m3u8_' + i]);
					    this['hls_'+ i].on(Hls.Events.MANIFEST_PARSED,function() {
					      temp.play();
					      cfg.bigplayobj.style.display = 'none'
					      _this.setStyle(cfg.V_play, 'display', 'none');
					      _this.setStyle(cfg.V_pause, 'display', 'block');
					  });
					 }else {
					 	let temp = this['m3u8_' + i]
					 	if (this['m3u8_' + i].canPlayType('application/vnd.apple.mpegurl')) {
						    if (cfg.defaultmodel == 'high') {
						      this['m3u8_' + i].src = cfg.channel[i];
						    } else if(cfg.defaultmodel == 'normal') {
						    	this['m3u8_' + i].src = cfg.channelB[i];
						    } else{
						    	this['m3u8_' + i].src = cfg.channelS[i];
						    }
						    this['m3u8_' + i].addEventListener('canplay',function() {
						      temp.play();
						      cfg.bigplayobj.style.display = 'none'
						      _this.setStyle(cfg.V_play, 'display', 'none');
					      	  _this.setStyle(cfg.V_pause, 'display', 'block');
						    });
						 }
					 }
					break;
				case 'pause':
					if(redaystate.state != 0) {
						if(this.getStyle(cfg.bigplayobj, 'display') == "none") {
						  cfg.bigplayobj.style.display = 'block'
						}
						this['videobj_' + i].pause();
					} else {
						//cfg.errnum.push(i)
						this.errordeal(i);
					}
					break;
				case 'playbackRate':
					if(redaystate.state != 0) {
						this['videobj_' + i].playbackRate(num);
					} else {
						this.errordeal(i);
					}
					break;
				case 'jump':
					if(redaystate.state != 0) {
						if(ind) {
							if(ind == 'add') {
								if(num + 5 >= cfg.totaltime) {
									this['videobj_' + i].playtoseconds(0);
								} else {
									this['videobj_' + i].playtoseconds(num + 5);
								}

							} else {
								if(num - 5 <= 0) {
									this['videobj_' + i].playtoseconds(0);
								} else {
									this['videobj_' + i].playtoseconds(num - 5);
								}
							}
						} else {
//							console.log('jumpto' + num + '秒')
							this['videobj_' + i].playtoseconds(num);
						}
						cfg.playnowseconds = num
					} else {
						//cfg.errnum.push(i)
						this.errordeal(i);
					}
					break;
				case 'volum':
//				console.log('volumvolum====')
					if(redaystate.state != 0) {
						if(ind != undefined) {
							if(ind == i) {
								this['videobj_' + i].volumset(num);
								if(num == 0) {
									this.setAttr(cfg.V_volumcontrollist.children[i], "class", "mute iconoff iconfont icon-yinliangguan");
									this['videobj_' + i].mute(true);
								} else {
									this.setAttr(cfg.V_volumcontrollist.children[i], "class", "mute selected iconon iconfont icon-yinliangkai");
									this['videobj_' + i].mute(false);
								}

							} else {
								this['videobj_' + i].volumset(0);
								this['videobj_' + i].mute(true);
								this.setAttr(cfg.V_volumcontrollist.children[i], "class", "mute iconoff iconfont icon-yinliangguan");
							}
						} else {
							this['videobj_' + i].volumset(num);
							if(num == 0) {
								this.setAttr(cfg.V_volumcontrollist.children[i], "class", "mute iconoff iconfont icon-yinliangguan");
								this['videobj_' + i].mute(true);
							} else {
								this.setAttr(cfg.V_volumcontrollist.children[i], "class", "mute selected iconon iconfont icon-yinliangkai");
								this['videobj_' + i].mute(false);
							}
						}
					} else {
						//cfg.errnum.push(i)
						this.errordeal(i);
					}
					break;
				case 'urlreplace':
					this.setAttr(this['videobj_' + i].id, "src", num[i]);
					break;
				case 'loading':
					this.setStyle(this.getid('list_' + i).querySelector('.loading'), 'display', num);
					break;
				case 'error':
					this.setStyle(this.getid('list_' + i).querySelector('.error'), 'display', num);
					break;
			}
		}
		if(etype == 'init') {
			let modeldom = ''
			if(cfg.model.length > 0) {
				for(let item = 0; item < cfg.model.length; item++) {
					if (cfg.defaultmodel == cfg.model[item].type) {
						modeldom += `<span class="modelspan selected" type=${cfg.model[item].type}>${cfg.model[item].name}</span>`
					} else {
						modeldom += `<span class="modelspan" type=${cfg.model[item].type}>${cfg.model[item].name}</span>`
					}
					
				}
			}
			if (cfg.playbackRateflag) {
			  let playdom = ''
				if(cfg.playbackRate.length > 0) {
					for(let item = cfg.playbackRate.length - 1; item >= 0; item--) {
						if (cfg.playbackRate[item] == 1) {
						    playdom += `<span class="modelspan selected" >${cfg.playbackRate[item]}</span>`
						} else {
							playdom += `<span class="modelspan" >${cfg.playbackRate[item]}</span>`
						}
					}
				}
				if (cfg.V_playcontrollist.innerHTML == '') {
			      cfg.V_playcontrollist.innerHTML = playdom;
			    }
				this.setAttr(cfg.V_playcontrollist, "style", 'top:-' + ((cfg.playbackRate.length + 1) * 20 + 11) + 'px;');
				this.channelplayEvent(cfg.V_playcontrollist);
			}
			cfg.V_modelcontrollist.innerHTML = modeldom;
//			console.log(dom, 'dom')
			cfg.V_volumcontrollist.innerHTML = dom;
			this.setAttr(cfg.V_modelcontrollist, "style", 'top:-' + ((cfg.model.length + 1) * 20 + 11) + 'px;');
			this.setAttr(cfg.V_volumcontrollist, "style", 'top:-' + ((listlen.length + 1) * 20 + 11) + 'px;');
			this.channelmuteEvent(cfg.V_volumcontrollist);
			this.channelmodelEvent(cfg.V_modelcontrollist);
			
		}
	}
	/*
	 * @FN errordeal  隐藏loading操作,显示error
	 */
	errordeal(i) {
		let cfg = this.cfg;
		if(this.getStyle(this.getid('video_' + i), 'display') == "block") {
			this.setStyle(this.getid('video_' + i), 'display', "none");
			this.setStyle(this.getid('mute_' + i), 'display', "none");
			let hei = parseInt(this.getStyle(cfg.V_volumcontrollist, 'top')) + 20;
			cfg.V_volumcontrollist.style.top = hei + 'px';
		}
		if(this['videobj_' + i]) {
			this.setStyle(this.getid('list_' + i).querySelector('.loading'), 'display', "none");
			this.setStyle(this.getid('list_' + i).querySelector('.error'), 'display', "block");
		}
	}
	/*
	 * @FN durationcallback  视频加载回调
	 * @Param durationcount 加载统计
	 */
	durationcallback(i, num) {
		var _this = this;
		let cfg = this.cfg;
		this['videobj_' + i].duration(function(total) {
			console.log(i,total, '----totaltotal------')
			cfg.V_totaltime.innerHTML = _this.timeformcat(parseInt(total))
			if(cfg.setchannel && i == cfg.mainfile[0]) { // 指定通道播放
				cfg.totaltime = parseInt(total)
				cfg.nowchannelnum = i
				cfg.mainfile[1] = parseInt(total);
				_this.videoopt();
				_this.addknowledge();
			}
			if(!cfg.setchannel && !cfg.mainfile[1]) {
				//初始化静音id
				cfg.mutedid = 'mute_' + i;
				cfg.nowchannelnum = i
				let nowchannel = _this.getid(cfg.mutedid)
				nowchannel.className = nowchannel.className.replace(/(icon-yinliangguan)/gi, 'selected icon-yinliangkai')
				cfg.mainfile[1] = parseInt(total);
				cfg.totaltime = parseInt(total)
				_this.videoopt();
				_this.addknowledge();
				_this['videobj_' + i].mute(false)
				_this['videobj_' + i].volumset(0.5);
			}
			_this.slideRefrash();
			_this.setStyle(_this.getid('list_' + i).getElementsByClassName("loading")[0], 'display', "none");
			cfg.durationcount++; //全部视频流加载计数
			if(cfg.durationcount == cfg.channelnum) {
				//				console.log('加载完全，直接播放', num, cfg.playnowseconds)
				if(num == "jump") {
					_this.opts('jump', cfg.playnowseconds);
					_this.opts('loading', 'none');
				}
				if(cfg.autojump) {
//					console.log('执行初始化跳转', cfg.autojump)
					if(cfg.totaltime < cfg.autojump) {
						let time = parseInt(cfg.autojump / cfg.totaltime)
						_this.opts('jump', cfg.autojump - time * cfg.totaltime);
					} else {
						_this.opts('jump', cfg.autojump);
					}
				}
				if(cfg.autoplay) {
          cfg.V_play && cfg.V_play.click();
				}
			} else {
				console.log('未加载完全，播放等待中' + i)
			}
		})
	}
	/*
	 * @FN remove  删除
	 */
	remove(_element) {
		var _parentElement = _element.parentNode;
		if(_parentElement) {
			_parentElement.removeChild(_element);
		}
	}
};

var h5demo = new LocalVideo(infos);