

var trans3DDemo = $("#trans3DDemo"), 
    trans3DBoxes = $("#trans3DBoxes"),
    boxes = $("#trans3DBoxes div"),   
    slider = $("#slider"), 
    play_btn = $("#play_btn").button(),
    stop_btn = $("#stop_btn").button(),
    reverse_btn = $("#reverse_btn").button(), 
    threeDTimeline = new TimelineLite({onUpdate:updateSlider}); //允许滑块保持同步动画播放
    




TweenLite.set(trans3DBoxes, {
            css:{
                transformPerspective:400,   
                perspective:400,    
                transformStyle:"preserve-3d"  
                }
            }); 


threeDTimeline.fromTo(trans3DDemo, 2, {ease: Power0.easeIn, css:{autoAlpha:0}}, {css:{autoAlpha:1}})
              .to(trans3DBoxes, 1, {css:{rotationY:30, rotationX:20}})
              .add("z", "+=0.5"); 


    


boxes.each(function (index, element) {
  threeDTimeline.to(element, 1, {css:{z:getRandom(-30, 50)}}, "z"); 
})
  

threeDTimeline.to(trans3DBoxes, 1, {css:{rotationY:360, z:-180}, ease:Power2.easeOut}, "+=0.2")
              .to(trans3DBoxes, 1, {css:{rotationX:360, z:-10}})
              .to(boxes, 0.5, {borderRadius:"15px"})
              .to(boxes, 0.5, {borderRadius:"45px"})
              .to(boxes, 0.5, {borderRadius:"18 40px"})
              .to(boxes, 0.5, {borderRadius:"18px"})
              .to(boxes, 0.5, {borderRadius:"40px 0px 40px 40px", borderColor:"rgba(189, 186, 91, 0.3)"})
              .to(boxes, 0.5, {borderRadius:"0px"}, "+=0.2")
              .to(boxes, 0.5, {borderRadius:"15px",borderColor:"#fff"})
              .set(boxes, {transformPerspective:100})
              .to(boxes, 0.5, {rotationY:180, autoAlpha:1, z:0}, "+=0.5")
              .to(trans3DBoxes, 1, {css:{autoAlpha:0}});
    





function updateSlider(){
  slider.slider("value", threeDTimeline.progress() *100);
}

$( "#slider" ).slider({
            range: false,
            min: 0,
            max: 100,
            step:.1,
            slide: function ( event, ui ) {
            threeDTimeline.pause();
            threeDTimeline.progress( ui.value/100 );
            }
     });  

  
function getRandom(max, min){
  return Math.floor(Math.random() * (1 + max - min) + min);
} 
    
 // seek( ); timeScale( );
    
$("#play_btn").click(function(){
 
  if(threeDTimeline.progress()==1){
    threeDTimeline.restart();
    }else{
      threeDTimeline.play(); 
    }
}) 

$("#stop_btn").click(function(){
 
 
      threeDTimeline.pause(); 
    
})
$("#reverse_btn").click(function(){
 
 
      threeDTimeline.reverse(); 
    
})  
  