/**
 * 自定义选择表单
 * Created by LtWhite on 2015/7/27.
 */
;(function ($) {

    /**
     * 单选按钮
     */
    $.fn.jRadio = function (settings) {
        // 默认参数
        var defaults = {
            valueSelector: ".radio-value",  // 存放radio的value值的input表单的css选择器
            itemSelector: ".options > li", // radio项的css选择器
            checkedClass: "checked",    // 选择状态的类名
            completeFunction: function () {}    // 回调函数
        };

        var options = $.extend(defaults, settings || {});   // 使用参数

        var div = this;
        var radioValueInput = div.find(options.valueSelector);  // 单选按钮value的input表单
        var items = div.find(options.itemSelector); // 单选按钮项数组

        /*----初始化----*/
        /**
         * 进入页面，初始化单选按钮状态
         */
        items.each(function () {
            if($(this).hasClass(options.checkedClass)) {
                updateState($(this));
            }
        });

        /*---- 添加事件----*/
        div.on("click", options.itemSelector, function () {
            var item = $(this);
            // 如果当前项的状态为未选择
            if(!item.hasClass(options.checkedClass)) {
                updateState(item);
                options.completeFunction(); // 执行回调函数
            }

            return false;
        });

        /*----函数----*/
        /**
         * 更新数据
         * @param item  操作项
         */
        function updateState(item) {
            var value = item.data("value");  // 获取当前项的value值
            radioValueInput.val(value); // 修改隐藏表单的值

            items.removeClass(options.checkedClass);    // 移除所有项的选中样式
            item.addClass(options.checkedClass);    // 为当前项添加选中样式
        }
    };

    /**
     * 复选框
     */
    $.fn.jCheckBox = function (settings) {
        // 默认参数
        var defaults = {
            valueSelector: ".checkbox-value",  // 存放每一项checkbox的value值的input表单的css选择器
            itemSelector: ".options > li", // checkbox项的css选择器
            checkedClass: "checked",    // 选择状态的类名
            completeFunction: function () {}    // 回调函数
        };
        var options = $.extend(defaults, settings || {});   // 使用参数

        var div = this;
        var items = div.find(options.itemSelector); // 复选框项数组

        /*----初始化----*/
        /**
         * 进入页面，初始化复选框状态
         */
        items.each(function () {
            var item = $(this);
            var valueInput = item.find(options.valueSelector);
            if(item.hasClass(options.checkedClass)) {

                var value = item.data("value"); // 获取当前项value
                valueInput.val(value); // 修改隐藏表单的值
            } else {

                valueInput.val(""); // 置空隐藏表单的值
            }
        });

        /*----添加事件----*/
        div.on("click", options.itemSelector, function () {
            var item = $(this);
            var valueInput = item.find(options.valueSelector);

            if(item.hasClass(options.checkedClass)) {

                valueInput.val(""); // 置空隐藏表单的值
                item.removeClass(options.checkedClass);
            } else {

                var value = item.data("value"); // 获取当前项value
                valueInput.val(value); // 修改隐藏表单的值
                item.addClass(options.checkedClass);
            }
            options.completeFunction(); // 执行回调函数
            return false;
        });

    };

    /**
     * 下拉选择菜单
     */
    $.fn.jSelect = function (settings) {
        // 默认参数
        var defaults = {
            viewSelector: ".select-view",   // select选择层容器css选择器
            valueSelector: ".select-value", // 存放select的value值的input表单的css选择器
            textSelector: ".select-text",  // select显示文本的css选择器
            iconSelector: ".select-icon", // select的icon的css选择器
            iconClickAble: true,    // 是否使用点击icon展示下拉项

            itemContainerSelector: ".options",    // 下拉层css选择器
            itemSelector: ".options > li",   // 下拉项css选择器

            completeFunction: function () {}    // 回调函数
        };

        var options = $.extend(defaults, settings || {});   // 使用参数

        var div = this;
        var selectView = div.find(options.viewSelector);    // select显示层容器
        var selectValueInput = selectView.find(options.valueSelector);   // select的value值的input表单
        var selectText = selectView.find(options.textSelector); // select显示文本
        var selectIcon = selectView.find(options.iconSelector); // select的icon
        var selectItemContainer = div.find(options.itemContainerSelector);  // select下拉层
        var items = div.find(options.itemSelector); // select下拉项

        /*----添加事件----*/
        /**
         * 点击icon或者点击显示层，显示下拉层
         */
        if(options.iconClickAble) {
            selectIcon.on("click", function () {
                selectItemContainerToggle();

                return false;
            });
        } else {
            selectView.on("click", function () {
                selectItemContainerToggle();

                return false;
            });
        }

        /**
         * 点击下拉项，修改value值，改变显示文本
         */
        items.each(function () {
            var item = $(this);

            item.on("click", function () {
                var value = $(this).data("value");  // 获取当前项的value
                var text = $(this).text();  // 获取当前项的文本内容

                selectValueInput.val(value);    // 修改value
                selectText.text(text);  // 修改文本内容

                selectItemContainer.slideUp("fast");    // 收起下拉层
                options.completeFunction(); // 执行回调函数
                return false;
            });
        });

        /*----函数----*/
        /**
         * 显示或者隐藏下拉层
         */
        function selectItemContainerToggle() {
            selectItemContainer.slideToggle("fast");
        }
    }

})(jQuery);