/***
 * Author:nicezz
 * E-mail:hzdz163@163.com
 * Version:1.0.1
 * 本程序的版权遵循创作共用原则，你可以免费使用、修改、发布本程序，但此注释不可删除并请注明原作者
 * The copyright of this program follows the principle of creative Commons, you can use,
 * modify and distribute this program for free, but this annotation cannot be deleted,
 * please indicate the original author.
 * github https://github.com/nicez2/nicejson 
 */
var nicejson = {
    //转JSON字符串
    stringify: function(string) {
        return JSON.stringify(string);
    },
    //转JSON对象
    parse: function(str) {
        str = str.replace(new RegExp('\\"', "gm"), '"');
        return JSON.parse(str);
    },
    //JSON格式校验
    isJSON: function(json) {
        try {
            JSON.stringify(json);
        } catch (e) {
            console.error(e)
            return false;
        }
        return true;
    },
    //Key 字母a-z排序
    sort: function(json) {
        var keys = Object.keys(json).sort();
        var newObj = {}
        for (var i = 0; i < keys.length; i++) {
            var index = keys[i];
            newObj[index] = json[index];
        }
        return newObj;
    },
    //Key 字母z-a排序
    sortDesc: function(json) {
        var keys = Object.keys(json).sort();
        var newObj = {}
        for (var i = keys.length; i > 0; i--) {
            var index = keys[i];
            newObj[index] = json[index];
        }
        return newObj;
    },
    //去除value为null的元素
    removeNull: function(json) {
        for (var key in json) {
            if (json[key] === '' || json[key] === undefined || json[key] === null) {
                delete json[key]
            }
        }
        return json;
    },
    //去除指定key
    removeKey: function(json, key) {
        delete json[key]
        return json;
    },
    //获取JSON指定key的值
    getValue: function(json, key) {
        return json[key];
    },


    //xml转换json数据
    xmlToJSON: function(json) {
        var xmlObj = {};
        if (document.all) {
            var xmlDom = new ActiveXObject("Microsoft.XMLDOM");
            xmlDom.loadXML(xmlStr);
            xmlObj = xmlDom;
        } else {
            xmlObj = new DOMParser().parseFromString(xmlStr, "text/xml");
        }
        var jsonObj = {};
        if (xmlObj.childNodes.length > 0) {
            jsonObj = xml2json(xmlObj);
        }
        return jsonObj;
    },
    xml2json: function(xml) {
        try {
            var obj = {};
            if (xml.children.length > 0) {
                for (var i = 0; i < xml.children.length; i++) {
                    var item = xml.children.item(i);
                    var nodeName = item.nodeName;
                    if (typeof(obj[nodeName]) == "undefined") {
                        obj[nodeName] = xml2json(item);
                    } else {
                        if (typeof(obj[nodeName].push) == "undefined") {
                            var old = obj[nodeName];
                            obj[nodeName] = [];
                            obj[nodeName].push(old);
                        }
                        obj[nodeName].push(xml2json(item));
                    }
                }
            } else {
                obj = xml.textContent;
            }
            return obj;
        } catch (e) {
            console.log(e.message);
        }
    },
    //转为JSON数组
    toJSONArray: function(str) {
        return JSON.parse(str);
    },
    //去除JSON数组中value为null的元素
    arrayRemoveNull: function(array) {
        for (var i = 0; i < array.length; i++) {
            for (var key in array[i]) {
                if (array[i][key] === '' || array[i][key] === undefined || array[i][key] === null) {
                    delete array[i][key]
                }
            }
        }
        return array;
    },
    //去除JSON数组中指定key
    arrayRemoveKey: function(array, key) {
        for (var i = 0; i < array.length; i++) {
            delete array[i][key];
        }
        return array;
    },
    //获取JSON数组指定key的所有值
    arrayGetValues: function(array, key) {
        var reslut = new Array();
        for (var i = 0; i < array.length; i++) {
            reslut.push(array[i][key]);
        }
        return reslut
    },

    //获取JSON数组指定key等于指定value的所有对象
    arrayGetJSON: function(array, key, value) {
        var reslut = new Array();
        for (var i = 0; i < array.length; i++) {
            if (array[i][key] == value) {
                reslut.push(array[i]);
            }
        }
        return result
    },

    //设置JSON数组指定key的所有value
    arraySetValue: function(array, key, value) {
        for (var i = 0; i < array.length; i++) {
            array[i][key] = value;
        }
        return array
    },

    //设置JSON数组指定key的所有value自定义处理
    arraySetValueFunction: function(array, key, fun) {
        for (var i = 0; i < array.length; i++) {
            array[i][key] = fun(array[i][key]);
        }
        return array
    },


    //设置JSON数组指定key computed计算
    arrayComputedMap: function(array, key, obj) {
        for (var i = 0; i < array.length; i++) {
            array[i][key] = obj[array[i][key]]
        }
        return array
    },


    // 返回处理后的 json字符串 
    parseDistinct: function(jsonObj) {
        distinctJson(jsonObj);
        var last = JSON.stringify(jsonObj, undefined, 2);
        return last;
    },

    // 去掉 json中数组多余的项 
    distinctJson: function(obj) {
        if (obj instanceof Array) {
            if (obj.length > 1) { //数组中有超过一个对象，删除第一个对象之后的所有对象  
                obj.splice(1, (obj.length - 1));
            }
            distinctJson(obj[0]);
        } else if (obj instanceof Object) {
            for (var index in obj) {
                var jsonValue = obj[index];
                distinctJson(jsonValue);
            }
        }
    }
};
if (!Array.indexOf) {
    Array.prototype.indexOf = function(obj) {
        for (var i = 0; i < this.length; i++) {
            if (this[i] == obj) {
                return i;
            }
        }
        return -1;
    }
};


if (typeof JSON !== "object") {
    JSON = {};
}

(function() {
    "use strict";

    var rx_one = /^[\],:{}\s]*$/;
    var rx_two = /\\(?:["\\\/bfnrt]|u[0-9a-fA-F]{4})/g;
    var rx_three = /"[^"\\\n\r]*"|true|false|null|-?\d+(?:\.\d*)?(?:[eE][+\-]?\d+)?/g;
    var rx_four = /(?:^|:|,)(?:\s*\[)+/g;
    var rx_escapable = /[\\"\u0000-\u001f\u007f-\u009f\u00ad\u0600-\u0604\u070f\u17b4\u17b5\u200c-\u200f\u2028-\u202f\u2060-\u206f\ufeff\ufff0-\uffff]/g;
    var rx_dangerous = /[\u0000\u00ad\u0600-\u0604\u070f\u17b4\u17b5\u200c-\u200f\u2028-\u202f\u2060-\u206f\ufeff\ufff0-\uffff]/g;

    function f(n) {
        // Format integers to have at least two digits.
        return (n < 10) ?
            "0" + n :
            n;
    }

    function this_value() {
        return this.valueOf();
    }

    if (typeof Date.prototype.toJSON !== "function") {

        Date.prototype.toJSON = function() {

            return isFinite(this.valueOf()) ?
                (
                    this.getUTCFullYear() +
                    "-" +
                    f(this.getUTCMonth() + 1) +
                    "-" +
                    f(this.getUTCDate()) +
                    "T" +
                    f(this.getUTCHours()) +
                    ":" +
                    f(this.getUTCMinutes()) +
                    ":" +
                    f(this.getUTCSeconds()) +
                    "Z"
                ) :
                null;
        };

        Boolean.prototype.toJSON = this_value;
        Number.prototype.toJSON = this_value;
        String.prototype.toJSON = this_value;
    }

    var gap;
    var indent;
    var meta;
    var rep;


    function quote(string) {

        rx_escapable.lastIndex = 0;
        return rx_escapable.test(string) ?
            "\"" + string.replace(rx_escapable, function(a) {
                var c = meta[a];
                return typeof c === "string" ?
                    c :
                    "\\u" + ("0000" + a.charCodeAt(0).toString(16)).slice(-4);
            }) + "\"" :
            "\"" + string + "\"";
    }


    function str(key, holder) {
        var i; // The loop counter.
        var k; // The member key.
        var v; // The member value.
        var length;
        var mind = gap;
        var partial;
        var value = holder[key];
        if (
            value &&
            typeof value === "object" &&
            typeof value.toJSON === "function"
        ) {
            value = value.toJSON(key);
        }

        if (typeof rep === "function") {
            value = rep.call(holder, key, value);
        }

        switch (typeof value) {
            case "string":
                return quote(value);

            case "number":

                return (isFinite(value)) ?
                    String(value) :
                    "null";
            case "boolean":
            case "null":
                return String(value);
            case "object":
                if (!value) {
                    return "null";
                }
                gap += indent;
                partial = [];
                if (Object.prototype.toString.apply(value) === "[object Array]") {
                    length = value.length;
                    for (i = 0; i < length; i += 1) {
                        partial[i] = str(i, value) || "null";
                    }
                    v = partial.length === 0 ?
                        "[]" :
                        gap ?
                        (
                            "[\n" +
                            gap +
                            partial.join(",\n" + gap) +
                            "\n" +
                            mind +
                            "]"
                        ) :
                        "[" + partial.join(",") + "]";
                    gap = mind;
                    return v;
                }

                if (rep && typeof rep === "object") {
                    length = rep.length;
                    for (i = 0; i < length; i += 1) {
                        if (typeof rep[i] === "string") {
                            k = rep[i];
                            v = str(k, value);
                            if (v) {
                                partial.push(quote(k) + (
                                    (gap) ?
                                    ": " :
                                    ":"
                                ) + v);
                            }
                        }
                    }
                } else {
                    for (k in value) {
                        if (Object.prototype.hasOwnProperty.call(value, k)) {
                            v = str(k, value);
                            if (v) {
                                partial.push(quote(k) + (
                                    (gap) ?
                                    ": " :
                                    ":"
                                ) + v);
                            }
                        }
                    }
                }
                v = partial.length === 0 ?
                    "{}" :
                    gap ?
                    "{\n" + gap + partial.join(",\n" + gap) + "\n" + mind + "}" :
                    "{" + partial.join(",") + "}";
                gap = mind;
                return v;
        }
    }
    if (typeof JSON.stringify !== "function") {
        meta = { // table of character substitutions
            "\b": "\\b",
            "\t": "\\t",
            "\n": "\\n",
            "\f": "\\f",
            "\r": "\\r",
            "\"": "\\\"",
            "\\": "\\\\"
        };
        JSON.stringify = function(value, replacer, space) {
            var i;
            gap = "";
            indent = "";
            if (typeof space === "number") {
                for (i = 0; i < space; i += 1) {
                    indent += " ";
                }

            } else if (typeof space === "string") {
                indent = space;
            }
            rep = replacer;
            if (replacer && typeof replacer !== "function" && (
                    typeof replacer !== "object" ||
                    typeof replacer.length !== "number"
                )) {
                throw new Error("JSON.stringify");
            }


            return str("", { "": value });
        };
    }

    if (typeof JSON.parse !== "function") {
        JSON.parse = function(text, reviver) {
            var j;

            function walk(holder, key) {
                var k;
                var v;
                var value = holder[key];
                if (value && typeof value === "object") {
                    for (k in value) {
                        if (Object.prototype.hasOwnProperty.call(value, k)) {
                            v = walk(value, k);
                            if (v !== undefined) {
                                value[k] = v;
                            } else {
                                delete value[k];
                            }
                        }
                    }
                }
                return reviver.call(holder, key, value);
            }
            text = String(text);
            rx_dangerous.lastIndex = 0;
            if (rx_dangerous.test(text)) {
                text = text.replace(rx_dangerous, function(a) {
                    return (
                        "\\u" +
                        ("0000" + a.charCodeAt(0).toString(16)).slice(-4)
                    );
                });
            }
            if (
                rx_one.test(
                    text
                    .replace(rx_two, "@")
                    .replace(rx_three, "]")
                    .replace(rx_four, "")
                )
            ) {
                j = eval("(" + text + ")");

                return (typeof reviver === "function") ?
                    walk({ "": j }, "") :
                    j;
            }
            throw new SyntaxError("JSON.parse");
        };
    }
}());
