/**
 * 表格操作增加合计功能
 * 原则：1只针对不分页的表格，2前端做合计
 * 根据所需选择合计行的格式
 * 添加合计行/删除合计行无用内容/合并合计行单元格，需要根据自身表格实际情况修改下标值及其样式
 */

// 定义合计初始值 0 
let priceSum = 0;
// 定义数据总行数初始值 0
let lastIndex = 0;
$(document).ready(function () {
    //加载数据
    init();
    //数据加载完整后，获取总条数（也可通过后台返回数据总条数来获取）
    lastIndex = $("#bootstrap-table").bootstrapTable("getData").length;
    //添加合计行
    addTotalRow();
    //方法一：删除合计行无用的td内容
    //delTdata();
    //方法二：做合并单元格
    colSpan();
});

function init() {
    //选择人员
    $('#bootstrap-table').bootstrapTable({
        data: [
            {
                "id": 1,
                "name": "苹果",
                "card": "30.05"
            },
            {
                "id": 2,
                "name": "橘子",
                "card": "18"
            },
            {
                "id": 3,
                "name": "香蕉",
                "card": "10.5"
            },
            {
                "id": 4,
                "name": "栗子",
                "card": "12.05"
            },
            {
                "id": 5,
                "name": "田七",
                "card": "5.00"
            }
        ],
        reorderableRows: true,
        clickToSelect: true,//点击行选中
        striped: true, // 是否显示行间隔色
        uniqueId: "id",
        search: false,
        showRefresh: false,
        columns: [
            {
                checkbox: true,
                halign: 'center',
                align: 'center',
                width:  20,
                footerFormatter: function () {
                    return '合计';
                }
            },
            {
                field: 'xh',
                title: "序号",
                halign :"center",
                align:  "center",
                width:  40,
                formatter: function (value, row, index) {
                    return index+1;
                }
            },
            {
                field: 'name',
                title: '商品',
                width:  260,
            },
            {
                field: 'card',
                title: '价格',
                halign :"center",
                align:  "center",
                width:  80,
                formatter: function(value, row, index){
                    //增加的合计行不能并入总和计算范围内
                    if(value.indexOf("span") == -1){
                        priceSum = floatTool.add(priceSum,value);
                    }
                    return value;
                }
            }
        ]
    });
}

// 添加合计行
function addTotalRow() {
    //表格存在数据时才添加合计行
    if(lastIndex>0){
        $("#bootstrap-table").bootstrapTable('append', [{
            name: '<span style="font-size:20px;">合计</span>',
            card: '<span style="font-size:20px;color:red;">'+priceSum+'</span>'
        }]);
    }
}

// 删除合计行无用的td内容
function delTdata(){
    //表格存在数据时再处理合计行内容
    if(lastIndex>0){
        //获取表格中所有行
        let pages = $("#bootstrap-table").bootstrapTable()[0].rows;
        //获取最后一行中，所有td标签
        let tds  = $(pages[lastIndex+1]).find("td");
        //删除第一列中，多余的复选框，默认下标为0；
        $(tds[0]).find("input").remove();
        //根据表格内容，删除下标值为1的，第二列中多余的序号
        $(tds[1]).html("");
    };
}

//合并单元格的样式
function colSpan(){
    if (lastIndex > 0) {
        //获取表格中所有行
        let pages = $("#bootstrap-table").bootstrapTable()[0].rows;
        //获取最后一行中，所有td标签
        let tds = $(pages[lastIndex + 1]).find("td");
        //删除最后一行中多余的td，根据表格内容，此处下标值为0和1
        $(tds[0]).remove();
        $(tds[1]).remove();
        //根据表格内容，下标值为2，即第三个单元格做合并
        $(tds[2]).attr("colspan","3");
        $(tds[2]).css("text-align","center");
    };
}