function Snake() {
	this.head = [0, 5, imgs[1]]; // x,y坐标,头
	this.body = []; // 二维数组，身体
	this.snake = []; //完整的蛇
	this.init(6);
	this.direction = 'down'; // 默认向下运动
}

Snake.prototype = {
	init: function(len) {
		len = len ? len > 10 ? 10 : len : 5;
		var head = this.head = [0, len, imgs[1]];
		var body = this.body;
		for (var i = 0; i < len; i++) {
			body.push([0, i]);
		}
		this.getSnake();
	},
	restart: function() {
		ctx.clearRect(0, 0, width, height);
		this.head = [0, 5, imgs[1]]; // x,y坐标,头
		this.body = []; // 二维数组，身体
		this.snake = []; //完整的蛇
		exit = [];
		this.direction = 'down'; // 默认向下运动
		this.init(6);
		food.update();
		score.scoreClear();
	},
	eat: function() {
		var head = [this.head[0], this.head[1]];
		var body = this.body;
		if (food.food.toString() == head.toString()) {
			food.update();
			score.scoreAdd();
			return true;
		}
		return false;
	},
	update: function(direction) {
		var oldDirection = this.direction;
		this.direction = direction || this.direction;
		if ((this.direction == 'down' && oldDirection == 'up') ||
			(this.direction == 'up' && oldDirection == 'down') ||
			(this.direction == 'left' && oldDirection == 'right') ||
			(this.direction == 'right' && oldDirection == 'left')) {
			this.direction = oldDirection;
		}
		if (this.direction == 'left' && oldDirection != 'right') {
			this.head[0] -= 1;
			this.head[2] = imgs[2];
		} else if (this.direction == 'right' && oldDirection != 'left') {
			this.head[0] += 1;
			this.head[2] = imgs[3];
		} else if (this.direction == 'up' && oldDirection != 'down') {
			this.head[1] -= 1;
			this.head[2] = imgs[0];
		} else if (this.direction == 'down' && oldDirection != 'up') {
			this.head[1] += 1;
			this.head[2] = imgs[1];
		}
		this.die();
	},
	gameOver: function() {
		alert('game over!')
		console.log('game over!');
		parse = true;
		score.highScore();
	},
	die: function() {
		var head = this.head;
		var x = head[0],
			y = head[1];
		if (x < 0 || x > maxX || y < 0 || y > maxY) {
			this.gameOver();
		}
		var body = this.body;
		for (var i = 0; i < body.length; i++) {
			if (body[i].toString() == [x, y].toString()) {
				this.gameOver();
			}
		}
	},
	render: function() {
		var snake = this.snake;
		for (var i = 0, len = snake.length; i < len; i++) {
			var item = snake[i];
			render(item[0], item[1], 'green', item[2]);
		}
	},
	move: function(direction) {
		var head = this.head;
		var headCopy = head.slice(); //之前的头
		var body = this.body;
		body.push([headCopy[0], headCopy[1]]);
		this.update(direction);
		var eat = this.eat();
		if (!eat) {
			var del = body.shift();
			clear(del[0], del[1]);
		}
		this.getSnake();
	},
	getSnake: function() {
		var head = this.head;
		var body = this.body;
		var snake = this.snake = [];
		for (var i = 0, l = body.length; i < l; i++) {
			snake.push(body[i]);
		}
		snake.push(head);
		exit = [];
		for (var i = 0; i < snake.length; i++) {
			exit.push(snake[i]);
		}
		this.render();
	}
}
