var arr = {"x": "0", "y": "0", "size": "10", "spread": "0","color": "#000000", "alpha": "1", "inset": ""},
    box = $('.box'),
    check = $('.checkbox');
function updateShadow() {
  var hex = arr["color"],
      color = 'rgba('+hexToRgb(hex).r+', '+hexToRgb(hex).g+', '+hexToRgb(hex).b+', '+arr["alpha"]+')',
      shadow = arr["x"]+"px "+arr["y"]+"px "+arr["size"]+"px "+arr["spread"]+"px "+color+arr["inset"];
  box.css("box-shadow", shadow);
  box.text("box-shadow: "+shadow+";"); 
}
function hexToRgb(hex) {
    // Expand shorthand form (e.g. "03F") to full form (e.g. "0033FF")
    var shorthandRegex = /^#?([a-f\d])([a-f\d])([a-f\d])$/i;
    hex = hex.replace(shorthandRegex, function(m, r, g, b) {
        return r + r + g + g + b + b;
    });

    var result = /^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(hex);
    return result ? {
        r: parseInt(result[1], 16),
        g: parseInt(result[2], 16),
        b: parseInt(result[3], 16)
    } : null;
}
$('input').on("input", function(){
  var me = $(this),
      id = me.attr("id"),
      val = me.val();
  arr[id] = val;
  updateShadow();
});
$("#inset").on("click", function(){
  if($(this).is(":checked")) {
    arr["inset"] = " inset";
  }
  else {
    arr["inset"] = "";
  }
  updateShadow();
});
$("#inset").on("focus", function(){
    check.addClass("focus");
}).on("blur", function(){
  check.removeClass("focus");
});

updateShadow();
