/**
 * Copyright (C) 2011 by Paul Lewis
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 * Credit and thanks to the Three.js authors and Bartek Drozdz, without whom I
 * would not have worked out how to even start this engine :)
 */
var A3={};A3.Constants={MAX_LIGHTS:4,LIGHT_TYPES:{NONE:0,AMBIENT:1,DIRECTIONAL:2,POINT:4},RENDER_TYPES:{SOLID:1,PARTICLES:2},BLEND_TYPES:{NORMAL:1,ADDITIVE:2}};A3.Core={};A3.Core.Camera={};A3.Core.Math={};A3.Core.Remote={};A3.Core.Objects={};A3.Core.Objects.Lights={};A3.Core.Objects.Geometric={};A3.Core.Objects.Primitives={};A3.Core.Render={};A3.Core.Render.Shaders={};A3.Core.Render.Textures={};A3.Core.Scene={};A3.Addon={};A3.Addon.Intersection={};A3.Core.Math.Matrix3=function(){this.m11=0;this.m12=0;this.m13=0;this.m21=0;this.m22=0;this.m23=0;this.m31=0;this.m32=0;this.m33=0};A3.Core.Math.Matrix3.prototype={set:function(f,e,d,c,b,a,i,h,g){this.m11=f;this.m12=e;this.m13=d;this.m21=c;this.m22=b;this.m23=a;this.m31=i;this.m32=h;this.m33=g},transpose:function(){var d=this.m12,c=this.m13,f=this.m21,e=this.m23,b=this.m31,a=this.m32;this.m12=f;this.m13=b;this.m21=d;this.m23=a;this.m31=c;this.m32=e},determinant:function(){return this.m11*this.m22*this.m33+this.m12*this.m23*this.m31+this.m13*this.m21*this.m32-this.m11*this.m23*this.m32-this.m12*this.m21*this.m33-this.m13*this.m22*this.m31},invert:function(){var f=this.m11,e=this.m12,d=this.m13,c=this.m21,b=this.m22,a=this.m23,j=this.m31,i=this.m32,h=this.m33,g=this.determinant();if(g===0){throw ("Matrix determinant is zero, can't invert.")}this.m11=b*h-a*i;this.m12=d*i-e*h;this.m13=e*a-d*b;this.m21=a*j-c*h;this.m22=f*h-d*j;this.m23=d*c-f*a;this.m31=c*i-b*j;this.m32=e*j-f*i;this.m33=f*b-e*c;this.scaleByScalar(1/g);return this},copyMatrix4:function(a){this.m11=a.m11;this.m12=a.m12;this.m13=a.m13;this.m21=a.m21;this.m22=a.m22;this.m23=a.m23;this.m31=a.m31;this.m32=a.m32;this.m33=a.m33;return this},scaleByScalar:function(a){this.m11*=a;this.m12*=a;this.m13*=a;this.m21*=a;this.m22*=a;this.m23*=a;this.m31*=a;this.m32*=a;this.m33*=a;return this},toArray:function(a){if(!a){throw"You must provide a Float32Array to populate"}a[0]=this.m11;a[1]=this.m21;a[2]=this.m31;a[3]=this.m12;a[4]=this.m22;a[5]=this.m32;a[6]=this.m13;a[7]=this.m23;a[8]=this.m33;return a}};A3.M3=A3.Core.Math.Matrix3;A3.Core.Math.Matrix4=function(){this.m11=0;this.m12=0;this.m13=0;this.m14=0;this.m21=0;this.m22=0;this.m23=0;this.m24=0;this.m31=0;this.m32=0;this.m33=0;this.m34=0;this.m41=0;this.m42=0;this.m43=0;this.m44=0};A3.Core.Math.Matrix4.prototype={set:function(l,k,i,g,d,c,b,a,p,o,n,m,j,h,f,e){this.m11=l;this.m12=k;this.m13=i;this.m14=g;this.m21=d;this.m22=c;this.m23=b;this.m24=a;this.m31=p;this.m32=o;this.m33=n;this.m34=m;this.m41=j;this.m42=h;this.m43=f;this.m44=e;return this},copy:function(a){this.m11=a.m11;this.m12=a.m12;this.m13=a.m13;this.m14=a.m14;this.m21=a.m21;this.m22=a.m22;this.m23=a.m23;this.m24=a.m24;this.m31=a.m31;this.m32=a.m32;this.m33=a.m33;this.m34=a.m34;this.m41=a.m41;this.m42=a.m42;this.m43=a.m43;this.m44=a.m44;return this},identity:function(){return this.set(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1)},zero:function(){return this.set(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0)},frustum:function(f,p,e,l,i,g){var o=(p+f)/(p-f),m=(l+e)/(l-e),j=-(g+i)/(g-i),h=-(2*g*i)/(g-i),n=(2*i)/(p-f),k=(2*i)/(l-e);return this.set(n,0,o,0,0,k,m,0,0,0,j,h,0,0,-1,0)},perspective:function(g,d,c,b){var a,f,h,e;e=c*Math.tan(g*Math.PI/360);h=-e;a=h*d;f=e*d;return this.frustum(a,f,h,e,c,b)},setTranslationFromVector:function(a){this.m14+=a.x;this.m24+=a.y;this.m34+=a.z;return this},scaleByVector:function(b){var a=b.x,d=b.y,c=b.z;this.m11*=a;this.m12*=d;this.m13*=c;this.m21*=a;this.m22*=d;this.m23*=c;this.m31*=a;this.m32*=d;this.m33*=c;this.m41*=a;this.m42*=d;this.m43*=c;return this},scaleByScalar:function(a){this.m11*=a;this.m12*=a;this.m13*=a;this.m21*=a;this.m22*=a;this.m23*=a;this.m31*=a;this.m32*=a;this.m33*=a;this.m41*=a;this.m42*=a;this.m43*=a;return this},setRotationFromVector:function(b){var m=b.x,k=b.y,i=b.z,f=Math.cos(m),l=Math.sin(m),e=Math.cos(k),j=Math.sin(k),d=Math.cos(i),h=Math.sin(i),g=d*l,a=l*h,c=f*d;this.m11=e*d;this.m12=e*-h;this.m13=j;this.m21=g*j+h*f;this.m22=a*-j+c;this.m23=-l*e;this.m31=c*-j+a;this.m32=f*j*h+g;this.m33=f*e;return this
},multiply:function(C){var w=this.m11,u=this.m12,s=this.m13,q=this.m14,a=this.m21,J=this.m22,I=this.m23,G=this.m24,m=this.m31,l=this.m32,k=this.m33,i=this.m34,B=this.m41,A=this.m42,v=this.m43,t=this.m44,h=C.m11,f=C.m12,d=C.m13,b=C.m14,r=C.m21,p=C.m22,o=C.m23,n=C.m24,H=C.m31,F=C.m32,E=C.m33,D=C.m34,j=C.m41,g=C.m42,e=C.m43,c=C.m44;this.m11=w*h+u*r+s*H+q*j;this.m12=w*f+u*p+s*F+q*g;this.m13=w*d+u*o+s*E+q*e;this.m14=w*b+u*n+s*D+q*c;this.m21=a*h+J*r+I*H+G*j;this.m22=a*f+J*p+I*F+G*g;this.m23=a*d+J*o+I*E+G*e;this.m24=a*b+J*n+I*D+G*c;this.m31=m*h+l*r+k*H+i*j;this.m32=m*f+l*p+k*F+i*g;this.m33=m*d+l*o+k*E+i*e;this.m34=m*b+l*n+k*D+i*c;this.m41=B*h+A*r+v*H+t*j;this.m42=B*f+A*p+v*F+t*g;this.m43=B*d+A*o+v*E+t*e;this.m44=B*b+A*n+v*D+t*c;return this},multiplyVector3:function(a){var d=a.x,c=a.y,b=a.z,e=1/(this.m41*d*this.m42*c+this.m43*b+this.m44);a.x=this.m11*d+this.m12*c+this.m13*b+this.m14;a.y=this.m21*d+this.m22*c+this.m23*b+this.m24;a.z=this.m31*d+this.m32*c+this.m33*b+this.m34;a.multiplyByScalar(e);return a},determinant:function(){return this.m14*this.m23*this.m32*this.m41-this.m13*this.m24*this.m32*this.m41-this.m14*this.m22*this.m33*this.m41+this.m12*this.m24*this.m33*this.m41+this.m13*this.m22*this.m34*this.m41-this.m12*this.m23*this.m34*this.m41-this.m14*this.m23*this.m31*this.m42+this.m13*this.m24*this.m31*this.m42+this.m14*this.m21*this.m33*this.m42-this.m11*this.m24*this.m33*this.m42-this.m13*this.m21*this.m34*this.m42+this.m11*this.m23*this.m34*this.m42+this.m14*this.m22*this.m31*this.m43-this.m12*this.m24*this.m31*this.m43-this.m14*this.m21*this.m32*this.m43+this.m11*this.m24*this.m32*this.m43+this.m12*this.m21*this.m34*this.m43-this.m11*this.m22*this.m34*this.m43-this.m13*this.m22*this.m31*this.m44+this.m12*this.m23*this.m31*this.m44+this.m13*this.m21*this.m32*this.m44-this.m11*this.m23*this.m32*this.m44-this.m12*this.m21*this.m33*this.m44+this.m11*this.m22*this.m33*this.m44},invert:function(){var l=this.m11,k=this.m12,i=this.m13,g=this.m14,d=this.m21,c=this.m22,b=this.m23,a=this.m24,q=this.m31,p=this.m32,o=this.m33,m=this.m34,j=this.m41,h=this.m42,f=this.m43,e=this.m44,n=this.determinant();if(n===0){throw ("Matrix determinant is zero, can't invert.")}this.m11=b*m*h-a*o*h+a*p*f-c*m*f-b*p*e+c*o*e;this.m12=g*o*h-i*m*h-g*p*f+k*m*f+i*p*e-k*o*e;this.m13=i*a*h-g*b*h+g*c*f-k*a*f-i*c*e+k*b*e;this.m14=g*b*p-i*a*p-g*c*o+k*a*o+i*c*m-k*b*m;this.m21=a*o*j-b*m*j-a*q*f+d*m*f+b*q*e-d*o*e;this.m22=i*m*j-g*o*j+g*q*f-l*m*f-i*q*e+l*o*e;this.m23=g*b*j-i*a*j-g*d*f+l*a*f+i*d*e-l*b*e;this.m24=i*a*q-g*b*q+g*d*o-l*a*o-i*d*m+l*b*m;this.m31=c*m*j-a*p*j+a*q*h-d*m*h-c*q*e+d*p*e;this.m32=g*p*j-k*m*j-g*q*h+l*m*h+k*q*e-l*p*e;this.m33=k*a*j-g*c*j+g*d*h-l*a*h-k*d*e+l*c*e;this.m34=g*c*q-k*a*q-g*d*p+l*a*p+k*d*p-l*c*m;this.m41=b*p*j-c*o*j-b*q*h+d*o*h+c*q*f-d*p*f;this.m42=k*o*j-i*p*j+i*q*h-l*o*h-k*q*f+l*p*f;this.m43=i*c*j-k*b*j-i*d*h+l*b*h+k*d*f-l*c*f;this.m44=k*b*q-i*c*q+i*d*p-l*b*p-k*d*o+l*c*o;this.scaleByScalar(1/n);return this},lookAt:function(c,f,b){var e=new A3.Core.Math.Vector3(),a=new A3.Core.Math.Vector3(),d=new A3.Core.Math.Vector3();e.copy(c).subtract(f).normalize();if(e.length()===0){e.z=1}a.copy(b).cross(e).normalize();if(a.length()===0){e.z+=0.1;a.copy(b).cross(e).normalize()}d.copy(e).cross(a).normalize();this.m11=a.x;this.m12=d.x;this.m13=e.x;this.m21=a.y;this.m22=d.y;this.m23=e.y;this.m31=a.z;this.m32=d.z;this.m33=e.z;return this},toArray:function(a){if(!a){throw"You must provide a Float32Array to populate"}a[0]=this.m11;a[1]=this.m21;a[2]=this.m31;a[3]=this.m41;a[4]=this.m12;a[5]=this.m22;a[6]=this.m32;a[7]=this.m42;a[8]=this.m13;a[9]=this.m23;a[10]=this.m33;a[11]=this.m43;a[12]=this.m14;a[13]=this.m24;a[14]=this.m34;a[15]=this.m44;return a},toString:function(){return"Matrix4["+this.m11+","+this.m12+","+this.m13+","+this.m14+","+this.m21+","+this.m22+","+this.m23+","+this.m24+","+this.m31+","+this.m32+","+this.m33+","+this.m34+","+this.m41+","+this.m42+","+this.m43+","+this.m44+"]"}};A3.M4=A3.Core.Math.Matrix4;A3.Core.Math.Vector2=function(a,b){this.x=this.oldX=0;
this.y=this.oldY=0;a=a||0;b=b||0;return this.set(a,b)};A3.Core.Math.Vector2.prototype={isDirty:function(b){var a=(this.x===this.oldX)&&(this.y===this.oldY);return(!a)},resetDirty:function(){this.oldX=this.x;this.oldY=this.y;return this},set:function(a,b){this.x=a;this.y=b;return this},copy:function(a){return this.set(a.x,a.y)},dot:function(a){return this.x*a.x+this.y*a.y},length:function(){return Math.sqrt(this.x*this.x+this.y*this.y)},normalize:function(){len=1/this.length();this.x*=len;this.y*=len;return this},subtract:function(a){this.x-=a.x;this.y-=a.y;return this},add:function(a){this.x+=a.x;this.y+=a.y;return this},multiplyByScalar:function(a){this.x*=a;this.y*=a;return this},zero:function(){this.x=this.y=0;return this},negate:function(){this.x=-this.x;this.y=-this.y;return this},toArray:function(a){if(!a){throw"You must provide a Float32Array to populate"}a[0]=this.x;a[1]=this.y;return a},toString:function(){return"Vector2["+this.x+","+this.y+"]"}};A3.V2=A3.Core.Math.Vector2;A3.Core.Math.Vector3=function(a,c,b){this.x=this.oldX=0;this.y=this.oldY=0;this.z=this.oldZ=0;a=a||0;c=c||0;b=b||0;return this.set(a,c,b)};A3.Core.Math.Vector3.prototype={isDirty:function(){var a=(this.x===this.oldX)&&(this.y===this.oldY)&&(this.z===this.oldZ);return(!a)},resetDirty:function(){this.oldX=this.x;this.oldY=this.y;this.oldZ=this.z;return this},set:function(a,c,b){this.x=a;this.y=c;this.z=b;return this},copy:function(a){return this.set(a.x,a.y,a.z)},dot:function(a){return this.x*a.x+this.y*a.y+this.z*a.z},cross:function(b){var a=this.x,d=this.y,c=this.z;this.x=d*b.z-c*b.y;this.y=c*b.x-a*b.z;this.z=a*b.y-d*b.x;return this},length:function(){return Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z)},normalize:function(){len=1/this.length();this.x*=len;this.y*=len;this.z*=len;return this},subtract:function(a){this.x-=a.x;this.y-=a.y;this.z-=a.z;return this},add:function(a){this.x+=a.x;this.y+=a.y;this.z+=a.z;return this},multiplyByScalar:function(a){this.x*=a;this.y*=a;this.z*=a;return this},zero:function(){this.x=this.y=this.z=0;return this},negate:function(){this.x=-this.x;this.y=-this.y;this.z=-this.z;return this},toArray:function(a){if(!a){throw"You must provide a Float32Array to populate"}a[0]=this.x;a[1]=this.y;a[2]=this.z;return a},toString:function(){return"Vector3["+this.x+","+this.y+","+this.z+"]"}};A3.V3=A3.Core.Math.Vector3;A3.Core.Math.Vector4=function(a,d,c,b){return this.set(a,d,c,b)};A3.Core.Math.Vector4.prototype={set:function(a,d,c,b){this.x=a;this.y=d;this.z=c;this.w=b},xyz:function(){return new A3.Core.Math.Vector3(this.x,this.y,this.z)},rgb:function(){return this.xyz()},zero:function(){this.x=this.y=this.z=this.w=0},toArray:function(a){a[0]=this.x;a[1]=this.y;a[2]=this.z;a[3]=this.w;return a},toString:function(){return"Vector4["+this.x+","+this.y+","+this.z+","+this.w+"]"}};A3.V4=A3.Core.Math.Vector4;A3.Core.Object3D=function(){this.name=null;this.children=[];this.parent=null;this.matrix=new A3.Core.Math.Matrix4();this.matrixWorld=new A3.Core.Math.Matrix4();this.position=new A3.Core.Math.Vector3(0,0,0);this.rotation=new A3.Core.Math.Vector3(0,0,0);this.scale=new A3.Core.Math.Vector3(1,1,1);this.up=new A3.Core.Math.Vector3(0,1,0);this.target=null;this.dirty=true;this.visible=true};A3.Core.Object3D.prototype={add:function(a){if(a instanceof A3.Core.Object3D){if(!!a.parent){a.parent.remove(a)}a.parent=this;this.children.push(a);this.dirty=true}else{throw ("Child object must have a prototype of Object3D")}},remove:function(b){var a=this.children.indexOf(b);if(~a){this.children.splice(a,1);this.dirty=true}},update:function(b,c){var a=this.children.length;this.dirty=c||this.dirty||this.position.isDirty()||this.rotation.isDirty()||this.scale.isDirty();if(this.dirty){this.matrix.identity();this.matrix.setTranslationFromVector(this.position);if(!this.target){this.matrix.setRotationFromVector(this.rotation)}else{this.matrix.lookAt(this.position,this.target,this.up)}this.matrix.scaleByVector(this.scale);if(!b){this.matrixWorld.copy(this.matrix)
}else{this.matrixWorld.copy(b);this.matrixWorld.multiply(this.matrix)}if(!!this.matrixNormals){this.matrixNormals.copyMatrix4(this.matrixWorld).invert().transpose()}if(!!this.inverseMatrix){this.inverseMatrix.copy(this.matrixWorld);this.inverseMatrix.invert()}}while(a--){this.children[a].update(this.matrixWorld,this.dirty)}this.position.resetDirty();this.rotation.resetDirty();this.scale.resetDirty();this.dirty=false},lookAt:function(a){this.target=a}};A3.O3D=A3.Core.Object3D;A3.Core.Utility=function(){this.checkValue=function(c,a){var b=c;if(c===undefined||c===null){b=a}return b}};A3.Utility=new A3.Core.Utility();A3.Core.Render.Textures.Texture=function(a,b,d){var c=false;this.index=b||0;this.domElement=new Image();this.domElement.onload=function(){c=true;if(!!d){d()}};this.domElement.src=a;this.isReady=function(){return c}};A3.Texture=A3.Core.Render.Textures.Texture;A3.Core.Render.Textures.EnvironmentMap=function(c,b){var d=false,e=6,f=c.callback;function a(){e--;d=(e===0);if(d&&!!f){f()}}this.index=b||0;this.px=new A3.Core.Render.Textures.Texture(c.px,b,a);this.nx=new A3.Core.Render.Textures.Texture(c.nx,b,a);this.py=new A3.Core.Render.Textures.Texture(c.py,b,a);this.ny=new A3.Core.Render.Textures.Texture(c.ny,b,a);this.pz=new A3.Core.Render.Textures.Texture(c.pz,b,a);this.nz=new A3.Core.Render.Textures.Texture(c.nz,b,a);this.isReady=function(){return d}};A3.EnvironmentMap=A3.Core.Render.Textures.EnvironmentMap;A3.Core.Render.Shaders.Shader=function(g){var d=["uniform mat4 uProjectionMatrix, uModelViewMatrix;","uniform mat3 uNormalMatrix;","attribute vec3 aVertColor;","attribute vec3 aVertPosition;","attribute vec3 aVertNormal;","attribute vec2 aVertUV;",""].join("\n"),a=["#ifdef GL_ES","precision highp float;","#endif","uniform sampler2D uTexture;","uniform samplerCube uEnvironment;","uniform float uAlpha;",""].join("\n"),c=["uniform vec3 uEyeDirection, uEyePosition;","struct sLight {","int type;","bool active;","float falloff;","vec3 location;","vec3 color;","};","uniform vec3 uAmbientLightColor;","uniform sLight uLightSources["+A3.Constants.MAX_LIGHTS+"];",""].join("\n"),f=g.vertexShader||"",e=g.fragmentShader||"",h=g.attributes,b=g.uniforms;if(!!g.texture){f="#define USE_TEXTURE 1\n"+f;e="#define USE_TEXTURE 1\n"+e}if(!!g.environmentMap){f="#define USE_ENVMAP 1\n"+f;e="#define USE_ENVMAP 1\n"+e}if(!!g.fragmentLighting){a+=c}else{d+=c}this.shaderProgram=null;this.texture=g.texture;this.environmentMap=g.environmentMap;this.vertexShaderSource=d+f;this.fragmentShaderSource=a+e;this.customUniforms=b||{};this.customAttributes=h||{};this.initialized=false};A3.Core.Render.Shaders.Shader.prototype={initialize:function(i){if(!this.initialized){var n=i.createShader(i.VERTEX_SHADER),f=i.createShader(i.FRAGMENT_SHADER),g=null,j=0,h=0,k=A3.Constants.MAX_LIGHTS,b=Object.keys(this.customUniforms),e=b.length,m=null,l=Object.keys(this.customAttributes),c=l.length,a=null,d=null;this.shaderProgram=i.createProgram();i.shaderSource(n,this.vertexShaderSource);i.shaderSource(f,this.fragmentShaderSource);i.compileShader(n);i.compileShader(f);if(!i.getShaderParameter(n,i.COMPILE_STATUS)){console.error("Vertex shader compile failed");console.error(this.vertexShaderSource);throw i.getShaderInfoLog(n)}if(!i.getShaderParameter(f,i.COMPILE_STATUS)){console.error("Fragment shader compile failed");console.error(this.fragmentShaderSource);throw i.getShaderInfoLog(f)}i.attachShader(this.shaderProgram,n);i.attachShader(this.shaderProgram,f);i.linkProgram(this.shaderProgram);this.shaderProgram.attributes={aVertPosition:i.getAttribLocation(this.shaderProgram,"aVertPosition"),aVertNormal:i.getAttribLocation(this.shaderProgram,"aVertNormal"),aVertColor:i.getAttribLocation(this.shaderProgram,"aVertColor"),aVertUV:i.getAttribLocation(this.shaderProgram,"aVertUV"),aCustoms:[]};g=Object.keys(this.shaderProgram.attributes);j=g.length;while(j--){if(g[j]!=="aCustoms"){i.enableVertexAttribArray(this.shaderProgram.attributes[g[j]])}}while(c--){a=l[c];d=this.customAttributes[a];
this.shaderProgram.attributes.aCustoms.push({name:a,location:i.getAttribLocation(this.shaderProgram,a),data:i.createBuffer(),dataValues:new Float32Array(d.value)});d.needsUpdate=true;i.enableVertexAttribArray(this.shaderProgram.attributes.aCustoms[this.shaderProgram.attributes.aCustoms.length-1].location)}this.shaderProgram.uniforms={uModelViewMatrix:i.getUniformLocation(this.shaderProgram,"uModelViewMatrix"),uProjectionMatrix:i.getUniformLocation(this.shaderProgram,"uProjectionMatrix"),uEyeDirection:i.getUniformLocation(this.shaderProgram,"uEyeDirection"),uEyePosition:i.getUniformLocation(this.shaderProgram,"uEyePosition"),uAmbientLightColor:i.getUniformLocation(this.shaderProgram,"uAmbientLightColor"),uNormalMatrix:i.getUniformLocation(this.shaderProgram,"uNormalMatrix"),uTexture:i.getUniformLocation(this.shaderProgram,"uTexture"),uEnvironment:i.getUniformLocation(this.shaderProgram,"uEnvironment"),uAlpha:i.getUniformLocation(this.shaderProgram,"uAlpha"),uLightSources:[],uCustoms:[]};for(h=0;h<k;h++){this.shaderProgram.uniforms.uLightSources.push({type:i.getUniformLocation(this.shaderProgram,"uLightSources["+h+"].type"),falloff:i.getUniformLocation(this.shaderProgram,"uLightSources["+h+"].falloff"),location:i.getUniformLocation(this.shaderProgram,"uLightSources["+h+"].location"),color:i.getUniformLocation(this.shaderProgram,"uLightSources["+h+"].color")})}while(e--){m=b[e];this.shaderProgram.uniforms.uCustoms.push({name:m,value:i.getUniformLocation(this.shaderProgram,m)})}this.initialized=true}}};A3.Shader=A3.Core.Render.Shaders.Shader;A3.Core.Render.Shaders.ShaderLibrary=function(){this.get=function(h){var i=null,d=null,g=A3.Constants.MAX_LIGHTS,f=null,e=A3.Core.Render.Shaders.ShaderLibrary;h=A3.Utility.checkValue(h,{});h.name=A3.Utility.checkValue(h.name,"");h.type=A3.Utility.checkValue(h.type,"");h.ambientReflection=A3.Utility.checkValue(h.ambientReflection,1);h.diffuseReflection=A3.Utility.checkValue(h.diffuseReflection,1);h.specularReflection=A3.Utility.checkValue(h.specularReflection,1);h.specularShininess=A3.Utility.checkValue(h.specularShininess,20);h.particleSize=A3.Utility.checkValue(h.particleSize,5);h.particleScale=A3.Utility.checkValue(h.particleScale,0.01);h.specularColor=A3.Utility.checkValue(h.specularColor,new A3.Core.Math.Vector3(1,1,1));if(h.type==="Lambert"){h.specularReflection="0.0"}switch(h.type){case"Pink":i=e.Shaders.Pink.vertexShader;d=e.Shaders.Pink.fragmentShader;break;case"Basic":i=e.Shaders.Basic.vertexShader;d=e.Shaders.Basic.fragmentShader;break;case"Particle":e.Chunks.ParticleSize=a(h.particleSize);e.Chunks.ParticleScale=a(h.particleScale);i=c(e.Shaders.Particle.vertexShader);d=c(e.Shaders.Particle.fragmentShader);break;case"Normals":i=e.Shaders.Normals.vertexShader;d=e.Shaders.Normals.fragmentShader;break;case"Phong":case"Lambert":f="";for(g=0;g<A3.Constants.MAX_LIGHTS;g++){f+="addLight(lightDiffuseColor,lightSpecularColor,uLightSources["+g+"],aWorldVertexPosition,aVertEyeNormal,uEyeDirection,"+a(h.diffuseReflection)+","+a(h.specularReflection)+","+a(h.specularShininess)+","+b(h.specularColor)+");\n"}e.Chunks.LightingCalls=f;i=c(e.Shaders.PhongLambert.vertexShader);d=c(e.Shaders.PhongLambert.fragmentShader);break}return new A3.Core.Render.Shaders.Shader({name:h.name,vertexShader:i,fragmentShader:d,texture:h.texture,environmentMap:h.environmentMap,attributes:h.attributes,uniforms:h.uniforms})};function c(f){var d=/CHUNK\[([^\]]*)\]/,e=A3.Core.Render.Shaders.ShaderLibrary;while(d.test(f)){chunk=f.match(d);f=f.replace(chunk[0],e.Chunks[chunk[1]])}return f}function a(d){if(typeof d==="number"){d=d.toString();if(parseInt(d,10)===parseFloat(d,10)){d=d+".0"}}else{d="0.0"}return d}function b(d){return"vec3("+a(d.x)+","+a(d.y)+","+a(d.z)+")"}};A3.ShaderLibrary=new A3.Core.Render.Shaders.ShaderLibrary();A3.Core.Render.Renderer=function(c,a,b){c=c||404;a=a||250;b=b||{};return this.create(c,a,b)};A3.Core.Render.Renderer.prototype={create:function(c,a,b){this.domElement=null;this.gl=null;this.autoClear=A3.Utility.checkValue(b.autoClear,true);
this.clearColor=b.clearColor||new A3.Core.Math.Vector4(0,0,0,0);this.antialias=A3.Utility.checkValue(b.antialias,true);this.opaqueRenderableObjects=[];this.transparentRenderableObjects=[];this.lights=[];this.projectionMatrix=new A3.Core.Math.Matrix4();this.projectionMatrixArray=new Float32Array(16);this.modelViewMatrixArray=new Float32Array(16);this.normalMatrixArray=new Float32Array(9);this.lastShaderProgram=null;this.ambientLightColor=new A3.Core.Math.Vector3(0,0,0);this.ambientlightColorArray=new Float32Array(3);this.lightLocationArray=new Float32Array(3);this.lightColorArray=new Float32Array(3);this.eyeDirectionVector=new A3.Core.Math.Vector3(0,0,0);this.eyeDirectionArray=new Float32Array(3);this.eyePositionArray=new Float32Array(3);this._initialize(c,a,b);return this},_initialize:function(d,a,b){this.domElement=b.domElement||document.createElement("canvas");try{this.gl=this.domElement.getContext("experimental-webgl",{antialias:this.antialias});this.gl.clearColor(this.clearColor.x,this.clearColor.y,this.clearColor.z,this.clearColor.w);this.gl.enable(this.gl.DEPTH_TEST);this.gl.depthFunc(this.gl.LEQUAL);this.gl.depthMask(true)}catch(c){console.error("WebGL Context Creation Failed")}this.resize(d,a);this.gl.enable(this.gl.CULL_FACE);this.gl.cullFace(this.gl.BACK);this.gl.frontFace(this.gl.CCW)},resize:function(b,a){if(!!this.domElement&&!!this.gl){this.domElement.width=b;this.domElement.height=a;this.gl.viewportWidth=b;this.gl.viewportHeight=a;this.gl.viewport(0,0,this.gl.viewportWidth,this.gl.viewportHeight);if(this.autoClear){this.clear()}}},clear:function(){this.gl.clear(this.gl.COLOR_BUFFER_BIT|this.gl.DEPTH_BUFFER_BIT)},render:function(d,c){var b=null,a=null,e=null;this.projectionMatrix.zero();this.lastShaderProgram=null;if(this.autoClear){this.clear()}c.update();d.update();b=c.inverseMatrix;a=c.projectionMatrix;this.projectionMatrix.copy(a).multiply(b);this.projectionMatrix.toArray(this.projectionMatrixArray);this.eyeDirectionVector.copy(c.position).negate().normalize().toArray(this.eyeDirectionArray);c.position.toArray(this.eyePositionArray);this.opaqueRenderableObjects.length=0;this.transparentRenderableObjects.length=0;this.lights.length=0;this.appendChildren(d);this.transparentRenderableObjects.sort(this.sortByZ);this.renderObjectArray(this.opaqueRenderableObjects);this.renderObjectArray(this.transparentRenderableObjects);d.dirty=false;c.dirty=false;a=null;b=null;e=null},sortByZ:function(b,a){if(b.position.z>a.position.z){return -1}else{if(b.position.z<a.position.z){return 1}else{return 0}}},switchRenderMode:function(a){switch(a){case"additive":this.gl.enable(this.gl.BLEND);this.gl.blendEquation(this.gl.FUNC_ADD);this.gl.blendFunc(this.gl.SRC_ALPHA,this.gl.ONE);break;case"transparent":this.gl.enable(this.gl.BLEND);this.gl.blendEquation(this.gl.FUNC_ADD);this.gl.blendFunc(this.gl.SRC_ALPHA,this.gl.ONE_MINUS_SRC_ALPHA);break;default:this.gl.disable(this.gl.BLEND);break}},renderObjectArray:function(a){var b=a.length,c=null;while(b--){c=a[b];if(c.blendType===A3.Constants.BLEND_TYPES.ADDITIVE){this.switchRenderMode("additive")}else{if(c.transparent){this.switchRenderMode("transparent")}else{this.switchRenderMode("normal")}}this.renderObject(c);c.dirty=false}},appendChildren:function(b){if(!!b.visible){if(b instanceof A3.Core.Objects.Mesh){b.initialize(this.gl);if(b.transparent||b.blendType===A3.Constants.BLEND_TYPES.ADDITIVE){this.transparentRenderableObjects.push(b)}else{this.opaqueRenderableObjects.push(b)}}if(b instanceof A3.Core.Objects.Lights.Light){this.lights.push(b)}if(!!b.children.length){var a=b.children.length;while(a--){this.appendChildren(b.children[a])}}}},renderObject:function(b){var A=b.shader.shaderProgram,r=A.attributes.aVertPosition,c=A.attributes.aVertNormal,D=A.attributes.aVertColor,l=A.attributes.aVertUV,d=A.uniforms.uModelViewMatrix,g=A.uniforms.uProjectionMatrix,n=A.uniforms.uNormalMatrix,a=A.uniforms.uAmbientLightColor,B=A.uniforms.uEyeDirection,m=A.uniforms.uEyePosition,k=A.uniforms.uTexture,o=A.uniforms.uEnvironment,p=A.uniforms.uAlpha,t=A.attributes.aCustoms,j=t.length,s=null,v=null,q=A.uniforms.uCustoms,C=q.length,u=null,w=null,i=0,h=0,f=null,e=null;
this.ambientLightColor.zero();b.matrixWorld.toArray(this.modelViewMatrixArray);b.matrixNormals.toArray(this.normalMatrixArray);if(A!==this.lastShaderProgram){this.gl.useProgram(A);this.lastShaderProgram=A;this.gl.uniformMatrix4fv(g,false,this.projectionMatrixArray)}if(!b.transparent){b.opacity=1}this.gl.uniform1f(p,b.opacity);if(b.depthTest){this.gl.enable(this.gl.DEPTH_TEST)}else{this.gl.disable(this.gl.DEPTH_TEST)}while(i<A3.Constants.MAX_LIGHTS){e=this.lights[h];f=A.uniforms.uLightSources[i];if(!!e){if(e.type!==A3.Constants.LIGHT_TYPES.AMBIENT){if(e.type===A3.Constants.LIGHT_TYPES.DIRECTIONAL){e.location.x=e.position.x-e.target.x;e.location.y=e.position.y-e.target.y;e.location.z=e.position.z-e.target.z;e.location.normalize()}else{e.location.x=e.position.x;e.location.y=e.position.y;e.location.z=e.position.z}e.location.toArray(this.lightLocationArray);e.color.toArray(this.lightColorArray);this.gl.uniform1i(f.type,e.type);this.gl.uniform1f(f.falloff,e.fallOffDistance||0);this.gl.uniform3fv(f.location,this.lightLocationArray);this.gl.uniform3fv(f.color,this.lightColorArray);i++}else{this.ambientLightColor.x+=e.color.x;this.ambientLightColor.y+=e.color.y;this.ambientLightColor.z+=e.color.z}}else{this.gl.uniform1i(f.type,A3.Constants.LIGHT_TYPES.NONE);i++}h++}this.ambientLightColor.toArray(this.ambientlightColorArray);this.gl.uniform3fv(a,this.ambientlightColorArray);while(C--){w=q[C];u=b.shader.customUniforms[w.name];if(!!u&&!!w.value){switch(u.type){case"float":this.gl.uniform1f(w.value,u.value);break}}}while(j--){v=t[j];s=b.shader.customAttributes[v.name];if(!!s&&!!v.location){switch(s.type){case"float":this.gl.bindBuffer(this.gl.ARRAY_BUFFER,v.data);if(s.needsUpdate){v.dataValues.set(s.value);this.gl.bufferData(this.gl.ARRAY_BUFFER,v.dataValues,this.gl.STATIC_DRAW)}this.gl.vertexAttribPointer(v.location,1,this.gl.FLOAT,false,0,0);break}}}this.gl.uniform3fv(m,this.eyePositionArray);this.gl.uniform3fv(B,this.eyeDirectionArray);this.gl.uniformMatrix4fv(d,false,this.modelViewMatrixArray);this.gl.uniformMatrix3fv(n,false,this.normalMatrixArray);if(b.renderType===A3.Constants.RENDER_TYPES.PARTICLES){l=0}if(!!b.shader.texture&&b.shader.texture.isReady()&&~l){if(!b.shader.texture.data){this.processTexture(b.shader.texture)}this.gl.activeTexture(this.gl.TEXTURE0+b.shader.texture.index);this.gl.bindTexture(this.gl.TEXTURE_2D,b.shader.texture.data);this.gl.uniform1i(k,b.shader.texture.index);this.gl.bindBuffer(this.gl.ARRAY_BUFFER,b.buffers.uvs.data);this.gl.vertexAttribPointer(l,b.uvDataSize,this.gl.FLOAT,false,0,0)}if(!!b.shader.environmentMap&&b.shader.environmentMap.isReady()){if(!b.shader.environmentMap.data){this.processEnvironmentMap(b.shader.environmentMap)}this.gl.activeTexture(this.gl.TEXTURE0+b.shader.environmentMap.index);this.gl.bindTexture(this.gl.TEXTURE_2D,b.shader.environmentMap.data);this.gl.uniform1i(o,b.shader.environmentMap.index)}if(b.renderType===A3.Constants.RENDER_TYPES.SOLID){if(~c){this.gl.bindBuffer(this.gl.ARRAY_BUFFER,b.buffers.normals.data);this.gl.vertexAttribPointer(c,b.normalDataSize,this.gl.FLOAT,false,0,0)}if(~D){this.gl.bindBuffer(this.gl.ARRAY_BUFFER,b.buffers.colors.data);this.gl.vertexAttribPointer(D,b.colorDataSize,this.gl.FLOAT,false,0,0)}this.gl.bindBuffer(this.gl.ARRAY_BUFFER,b.buffers.vertices.data);this.gl.vertexAttribPointer(r,b.vertexDataSize,this.gl.FLOAT,false,0,0);this.gl.bindBuffer(this.gl.ELEMENT_ARRAY_BUFFER,b.buffers.elements.data);this.gl.drawElements(this.gl.TRIANGLES,b.buffers.elements.size,this.gl.UNSIGNED_SHORT,0)}else{this.gl.bindBuffer(this.gl.ARRAY_BUFFER,b.buffers.colors.data);this.gl.vertexAttribPointer(D,b.colorDataSize,this.gl.FLOAT,false,0,0);this.gl.bindBuffer(this.gl.ARRAY_BUFFER,b.buffers.vertices.data);this.gl.vertexAttribPointer(r,b.vertexDataSize,this.gl.FLOAT,false,0,0);this.gl.drawArrays(this.gl.POINTS,0,b.buffers.vertices.size)}},processTexture:function(a){a.data=this.gl.createTexture();this.gl.bindTexture(this.gl.TEXTURE_2D,a.data);this.gl.pixelStorei(this.gl.UNPACK_FLIP_Y_WEBGL,true);
this.gl.texImage2D(this.gl.TEXTURE_2D,0,this.gl.RGBA,this.gl.RGBA,this.gl.UNSIGNED_BYTE,a.domElement);this.gl.texParameteri(this.gl.TEXTURE_2D,this.gl.TEXTURE_MAG_FILTER,this.gl.LINEAR);this.gl.texParameteri(this.gl.TEXTURE_2D,this.gl.TEXTURE_MIN_FILTER,this.gl.LINEAR);this.gl.texParameteri(this.gl.TEXTURE_2D,this.gl.TEXTURE_WRAP_S,this.gl.CLAMP_TO_EDGE);this.gl.texParameteri(this.gl.TEXTURE_2D,this.gl.TEXTURE_WRAP_T,this.gl.CLAMP_TO_EDGE);this.gl.bindTexture(this.gl.TEXTURE_2D,null)},processEnvironmentMap:function(a){a.data=this.gl.createTexture();this.gl.bindTexture(this.gl.TEXTURE_CUBE_MAP,a.data);this.gl.pixelStorei(this.gl.UNPACK_FLIP_Y_WEBGL,false);this.gl.texImage2D(this.gl.TEXTURE_CUBE_MAP_POSITIVE_X,0,this.gl.RGBA,this.gl.RGBA,this.gl.UNSIGNED_BYTE,a.px.domElement);this.gl.texImage2D(this.gl.TEXTURE_CUBE_MAP_NEGATIVE_X,0,this.gl.RGBA,this.gl.RGBA,this.gl.UNSIGNED_BYTE,a.nx.domElement);this.gl.texImage2D(this.gl.TEXTURE_CUBE_MAP_POSITIVE_Y,0,this.gl.RGBA,this.gl.RGBA,this.gl.UNSIGNED_BYTE,a.py.domElement);this.gl.texImage2D(this.gl.TEXTURE_CUBE_MAP_NEGATIVE_Y,0,this.gl.RGBA,this.gl.RGBA,this.gl.UNSIGNED_BYTE,a.ny.domElement);this.gl.texImage2D(this.gl.TEXTURE_CUBE_MAP_POSITIVE_Z,0,this.gl.RGBA,this.gl.RGBA,this.gl.UNSIGNED_BYTE,a.pz.domElement);this.gl.texImage2D(this.gl.TEXTURE_CUBE_MAP_NEGATIVE_Z,0,this.gl.RGBA,this.gl.RGBA,this.gl.UNSIGNED_BYTE,a.nz.domElement);this.gl.texParameteri(this.gl.TEXTURE_CUBE_MAP,this.gl.TEXTURE_MAG_FILTER,this.gl.LINEAR);this.gl.texParameteri(this.gl.TEXTURE_CUBE_MAP,this.gl.TEXTURE_MIN_FILTER,this.gl.LINEAR);this.gl.texParameteri(this.gl.TEXTURE_CUBE_MAP,this.gl.TEXTURE_WRAP_S,this.gl.CLAMP_TO_EDGE);this.gl.texParameteri(this.gl.TEXTURE_CUBE_MAP,this.gl.TEXTURE_WRAP_T,this.gl.CLAMP_TO_EDGE);this.gl.generateMipmap(this.gl.TEXTURE_CUBE_MAP);this.gl.bindTexture(this.gl.TEXTURE_2D,null)}};A3.R=A3.Core.Render.Renderer;A3.Core.Scene.BasicScene=function(){A3.Core.Object3D.call(this)};A3.Core.Scene.BasicScene.prototype=new A3.Core.Object3D();A3.Scene=A3.Core.Scene.BasicScene;A3.Core.Camera.BasicCamera=function(d,c,b,a){A3.Core.Object3D.call(this);this.name="camera";this.projectionMatrix=new A3.Core.Math.Matrix4();this.inverseMatrix=new A3.Core.Math.Matrix4();this.inverseMatrix.identity();this.projectionMatrix.perspective(d,c,b,a);this.target=new A3.Core.Math.Vector3(0,0,0);this.position=new A3.Core.Math.Vector3(0,0,1)};A3.Core.Camera.BasicCamera.prototype=new A3.Core.Object3D();A3.Camera=A3.Core.Camera.BasicCamera;A3.Core.Objects.Mesh=function(a){A3.Core.Object3D.call(this);a=A3.Utility.checkValue(a,{});a.vertexDataSize=A3.Utility.checkValue(a.vertexDataSize,3);a.normalDataSize=A3.Utility.checkValue(a.normalDataSize,3);a.colorDataSize=A3.Utility.checkValue(a.colorDataSize,3);a.uvDataSize=A3.Utility.checkValue(a.uvDataSize,2);a.renderType=A3.Utility.checkValue(a.renderType,"solid");a.blendType=A3.Utility.checkValue(a.blendType,"normal");a.depthTest=A3.Utility.checkValue(a.depthTest,true);this.geometry=null;this.vertexDataSize=a.vertexDataSize;this.normalDataSize=a.normalDataSize;this.colorDataSize=a.colorDataSize;this.uvDataSize=a.uvDataSize;this.matrixNormals=new A3.Core.Math.Matrix3();this.dynamic=a.dynamic||false;this.shader=a.shader;this.renderType=a.renderType.toLowerCase()==="particle"?A3.Constants.RENDER_TYPES.PARTICLES:A3.Constants.RENDER_TYPES.SOLID;this.blendType=a.blendType.toLowerCase()==="additive"?A3.Constants.BLEND_TYPES.ADDITIVE:A3.Constants.BLEND_TYPES.NORMAL;this.opacity=a.opacity||1;this.transparent=a.transparent||false;this.depthTest=a.depthTest;this.buffers={vertices:null,elements:null,normals:null,uvs:null,colors:null};if(!!a.geometry){this.geometry=a.geometry}};A3.Core.Objects.Mesh.prototype=new A3.Core.Object3D();A3.Core.Objects.Mesh.prototype.initialize=function(b){var a=this.dynamic?b.DYNAMIC_DRAW:b.STATIC_DRAW;if(this.geometry.verticesNeedUpdate){if(!this.buffers.vertices){this.buffers.vertices={data:b.createBuffer(),size:this.geometry.vertexPositionArray.length/this.vertexDataSize}
}b.bindBuffer(b.ARRAY_BUFFER,this.buffers.vertices.data);b.bufferData(b.ARRAY_BUFFER,this.geometry.vertexPositionArray,a);this.geometry.verticesNeedUpdate=false}if(this.geometry.normalsNeedUpdate){if(!this.buffers.normals){this.buffers.normals={data:b.createBuffer(),size:this.geometry.vertexNormalArray.length/this.vertexDataSize}}b.bindBuffer(b.ARRAY_BUFFER,this.buffers.normals.data);b.bufferData(b.ARRAY_BUFFER,this.geometry.vertexNormalArray,a);this.geometry.normalsNeedUpdate=false}if(this.geometry.colorsNeedUpdate){if(!this.buffers.colors){this.buffers.colors={data:b.createBuffer(),size:this.geometry.vertexColorArray.length/this.colorDataSize}}b.bindBuffer(b.ARRAY_BUFFER,this.buffers.colors.data);b.bufferData(b.ARRAY_BUFFER,this.geometry.vertexColorArray,a);this.geometry.colorsNeedUpdate=false}if(this.geometry.elementsNeedUpdate){if(!this.buffers.elements){this.buffers.elements={data:b.createBuffer(),size:this.geometry.faceElementArray.length}}b.bindBuffer(b.ELEMENT_ARRAY_BUFFER,this.buffers.elements.data);b.bufferData(b.ELEMENT_ARRAY_BUFFER,this.geometry.faceElementArray,a);this.geometry.elementsNeedUpdate=false}if(this.geometry.uvsNeedUpdate){if(!this.buffers.uvs){this.buffers.uvs={data:b.createBuffer(),size:this.geometry.uvArray.length}}b.bindBuffer(b.ARRAY_BUFFER,this.buffers.uvs.data);b.bufferData(b.ARRAY_BUFFER,this.geometry.uvArray,a);this.geometry.uvsNeedUpdate=false}this.shader.initialize(b)};A3.Mesh=A3.Core.Objects.Mesh;A3.Core.Objects.Geometric.Vertex=function(a,c,b){this.normal=new A3.Core.Math.Vector3(0,0,0);this.position=new A3.Core.Math.Vector3(a,c,b);this.positionArray=new Array(3);this.normalArray=new Array(3)};A3.Core.Objects.Geometric.Vertex.prototype={copy:function(a){this.position.copy(a.position);return this},toPositionArray:function(){this.positionArray[0]=this.position.x;this.positionArray[1]=this.position.y;this.positionArray[2]=this.position.z;return this.positionArray},toNormalArray:function(){this.normalArray[0]=this.normal.x;this.normalArray[1]=this.normal.y;this.normalArray[2]=this.normal.z;return this.normalArray}};A3.Vertex=A3.Core.Objects.Geometric.Vertex;A3.Core.Objects.Geometric.Face3=function(c,b,a){this.v1=c;this.v2=b;this.v3=a;this.normal=null;this.elementArray=new Array(3)};A3.Core.Objects.Geometric.Face3.prototype={toElementArray:function(){this.elementArray[0]=this.v1;this.elementArray[1]=this.v2;this.elementArray[2]=this.v3;return this.elementArray}};A3.Face3=A3.Core.Objects.Geometric.Face3;A3.Core.Objects.Geometric.Face4=function(d,c,b,a){this.v1=d;this.v2=c;this.v3=b;this.v4=a;this.normal=null;this.elementArray=new Array(6)};A3.Core.Objects.Geometric.Face4.prototype={toElementArray:function(){this.elementArray[0]=this.v1;this.elementArray[1]=this.v2;this.elementArray[2]=this.v3;this.elementArray[3]=this.v1;this.elementArray[4]=this.v3;this.elementArray[5]=this.v4;return this.elementArray}};A3.Face4=A3.Core.Objects.Geometric.Face4;A3.Core.Objects.Geometric.Geometry=function(a){this.vertices=a.vertices;this.faces=a.faces||[];this.colors=a.colors||[];this.faceUVs=a.faceUVs||[];this.uvs=(!!this.faceUVs?new Array(this.vertices.length):[]);this.verticesNeedUpdate=true;this.colorsNeedUpdate=true;this.normalsNeedUpdate=true;this.elementsNeedUpdate=true;this.uvsNeedUpdate=true;this.vertexPositionArray=null;this.vertexNormalArray=null;this.vertexColorArray=null;this.faceElementArray=null;this.uvArray=null;this.drawAsFlat=a.flatShaded||false;this.separateFaces();this.calculateNormals();this.updateVertexPositionArray();this.updateVertexNormalArray();this.updateVertexColorArray();this.updateFaceElementArray();this.updateUVArray()};A3.Core.Objects.Geometric.Geometry.prototype={calculateNormals:function(){var e=null,d=null,a=null,h=null,c=null,i=new A3.Core.Math.Vector3(),g=new A3.Core.Math.Vector3(),b=new A3.Core.Math.Vector3();for(d=0;d<this.faces.length;d++){e=this.faces[d];i.copy(this.vertices[e.v1].position);g.copy(this.vertices[e.v2].position);b.copy(this.vertices[e.v3].position);i.subtract(g);
g.subtract(b);h=i.cross(g);this.addToNormal(this.vertices[e.v1],h);this.addToNormal(this.vertices[e.v2],h);this.addToNormal(this.vertices[e.v3],h);if(!!e.v4){this.addToNormal(this.vertices[e.v4],h)}}for(a=0;a<this.vertices.length;a++){c=this.vertices[a];c.normal.normalize()}},addToNormal:function(b,c){var a=0;if(!!b.smoothGroup){a=b.smoothGroup.length;while(a--){this.vertices[b.smoothGroup[a]].normal.add(c)}}else{b.normal.add(c)}},separateFaces:function(j){var e=0,i=1,b=0,d=3,g=null,h=null,c=null,a=null;for(e=0;e<this.faces.length;e++){h=this.faces[e];d=(h instanceof A3.Core.Objects.Geometric.Face3?3:4);for(i=1;i<=d;i++){c=this.vertices[h["v"+i]];a=this.colors[h["v"+i]];if(!c.inUse){c.inUse=true}else{g=new A3.Core.Objects.Geometric.Vertex(c.position.x,c.position.y,c.position.z);if(j){g.normal.x=c.normal.x;g.normal.y=c.normal.y;g.normal.z=c.normal.z}this.vertices.push(g);if(!this.drawAsFlat){if(!c.smoothGroup){c.smoothGroup=[]}g.smoothGroup=c.smoothGroup}c.smoothGroup.push(this.vertices.length-1);c.smoothGroup.push(h["v"+i]);if(!!a){this.colors.push(new A3.Core.Math.Vector3(a.x,a.y,a.z))}h["v"+i]=(this.vertices.length-1)}if(b<this.faceUVs.length){this.uvs[h["v"+i]]=this.faceUVs[b]}b++}}},updateUVArray:function(){var c=0,d=0,e=new Array(this.uvs.length*2),b=[],a=null;for(c=0;c<this.uvs.length;c++){a=this.uvs[c];if(!!a){a.toArray(b);e[d++]=b[0];e[d++]=b[1]}}this.uvsNeedUpdate=true;this.uvArray=new Float32Array(e);return this.uvArray},updateVertexPositionArray:function(){var b=0,d=0,c=this.vertices.length*3,e=new Array(c),a=null;for(b=0;b<this.vertices.length;b++){a=this.vertices[b].toPositionArray();e[d++]=a[0];e[d++]=a[1];e[d++]=a[2]}this.verticesNeedUpdate=true;this.vertexPositionArray=new Float32Array(e);return this.vertexPositionArray},updateVertexNormalArray:function(){var c=0,e=0,d=this.vertices.length*3,b=new Array(d),a=null;for(c=0;c<this.vertices.length;c++){a=this.vertices[c].toNormalArray();b[e++]=a[0];b[e++]=a[1];b[e++]=a[2]}this.normalsNeedUpdate=true;this.vertexNormalArray=new Float32Array(b);return this.vertexNormalArray},updateVertexColorArray:function(){var e=0,b=0,d=[],a=[];for(e=0;e<this.colors.length;e++){this.colors[e].toArray(a);d[b++]=a[0];d[b++]=a[1];d[b++]=a[2]}this.colorsNeedUpdate=true;this.vertexColorArray=new Float32Array(d);return this.vertexColorArray},updateFaceElementArray:function(){var d=0,a=0,b=[],c=null;for(d=0;d<this.faces.length;d++){c=this.faces[d].toElementArray();for(a=0;a<c.length;a++){b.push(c[a])}}this.elementsNeedUpdate=true;this.faceElementArray=new Uint16Array(b);return this.faceElementArray}};A3.Geometry=A3.Core.Objects.Geometric.Geometry;A3.Core.Objects.Lights.Light=function(b,a){A3.Core.Object3D.call(this);this.color=b;if(!!b){this.color.x*=a;this.color.y*=a;this.color.z*=a}this.type=0;this.location=new A3.Core.Math.Vector3(0,0,0)};A3.Core.Objects.Lights.Light.prototype=new A3.Core.Object3D();A3.Core.Objects.Lights.AmbientLight=function(b,a){A3.Core.Objects.Lights.Light.call(this,b,a);this.type=A3.Constants.LIGHT_TYPES.AMBIENT};A3.Core.Objects.Lights.AmbientLight.prototype=new A3.Core.Objects.Lights.Light();A3.AmbientLight=A3.Core.Objects.Lights.AmbientLight;A3.Core.Objects.Lights.DirectionalLight=function(b,a){A3.Core.Objects.Lights.Light.call(this,b,a);this.target=new A3.Core.Math.Vector3(0,0,0);this.position=new A3.Core.Math.Vector3(0,1,0);this.type=A3.Constants.LIGHT_TYPES.DIRECTIONAL};A3.Core.Objects.Lights.DirectionalLight.prototype=new A3.Core.Objects.Lights.Light();A3.DirectionalLight=A3.Core.Objects.Lights.DirectionalLight;A3.Core.Objects.Lights.PointLight=function(b,a){A3.Core.Objects.Lights.Light.call(this,b,a);this.position=new A3.Core.Math.Vector3(0,0,0);this.fallOffDistance=200;this.type=A3.Constants.LIGHT_TYPES.POINT};A3.Core.Objects.Lights.PointLight.prototype=new A3.Core.Objects.Lights.Light();A3.PointLight=A3.Core.Objects.Lights.PointLight;A3.Core.Objects.Primitives.Cube=function(n){n*=0.5;var g=null,d=null,b=[],j=0,m=new A3.Vertex(-n,-n,n),i=new A3.Vertex(n,-n,n),e=new A3.Vertex(n,n,n),h=new A3.Vertex(-n,n,n),l=new A3.Vertex(n,-n,-n),a=new A3.Vertex(-n,-n,-n),k=new A3.Vertex(-n,n,-n),f=new A3.Vertex(n,n,-n);
g=[m,i,e,h,l,a,k,f,(new A3.Vertex()).copy(a),(new A3.Vertex()).copy(m),(new A3.Vertex()).copy(h),(new A3.Vertex()).copy(k),(new A3.Vertex()).copy(i),(new A3.Vertex()).copy(l),(new A3.Vertex()).copy(f),(new A3.Vertex()).copy(e),(new A3.Vertex()).copy(e),(new A3.Vertex()).copy(f),(new A3.Vertex()).copy(k),(new A3.Vertex()).copy(h),(new A3.Vertex()).copy(i),(new A3.Vertex()).copy(m),(new A3.Vertex()).copy(a),(new A3.Vertex()).copy(l)];d=[new A3.Face4(0,1,2,3),new A3.Face4(4,5,6,7),new A3.Face4(8,9,10,11),new A3.Face4(12,13,14,15),new A3.Face4(16,17,18,19),new A3.Face4(20,21,22,23)];for(j=0;j<g.length;j++){b.push(new A3.V3(1,1,1))}return new A3.Geometry({vertices:g,faces:d,colors:b})};A3.Core.Objects.Primitives.Cube.prototype=new A3.Core.Objects.Mesh();A3.Cube=A3.Core.Objects.Primitives.Cube;A3.Core.Objects.Primitives.Sphere=function(i,w,r){var C=Math.PI*-0.5,n=Math.PI*0.5,f=Math.PI,A=0,B=Math.PI*2,l=[],d=[],s=[],q=[],m=0,c=0,o=C,h=A,t=0,u=0,p=null,g=null,e=null,b=null,a=null;r=Math.max(r,3);w=Math.max(w,3);function k(F,H){var I=Math.cos(F),E=Math.sin(F),G=Math.cos(H),D=Math.sin(H);x=I*G*i;y=-E*i;z=-I*D*i;return v({vertex:new A3.Vertex(Math.round(x),Math.round(y),Math.round(z)),color:new A3.V3(1,1,1)})}function v(G){var H=null,F=false,E=0,D=0;for(D=0;D<l.length;D++){H=l[D].position;F=((H.x===G.vertex.position.x)&&(H.y===G.vertex.position.y)&&(H.z===G.vertex.position.z));if(F){E=D;break}}if(!F){l.push(G.vertex);q.push(G.color);E=l.length-1}return E}function j(D,E){return new A3.V2(E/B,1-((D/n)+1)*0.5)}while(m<r){h=(m/r)*B;u=((m+1)/r)*B;c=0;while(c<w){o=C+(c/w)*f;t=C+((c+1)/w)*f;g=k(o,h);e=k(t,h);b=k(t,u);a=k(o,u);if(g===e||e===b||b===a||a===g){if(g===e){p=new A3.Face3(g,b,a);s.push(j(o,h));s.push(j(t,u));s.push(j(o,u))}else{if(e===b){p=new A3.Face3(g,e,a);s.push(j(o,h));s.push(j(t,h));s.push(j(o,u))}else{if(b===a){p=new A3.Face3(g,e,a);s.push(j(o,h));s.push(j(t,h));s.push(j(o,u))}else{if(a===g){p=new A3.Face3(g,e,b);s.push(j(o,h));s.push(j(t,h));s.push(j(t,u))}}}}}else{p=new A3.Face4(g,e,b,a);s.push(j(o,h));s.push(j(t,h));s.push(j(t,u));s.push(j(o,u))}d.push(p);c++}m++}return new A3.Geometry({vertices:l,faces:d,colors:q,faceUVs:s})};A3.Core.Objects.Primitives.Sphere.prototype=new A3.Core.Objects.Mesh();A3.Sphere=A3.Core.Objects.Primitives.Sphere;A3.Core.Objects.Primitives.Plane=function(e,q,k,m){var n=[],f=[],d=[],i=[],g=e,c=q,j=e*0.5,o=q*0.5,l=0,p=0;k=k||1;m=m||1;g=e/k;c=q/m;function b(s,r){return a({vertex:new A3.Vertex((s*g)-j,(r*c)-o,0),color:new A3.V3(1,1,1)})}function a(t){var u=null,s=false,r=0,h=0;for(h=0;h<n.length;h++){u=n[h].position;s=((u.x===t.vertex.position.x)&&(u.y===t.vertex.position.y)&&(u.z===t.vertex.position.z));if(s){r=h;break}}if(!s){n.push(t.vertex);d.push(t.color);r=n.length-1}return r}for(l=0;l<k;l++){for(p=0;p<m;p++){i.push(new A3.V2(l/k,p/m));i.push(new A3.V2((l+1)/k,p/m));i.push(new A3.V2((l+1)/k,(p+1)/m));i.push(new A3.V2(l/k,(p+1)/m));f.push(new A3.Face4(b(l,p),b(l+1,p),b(l+1,p+1),b(l,p+1)))}}return new A3.Geometry({vertices:n,faces:f,colors:d,faceUVs:i,flatShaded:false})};A3.Core.Objects.Primitives.Plane.prototype=new A3.Core.Objects.Mesh();A3.Plane=A3.Core.Objects.Primitives.Plane;A3.Core.Remote.MeshLoader=function(c,d){var b=new XMLHttpRequest(),e=null,s=null,n=null,h=[],a=[],k=[],o=null,q=null,j=null,l=[],p=null,g=null,m=0,r=0,i=0;b.onreadystatechange=function(){if(b.readyState===4){s=JSON.parse(b.responseText);n=s.vertices;o=s.faces;p=s.uv;for(m=0;m<n.length;m++){vertexData=n[m];h.push(new A3.Vertex(vertexData[0],vertexData[1],vertexData[2]))}for(r=0;r<o.length;r++){q=o[r];if(q.length===3){j=new A3.Face3(q[0],q[1],q[2])}else{if(q.length===4){j=new A3.Face4(q[0],q[1],q[2],q[3])}}a.push(j)}if(!!p&&!!p.length){for(i=0;i<p.length;i++){g=p[i];l.push(new A3.V2(g[0],g[1]))}}e=new A3.Geometry({vertices:h,faces:a,colors:k,faceUVs:l});if(!!d){d(e)}}};this.load=function(){b.open("GET",c,true);b.send(null)}};A3.MeshLoader=A3.Core.Remote.MeshLoader;A3.Core.Render.Shaders.ShaderLibrary.Chunks={Lighting:"/**\n * Adds the diffuse component of the light\n */\nvoid addLight( inout vec3 aDiffuseColor,\n inout vec3 aSpecularColor,\n sLight light,\n vec4 aWorldVertexPosition,\n vec3 aVertEyeNormal,\n vec3 uEyeDirection,\n float diffuseReflection,\n float specularReflection,\n float specularShininess, \n vec3 specularColor) {\n // if it has no type, discard it\n if(light.type == 0) {\n return;\n } else if(light.type >= 2) {\n vec3 lightLocation = light.location;\n vec3 reflectLightDirection = reflect(lightLocation, aVertEyeNormal);\n float attenuation = 1.0;\n float specularPower = 1.0;\n if(light.type == 4) {\n vec3 lightToVertex = light.location - aWorldVertexPosition.xyz;\n float distance = length(lightToVertex);\n attenuation = max(1.0 - (distance / light.falloff), 0.0);\n lightLocation = normalize(lightToVertex);\n reflectLightDirection = reflect(lightLocation, aVertEyeNormal);\n }\n specularPower = pow(max(dot(uEyeDirection, reflectLightDirection), 0.0), specularShininess);\n // diffuse\n aDiffuseColor += max(dot(aVertEyeNormal, lightLocation), 0.0) * diffuseReflection * light.color * attenuation;\n aSpecularColor += specularColor * specularPower * specularReflection * attenuation;\n }\n}"};
A3.Core.Render.Shaders.ShaderLibrary.Shaders={Basic:{vertexShader:"varying vec3 vVertexColor;\n#ifdef USE_TEXTURE \n varying vec2 vVertexUV;\n#endif \nvoid main() {\n #ifdef USE_TEXTURE \n vVertexUV = aVertUV;\n #endif \n vVertexColor = aVertColor;\n gl_Position = uProjectionMatrix * uModelViewMatrix * vec4(aVertPosition, 1.0);\n}",fragmentShader:"varying vec3 vVertexColor;\n#ifdef USE_TEXTURE\n varying vec2 vVertexUV;\n#endif\nvoid main() {\n vec4 vertexFinalColor = vec4(vVertexColor, 1.0);\n #ifdef USE_TEXTURE\n vertexFinalColor *= texture2D(uTexture, vVertexUV);\n #endif\n vertexFinalColor.a *= uAlpha;\n gl_FragColor = vertexFinalColor;\n}"},Pink:{vertexShader:"void main() {\n gl_Position = uProjectionMatrix * uModelViewMatrix * vec4(aVertPosition, 1.0);\n}",fragmentShader:"void main() {\n gl_FragColor = vec4(0.996078, 0.341176, 0.631372, 1.0);\n}"},Particle:{vertexShader:"varying vec3 vVertexColor;\nvoid main() {\n vec4 particlePosition = uModelViewMatrix * vec4(aVertPosition, 1.0);\n vVertexColor = aVertColor;\n gl_Position = uProjectionMatrix * particlePosition;\n gl_PointSize = CHUNK[ParticleSize] / (CHUNK[ParticleScale] * length(uEyePosition.xyz - particlePosition.xyz));\n}",fragmentShader:"varying vec3 vVertexColor;\n#ifdef USE_TEXTURE\n varying vec2 vVertexUV;\n#endif\nvoid main() {\n vec4 vertexFinalColor = vec4(vVertexColor, uAlpha);\n #ifdef USE_TEXTURE\n vertexFinalColor *= texture2D(uTexture, gl_PointCoord);\n #endif\n gl_FragColor = vertexFinalColor;\n}"},Normals:{vertexShader:"varying vec3 aVertexColor;\nvoid main() {\n vec3 aVertEyeNormal = normalize(uNormalMatrix * aVertNormal);\n aVertexColor = vec3(\n (aVertEyeNormal.x + 1.0) * 0.5,\n (aVertEyeNormal.y + 1.0) * 0.5,\n max(0.0, aVertEyeNormal.z));\n gl_Position = uProjectionMatrix * uModelViewMatrix * vec4(aVertPosition, 1.0);\n}",fragmentShader:"varying vec3 aVertexColor;\nvoid main() {\n gl_FragColor = vec4(aVertexColor, 1.0);\n}"},PhongLambert:{vertexShader:"varying vec3 vVertexColor;\n#ifdef USE_TEXTURE \n varying vec2 vVertexUV;\n#endif\n#ifdef USE_ENVMAP\n varying vec3 vVertexRef;\n#endif\nCHUNK[Lighting]\nvoid main() {\n vec3 aVertEyeNormal = normalize(uNormalMatrix * aVertNormal);\n vec3 lightDiffuseColor = uAmbientLightColor;\n vec3 lightSpecularColor = vec3(0.0);\n vec4 aWorldVertexPosition = uModelViewMatrix * vec4(aVertPosition, 1.0);\n #ifdef USE_TEXTURE \n vVertexUV = aVertUV;\n #endif \n #ifdef USE_ENVMAP\n vVertexRef = reflect(normalize(aWorldVertexPosition.xyz - uEyePosition), aVertEyeNormal);\n #endif\n CHUNK[LightingCalls]\n vVertexColor = lightSpecularColor + (aVertColor * lightDiffuseColor);\n gl_Position = uProjectionMatrix * aWorldVertexPosition;\n}",fragmentShader:"varying vec3 vVertexColor;\n#ifdef USE_TEXTURE \n varying vec2 vVertexUV;\n#endif\n#ifdef USE_ENVMAP\n varying vec3 vVertexRef;\n#endif\nvoid main() {\n vec4 vertexFinalColor = vec4(vVertexColor, 1.0);\n #ifdef USE_TEXTURE \n vertexFinalColor *= texture2D(uTexture, vVertexUV);\n #endif\n #ifdef USE_ENVMAP\n vertexFinalColor *= textureCube(uEnvironment, vVertexRef);\n #endif\n vertexFinalColor.a *= uAlpha;\n gl_FragColor = vertexFinalColor;\n}"}};

A3.Addon.Intersection.Ray=function(a,b){this.origin=a;this.direction=b};A3.Ray=A3.Addon.Intersection.Ray;A3.Addon.Intersection.Projector=function(a){this.camera=a};A3.Addon.Intersection.Projector.prototype={unproject:function(b){var c=new A3.Core.Math.Matrix4(),d=new A3.Core.Math.Matrix4(),e=new A3.Core.Math.Vector3(0,0,0),a=new A3.Core.Math.Vector3(b.x,b.y,1);d.copy(this.camera.projectionMatrix).invert();c.copy(this.camera.matrixWorld).multiply(d).multiplyVector3(e);c.multiplyVector3(a);return a.subtract(e)}};A3.Projector=A3.Addon.Intersection.Projector;