/**
 * 自适应蛇形曲线数据展示（基于VUE单文件）
 * 作者：程文娅
 * 日期：2020-09-04
 */

var vue = new Vue({
	el:'#mainSnakLine',
	data:{
		colNum:0,
		rowNum:0,
		data:[
			{
				GXH:'123456789877899',
				WCZTDM:1 //完成状态代码：0-无需处理 1-已完成 2-未完成 3-未开始
			},
			{GXH:'2',WCZTDM:2},
			{GXH:'3',WCZTDM:2},
			{GXH:'4',WCZTDM:3},
			{GXH:'5'},
			{GXH:'6'},
			{GXH:'7'},
			{GXH:'8'},
			{GXH:'9'},
			{GXH:'10'},
			{GXH:'11'},
			{GXH:'12'},
			{GXH:'13'},
			{GXH:'14'},
			{GXH:'15'},
			{GXH:'16'},
			{GXH:'17'},
			{GXH:'18'},
			{GXH:'19'}
		],
		snckData:[]
	},
	mounted:function(){
		var that = this;
		that.initSnckLine();
		window.onresize = function(){
			that.initSnckLine(); 
		}
	},
	methods:{
		initSnckLine:function(){
			this.calColNum();
			
			if(this.colNum > 0 && this.data.length > 0){
				this.calRowNum();
			}
		},
		
		/**
		 * 计算一行显示的列数
		 */
		calColNum:function(){
			this.colNum = Math.floor(($('.main-snakLine').width() - 158) / 140);
		},
		
		/**
		 * 计算需要多少行显示完
		 */
		calRowNum:function(){
			var length = this.data.length;
			if(this.colNum > length){
				this.rowNum = 1;
			}else{
				this.rowNum = Math.floor(length / this.colNum);
				
				if(length % this.colNum > 0){
					this.rowNum++;
				}
			}	
			
			this.initsSnckData();
		},
		/**
		 * 初始化蛇形展示数据
		 * 得到一个二位数组
		 */
		initsSnckData:function(){
			var that = this;
			var newArr = [];
			if(this.rowNum == 1){
				newArr.push(that.data);
			}else{
				for(var i = 0; i <= that.data.length; i += that.colNum){
					var arr = that.data.slice(i,i + that.colNum);
					newArr.push(arr);
				}
			}		
			
			if(newArr.length > 0){
				newArr.forEach(function(item,index){
					newArr[index] = that.getRowData(item,index);
				});
			}
			
			that.snckData = newArr;
			console.log(newArr)
		},
		getRowData:function(data,index){
			return (index % 2) == 0 ? data : data.reverse();
		},
		getWczt:function(ztdm){
			var className = '';
			switch(ztdm){
				case 1 ://已完成
					className = 'green';
					break;
				case 2://未完成
					className = 'yellow'
					break;
				case 3://未开始
					className = 'red'
					break;				
			}
			
			return className;
		}
	}
})