//开启
function LeftOpen() {
  $('.popleft').css({
    "display": "block"
  });
  setTimeout(function () {
    $('.content-popleft').css({
      "transform": "translateX(0)"
    });
  }, 100);
}
//关闭
function LeftClose() {
  $('.content-popleft').css({
    "transform": "translateX(-100%)"
  });
  setTimeout(function () {
    $('.popleft').css({
      "display": "none"
    });
  }, 600);

};

$(function() {
    var key = "";
    $.ajax({
        url: 'https://view.inews.qq.com/g2/getOnsInfo?name=disease_h5',
        type: "get",
        // json或jsonp（可以用来解决跨域
        dataType: "jsonp",
        success: function(data) {
            var obj = $.parseJSON(data.data);
            // console.log(obj)

            // 更新时间
            $(".time").text(obj.lastUpdateTime)
            // 现有确诊
            $(".Cure_1").text(obj.chinaTotal.nowConfirm)
            $(".decline_1").text(obj.chinaAdd.nowConfirm)

            if ($(".decline_1").text()>=0) {
              $(".decline_1").text("+"+obj.chinaAdd.nowConfirm)
            }
            else{
              $(".decline_1").text(obj.chinaAdd.nowConfirm)
            }
            // 现有疑似
            $(".Cure_2").text(obj.chinaTotal.suspect)
            $(".decline_2").text(obj.chinaAdd.suspect)
            if ($(".decline_2").text()>=0) {
              $(".decline_2").text("+"+obj.chinaAdd.suspect)
            }
            else{
              $(".decline_2").text(obj.chinaAdd.suspect)
            }
            // 现有重症
            $(".Cure_3").text(obj.chinaTotal.nowSevere)
            $(".decline_3").text(obj.chinaAdd.nowSevere)
            if ($(".decline_3").text()>=0) {
              $(".decline_3").text("+"+obj.chinaAdd.nowSevere)
            }
            else{
              $(".decline_3").text(obj.chinaAdd.nowSevere)
            }
            // 累计确诊
            $(".Cure_4").text(obj.chinaTotal.confirm)
            $(".decline_4").text(obj.chinaAdd.confirm)
            if ($(".decline_4").text()>=0) {
              $(".decline_4").text("+"+obj.chinaAdd.confirm)
            }
            else{
              $(".decline_4").text(obj.chinaAdd.confirm)
            }

            // 累计治愈
            $(".Cure_5").text(obj.chinaTotal.heal)
            $(".decline_5").text(obj.chinaAdd.heal)
            if ($(".decline_5").text()>=0) {
              $(".decline_5").text("+"+obj.chinaAdd.heal)
            }
            else{
              $(".decline_5").text(obj.chinaAdd.heal)
            }
            // 累计死亡
            $(".Cure_6").text(obj.chinaTotal.dead)
            $(".decline_6").text(obj.chinaAdd.dead)
            if ($(".decline_6").text()>=0) {
              $(".decline_6").text("+"+obj.chinaAdd.dead)
            }
            else{
              $(".decline_6").text(obj.chinaAdd.dead)
            } 
            // 境外输入
            $(".Cure_7").text(obj.chinaTotal.importedCase)
            $(".decline_7").text(obj.chinaAdd.importedCase)
            if ($(".decline_7").text()>=0) {
              $(".decline_7").text("+"+obj.chinaAdd.importedCase)
            }
            else{
              $(".decline_7").text(obj.chinaAdd.importedCase)
            }
            // 无症状者
            $(".Cure_8").text(obj.chinaTotal.noInfect)
            $(".decline_8").text(obj.chinaAdd.noInfect)
            if ($(".decline_8").text()>=0) {
              $(".decline_8").text("+"+obj.chinaAdd.noInfect)
            }
            else{
              $(".decline_8").text(obj.chinaAdd.noInfect)
            }            

            // 全国省份
            // console.log(obj.areaTree[0])
            var proName = '<tr>' +
                '<td class="name">'
            var proNow = '</td>' +
                '<td class="confirm">'
            var proConfirm = '</td>' +
                '<td class="confirm">'
            var proHeal = '</td>' +
                '<td class="heal">'
            var proDead = '</td>' +
                '<td class="dead">'
            var proEnd = '</td>' +
                '</tr>'

            // 山东省城市
            var cityName = '<tr>' +
                '<td class="c_name">'
            var cityNow = '</td>' +
                '<td class="c_confirm">'
            var cityConfirm = '</td>' +
                '<td class="c_confirm">'
            var cityHeal = '</td>' +
                '<td class="c_heal">'
            var cityDead = '</td>' +
                '<td class="c_dead">'
            var cityEnd = '</td>' +
                '</tr>'


            // 定义数组存储全国34省
            var arr = obj.areaTree[0].children;   
            // 遍历省份
            for(var i = 0; i < arr.length; i++){
                // 输出省份
                $(".province").append(
                    proName + arr[i].name +
                    proNow + arr[i].total.nowConfirm +
                    proConfirm + arr[i].total.confirm + 
                    proHeal + arr[i].total.heal + 
                    proDead + arr[i].total.dead);

                // 判断全国省份若名字为山东的
                if (arr[i].name=="山东") {
                  // 山东累计确诊
                  $(".sd_2").text(arr[i].total.confirm)
                  // 治愈
                  $(".sd_3").text(arr[i].total.heal)
                  // 死亡
                  $(".sd_4").text(arr[i].total.dead)
                  // 境外输入
                  $(".sd_5").text(arr[i].today.tip)
                  // 现有确诊
                  $(".sd_1").text($(".sd_2").text() - $(".sd_3").text() - $(".sd_4").text())

                  // 将山东省份城市赋值给shanDong
                  // console.log(arr[i].children)
                  var shanDong = arr[i].children
                  // 遍历山东省市级城市
                  for(var j = 0; j < shanDong.length; j++){
                    $(".city").append(
                      cityName + shanDong[j].name +
                      cityNow + shanDong[j].total.nowConfirm +
                      cityConfirm + shanDong[j].total.confirm + 
                      cityHeal + shanDong[j].total.heal + 
                      cityDead + shanDong[j].total.dead);
                  }                
                }
            }

            // console.log(obj)
            // // 定义数组存储山东城市
            // var arr1 = (obj.areaTree[0].children[12].children);   
            // // 遍历省份
            // for(var i = 0; i < arr1.length; i++){
            //     $(".city").append(
            //         cityName + arr1[i].name +
            //         cityNow + arr1[i].total.nowConfirm +
            //         cityConfirm + arr1[i].total.confirm + 
            //         cityHeal + arr1[i].total.heal + 
            //         cityDead + arr1[i].total.dead);
            // }

        }
    })
})

// 现有
// 初始化echarts实例
var myChart = echarts.init(document.getElementById('myEcharts'));
// 指定图表的配置项和数据
option = {
  // 设置标题和副标题及副标题跳转链接
  title: {
    // 主标题文本，支持使用 \n 换行。
    text: '新冠病毒疫情病毒(各省现有确诊病例)',
    // 主标题样式
    // textStyle: {
    //   color: "#333"
    // },
    // 副标题文本，支持使用 \n 换行。
    subtext: '数据来源--腾讯新闻',
    // 副标题文本超链接。
    sublink: 'https://view.inews.qq.com/g2/getOnsInfo?name=disease_h5',
    // 副标题样式
    // subtextStyle: {
    //   color: "#333"
    // },
    left: 'center'
  },
  // 数据提示框组件
  tooltip: {
    // item放到数据区域触发
    trigger: 'item',
    // 提示数据格式br表示换行，地图 : {a}（系列名称），{b}（区域名称），{c}（合并数值）, {d}（无）
    // formatter: '{b}<br/>{a}{c}(人)',
    // formatter: '{b}&nbsp;{a}<br/>{c}人&nbsp;&nbsp;' +
    // "<a class='tip' href='JavaScript:;'"+">分享</a>",
    // 鼠标是否可进入提示框浮层中，默认为false，如需详情内交互，如添加链接，按钮，可设置为 true
    enterable: true,
    // 提示框定位
    position: "right",
    color: "#fff",
    // 函数传参，提示框显示data数据
    formatter: function(params){
      return [
        "<div class='point-content'>"
        + "<span>" + params.data.name + "</span>"
        + "<span>"+ "&nbsp;现有确诊<br>" + params.data.value + "&nbsp;(人)&nbsp;&nbsp;" + "</span>"
        + "<a href='http://www.lixianliang.top' class='tip'>分享</a>"
        + " </div>"
      ];
    }
  },
  // //图例组件
  // legend: {
  //   // 图例列表的布局朝向。
  //   orient: 'vertical',
  //   left: 'left',
  //   // 图例的数据数组。
  //   data: ['中国疫情图'],
  // },
  /*visualMap: {
  min: 1,   // 颜色映射对应的最小值
  max: 1500, // 颜色映射对应的最大值
  text: ['严重', '一般'], // 映射图上下标记文本
  realtime: true, // 是否显示拖拽手柄，映射条可以拖拽调整要映射的范围
  calculable: true, // 拖拽时，是否实时更新地图
  },*/
  // 连续型视觉映射组件
  visualMap: {
    // 类型为连续型。
    type: 'piecewise',
    // 图形的宽度
    itemWidth: 10,
    itemHeight: 10,
    //两端文字主体之间的距离，单位为px  
    textGap: 5, 
    //每两个图元之间的间隔距离，单位为px  
    itemGap: 5, 
    // 字体大小
    textStyle: {
      fontSize: 10
    },
    // 自定义『分段式视觉映射组件（visualMapPiecewise）』的每一段的范围，以及每一段的文字，以及每一段的特别的样式。
    pieces: [
          { min: 10000, max: 1000000, label: '确诊>10000人', color: '#372a28' },
          { min: 1000, max: 9999, label: '确诊1000-9999', color: '#70161d' },
          { min: 500, max: 999, label: '确诊500-999人', color: '#cb2a2f' },
          { min: 100, max: 499, label: '确诊100-499人', color: '#e55a4e' },
          { min: 10, max: 99, label: '确诊10-99人', color: '#f59e83' },
          { min: 1, max: 9, label: '确诊1-9人', color: '#fdebcf' },
    ],
  },
  // 工具栏
  // toolbox: {
  //   show: true,
  //   // 工具栏 icon 的布局朝向。
  //   orient: 'vertical',
  //   left: 'right',
  //   top: 'center',
  //   feature: {
  //     // 数据视图工具，可以展现当前图表所用的数据，编辑后可以动态更新。
  //     dataView: { show: true, readOnly: false },
  //     // 配置项还原。
  //     restore: { show: true },
  //     // 保存为图片。
  //     saveAsImage: { show: true }
  //   }
  // },
  // 具体数据
  geo: [
    {
      // 地图类型。
      type: 'map',
      // 要使用的地图，即上面注册的地图名称
      mapType: 'china',
      // 开启鼠标缩放和平移漫游
      roam: false,
      // // 图形上的文本标签，地图默认显示数据名
      // label: {
      //   show: true,
      //   color: 'rgb(249, 249, 249)',
      // },
    }
  ]
};

//使用指定的配置项和数据显示图表
myChart.setOption(option);
//获取数据
$(function () {
  $.ajax({
    // 接口地址
    url: "https://view.inews.qq.com/g2/getOnsInfo?name=disease_h5",
    // json或jsonp（可以用来解决跨域
    dataType: "jsonp",
    // 请求成功的回调函数 data请求成功返回的数据
    success: function (data) {
      //  console.log(data.data)
      //  通常用于与服务端交换数据。在接收服务器数据时一般是字符串,我们可以使用JSON.parse()方法将数据转换为 JavaScript 对象
      obj = JSON.parse(data.data);
      // 定义空数组
      var newArr = [];
      if (obj) {
        //获取到各个省份的数据
        var province = obj.areaTree[0].children;
        for (var i = 0; i < province.length; i++) {
          var json = {
            // 获取哪个省
            name: province[i].name,
            // 获取确诊人数
            value: province[i].total.confirm - province[i].total.heal - province[i].total.dead
          }
          newArr.push(json)
        }
        //使用指定的配置项和数据显示图表
        myChart.setOption({
          series: [
            {
              name: '现有确诊',
              type: 'map',
              mapType: 'china',
              roam: false,
              label: {
                show: false,
                fontSize: 8,
                color: 'rgb(249, 249, 249)'
              },
              data: newArr,
            }
          ]
        });
      }
    }

  })
})

// 总确诊
// 初始化echarts实例
var myChart1 = echarts.init(document.getElementById('myEcharts1'));
// 指定图表的配置项和数据
option1 = {
  // 设置标题和副标题及副标题跳转链接
  title: {
    // 主标题文本，支持使用 \n 换行。
    text: '新冠病毒疫情病毒(各省总确诊病例)',
    // // 主标题链接
    // link:'https://view.inews.qq.com/g2/getOnsInfo?name=disease_h5',
    // // 跳转方式
    // target:'blank',
    // 主标题样式
    // textStyle: {
    //   color: "#333"
    // },
    // 副标题文本，支持使用 \n 换行。
    subtext: '数据来源--腾讯新闻',
    // 副标题文本超链接。
    sublink: 'https://view.inews.qq.com/g2/getOnsInfo?name=disease_h5',
    // 副标题样式
    // subtextStyle: {
    //   color: "#333"
    // },
    left: 'center'
  },
  // 数据提示框组件
  tooltip: {
    // item放到数据区域触发
    trigger: 'item',
    // 提示数据格式br表示换行，地图 : {a}（系列名称），{b}（区域名称），{c}（合并数值）, {d}（无）
    formatter: '{b}<br/>{a}{c}(人)',
  },
  //图例组件
  // legend: {
  //   // 图例列表的布局朝向。
  //   orient: 'vertical',
  //   left: 'left',
  //   // 图例的数据数组。
  //   data: ['中国疫情图'],
  // },
  /*visualMap: {
      min: 1,   // 颜色映射对应的最小值
      max: 1500, // 颜色映射对应的最大值
      text: ['严重', '一般'], // 映射图上下标记文本
      realtime: true, // 是否显示拖拽手柄，映射条可以拖拽调整要映射的范围
      calculable: true, // 拖拽时，是否实时更新地图
  },*/
  // 分段型视觉映射组件
  visualMap: {
    // 类型为分段型。
    type: 'piecewise',
    // 是否显示指示图
    show:true,  
    // 图形的宽度
    itemWidth: 10,
    itemHeight: 10,
    //两端文字主体之间的距离，单位为px  
    textGap: 5, 
    //每两个图元之间的间隔距离，单位为px  
    itemGap: 5, 
    // 字体大小
    textStyle: {
      fontSize: 10
    },
    // 鼠标指向高亮
    // hoverLink:false,
    // 自定义『分段式视觉映射组件（visualMapPiecewise）』的每一段的范围，以及每一段的文字，以及每一段的特别的样式。
    pieces: [
      { min: 10000, max: 1000000, label: '确诊>10000人', color: '#372a28' },
      { min: 1000, max: 9999, label: '确诊1000-9999', color: '#70161d' },
      { min: 500, max: 999, label: '确诊500-999人', color: '#cb2a2f' },
      { min: 100, max: 499, label: '确诊100-499人', color: '#e55a4e' },
      { min: 10, max: 99, label: '确诊10-99人', color: '#f59e83' },
      { min: 1, max: 9, label: '确诊1-9人', color: '#fdebcf' },
    ]
  },
  // 工具栏
  // toolbox: {
  //   show: true,
  //   // 工具栏 icon 的布局朝向。
  //   orient: 'vertical',
  //   left: 'right',
  //   top: 'center',
  //   feature: {
  //     // 数据视图工具，可以展现当前图表所用的数据，编辑后可以动态更新。
  //     dataView: { show: true, readOnly: false },
  //     // 配置项还原。
  //     restore: { show: true },
  //     // 保存为图片。
  //     saveAsImage: { show: true }
  //   }
  // },
  // 具体数据
  geo: [
    {
      // 地图类型。
      type: 'map',
      // 要使用的地图，即上面注册的地图名称
      mapType: 'china',
      // 开启鼠标缩放和平移漫游
      roam: false,
      // 图形上的文本标签，地图默认显示数据名
      // label: {
      //   show: true,
      //   color: 'rgb(249, 249, 249)',
      // },
    }
  ]
};

//使用指定的配置项和数据显示图表
myChart1.setOption(option1);
//获取数据
$(function () {
  $.ajax({
    // 接口地址
    url: "https://view.inews.qq.com/g2/getOnsInfo?name=disease_h5",
    // json或jsonp（可以用来解决跨域
    dataType: "jsonp",
    // 请求成功的回调函数 data请求成功返回的数据
    success: function (data) {
      //  console.log(data.data)
      //  通常用于与服务端交换数据。在接收服务器数据时一般是字符串,我们可以使用JSON.parse()方法将数据转换为 JavaScript 对象
      obj = JSON.parse(data.data);
      // 定义空数组
      var newArr = [];
      if (obj) {
        //获取到各个省份的数据
        var province = obj.areaTree[0].children;
        for (var i = 0; i < province.length; i++) {
          var json = {
            // 获取哪个省
            name: province[i].name,
            // 获取确诊人数
            value: province[i].total.confirm
          }
          newArr.push(json)
        }
        //使用指定的配置项和数据显示图表
        myChart1.setOption({
          series: [
            {
              name: '确诊数',
              type: 'map',
              mapType: 'china',
              roam: false,
              // 图形上的文本标签，地图默认显示数据名
              label: {
                show: true,
                color: 'rgb(249, 249, 249)',
                fontSize: 8
              },
              data: newArr
            }
          ]
        });
      }
    }

  })
})

// 环形图
// 基于准备好的dom，初始化echarts实例
var myChart0 = echarts.init(document.getElementById('main'));
// 指定图表的配置项和数据
//app.title = '环形图';
option0 = {
    //饼图颜色
    color: ['#facf11','#fa9416','#fc0518','#fc0884','#fa0acb','#c30df6','#8417fc','#1438ff','#1e7af9','#32b0fc','#4fecf1','#45f02f','#4ef716','#99f514','#cff516','#f9f01f'],
    tooltip: {
        trigger: 'item',
        formatter: " {b}{a}: {c} (人)<br/>占总数的：{d}%"
    },      
     // 图形显示
            legend: {
                //布局的方向,垂直排列
                orient: 'vertical',                          
                // 默认圆角矩形roundRect，'circle' 椭圆，'rect' 矩形，'roundRect' 圆角矩形 '，triangle' 三角形，'diamond' 菱形，'pin' 正圆 ，'arrow' 箭头.使用icon:'image:/ico/echarts.png',
                // icon: 'rect',   
                // x: '80%',
                y: '55%',
                right:"right",
                //图例相互之间的距离
                itemGap: 4, 
                //图形的宽度，即长条的宽度。                           
                itemWidth: 10,
                //图形的高度，即长条的高度。                          
                itemHeight: 10,  
                show: false                  
            }          

}
// 使用刚指定的配置项和数据显示图表。
myChart0.setOption(option0);
//获取数据
$(function () {
  $.ajax({
    // 接口地址
    url: "https://view.inews.qq.com/g2/getOnsInfo?name=disease_h5",
    // json或jsonp（可以用来解决跨域
    dataType: "jsonp",
    // 请求成功的回调函数 data请求成功返回的数据
    success: function (data) {
        //  console.log(data.data)
        //  通常用于与服务端交换数据。在接收服务器数据时一般是字符串,我们可以使用JSON.parse()方法将数据转换为 JavaScript 对象
        obj = JSON.parse(data.data);
        // 定义空数组
        var newArr = [];
        // 获取到全国省份的数据
        var province=obj.areaTree[0].children
        // 遍历省份
        for (var i = 0; i < province.length; i++) {
            // console.log(province[i].name)
            // 判断全国省份若名字为山东的
            if (province[i].name=="山东") {
                // 将山东省份城市赋值给shanDong
                var shanDong = province[i].children;
                // console.log(shanDong)
                // 遍历山东省市级城市
                for (var j = 0; j < shanDong.length; j++) {
                  var json = {
                    // 获取哪个市
                    name: shanDong[j].name,
                    // 获取确诊人数
                    value: shanDong[j].total.confirm
                  }
                  newArr.push(json)
                }
            }                
        }
        //使用指定的配置项和数据显示图表
        myChart0.setOption({
            series: [
            {
                // 双饼状图指示
                name: '总确诊',
                //类型饼状图
                type: 'pie',
                //是否开启 hover 在扇区上的放大动画效果，默认默认开启
                //hoverAnimation:false,
                //内半径，外半径，内半径0时为弧形
                radius: ['30%', '70%'],
                //是否启用防止标签重叠策略，默认默认开启
                avoidLabelOverlap: false,
                // center 圆心位置，距离top，距离left
                //center: ['50%', '50%'], 
                //图形是否不响应和触发鼠标事件
                //silent: true,
            
                // label: {
                //     normal: {
                //         show: false,
                //         position: 'center'
                //     },
                //     emphasis: {
                //         show: true,
                //         textStyle: {
                //             fontSize: '30',
                //             fontWeight: 'bold'
                //         }
                //     }
                // },
                // labelLine: {
                //     normal: {
                //         show: true
                //     }
                // },
                data: newArr,
            }
            ],
           
        });
    }

  })
})
// 1、css实现最大宽度或者@media
// 2、当窗口改变时重新加载
// 窗口改变时重新加载
$(window).resize(function(){   
  this.myChart.resize(); 
  this.myChart1.resize(); 
  this.myChart0.resize();
});  
// window.onresize = function () {
//   this.myChart.resize(); 
//   this.myChart1.resize();
//   this.myChart0.resize(); 
// };