(function(){
    var config;
    var me;
    var zFish = {config : config = {
            delay: 20,
            svgH: 0,
            maxVx: 30,
            maxVy: 30,
            svgW: 0,
            da: 40,//默认加速度
            df: 8,//默认阻力
        },
        fishArr: []
    };

    me = {
        id: 'user0',
        clazz: '',
        type: 1,
        seed: 0,
        head:{
            r : 7,
            x : 50,
            y : 50,
            vx : 0,
            vy : 0,
            xPower : 0,//-1 0 1 横向加速度
            yPower : 0,//-1 0 1 纵向加速度
        },
        body:[
            {x:0,y:0,r:8},
            {x:0,y:0,r:9},
            {x:0,y:0,r:9},
            {x:0,y:0,r:8},
            {x:0,y:0,r:7},
            {x:0,y:0,r:5},
            {x:0,y:0,r:4},
            {x:0,y:0,r:5},
        ]
    };
    function makeSVG(tag,id) {
        var ns = 'http://www.w3.org/2000/svg';
        var el= document.createElementNS(ns, tag);
        el.setAttribute("class","draw-line");
        el.setAttribute("id",id);
        return el;
    }
    zFish.initRoad = function() {
        var svg = $("#svg");
        var h = svg.height();
        var w = svg.width();
        config.svgH = h;
        config.svgW = w;
    }
    zFish.initFish = function(fish) {
        var svg = $("#svg");
        var h = svg.height();
        var w = svg.width();
        var ball = $(makeSVG("circle","fish_"+fish.id+"_0"));
        ball.addClass(fish.clazz);
        var x0 = fish.head.x;
        var y0 = h-fish.head.y;
        ball.attr("cx",x0).attr("cy",y0).attr("r",fish.head.r);
        ball.css("zIndex",fish.body.length + 1);
        svg.append(ball);
        for (var tai in fish.body) {
            var tail = $(makeSVG("circle","fish_"+fish.id+"_"+(parseInt(tai)+1)));
            tail.attr("cx",x0).attr("cy",y0).attr("r",fish.body[tai].r);
            tail.addClass(fish.clazz+' draw-line');
            tail.css('stroke-dasharray',zFish.randomNum(0,4)+','+zFish.randomNum(0,4));
            svg.append(tail);
            tail.css("zIndex",fish.body.length - parseInt(tai));
        }
        if(fish.type == 1){
            $("#jsd").text("加速度："+config.da);
            $("#mczl").text("阻力："+config.df);
            $("#sd").text("当前速度：0");
        }


    }
    zFish.initEvent = function() {
        $(document).bind('keypress', function(event){
            if(event.keyCode === 119){
                me.head.yPower = config.da;
            }else if(event.keyCode === 100){
                me.head.xPower = config.da;
            }else if(event.keyCode === 115){
                me.head.yPower = -config.da;
            }else if(event.keyCode === 97){
                me.head.xPower = -config.da;
            }
        }).bind('keyup', function(event){
            if(event.keyCode === 87){
                me.head.yPower = 0;
            }else if(event.keyCode === 68){
                me.head.xPower = 0;
            }else if(event.keyCode === 83){
                me.head.yPower = 0;
            }else if(event.keyCode === 65){
                me.head.xPower = 0;
            }
        });
    }
    zFish.run = function(fish){
        var ball ;
        if(fish == null){
            fish = me;
        }
        if(fish.type !== 1){
            fish.seed ++;
            if(fish.seed > 190){
                fish.seed = 0;
            }
            if(fish.seed == 0 ){
                var xy = fish.getPower();
                fish.head.xPower = xy.x;
                fish.head.yPower = xy.y;
            }

        }
        var ball = fish.head;
        var xPower = ball.xPower;
        var yPower = ball.yPower;

        if(ball.vx !== 0 ){
            xPower += (ball.vx > 0) ? -config.df : config.df;
        }
        if(ball.vy !== 0 ){
            yPower += (ball.vy > 0) ? -config.df : config.df;
        }
        var t = config.delay/1000;
        var afterVx = ball.vx + xPower * t;
        var afterVy = ball.vy + yPower * t;
        //var nowV = parseInt(Math.sqrt(afterVx*afterVx+afterVy*afterVy));
        ball.vx = Math.abs(afterVx) <= config.maxVx ? afterVx : (afterVx>0?1:-1)*config.maxVx;

        ball.vy = Math.abs(afterVy) <= config.maxVy ? afterVy : (afterVy>0?1:-1)*config.maxVy;
        if(Math.abs(ball.vx) < 0.0000000001){
            ball.vx = 0;
        }
        if(Math.abs(ball.vy) < 0.0000000001){
            ball.vy = 0;
        }
        var sx = ball.vx*t + 0.5* xPower*t*t;
        var sy = ball.vy*t + 0.5* yPower*t*t;
        ball.x += sx *10;
        ball.y -= sy *10;
        var fix = ball.x;
        var fiy = config.svgH-ball.y;
        var fishObj = $("#fish_"+fish.id+"_0");
        if(ball.x >ball.r && ball.x < config.svgW-ball.r){
            fishObj.attr("cx",fix);
        }else{
            ball.vx = -ball.vx;
            if(ball.x <ball.r){
                ball.x = ball.r;
                fishObj.attr("cx",ball.x);
            }else if(ball.x > config.svgW-ball.r){
                ball.x = config.svgW-ball.r;
                fishObj.attr("cx",config.svgW-ball.r);
            }

        }
        if(ball.y >ball.r&& ball.y < config.svgH-ball.r){
            fishObj.attr("cy",ball.y);
        }else{
            ball.vy = -ball.vy;
            if(ball.y <ball.r){
                ball.y = ball.r;
                fishObj.attr("cy",ball.y);
            }else if(ball.y > config.svgH-ball.r){
                ball.y = config.svgH-ball.r;
                fishObj.attr("cy",config.svgH-ball.r);
            }
        }
        if(fish.type == 1){
            fish.seed ++;
            if(fish.seed>20){
                fish.seed = 0;
                $("#ssjsd").text("实时加速度：["+xPower+","+yPower+"]");
                if(ball.vx != 0 || ball.vy != 0){
                    $("#sd").text("当前速度："+parseInt(Math.sqrt(ball.vx*ball.vx+ball.vy*ball.vy)));
                }
            }


        }


        //$("#tail0").attr("cx",fix).attr("cy",fiy);
        //console.log(ball.vx,ball.vy);

        setTimeout(function () {
            $("#fish_"+fish.id+"_1").attr("cx",$("#fish_"+fish.id+"_0").attr("cx")).attr("cy",$("#fish_"+fish.id+"_0").attr("cy"));
        },30);
        for (var i = 1; i< fish.body.length;i++){
            var last = $("#fish_"+fish.id+"_"+i);
            var ccx = last.attr('cx');
            var ccy = last.attr('cy');
            var f= function(a,b,a1){
                return function () {
                    $("#fish_"+fish.id+"_"+a).attr(a1,b);
                }
            };
            setTimeout(f(i+1,ccx,'cx'),30);
            setTimeout(f(i+1,ccy,'cy'),30);

        }
    }
    zFish.runFish = function(){
        var t = setInterval(zFish.run,config.delay);
    }
    zFish.init = function(){
        zFish.initRoad();
        zFish.initFish(me);
        zFish.initEvent();
        zFish.runFish();
    }
    zFish.addFish = function(fish){
        setTimeout(function () {
            zFish.fishArr.push(fish);
            var f = function(fi){
                return function () {
                    zFish.run(fi);
                }
            }
            zFish.initFish(fish);
            setInterval(f(fish),config.delay);
        },400);

    }

    zFish.random = function(){
        var s1 = zFish.randomNum(1,3);
        var s2 = zFish.randomNum(1,3);
        var x = 0,y = 0;
        if(s1 == 1){
            x = -config.da/2+(10-zFish.randomNum(5,15));
        }else if(s1 == 3){
            x = config.da/2+(10-zFish.randomNum(5,15));
        }else{
            x = 0;
        }
        if(s2 == 1){
            y = -config.da/2+(10-zFish.randomNum(5,15));
        }else if(s2 == 3){
            y = config.da/2+(10-zFish.randomNum(5,15));
        }else{
            y = 0;
        }
        return {x:x,y:y};
    }
    zFish.randomNum = function(minNum,maxNum){
        switch(arguments.length){
            case 1:
                return parseInt(Math.random()*minNum+1,10);
                break;
            case 2:
                return parseInt(Math.random()*(maxNum-minNum+1)+minNum,10);
                break;
            default:
                return 0;
                break;
        }
    }

    window.zFish = zFish;
}());

