var formatdmm = function () {

    var C = {};

    //进度条控件数组
    var Objarr = C.Objarr = [];

    //进度条控件索引
    var ObjControlIndex = C.ObjControlIndex = {index: 0};

    //初始化插件
    var load = C.load = function (options1) {
        var options = $.extend({
            container: '',//容器
            containerWid: '10',//容器宽度px
            containerHeg: '100',//容器高度px
            startColor: '#c27c88',//开始颜色
            endColor: '#cc163a',//结束颜色
            itemColor: '#ddd',
            countNum: 32,//分隔数
            maxNumerical: 100,//基数
            direction: 'transverse',//排列方向transverse 横向  ，portrait 纵向
            duration: 2000,//每次渲染时长
            controlIndex: ObjControlIndex.index,
            callback: function () {
            }//回调函数，将当前进度传出
        }, options1);
        var colorArr = gradient(options.startColor, options.endColor, options.countNum);
        var objitem = {
            callback: options.callback,
            controlIndex: ObjControlIndex.index,
            colorArray: colorArr,
            itemColor: options.itemColor,
            maxNumerical: options.maxNumerical,
            duration: options.duration,
            setPercentage: 0
        };

        var obj1 = {
            controlIndex: ObjControlIndex.index,
            setPercentage: 0
        };
        C.Objarr.push(objitem);
        C.ObjControlIndex.index++;
        stratSeparate(options);
        return obj1;
    };

    var color = C.color = {

        rgbToHex: function (r, g, b) {
            var hex = ((r << 16) | (g << 8) | b).toString(16);
            return "#" + new Array(Math.abs(hex.length - 7)).join("0") + hex;
        },
        hexToRgb: function (hex) {
            var rgb = [];
            for (var i = 1; i < 7; i += 2) {
                rgb.push(parseInt("0x" + hex.slice(i, i + 2)));
            }
            return rgb;
        }


    };

    // 计算渐变过渡色
    var gradient = C.gradient = function (startColor, endColor, step) {

        // 将 hex 转换为rgb
        var sColor = color.hexToRgb(startColor),
            eColor = color.hexToRgb(endColor);

        // 计算R\G\B每一步的差值
        var rStep = (eColor[0] - sColor[0]) / step;
        gStep = (eColor[1] - sColor[1]) / step;
        bStep = (eColor[2] - sColor[2]) / step;

        var gradientColorArr = [];
        for (var i = 0; i < step; i++) {
            // 计算每一步的hex值
            gradientColorArr.push(color.rgbToHex(parseInt(rStep * i + sColor[0]), parseInt(gStep * i + sColor[1]), parseInt(bStep * i + sColor[2])));
        }
        return gradientColorArr;
    };

    //添加分隔
    var stratSeparate = C.stratSeparate = function (options) {
        // options.container;//容器ID
        // options.containerWid;//容器宽
        // options.containerHeg;//容器高
        // options.countNum;//分割数
        // options.controlIndex;//下标
        // options.direction;//transverse 横向  ，portrait 纵向
        // options.itemColor;//格子底色
        if(options.direction=='transverse'){
            $("#"+options.container).removeClass('uuu');
        }
        else if(options.direction=='portrait'){
            $("#"+options.container).addClass('uuu');
        }



        $("#"+options.container).html("");
        $("#"+options.container).css({'width':options.containerWid+'px','height':options.containerHeg+'px'});

        var htm = '';
        htm += '<ul class="progressBar">';
        for (var i = 0; i < options.countNum; i++) {
            htm += '<li class="pro_item pro_item'+i+'_'+options.controlIndex+'" style="min-height:'+options.containerHeg+'px;background:linear-gradient(#fff, '+options.itemColor+' 40%, '+options.itemColor+' 60%,#fff)"></li>';
        }
        htm += '</ul>';

        $("#"+options.container).append(htm);

    }

    //计算渲染颜色
    var setColorformat = C.setColorformat = function (obj) {
        var objitem = C.Objarr[obj.controlIndex];
        if(Number(objitem.setPercentage)<Number(obj.setPercentage)){

            $({
                // 起始值
                countNum: objitem.setPercentage
            }).animate({
                // 最终值
                countNum: obj.setPercentage
            }, {
                // 动画持续时间
                duration: objitem.duration,
                easing: "linear",
                step: function () {
                        // 设置每步动画计算的数值
                        objitem.callback(Math.round((this.countNum * 100) / 100));
                        var djge = Math.floor(this.countNum / (objitem.maxNumerical / objitem.colorArray.length));
                        $(".pro_item"+djge+"_"+objitem.controlIndex).css("background", objitem.colorArray[djge]);
                        //console.log(djge);
                },
                complete: function () {
                    objitem.callback(this.countNum);
                }
            });
        } else{

            $({
                // 起始值
                countNum: objitem.setPercentage
            }).animate({
                // 最终值
                countNum: obj.setPercentage
            }, {
                // 动画持续时间
                duration: objitem.duration,
                easing: "linear",
                step: function () {
                    // 设置每步动画计算的数值
                    objitem.callback(Math.round((this.countNum * 100) / 100));
                    var djge = Math.floor(this.countNum / (objitem.maxNumerical / objitem.colorArray.length));
                    $(".pro_item"+djge+"_"+objitem.controlIndex).css("background", 'linear-gradient(#fff, '+objitem.itemColor+' 40%, '+objitem.itemColor+' 60%,#fff)');
                    //console.log(djge);
                },
                complete: function () {
                    objitem.callback(this.countNum);
                }
            });

        }


        C.Objarr[obj.controlIndex].setPercentage = obj.setPercentage;
    };

    //恢复底色
    var reloadColor = C.reloadColor = function (obj) {
        var objitem = C.Objarr[obj.controlIndex];
        for (var i = 0; i < objitem.colorArray.length; i++) {
            $(".pro_item"+i+"_"+objitem.controlIndex).css("background", 'linear-gradient(#fff, '+objitem.itemColor+' 40%, '+objitem.itemColor+' 60%,#fff)');
        }
    };

    return C;

};

window.formatdmm = formatdmm();



