(function ($) {
  'use strict';

    // Dark Mode JS
    var toggleSwitch = document.getElementById('darkSwitch');
    var currentTheme = localStorage.getItem('theme');

    if (currentTheme) {
      document.documentElement.setAttribute('data-theme', currentTheme);
      if (currentTheme === 'dark') {
        if(toggleSwitch) {
          toggleSwitch.checked = true;
        }
      }
    }

    function switchTheme(e) {
      if (e.target.checked) {
        document.documentElement.setAttribute('data-theme', 'dark');
        localStorage.setItem('theme', 'dark');
      } else {
        document.documentElement.setAttribute('data-theme', 'light');
        localStorage.setItem('theme', 'light');
      }
    }

    if (toggleSwitch) {
      toggleSwitch.addEventListener('change', switchTheme, false);
    }

})(jQuery);